/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import kafka.catalog.ZKMetadataCollector;
import kafka.controller.KafkaController;
import kafka.server.KafkaConfig;
import kafka.server.MetadataSupport;
import kafka.server.RaftSupport;
import kafka.server.ReplicaManager;
import kafka.server.ZkSupport;
import kafka.server.link.ClusterLinkMetadataManager;
import kafka.server.link.ClusterLinkMetadataManagerWithKRaftSupport;
import kafka.server.link.ClusterLinkMetadataManagerWithZkSupport;
import kafka.server.link.ClusterLinkScheduler;
import kafka.server.metadata.KRaftImageMetadataCache;
import kafka.server.metadata.ZkMetadataCache;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.server.NodeToControllerChannelManager;
import org.apache.kafka.server.authorizer.AuthorizerServerInfo;
import scala.Function0;
import scala.MatchError;
import scala.Option;

public final class ClusterLinkMetadataManager$ {
    public static final ClusterLinkMetadataManager$ MODULE$ = new ClusterLinkMetadataManager$();

    public ClusterLinkMetadataManager createClusterLinkMetadataManager(KafkaConfig brokerConfig, ClusterLinkScheduler scheduler, MetadataSupport metadataSupport, NodeToControllerChannelManager controllerChannelManager, Function0<Admin> localAdminFactory, AuthorizerServerInfo serverInfo, ReplicaManager replicaManager, Option<ZKMetadataCollector> zkMetadataCollector) {
        if (metadataSupport instanceof ZkSupport) {
            ZkSupport zkSupport = (ZkSupport)metadataSupport;
            KafkaController controller = zkSupport.controller();
            KafkaZkClient zkClient = zkSupport.zkClient();
            ZkMetadataCache metadataCache = zkSupport.metadataCache();
            return new ClusterLinkMetadataManagerWithZkSupport(brokerConfig, scheduler, metadataCache, controllerChannelManager, controller, zkClient, localAdminFactory, replicaManager, serverInfo, zkMetadataCollector);
        }
        if (metadataSupport instanceof RaftSupport) {
            KRaftImageMetadataCache metadataCache = ((RaftSupport)metadataSupport).metadataCache();
            return new ClusterLinkMetadataManagerWithKRaftSupport(brokerConfig, scheduler, metadataCache, controllerChannelManager, localAdminFactory, serverInfo);
        }
        throw new MatchError((Object)metadataSupport);
    }

    private ClusterLinkMetadataManager$() {
    }
}

