/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import kafka.server.KafkaConfig;
import kafka.server.RegionalMetadataClient;
import kafka.server.RegionalNetworkMetadata;
import kafka.server.link.ClusterLinkRegionalMetadata$;
import kafka.server.link.ClusterLinkRegionalMetadataNetworkOp;
import kafka.server.link.ClusterLinkScheduler;
import kafka.utils.Logging;
import org.apache.kafka.common.security.authenticator.SaslInternalConfigs;
import org.apache.kafka.server.multitenant.LogicalClusterMetadata;
import org.apache.kafka.server.multitenant.MultiTenantMetadata;
import scala.Function0;
import scala.Option;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005}s!B\f\u0019\u0011\u0003yb!B\u0011\u0019\u0011\u0003\u0011\u0003\"B\u0015\u0002\t\u0003Q\u0003bB\u0016\u0002\u0005\u0004%\t\u0001\f\u0005\u0007k\u0005\u0001\u000b\u0011B\u0017\t\u000fY\n!\u0019!C\u0001Y!1q'\u0001Q\u0001\n5Bq\u0001O\u0001C\u0002\u0013\u0005\u0011\b\u0003\u0004>\u0003\u0001\u0006IA\u000f\u0004\u0005Ca\u0001a\b\u0003\u0005F\u0013\t\u0005\t\u0015!\u0003G\u0011!a\u0015B!A!\u0002\u0013i\u0005\u0002C)\n\u0005\u0003\u0005\u000b\u0011\u0002*\t\u0011\u0005L!\u0011!Q\u0001\n\tD\u0001\"Z\u0005\u0003\u0002\u0003\u0006IA\u001a\u0005\u0006S%!\tA\u001b\u0005\bc&\u0001\r\u0011\"\u0003s\u0011!y\u0018\u00021A\u0005\n\u0005\u0005\u0001bBA\u0007\u0013\u0001\u0006Ka\u001d\u0005\b\u0003/IA\u0011AA\r\u0011\u001d\tY\"\u0003C\u0005\u00033Aq!!\b\n\t\u0013\ty\u0002C\u0004\u0002>%!\t!a\u0010\u00027\rcWo\u001d;fe2Kgn\u001b*fO&|g.\u00197NKR\fG-\u0019;b\u0015\tI\"$\u0001\u0003mS:\\'BA\u000e\u001d\u0003\u0019\u0019XM\u001d<fe*\tQ$A\u0003lC\u001a\\\u0017m\u0001\u0001\u0011\u0005\u0001\nQ\"\u0001\r\u00037\rcWo\u001d;fe2Kgn\u001b*fO&|g.\u00197NKR\fG-\u0019;b'\t\t1\u0005\u0005\u0002%O5\tQEC\u0001'\u0003\u0015\u00198-\u00197b\u0013\tASE\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003}\tabY8oM2,XM\u001c;F]ZLE-F\u0001.!\tq3'D\u00010\u0015\t\u0001\u0014'\u0001\u0003mC:<'\"\u0001\u001a\u0002\t)\fg/Y\u0005\u0003i=\u0012aa\u0015;sS:<\u0017aD2p]\u001adW/\u001a8u\u000b:4\u0018\n\u001a\u0011\u0002\u001d\r|gN\u001a7vK:$xJ]4JI\u0006y1m\u001c8gYV,g\u000e^(sO&#\u0007%A\u0004sKR\u0014\u00180T:\u0016\u0003i\u0002\"\u0001J\u001e\n\u0005q*#aA%oi\u0006A!/\u001a;ss6\u001b\beE\u0002\nG}\u0002\"\u0001Q\"\u000e\u0003\u0005S!A\u0011\u000f\u0002\u000bU$\u0018\u000e\\:\n\u0005\u0011\u000b%a\u0002'pO\u001eLgnZ\u0001\u001eG\u0006tGK]1og2\fG/\u001a\"p_R\u001cHO]1q'V\u0004\b\u000f\\5feB\u0019AeR%\n\u0005!+#!\u0003$v]\u000e$\u0018n\u001c81!\t!#*\u0003\u0002LK\t9!i\\8mK\u0006t\u0017\u0001\u00042s_.,'oQ8oM&<\u0007C\u0001(P\u001b\u0005Q\u0012B\u0001)\u001b\u0005-Y\u0015MZ6b\u0007>tg-[4\u0002'5,H\u000e^5UK:\fg\u000e^'fi\u0006$\u0017\r^1\u0011\u0007\u0011\u001aV+\u0003\u0002UK\t1q\n\u001d;j_:\u0004\"AV0\u000e\u0003]S!\u0001W-\u0002\u00175,H\u000e^5uK:\fg\u000e\u001e\u0006\u00037iS!!H.\u000b\u0005qk\u0016AB1qC\u000eDWMC\u0001_\u0003\ry'oZ\u0005\u0003A^\u00131#T;mi&$VM\\1oi6+G/\u00193bi\u0006\f\u0011b]2iK\u0012,H.\u001a:\u0011\u0005\u0001\u001a\u0017B\u00013\u0019\u0005Q\u0019E.^:uKJd\u0015N\\6TG\",G-\u001e7fe\u00061\"/Z4j_:\fG.T3uC\u0012\fG/Y\"mS\u0016tG\u000fE\u0002%'\u001e\u0004\"A\u00145\n\u0005%T\"A\u0006*fO&|g.\u00197NKR\fG-\u0019;b\u00072LWM\u001c;\u0015\r-dWN\\8q!\t\u0001\u0013\u0002C\u0003F\u001f\u0001\u0007a\tC\u0003M\u001f\u0001\u0007Q\nC\u0003R\u001f\u0001\u0007!\u000bC\u0003b\u001f\u0001\u0007!\rC\u0003f\u001f\u0001\u0007a-A\u0006oKR<xN]6UsB,W#A:\u0011\u0005QlX\"A;\u000b\u0005Y<\u0018aE*bg2Le\u000e^3s]\u0006d7i\u001c8gS\u001e\u001c(B\u0001=z\u00035\tW\u000f\u001e5f]RL7-\u0019;pe*\u0011!p_\u0001\tg\u0016\u001cWO]5us*\u0011APW\u0001\u0007G>lWn\u001c8\n\u0005y,(a\u0003(fi^|'o\u001b+za\u0016\fqB\\3uo>\u00148\u000eV=qK~#S-\u001d\u000b\u0005\u0003\u0007\tI\u0001E\u0002%\u0003\u000bI1!a\u0002&\u0005\u0011)f.\u001b;\t\u0011\u0005-\u0011#!AA\u0002M\f1\u0001\u001f\u00132\u00031qW\r^<pe.$\u0016\u0010]3!Q\r\u0011\u0012\u0011\u0003\t\u0004I\u0005M\u0011bAA\u000bK\tAao\u001c7bi&dW-A\u0004ti\u0006\u0014H/\u001e9\u0015\u0005\u0005\r\u0011aE4fi2{7-\u00197OKR<xN]6UsB,\u0017AG:f]\u0012tU\r^<pe.lU\r^1eCR\f'+Z9vKN$HCBA\u0002\u0003C\tI\u0004C\u0004\u0002$U\u0001\r!!\n\u0002\u001d=\u0014x-\u00198ju\u0006$\u0018n\u001c8JIB!\u0011qEA\u001b\u001d\u0011\tI#!\r\u0011\u0007\u0005-R%\u0004\u0002\u0002.)\u0019\u0011q\u0006\u0010\u0002\rq\u0012xn\u001c;?\u0013\r\t\u0019$J\u0001\u0007!J,G-\u001a4\n\u0007Q\n9DC\u0002\u00024\u0015Bq!a\u000f\u0016\u0001\u0004\t)#A\u0007f]ZL'o\u001c8nK:$\u0018\nZ\u0001\u0016O\u0016$8\t\\;ti\u0016\u0014h*\u001a;x_J\\G+\u001f9f+\t\t\t\u0005E\u0002\u0002DutA!!\u0012\u0002^9!\u0011qIA.\u001d\u0011\tI%!\u0017\u000f\t\u0005-\u0013q\u000b\b\u0005\u0003\u001b\n)F\u0004\u0003\u0002P\u0005Mc\u0002BA\u0016\u0003#J\u0011AX\u0005\u00039vK!!H.\n\u0005qT\u0016B\u0001>|\u0013\tA\u00180\u0003\u0002wo\u0002")
public class ClusterLinkRegionalMetadata
implements Logging {
    private final Function0<Object> canTranslateBootstrapSupplier;
    private final KafkaConfig brokerConfig;
    private final Option<MultiTenantMetadata> multiTenantMetadata;
    private final ClusterLinkScheduler scheduler;
    private final Option<RegionalMetadataClient> regionalMetadataClient;
    private volatile SaslInternalConfigs.NetworkType networkType;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static int retryMs() {
        return ClusterLinkRegionalMetadata$.MODULE$.retryMs();
    }

    public static String confluentOrgId() {
        return ClusterLinkRegionalMetadata$.MODULE$.confluentOrgId();
    }

    public static String confluentEnvId() {
        return ClusterLinkRegionalMetadata$.MODULE$.confluentEnvId();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private SaslInternalConfigs.NetworkType networkType() {
        return this.networkType;
    }

    private void networkType_$eq(SaslInternalConfigs.NetworkType x$1) {
        this.networkType = x$1;
    }

    public void startup() {
        if (this.canTranslateBootstrapSupplier.apply$mcZ$sp() && this.regionalMetadataClient.isDefined() && this.multiTenantMetadata.isDefined()) {
            this.info((Function0<String>)(Function0 & Serializable)() -> "Getting cluster link regional metadata");
            this.scheduler.scheduleOnce("ClusterLinkRegionalMetadata", () -> this.getLocalNetworkType());
            return;
        }
    }

    private void getLocalNetworkType() {
        try {
            if (this.canTranslateBootstrapSupplier.apply$mcZ$sp()) {
                LogicalClusterMetadata firstActiveUserLkcMetadata = ((MultiTenantMetadata)this.multiTenantMetadata.get()).firstActiveUserLkcMetadata();
                if (firstActiveUserLkcMetadata != null) {
                    this.sendNetworkMetadataRequest(firstActiveUserLkcMetadata.organizationId(), firstActiveUserLkcMetadata.environmentId());
                } else {
                    this.sendNetworkMetadataRequest(ClusterLinkRegionalMetadata$.MODULE$.confluentOrgId(), ClusterLinkRegionalMetadata$.MODULE$.confluentEnvId());
                }
            }
        }
        catch (Throwable e) {
            this.error((Function0<String>)(Function0 & Serializable)() -> "Exception when getting local network type, will retry after ", (Function0<Throwable>)(Function0 & Serializable)() -> e);
            if (this.scheduler.isStarted()) {
                this.scheduler.scheduleOnce("ClusterLinkRegionalMetadata", () -> this.getLocalNetworkType(), ClusterLinkRegionalMetadata$.MODULE$.retryMs());
                return;
            }
            this.warn((Function0<String>)(Function0 & Serializable)() -> "Stop scheduling because scheduler is shutdown");
        }
    }

    private void sendNetworkMetadataRequest(String organizationId, String environmentId) {
        new ClusterLinkRegionalMetadataNetworkOp(organizationId, environmentId, this.brokerConfig.trafficNetworkId(), (RegionalMetadataClient)this.regionalMetadataClient.get()).execute().whenComplete((networkMetadata, ex) -> {
            if (ex != null) {
                this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(77).append("Failed to get local network type with organization ").append(organizationId).append(" environment ").append(environmentId).append(" and network ").append($this.brokerConfig.trafficNetworkId()).toString(), (Function0<Throwable>)(Function0 & Serializable)() -> ex);
                $this.scheduler.scheduleOnce("ClusterLinkRegionalMetadata", () -> this.getLocalNetworkType(), ClusterLinkRegionalMetadata$.MODULE$.retryMs());
                return;
            }
            if (!networkMetadata.isDefined()) {
                this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(78).append("Local network type is unavailable with organization ").append(organizationId).append(" environment ").append(environmentId).append(" and network ").append($this.brokerConfig.trafficNetworkId()).toString());
                $this.scheduler.scheduleOnce("ClusterLinkRegionalMetadata", () -> this.getLocalNetworkType(), ClusterLinkRegionalMetadata$.MODULE$.retryMs());
                return;
            }
            this.networkType_$eq(((RegionalNetworkMetadata)networkMetadata.get()).isPrivate() ? SaslInternalConfigs.NetworkType.PRIVATE : SaslInternalConfigs.NetworkType.PUBLIC);
            this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(22).append("Local network type is ").append(this.networkType().name()).toString());
        });
    }

    public SaslInternalConfigs.NetworkType getClusterNetworkType() {
        return this.networkType();
    }

    public ClusterLinkRegionalMetadata(Function0<Object> canTranslateBootstrapSupplier, KafkaConfig brokerConfig, Option<MultiTenantMetadata> multiTenantMetadata, ClusterLinkScheduler scheduler, Option<RegionalMetadataClient> regionalMetadataClient) {
        this.canTranslateBootstrapSupplier = canTranslateBootstrapSupplier;
        this.brokerConfig = brokerConfig;
        this.multiTenantMetadata = multiTenantMetadata;
        this.scheduler = scheduler;
        this.regionalMetadataClient = regionalMetadataClient;
        this.logIdent_$eq(new StringBuilder(38).append("[ClusterLinkRegionalMetadata-broker-").append(brokerConfig.brokerId()).append("] ").toString());
        this.networkType = SaslInternalConfigs.NetworkType.NOT_SET;
    }
}

