/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;
import kafka.server.ClusterLinkRequestQuota;
import kafka.server.LinkRequestQuotaUsageType$Fetcher$;
import kafka.server.link.ClusterLinkFetcherThreadPool;
import kafka.server.link.ClusterLinkFetcherWithSharedThread;
import kafka.server.link.ClusterLinkNetworkClient;
import kafka.server.link.SharedFetcherTag;
import kafka.utils.Logging;
import org.apache.kafka.common.utils.ExponentialBackoff;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.util.ShutdownableThread;
import scala.Function0;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005mb!B\f\u0019\u0001aq\u0002\u0002C\u0019\u0001\u0005\u0003\u0005\u000b\u0011B\u001a\t\u0011\u0001\u0003!Q1A\u0005\u0002\u0005C\u0001B\u0012\u0001\u0003\u0002\u0003\u0006IA\u0011\u0005\t\u000f\u0002\u0011\t\u0011)A\u0005g!A\u0001\n\u0001BC\u0002\u0013\u0005\u0011\n\u0003\u0005N\u0001\t\u0005\t\u0015!\u0003K\u0011!q\u0005A!b\u0001\n\u0003y\u0005\u0002C*\u0001\u0005\u0003\u0005\u000b\u0011\u0002)\t\u0011Q\u0003!Q1A\u0005\u0002UC\u0001B\u0017\u0001\u0003\u0002\u0003\u0006IA\u0016\u0005\t7\u0002\u0011\t\u0011)A\u00059\"A1\r\u0001B\u0001B\u0003%A\rC\u0003h\u0001\u0011\u0005\u0001\u000eC\u0004s\u0001\t\u0007I\u0011A:\t\u000f\u0005%\u0001\u0001)A\u0005i\"9\u00111\u0002\u0001\u0005\u0002\u00055\u0001bBA\u000f\u0001\u0011\u0005\u0011q\u0004\u0005\b\u0003K\u0001A\u0011AA\u0014\u0011\u001d\tI\u0003\u0001C!\u0003WAq!!\f\u0001\t\u0003\ny\u0003C\u0004\u00028\u0001!\t%a\u000b\t\u000f\u0005e\u0002\u0001\"\u0011\u0002,\tq2\t\\;ti\u0016\u0014H*\u001b8l'\"\f'/\u001a3GKR\u001c\u0007.\u001a:UQJ,\u0017\r\u001a\u0006\u00033i\tA\u0001\\5oW*\u00111\u0004H\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003u\tQa[1gW\u0006\u001c2\u0001A\u0010,!\t\u0001\u0013&D\u0001\"\u0015\t\u00113%\u0001\u0003vi&d'BA\u000e%\u0015\tiRE\u0003\u0002'O\u00051\u0011\r]1dQ\u0016T\u0011\u0001K\u0001\u0004_J<\u0017B\u0001\u0016\"\u0005I\u0019\u0006.\u001e;e_^t\u0017M\u00197f)\"\u0014X-\u00193\u0011\u00051zS\"A\u0017\u000b\u00059b\u0012!B;uS2\u001c\u0018B\u0001\u0019.\u0005\u001daunZ4j]\u001e\fAA\\1nK\u000e\u0001\u0001C\u0001\u001b>\u001d\t)4\b\u0005\u00027s5\tqG\u0003\u00029e\u00051AH]8pizR\u0011AO\u0001\u0006g\u000e\fG.Y\u0005\u0003ye\na\u0001\u0015:fI\u00164\u0017B\u0001 @\u0005\u0019\u0019FO]5oO*\u0011A(O\u0001\u0011g\"\f'/\u001a3GKR\u001c\u0007.\u001a:UC\u001e,\u0012A\u0011\t\u0003\u0007\u0012k\u0011\u0001G\u0005\u0003\u000bb\u0011\u0001c\u00155be\u0016$g)\u001a;dQ\u0016\u0014H+Y4\u0002#MD\u0017M]3e\r\u0016$8\r[3s)\u0006<\u0007%\u0001\u0005mS:\\g*Y7f\u0003)!\bN]3bIB{w\u000e\\\u000b\u0002\u0015B\u00111iS\u0005\u0003\u0019b\u0011Ad\u00117vgR,'\u000fT5oW\u001a+Go\u00195feRC'/Z1e!>|G.A\u0006uQJ,\u0017\r\u001a)p_2\u0004\u0013!E2mkN$XM\u001d'j].\u001cE.[3oiV\t\u0001\u000b\u0005\u0002D#&\u0011!\u000b\u0007\u0002\u0019\u00072,8\u000f^3s\u0019&t7NT3uo>\u00148n\u00117jK:$\u0018AE2mkN$XM\u001d'j].\u001cE.[3oi\u0002\nQ!];pi\u0006,\u0012A\u0016\t\u0003/bk\u0011AG\u0005\u00033j\u0011qc\u00117vgR,'\u000fT5oWJ+\u0017/^3tiF+x\u000e^1\u0002\rE,x\u000e^1!\u0003\u001d\u0011\u0017mY6pM\u001a\u0004\"!X1\u000e\u0003yS!AL0\u000b\u0005\u0001$\u0013AB2p[6|g.\u0003\u0002c=\n\u0011R\t\u001f9p]\u0016tG/[1m\u0005\u0006\u001c7n\u001c4g\u0003\u0011!\u0018.\\3\u0011\u0005u+\u0017B\u00014_\u0005\u0011!\u0016.\\3\u0002\rqJg.\u001b;?)%I'n\u001b7n]>\u0004\u0018\u000f\u0005\u0002D\u0001!)\u0011'\u0004a\u0001g!)\u0001)\u0004a\u0001\u0005\")q)\u0004a\u0001g!)\u0001*\u0004a\u0001\u0015\")a*\u0004a\u0001!\")A+\u0004a\u0001-\")1,\u0004a\u00019\")1-\u0004a\u0001I\u0006Aa-\u001a;dQ\u0016\u00148/F\u0001u!\u0015)80`A\u0002\u001b\u00051(BA<y\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0003EeT\u0011A_\u0001\u0005U\u00064\u0018-\u0003\u0002}m\n\t2i\u001c8dkJ\u0014XM\u001c;ICNDW*\u00199\u0011\u0005y|X\"A\u001d\n\u0007\u0005\u0005\u0011HA\u0002J]R\u00042aQA\u0003\u0013\r\t9\u0001\u0007\u0002#\u00072,8\u000f^3s\u0019&t7NR3uG\",'oV5uQNC\u0017M]3e)\"\u0014X-\u00193\u0002\u0013\u0019,Go\u00195feN\u0004\u0013AC1eI\u001a+Go\u00195feR1\u0011qBA\u000b\u00033\u00012A`A\t\u0013\r\t\u0019\"\u000f\u0002\u0005+:LG\u000f\u0003\u0004\u0002\u0018A\u0001\r!`\u0001\u000fg>,(oY3Ce>\\WM]%e\u0011\u001d\tY\u0002\u0005a\u0001\u0003\u0007\tqAZ3uG\",'/A\u0007sK6|g/\u001a$fi\u000eDWM\u001d\u000b\u0007\u0003\u001f\t\t#a\t\t\r\u0005]\u0011\u00031\u0001~\u0011\u001d\tY\"\u0005a\u0001\u0003\u0007\t1B\\;n\r\u0016$8\r[3sgV\tQ0\u0001\u0004e_^{'o\u001b\u000b\u0003\u0003\u001f\t\u0001#\u001b8ji&\fG/Z*ikR$wn\u001e8\u0015\u0005\u0005E\u0002c\u0001@\u00024%\u0019\u0011QG\u001d\u0003\u000f\t{w\u000e\\3b]\u0006i\u0011m^1jiNCW\u000f\u001e3po:\f\u0001b\u001d5vi\u0012|wO\u001c")
public class ClusterLinkSharedFetcherThread
extends ShutdownableThread
implements Logging {
    private final SharedFetcherTag sharedFetcherTag;
    private final ClusterLinkFetcherThreadPool threadPool;
    private final ClusterLinkNetworkClient clusterLinkClient;
    private final ClusterLinkRequestQuota quota;
    private final ExponentialBackoff backoff;
    private final Time time;
    private final ConcurrentHashMap<Object, ClusterLinkFetcherWithSharedThread> fetchers;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public SharedFetcherTag sharedFetcherTag() {
        return this.sharedFetcherTag;
    }

    public ClusterLinkFetcherThreadPool threadPool() {
        return this.threadPool;
    }

    public ClusterLinkNetworkClient clusterLinkClient() {
        return this.clusterLinkClient;
    }

    public ClusterLinkRequestQuota quota() {
        return this.quota;
    }

    public ConcurrentHashMap<Object, ClusterLinkFetcherWithSharedThread> fetchers() {
        return this.fetchers;
    }

    public void addFetcher(int sourceBrokerId, ClusterLinkFetcherWithSharedThread fetcher) {
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(35).append("Adding fetcher ").append(fetcher.name()).append(" with source leader ").append(sourceBrokerId).toString());
        if (this.fetchers().putIfAbsent(BoxesRunTime.boxToInteger((int)sourceBrokerId), fetcher) != null) {
            throw new IllegalStateException(new StringBuilder(46).append("Fetcher ").append(fetcher.name()).append(" has already been added to this thread").toString());
        }
        this.clusterLinkClient().networkClient().wakeup();
    }

    public void removeFetcher(int sourceBrokerId, ClusterLinkFetcherWithSharedThread fetcher) {
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(37).append("Removing fetcher ").append(fetcher.name()).append(" with source leader ").append(sourceBrokerId).toString());
        if (!this.fetchers().remove(BoxesRunTime.boxToInteger((int)sourceBrokerId), fetcher)) {
            this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(84).append("Fetcher ").append(fetcher.name()).append(" for source broker ").append(sourceBrokerId).append(" not present in the fetcher thread, fetchers present are ").append(this.fetchers()).toString());
        }
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(61).append("Removed fetcher ").append(fetcher.name()).append(" with source leader ").append(sourceBrokerId).append(", fetchers remaining are ").append(this.fetchers()).toString());
    }

    public int numFetchers() {
        return this.fetchers().size();
    }

    public void doWork() {
        long timeoutMs = this.fetchers().values().stream().allMatch(x$2 -> x$2.isBlocked()) ? this.backoff.backoff(0L) : 0L;
        this.clusterLinkClient().networkClient().poll(timeoutMs, this.time.milliseconds());
        long start = this.time.nanoseconds();
        try {
            this.fetchers().values().forEach(x$3 -> x$3.doWork());
        }
        finally {
            this.quota().record(this.time.nanoseconds() - start, LinkRequestQuotaUsageType$Fetcher$.MODULE$);
        }
    }

    public boolean initiateShutdown() {
        this.info((Function0<String>)(Function0 & Serializable)() -> "Shutting down fetcher thread");
        boolean justShutdown = super.initiateShutdown();
        if (justShutdown) {
            this.fetchers().values().forEach(x$4 -> x$4.initiateShutdown());
        }
        return justShutdown;
    }

    public void awaitShutdown() {
        this.fetchers().values().forEach(x$5 -> x$5.awaitShutdown());
        super.awaitShutdown();
    }

    public void shutdown() {
        this.fetchers().values().forEach(x$6 -> x$6.shutdown());
        this.clusterLinkClient().close();
        super.shutdown();
    }

    public ClusterLinkSharedFetcherThread(String name, SharedFetcherTag sharedFetcherTag, String linkName, ClusterLinkFetcherThreadPool threadPool, ClusterLinkNetworkClient clusterLinkClient, ClusterLinkRequestQuota quota, ExponentialBackoff backoff, Time time) {
        this.sharedFetcherTag = sharedFetcherTag;
        this.threadPool = threadPool;
        this.clusterLinkClient = clusterLinkClient;
        this.quota = quota;
        this.backoff = backoff;
        this.time = time;
        super(name, false);
        this.logIdent_$eq(new StringBuilder(3).append("[").append(name).append("] ").toString());
        this.fetchers = new ConcurrentHashMap();
        this.info((Function0<String>)(Function0 & Serializable)() -> "Starting fetcher thread");
    }
}

