/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.metadata;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalDouble;
import kafka.network.ConnectionQuotas;
import kafka.server.ClientQuotaManager;
import kafka.server.MetadataRequestMinimumThrottleConfig;
import kafka.server.QuotaFactory;
import kafka.server.metadata.ClientIdEntity;
import kafka.server.metadata.DefaultClientIdEntity$;
import kafka.server.metadata.DefaultIpEntity$;
import kafka.server.metadata.DefaultTenantEntity$;
import kafka.server.metadata.DefaultUserDefaultClientIdEntity$;
import kafka.server.metadata.DefaultUserEntity$;
import kafka.server.metadata.DefaultUserExplicitClientIdEntity;
import kafka.server.metadata.ExplicitUserDefaultClientIdEntity;
import kafka.server.metadata.ExplicitUserExplicitClientIdEntity;
import kafka.server.metadata.IpEntity;
import kafka.server.metadata.QuotaEntity;
import kafka.server.metadata.TenantEntity;
import kafka.server.metadata.UserEntity;
import kafka.utils.Logging;
import org.apache.kafka.common.metrics.Quota;
import org.apache.kafka.common.quota.ClientQuotaEntity;
import org.apache.kafka.common.utils.Sanitizer;
import org.apache.kafka.image.ClientQuotaDelta;
import org.apache.kafka.image.ClientQuotasDelta;
import org.apache.kafka.server.authorizer.AuthorizerConfig;
import org.apache.kafka.storage.internals.log.ProducerStateManagerConfig;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Product;
import scala.Some;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u0005mc\u0001B\t\u0013\u0001eA\u0011B\n\u0001\u0003\u0006\u0004%\tAE\u0014\t\u0011Y\u0002!\u0011!Q\u0001\n!B\u0011b\u000e\u0001\u0003\u0006\u0004%\tA\u0005\u001d\t\u0011}\u0002!\u0011!Q\u0001\neB\u0011\u0002\u0011\u0001\u0003\u0006\u0004%\tAE!\t\u0011E\u0003!\u0011!Q\u0001\n\tC\u0011B\u0015\u0001\u0003\u0006\u0004%\tAE*\t\u0011a\u0003!\u0011!Q\u0001\nQC\u0011\"\u0017\u0001\u0003\u0006\u0004%\tA\u0005.\t\u0011\u0015\u0004!\u0011!Q\u0001\nmCQA\u001a\u0001\u0005\u0002\u001dDQa\u001c\u0001\u0005\u0002ADQa\u001c\u0001\u0005\nqDq!!\u0007\u0001\t\u0013\tY\u0002C\u0004\u0002*\u0001!\t!a\u000b\t\u000f\u0005M\u0002\u0001\"\u0003\u00026\tQ2\t\\5f]R\fVo\u001c;b\u001b\u0016$\u0018\rZ1uC6\u000bg.Y4fe*\u00111\u0003F\u0001\t[\u0016$\u0018\rZ1uC*\u0011QCF\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003]\tQa[1gW\u0006\u001c\u0001aE\u0002\u00015\u0001\u0002\"a\u0007\u0010\u000e\u0003qQ\u0011!H\u0001\u0006g\u000e\fG.Y\u0005\u0003?q\u0011a!\u00118z%\u00164\u0007CA\u0011%\u001b\u0005\u0011#BA\u0012\u0017\u0003\u0015)H/\u001b7t\u0013\t)#EA\u0004M_\u001e<\u0017N\\4\u0002\u001bE,x\u000e^1NC:\fw-\u001a:t+\u0005A\u0003CA\u00154\u001d\tQ\u0013G\u0004\u0002,a9\u0011AfL\u0007\u0002[)\u0011a\u0006G\u0001\u0007yI|w\u000e\u001e \n\u0003]I!!\u0006\f\n\u0005I\"\u0012\u0001D)v_R\fg)Y2u_JL\u0018B\u0001\u001b6\u00055\tVo\u001c;b\u001b\u0006t\u0017mZ3sg*\u0011!\u0007F\u0001\u000fcV|G/Y'b]\u0006<WM]:!\u0003A\u0019wN\u001c8fGRLwN\\)v_R\f7/F\u0001:!\tQT(D\u0001<\u0015\tad#A\u0004oKR<xN]6\n\u0005yZ$\u0001E\"p]:,7\r^5p]F+x\u000e^1t\u0003E\u0019wN\u001c8fGRLwN\\)v_R\f7\u000fI\u0001\u001baJ|G-^2feN#\u0018\r^3NC:\fw-\u001a:D_:4\u0017nZ\u000b\u0002\u0005B\u00111iT\u0007\u0002\t*\u0011QIR\u0001\u0004Y><'BA$I\u0003%Ig\u000e^3s]\u0006d7O\u0003\u0002J\u0015\u000691\u000f^8sC\u001e,'BA\fL\u0015\taU*\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u001d\u0006\u0019qN]4\n\u0005A#%A\u0007)s_\u0012,8-\u001a:Ti\u0006$X-T1oC\u001e,'oQ8oM&<\u0017a\u00079s_\u0012,8-\u001a:Ti\u0006$X-T1oC\u001e,'oQ8oM&<\u0007%\u0001\u0013nKR\fG-\u0019;b%\u0016\fX/Z:u\u001b&t\u0017.\\;n)\"\u0014x\u000e\u001e;mK\u000e{gNZ5h+\u0005!\u0006CA+W\u001b\u0005!\u0012BA,\u0015\u0005\u0011jU\r^1eCR\f'+Z9vKN$X*\u001b8j[VlG\u000b\u001b:piRdWmQ8oM&<\u0017!J7fi\u0006$\u0017\r^1SKF,Xm\u001d;NS:LW.^7UQJ|G\u000f\u001e7f\u0007>tg-[4!\u0003M\tW\u000f\u001e5pe&TXM]\"p]\u001aLwm\u00149u+\u0005Y\u0006cA\u000e]=&\u0011Q\f\b\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005}\u001bW\"\u00011\u000b\u0005\u0005\u0014\u0017AC1vi\"|'/\u001b>fe*\u0011QCS\u0005\u0003I\u0002\u0014\u0001#Q;uQ>\u0014\u0018N_3s\u0007>tg-[4\u0002)\u0005,H\u000f[8sSj,'oQ8oM&<w\n\u001d;!\u0003\u0019a\u0014N\\5u}Q1\u0001N[6m[:\u0004\"!\u001b\u0001\u000e\u0003IAQAJ\u0006A\u0002!BQaN\u0006A\u0002eBQ\u0001Q\u0006A\u0002\tCQAU\u0006A\u0002QCQ!W\u0006A\u0002m\u000ba!\u001e9eCR,GCA9u!\tY\"/\u0003\u0002t9\t!QK\\5u\u0011\u0015)H\u00021\u0001w\u0003-\tXo\u001c;bg\u0012+G\u000e^1\u0011\u0005]TX\"\u0001=\u000b\u0005eT\u0015!B5nC\u001e,\u0017BA>y\u0005E\u0019E.[3oiF+x\u000e^1t\t\u0016dG/\u0019\u000b\u0005cv\fy\u0001C\u0003\u007f\u001b\u0001\u0007q0\u0001\u0004f]RLG/\u001f\t\u0005\u0003\u0003\tY!\u0004\u0002\u0002\u0004)!\u0011QAA\u0004\u0003\u0015\tXo\u001c;b\u0015\r\tIAS\u0001\u0007G>lWn\u001c8\n\t\u00055\u00111\u0001\u0002\u0012\u00072LWM\u001c;Rk>$\u0018-\u00128uSRL\bbBA\t\u001b\u0001\u0007\u00111C\u0001\u000bcV|G/\u0019#fYR\f\u0007cA<\u0002\u0016%\u0019\u0011q\u0003=\u0003!\rc\u0017.\u001a8u#V|G/\u0019#fYR\f\u0017!\u00045b]\u0012dW-\u00139Rk>$\u0018\rF\u0003r\u0003;\t9\u0003C\u0004\u0002 9\u0001\r!!\t\u0002\u0011%\u0004XI\u001c;jif\u00042![A\u0012\u0013\r\t)C\u0005\u0002\f#V|G/Y#oi&$\u0018\u0010C\u0004\u0002\u00129\u0001\r!a\u0005\u0002#!\fg\u000e\u001a7f)\u0016t\u0017M\u001c;Rk>$\u0018\rF\u0003r\u0003[\t\t\u0004C\u0004\u00020=\u0001\r!!\t\u0002\u0019Q,g.\u00198u\u000b:$\u0018\u000e^=\t\u000f\u0005Eq\u00021\u0001\u0002\u0014\u0005Y\u0002.\u00198eY\u0016,6/\u001a:DY&,g\u000e^)v_R\f7\t[1oO\u0016$r!]A\u001c\u0003w\ty\u0005C\u0004\u0002:A\u0001\r!!\t\u0002\u0017E,x\u000e^1F]RLG/\u001f\u0005\b\u0003{\u0001\u0002\u0019AA \u0003\rYW-\u001f\t\u0005\u0003\u0003\nIE\u0004\u0003\u0002D\u0005\u0015\u0003C\u0001\u0017\u001d\u0013\r\t9\u0005H\u0001\u0007!J,G-\u001a4\n\t\u0005-\u0013Q\n\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005\u001dC\u0004C\u0004\u0002RA\u0001\r!a\u0015\u0002\u00119,wOV1mk\u0016\u0004Ba\u0007/\u0002VA\u00191$a\u0016\n\u0007\u0005eCD\u0001\u0004E_V\u0014G.\u001a")
public class ClientQuotaMetadataManager
implements Logging {
    private final QuotaFactory.QuotaManagers quotaManagers;
    private final ConnectionQuotas connectionQuotas;
    private final ProducerStateManagerConfig producerStateManagerConfig;
    private final MetadataRequestMinimumThrottleConfig metadataRequestMinimumThrottleConfig;
    private final Option<AuthorizerConfig> authorizerConfigOpt;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public QuotaFactory.QuotaManagers quotaManagers() {
        return this.quotaManagers;
    }

    public ConnectionQuotas connectionQuotas() {
        return this.connectionQuotas;
    }

    public ProducerStateManagerConfig producerStateManagerConfig() {
        return this.producerStateManagerConfig;
    }

    public MetadataRequestMinimumThrottleConfig metadataRequestMinimumThrottleConfig() {
        return this.metadataRequestMinimumThrottleConfig;
    }

    public Option<AuthorizerConfig> authorizerConfigOpt() {
        return this.authorizerConfigOpt;
    }

    public void update(ClientQuotasDelta quotasDelta) {
        quotasDelta.changes().forEach((key, value) -> this.update((ClientQuotaEntity)key, (ClientQuotaDelta)value));
    }

    private void update(ClientQuotaEntity entity, ClientQuotaDelta quotaDelta) {
        if (entity.entries().containsKey("ip")) {
            Product product;
            Option option = Option$.MODULE$.apply(entity.entries().get("ip"));
            if (option instanceof Some) {
                String ip = (String)((Some)option).value();
                product = new IpEntity(ip);
            } else if (None$.MODULE$.equals(option)) {
                product = DefaultIpEntity$.MODULE$;
            } else {
                throw new MatchError((Object)option);
            }
            Product ipEntity = product;
            this.handleIpQuota((QuotaEntity)ipEntity, quotaDelta);
            return;
        }
        if (entity.entries().containsKey("confluent-tenant")) {
            Product product;
            Option option = Option$.MODULE$.apply(entity.entries().get("confluent-tenant"));
            if (option instanceof Some) {
                String tenant = (String)((Some)option).value();
                product = new TenantEntity(tenant);
            } else if (None$.MODULE$.equals(option)) {
                product = DefaultTenantEntity$.MODULE$;
            } else {
                throw new MatchError((Object)option);
            }
            Product tenantEntity = product;
            this.handleTenantQuota((QuotaEntity)tenantEntity, quotaDelta);
            return;
        }
        if (entity.entries().containsKey("user") || entity.entries().containsKey("client-id")) {
            String userVal = (String)entity.entries().get("user");
            String clientIdVal = (String)entity.entries().get("client-id");
            Product userClientEntity = entity.entries().containsKey("user") && entity.entries().containsKey("client-id") ? (userVal == null && clientIdVal == null ? DefaultUserDefaultClientIdEntity$.MODULE$ : (userVal == null ? new DefaultUserExplicitClientIdEntity(clientIdVal) : (clientIdVal == null ? new ExplicitUserDefaultClientIdEntity(userVal) : new ExplicitUserExplicitClientIdEntity(userVal, clientIdVal)))) : (entity.entries().containsKey("user") ? (userVal == null ? DefaultUserEntity$.MODULE$ : new UserEntity(userVal)) : (clientIdVal == null ? DefaultClientIdEntity$.MODULE$ : new ClientIdEntity(clientIdVal)));
            quotaDelta.changes().forEach((key, value) -> this.handleUserClientQuotaChange((QuotaEntity)userClientEntity, (String)key, (Option<Object>)OptionConverters.RichOptionalDouble$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalDouble(value))));
            return;
        }
        this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(35).append("Ignoring unsupported quota entity ").append(entity).append(".").toString());
    }

    private void handleIpQuota(QuotaEntity ipEntity, ClientQuotaDelta quotaDelta) {
        None$ none$;
        if (ipEntity instanceof IpEntity) {
            String ip = ((IpEntity)ipEntity).ip();
            try {
                none$ = new Some((Object)InetAddress.getByName(ip));
            }
            catch (UnknownHostException unknownHostException) {
                throw new IllegalArgumentException(new StringBuilder(26).append("Unable to resolve address ").append(ip).toString());
            }
        } else if (DefaultIpEntity$.MODULE$.equals(ipEntity)) {
            none$ = None$.MODULE$;
        } else {
            throw new IllegalStateException("Should only handle IP quota entities here");
        }
        None$ inetAddress = none$;
        quotaDelta.changes().forEach((arg_0, arg_1) -> ClientQuotaMetadataManager.$anonfun$handleIpQuota$1(this, ipEntity, (Option)inetAddress, arg_0, arg_1));
    }

    public void handleTenantQuota(QuotaEntity tenantEntity, ClientQuotaDelta quotaDelta) {
        None$ none$;
        if (tenantEntity instanceof TenantEntity) {
            String tenant = ((TenantEntity)tenantEntity).tenant();
            none$ = new Some((Object)tenant);
        } else if (DefaultTenantEntity$.MODULE$.equals(tenantEntity)) {
            none$ = None$.MODULE$;
        } else {
            throw new IllegalStateException("Should only handle tenant quota entities here");
        }
        None$ tenantOpt = none$;
        quotaDelta.changes().entrySet().forEach(arg_0 -> ClientQuotaMetadataManager.$anonfun$handleTenantQuota$1(this, (Option)tenantOpt, tenantEntity, arg_0));
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void handleUserClientQuotaChange(QuotaEntity quotaEntity, String key, Option<Object> newValue) {
        None$ none$;
        Some some;
        ClientQuotaManager clientQuotaManager;
        block26: {
            switch (key == null ? 0 : key.hashCode()) {
                case -1805480786: {
                    if (!"consumer_byte_rate".equals(key)) break;
                    clientQuotaManager = this.quotaManagers().fetch();
                    break block26;
                }
                case -965904822: {
                    if (!"request_percentage".equals(key)) break;
                    clientQuotaManager = this.quotaManagers().request();
                    break block26;
                }
                case -832502454: {
                    if (!"producer_byte_rate".equals(key)) break;
                    clientQuotaManager = this.quotaManagers().produce();
                    break block26;
                }
                case -748852909: {
                    if (!"controller_mutation_rate".equals(key)) break;
                    clientQuotaManager = this.quotaManagers().controllerMutation();
                    break block26;
                }
            }
            this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(42).append("Ignoring unexpected quota key ").append(key).append(" for entity ").append(quotaEntity).toString());
            return;
        }
        ClientQuotaManager manager = clientQuotaManager;
        if (quotaEntity instanceof UserEntity) {
            String user = ((UserEntity)quotaEntity).user();
            some = new Some((Object)Sanitizer.sanitize((String)user));
            none$ = None$.MODULE$;
        } else if (DefaultUserEntity$.MODULE$.equals(quotaEntity)) {
            some = new Some((Object)"<default>");
            none$ = None$.MODULE$;
        } else if (quotaEntity instanceof ClientIdEntity) {
            String clientId = ((ClientIdEntity)quotaEntity).clientId();
            some = None$.MODULE$;
            none$ = new Some((Object)Sanitizer.sanitize((String)clientId));
        } else if (DefaultClientIdEntity$.MODULE$.equals(quotaEntity)) {
            some = None$.MODULE$;
            none$ = new Some((Object)"<default>");
        } else if (quotaEntity instanceof ExplicitUserExplicitClientIdEntity) {
            ExplicitUserExplicitClientIdEntity explicitUserExplicitClientIdEntity = (ExplicitUserExplicitClientIdEntity)quotaEntity;
            String user = explicitUserExplicitClientIdEntity.user();
            String clientId = explicitUserExplicitClientIdEntity.clientId();
            some = new Some((Object)Sanitizer.sanitize((String)user));
            none$ = new Some((Object)Sanitizer.sanitize((String)clientId));
        } else if (quotaEntity instanceof ExplicitUserDefaultClientIdEntity) {
            String user = ((ExplicitUserDefaultClientIdEntity)quotaEntity).user();
            some = new Some((Object)Sanitizer.sanitize((String)user));
            none$ = new Some((Object)"<default>");
        } else if (quotaEntity instanceof DefaultUserExplicitClientIdEntity) {
            String clientId = ((DefaultUserExplicitClientIdEntity)quotaEntity).clientId();
            some = new Some((Object)"<default>");
            none$ = new Some((Object)Sanitizer.sanitize((String)clientId));
        } else if (DefaultUserDefaultClientIdEntity$.MODULE$.equals(quotaEntity)) {
            some = new Some((Object)"<default>");
            none$ = new Some((Object)"<default>");
        } else {
            if (quotaEntity instanceof IpEntity ? true : DefaultIpEntity$.MODULE$.equals(quotaEntity)) {
                throw new IllegalStateException("Should not see IP quota entities here");
            }
            if (quotaEntity instanceof TenantEntity ? true : DefaultTenantEntity$.MODULE$.equals(quotaEntity)) {
                throw new IllegalStateException("Should not see tenant quota entities here");
            }
            throw new MatchError((Object)quotaEntity);
        }
        None$ none$2 = none$;
        Option sanitizedUser = (Option)some;
        Option sanitizedClientId = (Option)none$2;
        Option quotaValue = newValue.map((Function1 & Serializable)x$6 -> ClientQuotaMetadataManager.$anonfun$handleUserClientQuotaChange$2(BoxesRunTime.unboxToDouble((Object)x$6)));
        try {
            void var13_14;
            void var12_13;
            manager.updateQuota((Option<String>)var12_13, (Option<String>)var13_14.map((Function1 & Serializable)x$1 -> Sanitizer.desanitize((String)x$1)), (Option<String>)var13_14, (Option<Quota>)quotaValue);
            return;
        }
        catch (Throwable t) {
            this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(35).append("Failed to update user-client quota ").append(quotaEntity).toString(), (Function0<Throwable>)(Function0 & Serializable)() -> t);
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$handleIpQuota$1(ClientQuotaMetadataManager $this, QuotaEntity ipEntity$1, Option inetAddress$1, String key, OptionalDouble value) {
        if (!key.equals("connection_creation_rate")) {
            $this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(42).append("Ignoring unexpected quota key ").append(key).append(" for entity ").append(ipEntity$1).toString());
            return;
        }
        try {
            $this.connectionQuotas().updateIpConnectionRateQuota((Option<InetAddress>)inetAddress$1, (Option<Object>)OptionConverters.RichOptionalDouble$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalDouble(value)));
            return;
        }
        catch (Throwable t) {
            $this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(26).append("Failed to update IP quota ").append(ipEntity$1).toString(), (Function0<Throwable>)(Function0 & Serializable)() -> t);
            return;
        }
    }

    public static final /* synthetic */ Integer $anonfun$handleTenantQuota$5(int x) {
        return BoxesRunTime.boxToInteger((int)x);
    }

    public static final /* synthetic */ Integer $anonfun$handleTenantQuota$21(int x) {
        return BoxesRunTime.boxToInteger((int)x);
    }

    public static final /* synthetic */ void $anonfun$handleTenantQuota$19(ClientQuotaMetadataManager $this, Option tenantOpt$1, OptionalDouble quotaValue$1, AuthorizerConfig authorizerConfig) {
        authorizerConfig.setTenantMaxAcls(OptionConverters.RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8(tenantOpt$1)), OptionConverters.RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8(OptionConverters.RichOptionalDouble$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalDouble(quotaValue$1)).map((Function1)(JFunction1.mcID.sp & Serializable)x$4 -> (int)x$4).map((Function1 & Serializable)x -> ClientQuotaMetadataManager.$anonfun$handleTenantQuota$21(BoxesRunTime.unboxToInt((Object)x))))));
        $this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(56).append("Setting tenant-level max acl count limit for tenant ").append(OptionConverters.RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8(tenantOpt$1))).append(" to ").append(quotaValue$1).toString());
    }

    public static final /* synthetic */ void $anonfun$handleTenantQuota$1(ClientQuotaMetadataManager $this, Option tenantOpt$1, QuotaEntity tenantEntity$1, Map.Entry e) {
        String quotaName = (String)e.getKey();
        OptionalDouble quotaValue = (OptionalDouble)e.getValue();
        if (quotaName.equals("connection_creation_rate")) {
            try {
                $this.connectionQuotas().updateTenantConnectionRateQuota((Option<String>)tenantOpt$1, (Option<Object>)OptionConverters.RichOptionalDouble$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalDouble(quotaValue)));
                return;
            }
            catch (Throwable t) {
                $this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(30).append("Failed to update tenant quota ").append(tenantEntity$1).toString(), (Function0<Throwable>)(Function0 & Serializable)() -> t);
                return;
            }
        }
        if (quotaName.equals("producer_id_expiration_ms")) {
            try {
                Optional quotaValueIntOpt = OptionConverters.RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8(OptionConverters.RichOptionalDouble$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalDouble(quotaValue)).map((Function1)(JFunction1.mcID.sp & Serializable)x$1 -> (int)x$1).map((Function1 & Serializable)x -> ClientQuotaMetadataManager.$anonfun$handleTenantQuota$5(BoxesRunTime.unboxToInt((Object)x)))));
                $this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(59).append("Setting tenant-level producer ID expiration for tenant ").append(OptionConverters.RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8(tenantOpt$1))).append(" to ").append(quotaValueIntOpt).toString());
                $this.producerStateManagerConfig().setProducerIdExpirationMs(OptionConverters.RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8(tenantOpt$1)), quotaValueIntOpt);
                return;
            }
            catch (Throwable t) {
                $this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(30).append("Failed to update tenant quota ").append(tenantEntity$1).toString(), (Function0<Throwable>)(Function0 & Serializable)() -> t);
                return;
            }
        }
        if (quotaName.equals("metadata_request_minimum_throttle_ms")) {
            try {
                Option quotaValueIntOpt = OptionConverters.RichOptionalDouble$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalDouble(quotaValue)).map((Function1)(JFunction1.mcID.sp & Serializable)x$2 -> (int)x$2);
                $this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(70).append("Setting tenant-level metadata request minimum throttle for tenant ").append(OptionConverters.RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8(tenantOpt$1))).append(" to ").append(OptionConverters.RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8(quotaValueIntOpt))).toString());
                $this.metadataRequestMinimumThrottleConfig().setMinimumThrottle((Option<String>)tenantOpt$1, (Option<Object>)quotaValueIntOpt);
                $this.debug((Function0<String>)(Function0 & Serializable)() -> String.valueOf($this.metadataRequestMinimumThrottleConfig()));
                return;
            }
            catch (Throwable t) {
                $this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(30).append("Failed to update tenant quota ").append(tenantEntity$1).toString(), (Function0<Throwable>)(Function0 & Serializable)() -> t);
                return;
            }
        }
        if (quotaName.equals("connection_creation_count")) {
            try {
                $this.connectionQuotas().updateTenantConnectionCountQuota((Option<String>)tenantOpt$1, (Option<Object>)OptionConverters.RichOptionalDouble$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalDouble(quotaValue)).map((Function1)(JFunction1.mcID.sp & Serializable)x$3 -> (int)x$3).map((Function1)(JFunction1.mcII.sp & Serializable)x -> x));
                $this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(42).append("Setting tenant connection count quota ").append(OptionConverters.RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8(tenantOpt$1))).append(" to ").append(quotaValue).toString());
                return;
            }
            catch (Throwable t) {
                $this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(30).append("Failed to update tenant quota ").append(tenantEntity$1).toString(), (Function0<Throwable>)(Function0 & Serializable)() -> t);
                return;
            }
        }
        if (quotaName.equals("acl_count")) {
            try {
                $this.authorizerConfigOpt().foreach((Function1 & Serializable)authorizerConfig -> {
                    ClientQuotaMetadataManager.$anonfun$handleTenantQuota$19($this, tenantOpt$1, quotaValue, authorizerConfig);
                    return BoxedUnit.UNIT;
                });
                return;
            }
            catch (Throwable t) {
                $this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(30).append("Failed to update tenant quota ").append(tenantEntity$1).toString(), (Function0<Throwable>)(Function0 & Serializable)() -> t);
                return;
            }
        }
        $this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(42).append("Ignoring unexpected quota key ").append(quotaName).append(" for entity ").append(tenantEntity$1).toString());
    }

    public static final /* synthetic */ Quota $anonfun$handleUserClientQuotaChange$2(double x$6) {
        return new Quota(x$6, true);
    }

    public ClientQuotaMetadataManager(QuotaFactory.QuotaManagers quotaManagers, ConnectionQuotas connectionQuotas, ProducerStateManagerConfig producerStateManagerConfig, MetadataRequestMinimumThrottleConfig metadataRequestMinimumThrottleConfig, Option<AuthorizerConfig> authorizerConfigOpt) {
        this.quotaManagers = quotaManagers;
        this.connectionQuotas = connectionQuotas;
        this.producerStateManagerConfig = producerStateManagerConfig;
        this.metadataRequestMinimumThrottleConfig = metadataRequestMinimumThrottleConfig;
        this.authorizerConfigOpt = authorizerConfigOpt;
    }
}

