/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.domain;

import com.google.flatbuffers.FlatBufferBuilder;
import io.confluent.kafka.storage.tier.serdes.PartitionDeleteComplete;
import java.nio.ByteBuffer;
import java.util.UUID;
import kafka.tier.TopicIdPartition;
import kafka.tier.domain.AbstractTierMetadata;
import kafka.tier.domain.TierRecordType;
import kafka.tier.state.OffsetAndEpoch;

public class TierPartitionDeleteComplete
extends AbstractTierMetadata {
    private static final byte VERSION_V0 = 0;
    private static final byte CURRENT_VERSION = 0;
    private static final int INITIAL_BUFFER_SIZE = 40;
    private final TopicIdPartition topicIdPartition;
    private final PartitionDeleteComplete metadata;

    public TierPartitionDeleteComplete(TopicIdPartition topicIdPartition, UUID messageId) {
        FlatBufferBuilder builder = new FlatBufferBuilder(40).forceDefaults(true);
        PartitionDeleteComplete.startPartitionDeleteComplete((FlatBufferBuilder)builder);
        PartitionDeleteComplete.addVersion((FlatBufferBuilder)builder, (byte)0);
        int messageIdOffset = io.confluent.kafka.storage.tier.serdes.UUID.createUUID((FlatBufferBuilder)builder, (long)messageId.getMostSignificantBits(), (long)messageId.getLeastSignificantBits());
        PartitionDeleteComplete.addMessageId((FlatBufferBuilder)builder, (int)messageIdOffset);
        int entryId = PartitionDeleteComplete.endPartitionDeleteComplete((FlatBufferBuilder)builder);
        builder.finish(entryId);
        this.topicIdPartition = topicIdPartition;
        this.metadata = PartitionDeleteComplete.getRootAsPartitionDeleteComplete((ByteBuffer)builder.dataBuffer());
    }

    public TierPartitionDeleteComplete(TopicIdPartition topicIdPartition, PartitionDeleteComplete metadata) {
        this.topicIdPartition = topicIdPartition;
        this.metadata = metadata;
    }

    public static int initialBufferSize() {
        return 40;
    }

    @Override
    public TierRecordType type() {
        return TierRecordType.PartitionDeleteComplete;
    }

    @Override
    public TopicIdPartition topicIdPartition() {
        return this.topicIdPartition;
    }

    @Override
    public ByteBuffer payloadBuffer() {
        return this.metadata.getByteBuffer().duplicate();
    }

    @Override
    public int tierEpoch() {
        return -1;
    }

    @Override
    public OffsetAndEpoch stateOffsetAndEpoch() {
        return OffsetAndEpoch.EMPTY;
    }

    @Override
    public UUID messageId() {
        return new UUID(this.metadata.messageId().mostSignificantBits(), this.metadata.messageId().leastSignificantBits());
    }

    public String toString() {
        return "TierPartitionDeleteComplete(version=" + this.metadata.version() + ", topic=" + this.topicIdPartition() + ", messageId=" + this.messageId() + ")";
    }
}

