/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.state;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.google.flatbuffers.FlatBufferBuilder;
import io.confluent.kafka.storage.tier.serdes.MaterializationTrackingInfo;
import io.confluent.kafka.storage.tier.serdes.SnapshotTrackingInfo;
import io.confluent.kafka.storage.tier.serdes.TierPartitionStateHeader;
import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import kafka.tier.state.CompactStats;
import kafka.tier.state.OffsetAndEpoch;
import kafka.tier.state.TierPartitionStatus;
import kafka.utils.CoreUtils;
import org.apache.kafka.common.Uuid;

public class Header {
    static final int HEADER_LENGTH_LENGTH = 2;
    private final TierPartitionStateHeader header;
    private final MaterializationInfo materializationInfo;
    private final SnapshotInfo snapshotInfo;
    private final boolean compactFeatureFlag;
    private final boolean tierPartitionStateSnapshotFeatureFlag;
    public static final UUID SNAPSHOT_ID_EMPTY = new UUID(Uuid.ZERO_UUID.getMostSignificantBits(), Uuid.ZERO_UUID.getLeastSignificantBits());
    private static final ObjectMapper JSON_MAPPER = new ObjectMapper();

    public Header(TierPartitionStateHeader header) {
        this.header = header;
        this.materializationInfo = new MaterializationInfo(header.materializationInfo());
        this.snapshotInfo = new SnapshotInfo(header.snapshotInfo());
        this.compactFeatureFlag = this.hasCompactDirtyStartOffset();
        this.tierPartitionStateSnapshotFeatureFlag = this.hasSnapshotInfo();
    }

    public Header(UUID topicId, byte version, int tierEpoch, TierPartitionStatus status, long startOffset, long endOffset, OffsetAndEpoch globalMaterializedOffsetAndEpoch, OffsetAndEpoch localMaterializedOffsetAndEpoch, OffsetAndEpoch errorOffsetAndEpoch, OffsetAndEpoch lastRestoredOffsetAndEpoch, boolean hasStateChangeTimestamp, boolean tierPartitionStateSnapshotFeatureFlag, long lastSnapshotTimestampMs, UUID lastSnapshotId) {
        this(topicId, version, tierEpoch, status, startOffset, endOffset, globalMaterializedOffsetAndEpoch, localMaterializedOffsetAndEpoch, errorOffsetAndEpoch, lastRestoredOffsetAndEpoch, false, -1L, CompactStats.EMPTY, CompactStats.EMPTY, hasStateChangeTimestamp, tierPartitionStateSnapshotFeatureFlag, lastSnapshotTimestampMs, lastSnapshotId);
    }

    @JsonCreator
    public Header(@JsonProperty(value="topicId") UUID topicId, @JsonProperty(value="version") byte version, @JsonProperty(value="tierEpoch") int tierEpoch, @JsonProperty(value="status") TierPartitionStatus status, @JsonProperty(value="startOffset") long startOffset, @JsonProperty(value="endOffset") long endOffset, @JsonProperty(value="globalMaterializedOffsetAndEpoch") OffsetAndEpoch globalMaterializedOffsetAndEpoch, @JsonProperty(value="localMaterializedOffsetAndEpoch") OffsetAndEpoch localMaterializedOffsetAndEpoch, @JsonProperty(value="errorOffsetAndEpoch") OffsetAndEpoch errorOffsetAndEpoch, @JsonProperty(value="restoreOffsetAndEpoch") OffsetAndEpoch lastRestoredOffsetAndEpoch, @JsonProperty(value="compactFeatureFlag") boolean compactFeatureFlag, @JsonProperty(value="compactCleanCheckpoint") long compactDirtyStartOffset, @JsonProperty(value="lastCompactStats") CompactStats lastCompactStats, @JsonProperty(value="accumulatedCompactStats") CompactStats accumulatedCompactStats, @JsonProperty(value="hasStateChangeTimestamp") boolean hasStateChangeTimestamp, @JsonProperty(value="tierPartitionStateSnapshotFeatureFlag") boolean tierPartitionStateSnapshotFeatureFlag, @JsonProperty(value="lastSnapshotTimestampMs") long lastSnapshotTimestampMs, @JsonProperty(value="lastSnapshotId") UUID lastSnapshotId) {
        if (tierEpoch < -1) {
            throw new IllegalArgumentException("Illegal tierEpoch " + tierEpoch);
        }
        FlatBufferBuilder builder = new FlatBufferBuilder(100).forceDefaults(true);
        int materializedInfo = MaterializationTrackingInfo.createMaterializationTrackingInfo((FlatBufferBuilder)builder, (long)globalMaterializedOffsetAndEpoch.offset(), (long)localMaterializedOffsetAndEpoch.offset(), (int)globalMaterializedOffsetAndEpoch.epoch().orElse(-1), (int)localMaterializedOffsetAndEpoch.epoch().orElse(-1));
        SnapshotTrackingInfo.startSnapshotTrackingInfo((FlatBufferBuilder)builder);
        SnapshotTrackingInfo.addLastSnapshotTimestampMs((FlatBufferBuilder)builder, (long)lastSnapshotTimestampMs);
        int snapshotIdOffset = io.confluent.kafka.storage.tier.serdes.UUID.createUUID((FlatBufferBuilder)builder, (long)lastSnapshotId.getMostSignificantBits(), (long)lastSnapshotId.getLeastSignificantBits());
        SnapshotTrackingInfo.addLastSnapshotId((FlatBufferBuilder)builder, (int)snapshotIdOffset);
        int snapshotInfoOffset = SnapshotTrackingInfo.endSnapshotTrackingInfo((FlatBufferBuilder)builder);
        TierPartitionStateHeader.startTierPartitionStateHeader((FlatBufferBuilder)builder);
        int topicIdOffset = io.confluent.kafka.storage.tier.serdes.UUID.createUUID((FlatBufferBuilder)builder, (long)topicId.getMostSignificantBits(), (long)topicId.getLeastSignificantBits());
        TierPartitionStateHeader.addTopicId((FlatBufferBuilder)builder, (int)topicIdOffset);
        TierPartitionStateHeader.addTierEpoch((FlatBufferBuilder)builder, (int)tierEpoch);
        TierPartitionStateHeader.addVersion((FlatBufferBuilder)builder, (byte)version);
        TierPartitionStateHeader.addStatus((FlatBufferBuilder)builder, (byte)TierPartitionStatus.toByte(status));
        TierPartitionStateHeader.addStartOffset((FlatBufferBuilder)builder, (long)startOffset);
        TierPartitionStateHeader.addEndOffset((FlatBufferBuilder)builder, (long)endOffset);
        TierPartitionStateHeader.addMaterializationInfo((FlatBufferBuilder)builder, (int)materializedInfo);
        int errorOffsetAndEpochId = io.confluent.kafka.storage.tier.serdes.OffsetAndEpoch.createOffsetAndEpoch((FlatBufferBuilder)builder, (long)errorOffsetAndEpoch.offset(), (int)errorOffsetAndEpoch.epoch().orElse(-1));
        TierPartitionStateHeader.addErrorOffsetAndEpoch((FlatBufferBuilder)builder, (int)errorOffsetAndEpochId);
        int restoreId = io.confluent.kafka.storage.tier.serdes.OffsetAndEpoch.createOffsetAndEpoch((FlatBufferBuilder)builder, (long)lastRestoredOffsetAndEpoch.offset(), (int)lastRestoredOffsetAndEpoch.epoch().orElse(-1));
        TierPartitionStateHeader.addRestoreOffsetAndEpoch((FlatBufferBuilder)builder, (int)restoreId);
        if (compactFeatureFlag) {
            TierPartitionStateHeader.addCompactDirtyStartOffset((FlatBufferBuilder)builder, (long)compactDirtyStartOffset);
            int lastCompactStatsOffset = io.confluent.kafka.storage.tier.serdes.CompactStats.createCompactStats((FlatBufferBuilder)builder, (long)lastCompactStats.bytesRead(), (long)lastCompactStats.bytesWritten(), (long)lastCompactStats.dirtyBytesRead());
            TierPartitionStateHeader.addLastCompactStats((FlatBufferBuilder)builder, (int)lastCompactStatsOffset);
            int accumulatedCompactStatsOffset = io.confluent.kafka.storage.tier.serdes.CompactStats.createCompactStats((FlatBufferBuilder)builder, (long)accumulatedCompactStats.bytesRead(), (long)accumulatedCompactStats.bytesWritten(), (long)accumulatedCompactStats.dirtyBytesRead());
            TierPartitionStateHeader.addAccumulatedCompactStats((FlatBufferBuilder)builder, (int)accumulatedCompactStatsOffset);
        }
        TierPartitionStateHeader.addHasStateChangeTimestamp((FlatBufferBuilder)builder, (boolean)hasStateChangeTimestamp);
        if (tierPartitionStateSnapshotFeatureFlag) {
            TierPartitionStateHeader.addSnapshotInfo((FlatBufferBuilder)builder, (int)snapshotInfoOffset);
        }
        int entryId = TierPartitionStateHeader.endTierPartitionStateHeader((FlatBufferBuilder)builder);
        builder.finish(entryId);
        this.header = TierPartitionStateHeader.getRootAsTierPartitionStateHeader((ByteBuffer)builder.dataBuffer());
        this.materializationInfo = new MaterializationInfo(this.header.materializationInfo());
        this.snapshotInfo = new SnapshotInfo(this.header.snapshotInfo());
        this.compactFeatureFlag = compactFeatureFlag;
        this.tierPartitionStateSnapshotFeatureFlag = tierPartitionStateSnapshotFeatureFlag;
    }

    public ByteBuffer payloadBuffer() {
        return this.header.getByteBuffer().duplicate();
    }

    @JsonProperty(value="tierEpoch", required=true)
    public int tierEpoch() {
        return this.header.tierEpoch();
    }

    @JsonProperty(value="topicId", required=true)
    public UUID topicId() {
        return new UUID(this.header.topicId().mostSignificantBits(), this.header.topicId().leastSignificantBits());
    }

    @JsonProperty(value="status", required=true)
    public TierPartitionStatus status() {
        return TierPartitionStatus.fromByte(this.header.status());
    }

    @JsonProperty(value="startOffset", required=true)
    public long startOffset() {
        return this.header.startOffset();
    }

    public void mutateStartOffset(long startOffset) {
        this.header.mutateStartOffset(startOffset);
    }

    @JsonProperty(value="endOffset", required=true)
    public long endOffset() {
        return this.header.endOffset();
    }

    public long size() {
        return this.payloadBuffer().remaining() + 2;
    }

    @JsonProperty(value="version", required=true)
    public short version() {
        return this.header.version();
    }

    public byte versionInByte() {
        return this.header.version();
    }

    @JsonProperty(value="localMaterializedOffsetAndEpoch", required=true)
    public OffsetAndEpoch localMaterializedOffsetAndEpoch() {
        return this.materializationInfo.localMaterializedOffsetAndEpoch();
    }

    @JsonProperty(value="globalMaterializedOffsetAndEpoch", required=true)
    public OffsetAndEpoch globalMaterializedOffsetAndEpoch() {
        return this.materializationInfo.globalMaterializedOffsetAndEpoch();
    }

    @JsonProperty(value="restoreOffsetAndEpoch", required=true)
    public OffsetAndEpoch restoreOffsetAndEpoch() {
        return this.header.restoreOffsetAndEpoch() == null ? OffsetAndEpoch.EMPTY : new OffsetAndEpoch(this.header.restoreOffsetAndEpoch());
    }

    @JsonProperty(value="errorOffsetAndEpoch", required=true)
    public OffsetAndEpoch errorOffsetAndEpoch() {
        return this.header.errorOffsetAndEpoch() == null ? OffsetAndEpoch.EMPTY : new OffsetAndEpoch(this.header.errorOffsetAndEpoch());
    }

    @JsonProperty(value="compactCleanCheckpoint", required=true)
    public long compactDirtyStartOffset() {
        return this.header.compactDirtyStartOffset();
    }

    public final boolean hasCompactDirtyStartOffset() {
        long dirtyStartOffset = this.header.compactDirtyStartOffset();
        return dirtyStartOffset != -1L || this.header.mutateCompactDirtyStartOffset(dirtyStartOffset);
    }

    @JsonProperty(value="lastCompactStats", required=true)
    public CompactStats lastCompactStats() {
        return this.header.lastCompactStats() == null ? CompactStats.EMPTY : new CompactStats(this.header.lastCompactStats());
    }

    @JsonProperty(value="accumulatedCompactStats", required=true)
    public CompactStats accumulatedCompactStats() {
        return this.header.accumulatedCompactStats() == null ? CompactStats.EMPTY : new CompactStats(this.header.accumulatedCompactStats());
    }

    @JsonProperty(value="hasStateChangeTimestamp", required=true)
    public boolean hasStateChangeTimestamp() {
        return this.header.hasStateChangeTimestamp();
    }

    @JsonProperty(value="lastSnapshotTimestampMs", required=true)
    public long lastSnapshotTimestampMs() {
        return this.snapshotInfo.lastSnapshotTimestampMs();
    }

    @JsonProperty(value="lastSnapshotId", required=true)
    public UUID lastSnapshotId() {
        return this.snapshotInfo.lastSnapshotId();
    }

    public final boolean hasSnapshotInfo() {
        return this.header.snapshotInfo() != null;
    }

    @JsonProperty(value="compactFeatureFlag", required=true)
    public boolean compactFeatureFlag() {
        return this.compactFeatureFlag;
    }

    @JsonProperty(value="tierPartitionStateSnapshotFeatureFlag", required=true)
    public boolean tierPartitionStateSnapshotFeatureFlag() {
        return this.tierPartitionStateSnapshotFeatureFlag;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Header that = (Header)o;
        return Objects.equals(this.version(), that.version()) && Objects.equals(this.topicId(), that.topicId()) && Objects.equals(this.tierEpoch(), that.tierEpoch()) && Objects.equals((Object)this.status(), (Object)that.status()) && Objects.equals(this.startOffset(), that.startOffset()) && Objects.equals(this.endOffset(), that.endOffset()) && Objects.equals(this.errorOffsetAndEpoch(), that.errorOffsetAndEpoch()) && Objects.equals(this.restoreOffsetAndEpoch(), that.restoreOffsetAndEpoch()) && Objects.equals(this.materializationInfo, that.materializationInfo) && Objects.equals(this.compactDirtyStartOffset(), that.compactDirtyStartOffset()) && Objects.equals(this.lastCompactStats(), that.lastCompactStats()) && Objects.equals(this.accumulatedCompactStats(), that.accumulatedCompactStats()) && Objects.equals(this.hasStateChangeTimestamp(), that.hasStateChangeTimestamp()) && Objects.equals(this.snapshotInfo, that.snapshotInfo);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.version(), this.topicId(), this.tierEpoch(), this.status(), this.startOffset(), this.endOffset(), this.restoreOffsetAndEpoch(), this.errorOffsetAndEpoch(), this.materializationInfo, this.snapshotInfo});
    }

    public String toString() {
        return "Header(version=" + this.version() + ", " + "topicId" + "=" + CoreUtils.uuidToBase64(this.topicId()) + ", " + "tierEpoch" + "=" + this.tierEpoch() + ", " + "status" + "=" + (Object)((Object)this.status()) + ", " + "startOffset" + "=" + this.startOffset() + ", " + "endOffset" + "=" + this.endOffset() + ", " + "errorOffsetAndEpoch" + "=" + this.errorOffsetAndEpoch() + ", " + "restoreOffsetAndEpoch" + "=" + this.restoreOffsetAndEpoch() + ", " + "MaterializationInfo" + "=" + this.materializationInfo + ", " + "compactFeatureFlag" + "=" + this.compactFeatureFlag() + ", " + "compactCleanCheckpoint" + "=" + this.compactDirtyStartOffset() + ", " + "lastCompactStats" + "=" + this.lastCompactStats() + ", " + "accumulatedCompactStats" + "=" + this.accumulatedCompactStats() + ", " + "hasStateChangeTimestamp" + "=" + this.hasStateChangeTimestamp() + ", " + "tierPartitionStateSnapshotFeatureFlag" + "=" + this.tierPartitionStateSnapshotFeatureFlag() + ", " + "SnapshotInfo" + "=" + this.snapshotInfo + ", )";
    }

    public String toJson() {
        try {
            return JSON_MAPPER.writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    private static OffsetAndEpoch toOffsetAndEpoch(long offset, int epoch) {
        Optional<Integer> epochOpt = epoch == -1 ? Optional.empty() : Optional.of(epoch);
        return new OffsetAndEpoch(offset, epochOpt);
    }

    static {
        JSON_MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, true);
        JSON_MAPPER.registerModule((Module)new Jdk8Module());
    }

    static class SnapshotInfo {
        private final long lastSnapshotTimestampMs;
        private final UUID lastSnapshotId;

        SnapshotInfo(@JsonProperty(value="SnapshotInfo") SnapshotTrackingInfo info) {
            if (info == null) {
                FlatBufferBuilder builder = new FlatBufferBuilder(100);
                SnapshotTrackingInfo.startSnapshotTrackingInfo((FlatBufferBuilder)builder);
                int snapshotIdOffset = io.confluent.kafka.storage.tier.serdes.UUID.createUUID((FlatBufferBuilder)builder, (long)SNAPSHOT_ID_EMPTY.getMostSignificantBits(), (long)SNAPSHOT_ID_EMPTY.getLeastSignificantBits());
                SnapshotTrackingInfo.addLastSnapshotId((FlatBufferBuilder)builder, (int)snapshotIdOffset);
                int entryId = SnapshotTrackingInfo.endSnapshotTrackingInfo((FlatBufferBuilder)builder);
                builder.finish(entryId);
                info = SnapshotTrackingInfo.getRootAsSnapshotTrackingInfo((ByteBuffer)builder.dataBuffer());
            }
            this.lastSnapshotTimestampMs = info.lastSnapshotTimestampMs();
            this.lastSnapshotId = new UUID(info.lastSnapshotId().mostSignificantBits(), info.lastSnapshotId().leastSignificantBits());
        }

        @JsonProperty(value="lastSnapshotTimestampMs", required=true)
        long lastSnapshotTimestampMs() {
            return this.lastSnapshotTimestampMs;
        }

        @JsonProperty(value="lastSnapshotId", required=true)
        UUID lastSnapshotId() {
            return this.lastSnapshotId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SnapshotInfo that = (SnapshotInfo)o;
            return this.lastSnapshotTimestampMs == that.lastSnapshotTimestampMs && this.lastSnapshotId.equals(that.lastSnapshotId);
        }

        public int hashCode() {
            return Objects.hash(this.lastSnapshotTimestampMs, this.lastSnapshotId);
        }

        public String toString() {
            return "SnapshotInfo{lastSnapshotTimestampMs=" + this.lastSnapshotTimestampMs + ", " + "lastSnapshotId" + "=" + this.lastSnapshotId + '}';
        }

        public String toJson() {
            try {
                return JSON_MAPPER.writeValueAsString((Object)this);
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
        }
    }

    static class MaterializationInfo {
        OffsetAndEpoch globalMaterializedOffsetAndEpoch;
        OffsetAndEpoch localMaterializedOffsetAndEpoch;

        @JsonCreator
        MaterializationInfo(@JsonProperty(value="MaterializationInfo") MaterializationTrackingInfo info) {
            if (info == null) {
                FlatBufferBuilder builder = new FlatBufferBuilder(100);
                MaterializationTrackingInfo.startMaterializationTrackingInfo((FlatBufferBuilder)builder);
                int entryId = MaterializationTrackingInfo.endMaterializationTrackingInfo((FlatBufferBuilder)builder);
                builder.finish(entryId);
                info = MaterializationTrackingInfo.getRootAsMaterializationTrackingInfo((ByteBuffer)builder.dataBuffer());
            }
            this.globalMaterializedOffsetAndEpoch = Header.toOffsetAndEpoch(info.globalMaterializedOffset(), info.globalMaterializedEpoch());
            this.localMaterializedOffsetAndEpoch = Header.toOffsetAndEpoch(info.localMaterializedOffset(), info.localMaterializedEpoch());
        }

        @JsonProperty(value="globalMaterializedOffsetAndEpoch", required=true)
        OffsetAndEpoch globalMaterializedOffsetAndEpoch() {
            return this.globalMaterializedOffsetAndEpoch;
        }

        @JsonProperty(value="localMaterializedOffsetAndEpoch", required=true)
        OffsetAndEpoch localMaterializedOffsetAndEpoch() {
            return this.localMaterializedOffsetAndEpoch;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MaterializationInfo that = (MaterializationInfo)o;
            return Objects.equals(this.localMaterializedOffsetAndEpoch(), that.localMaterializedOffsetAndEpoch()) && Objects.equals(this.globalMaterializedOffsetAndEpoch(), that.globalMaterializedOffsetAndEpoch());
        }

        public int hashCode() {
            return Objects.hash(this.localMaterializedOffsetAndEpoch(), this.globalMaterializedOffsetAndEpoch());
        }

        public String toString() {
            return "MaterializationInfo(localMaterializedOffset=" + this.localMaterializedOffsetAndEpoch() + ", " + "globalMaterializedOffset" + "=" + this.globalMaterializedOffsetAndEpoch() + ")";
        }

        public String toJson() {
            try {
                return JSON_MAPPER.writeValueAsString((Object)this);
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

