/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.store.objects;

import io.confluent.kafka.storage.checksum.E2EChecksumProtectedObjectType;
import io.confluent.kafka.storage.checksum.E2EChecksumStore;
import java.io.File;
import java.nio.ByteBuffer;
import java.util.Optional;
import kafka.tier.store.objects.ThrottledSegmentUpload;
import kafka.tier.store.objects.metadata.ObjectMetadata;
import org.apache.kafka.storage.internals.utils.Throttler;

public abstract class TierSegmentUpload<P> {
    private final ObjectMetadata objectMetadata;
    private final File segment;
    private final File offsetIdx;
    private final File timestampIdx;
    private final Optional<P> producerStateSnapshotOpt;
    private final Optional<ByteBuffer> txnIdxOpt;
    private final Optional<ByteBuffer> epochStateOpt;

    protected TierSegmentUpload(ObjectMetadata objectMetadata, File segment, File offsetIdx, File timestampIdx, Optional<P> producerStateSnapshotOpt, Optional<ByteBuffer> txnIdxOpt, Optional<ByteBuffer> epochStateOpt) {
        this.objectMetadata = objectMetadata;
        this.segment = segment;
        this.offsetIdx = offsetIdx;
        this.producerStateSnapshotOpt = producerStateSnapshotOpt;
        this.timestampIdx = timestampIdx;
        this.txnIdxOpt = txnIdxOpt;
        this.epochStateOpt = epochStateOpt;
    }

    public ObjectMetadata objectMetadata() {
        return this.objectMetadata;
    }

    public File segment() {
        return this.segment;
    }

    public File offsetIdx() {
        return this.offsetIdx;
    }

    public File timestampIdx() {
        return this.timestampIdx;
    }

    public Optional<P> producerStateSnapshotOpt() {
        return this.producerStateSnapshotOpt;
    }

    public Optional<ByteBuffer> txnIdxOpt() {
        return this.txnIdxOpt;
    }

    public Optional<ByteBuffer> epochStateOpt() {
        return this.epochStateOpt;
    }

    public Optional<Throttler> throttlerOpt() {
        if (this instanceof ThrottledSegmentUpload) {
            ThrottledSegmentUpload throttledSegmentUpload = (ThrottledSegmentUpload)this;
            return throttledSegmentUpload.throttlerOpt();
        }
        return Optional.empty();
    }

    public void postPutSegmentCleanup(E2EChecksumStore checksumStore) {
        if (checksumStore.checksumProtectionEnabled(E2EChecksumProtectedObjectType.SEGMENT)) {
            checksumStore.store().remove(this.segment.getAbsolutePath());
        }
        if (checksumStore.checksumProtectionEnabled(E2EChecksumProtectedObjectType.OFFSET_INDEX)) {
            checksumStore.store().remove(this.offsetIdx.getAbsolutePath());
        }
        if (checksumStore.checksumProtectionEnabled(E2EChecksumProtectedObjectType.TIMESTAMP_INDEX)) {
            checksumStore.store().remove(this.timestampIdx.getAbsolutePath());
        }
        if (checksumStore.checksumProtectionEnabled(E2EChecksumProtectedObjectType.PRODUCER_STATE) && this.producerStateSnapshotOpt.isPresent() && this instanceof ThrottledSegmentUpload) {
            ThrottledSegmentUpload throttledSegmentUpload = (ThrottledSegmentUpload)this;
            throttledSegmentUpload.producerStateSnapshotOpt().ifPresent(file -> checksumStore.store().remove(file.getAbsolutePath()));
        }
    }
}

