/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.tools;

import io.confluent.kafka.storage.checksum.Algorithm;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import kafka.tier.store.TierObjectStore;
import kafka.tier.store.TierObjectStoreFunctionUtils;
import kafka.tier.store.TierObjectStoreResponse;
import kafka.tier.store.objects.FragmentType;
import kafka.tier.store.objects.metadata.FileTierPartitionStateRecoveryUploadMetadata;
import kafka.tier.tools.RecoveryUtils;
import kafka.tier.tools.RestoreRawInput;
import kafka.tier.tools.common.RestoreRawInputInfoRemoteURI;
import kafka.tier.tools.common.RestoreRawOutputInfoRemoteURI;
import org.apache.kafka.common.TopicPartition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestoreRawRemoteURIInput
extends RestoreRawInput<RestoreRawInputInfoRemoteURI, RestoreRawOutputInfoRemoteURI> {
    private static final Logger LOGGER = LoggerFactory.getLogger(RestoreRawRemoteURIInput.class);

    @Override
    public File getFtpsForTopicPartition(RestoreRawInputInfoRemoteURI input, TierObjectStore objectStore) throws IOException, InterruptedException {
        String remoteURL = input.restoreRemoteURIInfo().getValue();
        LOGGER.info("Fetching object from remote url " + remoteURL);
        FileTierPartitionStateRecoveryUploadMetadata metadata = FileTierPartitionStateRecoveryUploadMetadata.fromPath(remoteURL);
        TierObjectStoreResponse response = TierObjectStoreFunctionUtils.getObjectStoreFragment(() -> false, objectStore, metadata, FragmentType.FILE_TIER_PARTITION_STATE_UPLOAD);
        Algorithm checksumAlgo = metadata.uploadObject().checksumAlgorithm();
        String topic = metadata.topicIdPartition().topic();
        int partition = metadata.topicIdPartition().partition();
        TopicPartition topicPartition = new TopicPartition(topic, partition);
        File file = new File(RecoveryUtils.getTempDirectoryForPartition(topicPartition) + "/" + metadata.uploadObject().baseName() + checksumAlgo.suffix);
        Path directoryPath = Paths.get(file.getParent(), new String[0]);
        try {
            Files.createDirectories(directoryPath, new FileAttribute[0]);
        }
        catch (IOException e) {
            String errorMessage = "Error creating or reading directory: " + directoryPath;
            LOGGER.error(errorMessage, (Throwable)e);
            throw new IOException(errorMessage, e);
        }
        FileChannel fileChannel = FileChannel.open(file.toPath(), StandardOpenOption.CREATE, StandardOpenOption.READ, StandardOpenOption.WRITE);
        this.readFtpsFile(fileChannel, response);
        fileChannel.close();
        return file;
    }

    void readFtpsFile(FileChannel fileChannel, TierObjectStoreResponse response) throws IOException {
        try (InputStream inputStream = response.getInputStream();){
            int bytesRead;
            ByteBuffer buffer = ByteBuffer.allocate(1024);
            while ((bytesRead = inputStream.read(buffer.array())) != -1) {
                buffer.limit(bytesRead);
                fileChannel.write(buffer);
                buffer.clear();
            }
        }
    }

    @Override
    public Boolean getRestoreLogStartOffset(RestoreRawInputInfoRemoteURI input) {
        return input.fenceEventInfo().freezeMergedLogStartOffset();
    }

    @Override
    public RestoreRawOutputInfoRemoteURI getRawOutputInfo(RestoreRawInputInfoRemoteURI input, String restore) {
        return new RestoreRawOutputInfoRemoteURI(input, restore);
    }

    @Override
    public void writeOutputFile(List<RestoreRawOutputInfoRemoteURI> outputs, File outputFile) throws IOException {
        FileOutputStream fos = new FileOutputStream(outputFile);
        RestoreRawOutputInfoRemoteURI.writeJsonToFile(outputs, fos);
        fos.close();
    }
}

