/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.tools;

import io.confluent.rest.TierRecoveryDataUploadResult;
import io.confluent.rest.TierTopicHeadDataLossDetectionRequest;
import io.confluent.rest.TierTopicHeadDataLossDetectionResponse;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import kafka.log.LogManager;
import kafka.tier.TopicIdPartition;
import kafka.tier.state.OffsetAndEpoch;
import kafka.tier.tools.TierRecoveryDataUploadCoordinator;
import kafka.tier.tools.TierRecoveryDataUploadResult;
import kafka.tier.topic.TierTopicConsumerRewindPolicy;
import kafka.tier.topic.TierTopicManager;
import kafka.utils.CoreUtils;

public class TierMetadataRecoveryHelper {
    private final LogManager logManager;
    private final TierRecoveryDataUploadCoordinator tierRecoveryDataUploadCoordinator;
    private final TierTopicManager tierTopicManager;

    public TierMetadataRecoveryHelper(LogManager logManager, Optional<TierRecoveryDataUploadCoordinator> tierRecoveryDataUploadCoordinator, Optional<TierTopicManager> tierTopicManager) {
        this.logManager = logManager;
        this.tierRecoveryDataUploadCoordinator = tierRecoveryDataUploadCoordinator.orElse(null);
        this.tierTopicManager = tierTopicManager.orElse(null);
    }

    public Map<String, Set<Integer>> maybeRewindTierTopicConsumer(Optional<Map<Integer, Map<Long, Optional<Integer>>>> partitionToPositionOpt, boolean forceStop, byte policy) {
        HashMap partitionToOffsetAndEpoch;
        if (this.tierTopicManager == null) {
            throw new UnsupportedOperationException("Can't rewind the tier topic consumer because tiered storage is unavailable.");
        }
        TierTopicConsumerRewindPolicy rewindPolicy = TierTopicConsumerRewindPolicy.forId(policy);
        if (rewindPolicy == null) {
            throw new IllegalArgumentException("Received unknown rewind policy value: " + policy);
        }
        if (partitionToPositionOpt.isPresent()) {
            partitionToOffsetAndEpoch = new HashMap();
            partitionToPositionOpt.get().forEach((partition, position) -> {
                if (position.isEmpty()) {
                    throw new IllegalArgumentException("No position was provided for partition: " + partition);
                }
                if (position.size() > 1) {
                    throw new IllegalArgumentException("Received multiple positions for partition: " + partition);
                }
                position.forEach((offset, epoch) -> partitionToOffsetAndEpoch.put(partition, new OffsetAndEpoch((long)offset, (Optional<Integer>)epoch)));
            });
        } else {
            partitionToOffsetAndEpoch = null;
        }
        return this.logManager.doRewind(Optional.ofNullable(partitionToOffsetAndEpoch), forceStop, rewindPolicy);
    }

    public UUID maybeInitiateTierRecoveryDataUpload(Set<org.apache.kafka.common.TopicIdPartition> topicIdPartitions, String identifier, int numThreads) {
        Set<TopicIdPartition> partitionSet = topicIdPartitions.stream().map(topicIdPartition -> new TopicIdPartition(topicIdPartition.topic(), CoreUtils.toJavaUUID(topicIdPartition.topicId()), topicIdPartition.partition())).collect(Collectors.toSet());
        if (this.tierRecoveryDataUploadCoordinator == null) {
            throw new UnsupportedOperationException("TierRecoveryDataUploadCoordinator is not initialized... Cannot initiate tier recovery data upload job.");
        }
        return this.tierRecoveryDataUploadCoordinator.initiateTierRecoveryDataUpload(partitionSet, identifier, numThreads);
    }

    public io.confluent.rest.TierRecoveryDataUploadResult maybeGetTierRecoveryDataUploadJobResult(UUID jobId) throws IOException {
        if (this.tierRecoveryDataUploadCoordinator == null) {
            throw new UnsupportedOperationException("TierRecoveryDataUploadCoordinator is not initialized... Cannot get tier recovery data upload job result.");
        }
        TierRecoveryDataUploadResult result = this.tierRecoveryDataUploadCoordinator.getJobResult(jobId);
        Map<org.apache.kafka.common.TopicIdPartition, String> failedPartitions = null;
        if (result.failedPartitions() != null) {
            failedPartitions = result.failedPartitions().entrySet().stream().collect(Collectors.toMap(e -> new org.apache.kafka.common.TopicIdPartition(CoreUtils.toKafkaUUID(((TopicIdPartition)e.getKey()).topicId()), ((TopicIdPartition)e.getKey()).partition(), ((TopicIdPartition)e.getKey()).topic()), Map.Entry::getValue));
        }
        return new io.confluent.rest.TierRecoveryDataUploadResult(result.identifier(), TierRecoveryDataUploadResult.TierRecoveryDataUploadJobStatus.valueOf((String)result.status().name()), failedPartitions, result.metadataUploadCompleted(), result.metadataUploadFailedExceptionMessage(), result.tierOffsetsUploadCompleted(), result.tierOffsetsUploadFailedExceptionMessage());
    }

    public TierTopicHeadDataLossDetectionResponse maybeDetectDataLossInTierTopicHead(TierTopicHeadDataLossDetectionRequest request, long timeoutMs) {
        if (this.tierTopicManager == null) {
            throw new UnsupportedOperationException("Can't detect data loss because tiered storage is unavailable");
        }
        return this.tierTopicManager.detectDataLossInTierTopicHeadOnDemand(request, timeoutMs);
    }
}

