/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.tools;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import kafka.tier.TopicIdPartition;
import kafka.tier.tools.TierMetadataRecoveryOrchestrator;
import kafka.tier.topic.recovery.ReconciledTierTopicHeadDataLossReport;
import kafka.tier.topic.recovery.TierTopicHeadDataLossReport;
import net.sourceforge.argparse4j.inf.Namespace;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.common.utils.Utils;

class TierMetadataRecoveryUtils {
    private TierMetadataRecoveryUtils() {
    }

    public static AdminClient getAdminClient(String adminConfigFile, String bootstrapServers) throws IOException {
        Properties properties = new Properties();
        if (adminConfigFile != null) {
            properties = Utils.loadProps((String)adminConfigFile);
        }
        properties.put("bootstrap.servers", bootstrapServers);
        properties.put("connections.max.idle.ms", (Object)10000);
        properties.put("request.timeout.ms", (Object)5000);
        return AdminClient.create((Properties)properties);
    }

    public static TierMetadataRecoveryOrchestrator getTierMetadataRecoveryOrchestrator(String adminConfigFile, String bootstrapServers, Integer restServerPort) throws IOException {
        AdminClient adminClient = TierMetadataRecoveryUtils.getAdminClient(adminConfigFile, bootstrapServers);
        return new TierMetadataRecoveryOrchestrator(adminClient, restServerPort);
    }

    public static Set<Integer> getBrokerList(Namespace namespace) throws IllegalArgumentException {
        Set<Integer> brokers = Arrays.stream(namespace.getString("broker-ids").split(",")).map(Integer::parseInt).collect(Collectors.toSet());
        if (brokers.isEmpty()) {
            throw new IllegalArgumentException("Must provide at least one broker to run the command on.");
        }
        return brokers;
    }

    public static String getIdentifierFromRecoveryDir(String dir) {
        String[] innerDirs = dir.split("/");
        String identifier = innerDirs[innerDirs.length - 1].substring("recovery-".length());
        if (identifier.isEmpty()) {
            throw new IllegalArgumentException("Invalid recovery directory path: " + dir);
        }
        return identifier;
    }

    public static Set<TopicIdPartition> getAffectedTopicPartitionsFromReconciledDLVOutput(String reconciledDlvOutputPath) throws IOException {
        return ReconciledTierTopicHeadDataLossReport.readJsonFromFile(Paths.get(reconciledDlvOutputPath, new String[0])).affectedUserTopicPartitions().keySet();
    }

    public static Set<TopicIdPartition> getAffectedTopicPartitionsFromNonReconciledDLVOutput(String nonReconciledDlvOutputPath) throws IOException {
        return TierTopicHeadDataLossReport.readJsonFromFile(Paths.get(nonReconciledDlvOutputPath, new String[0])).affectedUserTopicPartitions().keySet();
    }

    public static Set<TopicIdPartition> getAffectedTopicPartitionsFromTargetTopicPartitionsFile(String targetTopicPartitionsFilePath) throws IOException {
        HashSet<TopicIdPartition> topicIdPartitions = new HashSet<TopicIdPartition>();
        try (BufferedReader reader = new BufferedReader(new FileReader(targetTopicPartitionsFilePath));){
            String line;
            while ((line = reader.readLine()) != null) {
                topicIdPartitions.add(TopicIdPartition.fromString(line.trim()));
            }
        }
        return topicIdPartitions;
    }

    public static Map<Integer, Map<Long, Optional<Integer>>> getPartitionToPositionFromReconciledDLVOutput(String reconciledDlvOutputPath) throws IOException {
        HashMap<Integer, Map<Long, Optional<Integer>>> partitionToPosition = new HashMap<Integer, Map<Long, Optional<Integer>>>();
        ReconciledTierTopicHeadDataLossReport.readJsonFromFile(Paths.get(reconciledDlvOutputPath, new String[0])).affectedTierTopicPartitions().forEach((ttp, reconciledTtpInfo) -> {
            Map<Long, Optional<Integer>> offsetAndEpoch = Collections.singletonMap(reconciledTtpInfo.minTierTopicEndOffsetAndEpoch().offset(), reconciledTtpInfo.minTierTopicEndOffsetAndEpoch().epoch());
            partitionToPosition.put(ttp.partition(), offsetAndEpoch);
        });
        return partitionToPosition;
    }
}

