/*
 * Decompiled with CFR 0.152.
 */
package kafka.zk;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.Properties;
import java.util.UUID;
import kafka.admin.RackAwareMode;
import kafka.admin.RackAwareMode$Disabled$;
import kafka.admin.RackAwareMode$Enforced$;
import kafka.admin.RackAwareMode$Safe$;
import kafka.cluster.Broker;
import kafka.cluster.Observer$;
import kafka.common.TopicAlreadyMarkedForDeletionException;
import kafka.controller.ReplicaAssignment;
import kafka.controller.ReplicaAssignment$;
import kafka.server.DynamicConfig$Broker$;
import kafka.server.DynamicConfig$Client$;
import kafka.server.DynamicConfig$Ip$;
import kafka.server.DynamicConfig$Tenant$;
import kafka.server.DynamicConfig$User$;
import kafka.server.KafkaConfig;
import kafka.server.link.ClusterLinkTopicState;
import kafka.utils.CoreUtils$;
import kafka.utils.Implicits$MapExtensionMethods$;
import kafka.utils.Logging;
import kafka.zk.ClusterLinkData;
import kafka.zk.ConfigEntityZNode$;
import kafka.zk.KafkaZkClient;
import kafka.zk.TopicZNode;
import kafka.zk.TopicZNode$;
import org.apache.kafka.admin.AdminUtils;
import org.apache.kafka.admin.BrokerMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.BrokerNotAvailableException;
import org.apache.kafka.common.errors.ClusterLinkExistsException;
import org.apache.kafka.common.errors.ClusterLinkNotFoundException;
import org.apache.kafka.common.errors.InvalidPartitionsException;
import org.apache.kafka.common.errors.InvalidReplicaAssignmentException;
import org.apache.kafka.common.errors.InvalidTopicException;
import org.apache.kafka.common.errors.TopicExistsException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.internals.Topic;
import org.apache.kafka.metadata.TopicPlacement;
import org.apache.kafka.server.common.AdminOperationException;
import org.apache.kafka.server.config.ConfigType;
import org.apache.kafka.storage.internals.log.LogConfig;
import org.apache.zookeeper.KeeperException;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.SetOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u0011=a\u0001B&M\u0001EC\u0001B\u0018\u0001\u0003\u0002\u0003\u0006Ia\u0018\u0005\tG\u0002\u0011\t\u0011)A\u0005I\")Q\u000e\u0001C\u0001]\")!\u000f\u0001C\u0001g\"I\u00111\f\u0001\u0012\u0002\u0013\u0005\u0011Q\f\u0005\n\u0003g\u0002\u0011\u0013!C\u0001\u0003kB\u0011\"!\u001f\u0001#\u0003%\t!a\u001f\t\u0013\u0005}\u0004!%A\u0005\u0002\u0005m\u0004\"CAA\u0001E\u0005I\u0011AAB\u0011\u001d\t9\t\u0001C\u0001\u0003\u0013C\u0011\"!.\u0001#\u0003%\t!!\u001e\t\u0013\u0005]\u0006!%A\u0005\u0002\u0005e\u0006bBA_\u0001\u0011\u0005\u0011q\u0018\u0005\n\u0003O\u0004\u0011\u0013!C\u0001\u0003wB\u0011\"!;\u0001#\u0003%\t!a\u001f\t\u0013\u0005-\b!%A\u0005\u0002\u0005m\u0004\"CAw\u0001E\u0005I\u0011AAB\u0011\u001d\ty\u000f\u0001C\u0001\u0003cDq!a>\u0001\t\u0003\tI\u0010C\u0005\u0003\u0016\u0001\t\n\u0011\"\u0001\u0003\u0018!9!1\u0004\u0001\u0005\u0002\tu\u0001\"\u0003B\u0018\u0001E\u0005I\u0011AA>\u0011%\u0011\t\u0004AI\u0001\n\u0003\tY\bC\u0005\u00034\u0001\t\n\u0011\"\u0001\u0002\u0004\"9!Q\u0007\u0001\u0005\u0002\t]\u0002b\u0002B\u001e\u0001\u0011\u0005!Q\b\u0005\n\u0005[\u0002\u0011\u0013!C\u0001\u0005_B\u0011Ba\u001d\u0001#\u0003%\tA!\u001e\t\u0013\te\u0004!%A\u0005\u0002\u0005m\u0004\"\u0003B>\u0001E\u0005I\u0011\u0001B?\u0011%\u0011\t\tAI\u0001\n\u0003\t\u0019\tC\u0004\u0003\u0004\u0002!\tA!\"\t\u0013\tU\u0005!%A\u0005\u0002\t=\u0004b\u0002BL\u0001\u0011\u0005!\u0011\u0014\u0005\b\u0005O\u0003A\u0011\u0001BU\u0011%\u0011)\fAI\u0001\n\u0003\t\u0019\tC\u0004\u00038\u0002!IA!/\t\u000f\t%\u0007\u0001\"\u0001\u0003L\"9!1\u001b\u0001\u0005\u0002\tU\u0007\"\u0003Bt\u0001E\u0005I\u0011AA>\u0011\u001d\u0011I\u000f\u0001C\u0005\u0005WDqAa=\u0001\t\u0003\u0011)\u0010C\u0004\u0003~\u0002!\tAa@\t\u0013\r%\u0001!%A\u0005\u0002\u0005m\u0004bBB\u0006\u0001\u0011%1Q\u0002\u0005\b\u0007+\u0001A\u0011AB\f\u0011\u001d\u0019y\u0002\u0001C\u0001\u0007CAqaa\n\u0001\t\u0003\u0019I\u0003C\u0004\u00040\u0001!\ta!\r\t\u000f\r]\u0002\u0001\"\u0001\u0004:!91q\b\u0001\u0005\u0002\r\u0005\u0003bBB \u0001\u0011\u00051\u0011\n\u0005\b\u0007\u001f\u0002A\u0011BB)\u0011\u001d\u0019)\u0006\u0001C\u0001\u0007/Bqa!\u001c\u0001\t\u0003\u0019y\u0007C\u0004\u0004t\u0001!\ta!\u001e\t\u000f\re\u0004\u0001\"\u0003\u0004|!I1\u0011\u0012\u0001\u0012\u0002\u0013%\u00111\u0010\u0005\b\u0007\u0017\u0003A\u0011ABG\u0011\u001d\u0019\u0019\n\u0001C\u0001\u0007+Cqaa'\u0001\t\u0003\u0019i\nC\u0004\u0003L\u0001!\ta!*\t\u000f\t-\u0003\u0001\"\u0001\u00040\"911\u0017\u0001\u0005\u0002\rU\u0006bBBc\u0001\u0011\u00051q\u0019\u0005\b\u0007\u001b\u0004A\u0011ABh\u0011\u001d\u0019I\u000e\u0001C\u0001\u00077Dqaa8\u0001\t\u0003\u0019\t\u000fC\u0004\u0004j\u0002!\taa;\t\u000f\rE\b\u0001\"\u0001\u0004t\u001eIA\u0011\u0001'\u0002\u0002#\u0005A1\u0001\u0004\t\u00172\u000b\t\u0011#\u0001\u0005\u0006!1Q\u000e\u0013C\u0001\t\u000fA\u0011\u0002\"\u0003I#\u0003%\t\u0001b\u0003\u0003\u001b\u0005#W.\u001b8[W\u000ec\u0017.\u001a8u\u0015\tie*\u0001\u0002{W*\tq*A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0007\u0001\u0011\u0006\f\u0005\u0002T-6\tAKC\u0001V\u0003\u0015\u00198-\u00197b\u0013\t9FK\u0001\u0004B]f\u0014VM\u001a\t\u00033rk\u0011A\u0017\u0006\u00037:\u000bQ!\u001e;jYNL!!\u0018.\u0003\u000f1{wmZ5oO\u0006A!p[\"mS\u0016tG\u000f\u0005\u0002aC6\tA*\u0003\u0002c\u0019\ni1*\u00194lCj[7\t\\5f]R\f1b[1gW\u0006\u001cuN\u001c4jOB\u00191+Z4\n\u0005\u0019$&AB(qi&|g\u000e\u0005\u0002iW6\t\u0011N\u0003\u0002k\u001d\u000611/\u001a:wKJL!\u0001\\5\u0003\u0017-\u000bgm[1D_:4\u0017nZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007=\u0004\u0018\u000f\u0005\u0002a\u0001!)al\u0001a\u0001?\"91m\u0001I\u0001\u0002\u0004!\u0017aC2sK\u0006$X\rV8qS\u000e$\u0002\u0003^<\u0002\n\u0005M\u0011qCA\u0016\u0003w\t)%!\u0013\u0011\u0005M+\u0018B\u0001<U\u0005\u0011)f.\u001b;\t\u000ba$\u0001\u0019A=\u0002\u000bQ|\u0007/[2\u0011\u0007i\f\u0019A\u0004\u0002|\u007fB\u0011A\u0010V\u0007\u0002{*\u0011a\u0010U\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005\u0005A+\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003\u000b\t9A\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003\u0003!\u0006bBA\u0006\t\u0001\u0007\u0011QB\u0001\u000ba\u0006\u0014H/\u001b;j_:\u001c\bcA*\u0002\u0010%\u0019\u0011\u0011\u0003+\u0003\u0007%sG\u000fC\u0004\u0002\u0016\u0011\u0001\r!!\u0004\u0002#I,\u0007\u000f\\5dCRLwN\u001c$bGR|'\u000fC\u0005\u0002\u001a\u0011\u0001\n\u00111\u0001\u0002\u001c\u0005YAo\u001c9jG\u000e{gNZ5h!\u0011\ti\"a\n\u000e\u0005\u0005}!\u0002BA\u0011\u0003G\tA!\u001e;jY*\u0011\u0011QE\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002*\u0005}!A\u0003)s_B,'\u000f^5fg\"I\u0011Q\u0006\u0003\u0011\u0002\u0003\u0007\u0011qF\u0001\u000ee\u0006\u001c7.Q<be\u0016lu\u000eZ3\u0011\t\u0005E\u0012qG\u0007\u0003\u0003gQ1!!\u000eO\u0003\u0015\tG-\\5o\u0013\u0011\tI$a\r\u0003\u001bI\u000b7m[!xCJ,Wj\u001c3f\u0011%\ti\u0004\u0002I\u0001\u0002\u0004\ty$A\tvg\u0016\u001cXj\u001c3fe:$v\u000e]5d\u0013\u0012\u00042aUA!\u0013\r\t\u0019\u0005\u0016\u0002\b\u0005>|G.Z1o\u0011%\t9\u0005\u0002I\u0001\u0002\u0004\ty$A\tvg\u0016\u001cH*Z4bGf$v\u000e]5d\u0013\u0012D\u0011\"a\u0013\u0005!\u0003\u0005\r!!\u0014\u0002\u0017\rdWo\u001d;fe2Kgn\u001b\t\u0005'\u0016\fy\u0005\u0005\u0003\u0002R\u0005]SBAA*\u0015\r\t)&[\u0001\u0005Y&t7.\u0003\u0003\u0002Z\u0005M#!F\"mkN$XM\u001d'j].$v\u000e]5d'R\fG/Z\u0001\u0016GJ,\u0017\r^3U_BL7\r\n3fM\u0006,H\u000e\u001e\u00135+\t\tyF\u000b\u0003\u0002\u001c\u0005\u00054FAA2!\u0011\t)'a\u001c\u000e\u0005\u0005\u001d$\u0002BA5\u0003W\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u00055D+\u0001\u0006b]:|G/\u0019;j_:LA!!\u001d\u0002h\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002+\r\u0014X-\u0019;f)>\u0004\u0018n\u0019\u0013eK\u001a\fW\u000f\u001c;%kU\u0011\u0011q\u000f\u0016\u0005\u0003_\t\t'A\u000bde\u0016\fG/\u001a+pa&\u001cG\u0005Z3gCVdG\u000f\n\u001c\u0016\u0005\u0005u$\u0006BA \u0003C\nQc\u0019:fCR,Gk\u001c9jG\u0012\"WMZ1vYR$s'A\u000bde\u0016\fG/\u001a+pa&\u001cG\u0005Z3gCVdG\u000f\n\u001d\u0016\u0005\u0005\u0015%\u0006BA'\u0003C\n!cZ3u\u0005J|7.\u001a:NKR\fG-\u0019;bgR1\u00111RAV\u0003[\u0003b!!$\u0002\u0014\u0006]UBAAH\u0015\r\t\t\nV\u0001\u000bG>dG.Z2uS>t\u0017\u0002BAK\u0003\u001f\u00131aU3r!\u0011\tI*a*\u000e\u0005\u0005m%\u0002BA\u001b\u0003;S1aTAP\u0015\u0011\t\t+a)\u0002\r\u0005\u0004\u0018m\u00195f\u0015\t\t)+A\u0002pe\u001eLA!!+\u0002\u001c\nq!I]8lKJlU\r^1eCR\f\u0007\"CA\u0017\u0015A\u0005\t\u0019AA\u0018\u0011%\tyK\u0003I\u0001\u0002\u0004\t\t,\u0001\u0006ce>\\WM\u001d'jgR\u0004BaU3\u00024B1\u0011QRAJ\u0003\u001b\tAdZ3u\u0005J|7.\u001a:NKR\fG-\u0019;bg\u0012\"WMZ1vYR$\u0013'\u0001\u000fhKR\u0014%o\\6fe6+G/\u00193bi\u0006\u001cH\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u0005m&\u0006BAY\u0003C\n\u0011d\u0019:fCR,Gk\u001c9jG^KG\u000f[!tg&<g.\\3oiRyA/!1\u0002D\u0006\u001d\u0017Q\\Aq\u0003G\f)\u000fC\u0003y\u001b\u0001\u0007\u0011\u0010C\u0004\u0002F6\u0001\r!a\u0007\u0002\r\r|gNZ5h\u0011\u001d\tI-\u0004a\u0001\u0003\u0017\f!\u0004]1si&$\u0018n\u001c8SKBd\u0017nY1BgNLwM\\7f]R\u0004\u0002\"!$\u0002N\u00065\u0011\u0011[\u0005\u0005\u0003\u001f\fyIA\u0002NCB\u0004B!a5\u0002Z6\u0011\u0011Q\u001b\u0006\u0004\u0003/t\u0015AC2p]R\u0014x\u000e\u001c7fe&!\u00111\\Ak\u0005E\u0011V\r\u001d7jG\u0006\f5o]5h]6,g\u000e\u001e\u0005\n\u0003?l\u0001\u0013!a\u0001\u0003\u007f\t\u0001B^1mS\u0012\fG/\u001a\u0005\n\u0003{i\u0001\u0013!a\u0001\u0003\u007fA\u0011\"a\u0012\u000e!\u0003\u0005\r!a\u0010\t\u0013\u0005-S\u0002%AA\u0002\u00055\u0013aI2sK\u0006$X\rV8qS\u000e<\u0016\u000e\u001e5BgNLwM\\7f]R$C-\u001a4bk2$H\u0005N\u0001$GJ,\u0017\r^3U_BL7mV5uQ\u0006\u001b8/[4o[\u0016tG\u000f\n3fM\u0006,H\u000e\u001e\u00136\u0003\r\u001a'/Z1uKR{\u0007/[2XSRD\u0017i]:jO:lWM\u001c;%I\u00164\u0017-\u001e7uIY\n1e\u0019:fCR,Gk\u001c9jG^KG\u000f[!tg&<g.\\3oi\u0012\"WMZ1vYR$s'A\u0006u_BL7-\u0012=jgR\u001cH\u0003BA \u0003gDa!!>\u0013\u0001\u0004I\u0018!\u0003;pa&\u001cg*Y7f\u0003M1\u0018\r\\5eCR,Gk\u001c9jG\u000e\u0013X-\u0019;f)-!\u00181`A\u007f\u0003\u007f\u0014\tA!\u0005\t\u000ba\u001c\u0002\u0019A=\t\u000f\u0005%7\u00031\u0001\u0002L\"9\u0011QY\nA\u0002\u0005m\u0001b\u0002B\u0002'\u0001\u0007!QA\u0001\u000fi>\u0004\u0018nY:TkB\u0004H.[3s!\u0015\u0019&q\u0001B\u0006\u0013\r\u0011I\u0001\u0016\u0002\n\rVt7\r^5p]B\u0002R!!$\u0003\u000eeLAAa\u0004\u0002\u0010\n\u00191+\u001a;\t\u0013\tM1\u0003%AA\u0002\t-\u0011!D2sK\u0006$X\r\u001a+pa&\u001c7/A\u000fwC2LG-\u0019;f)>\u0004\u0018nY\"sK\u0006$X\r\n3fM\u0006,H\u000e\u001e\u00136+\t\u0011IB\u000b\u0003\u0003\f\u0005\u0005\u0014!H<sSR,Gk\u001c9jGB\u000b'\u000f^5uS>t\u0017i]:jO:lWM\u001c;\u0015\u001bQ\u0014yB!\t\u0003&\t%\"1\u0006B\u0017\u0011\u0015AX\u00031\u0001z\u0011\u001d\u0011\u0019#\u0006a\u0001\u0003\u0017\f\u0011C]3qY&\u001c\u0017-Q:tS\u001etW.\u001a8u\u0011\u001d\u00119#\u0006a\u0001\u0003\u007f\t\u0001\"[:Va\u0012\fG/\u001a\u0005\n\u0003{)\u0002\u0013!a\u0001\u0003\u007fA\u0011\"a\u0012\u0016!\u0003\u0005\r!a\u0010\t\u0013\u0005-S\u0003%AA\u0002\u00055\u0013aJ<sSR,Gk\u001c9jGB\u000b'\u000f^5uS>t\u0017i]:jO:lWM\u001c;%I\u00164\u0017-\u001e7uIQ\nqe\u001e:ji\u0016$v\u000e]5d!\u0006\u0014H/\u001b;j_:\f5o]5h]6,g\u000e\u001e\u0013eK\u001a\fW\u000f\u001c;%k\u00059sO]5uKR{\u0007/[2QCJ$\u0018\u000e^5p]\u0006\u001b8/[4o[\u0016tG\u000f\n3fM\u0006,H\u000e\u001e\u00137\u0003-!W\r\\3uKR{\u0007/[2\u0015\u0007Q\u0014I\u0004C\u0003y3\u0001\u0007\u00110A\u0007bI\u0012\u0004\u0016M\u001d;ji&|gn\u001d\u000b\u0015\u0003\u0017\u0014yD!\u0011\u0003F\t%#Q\nB)\u0005+\u00129G!\u001b\t\u000baT\u0002\u0019A=\t\u000f\t\r#\u00041\u0001\u0002L\u0006\u0011R\r_5ti&tw-Q:tS\u001etW.\u001a8u\u0011\u001d\u00119E\u0007a\u0001\u0003\u0017\u000b!\"\u00197m\u0005J|7.\u001a:t\u0011%\u0011YE\u0007I\u0001\u0002\u0004\ti!A\u0007ok6\u0004\u0016M\u001d;ji&|gn\u001d\u0005\n\u0005GQ\u0002\u0013!a\u0001\u0005\u001f\u0002BaU3\u0002L\"I!1\u000b\u000e\u0011\u0002\u0003\u0007\u0011qH\u0001\rm\u0006d\u0017\u000eZ1uK>sG.\u001f\u0005\n\u0005/R\u0002\u0013!a\u0001\u00053\na\u0002^8qS\u000e\u0004F.Y2f[\u0016tG\u000f\u0005\u0003TK\nm\u0003\u0003\u0002B/\u0005Gj!Aa\u0018\u000b\t\t\u0005\u0014QT\u0001\t[\u0016$\u0018\rZ1uC&!!Q\rB0\u00059!v\u000e]5d!2\f7-Z7f]RD\u0011\"a\u0013\u001b!\u0003\u0005\r!!\u0014\t\u000f\t-$\u00041\u0001\u0002@\u0005A\"/Y2l\u001b&D\u0018N\\4TkB\u0004xN\u001d;F]\u0006\u0014G.\u001a3\u0002/\u0005$G\rU1si&$\u0018n\u001c8tI\u0011,g-Y;mi\u0012\"TC\u0001B9U\u0011\ti!!\u0019\u0002/\u0005$G\rU1si&$\u0018n\u001c8tI\u0011,g-Y;mi\u0012*TC\u0001B<U\u0011\u0011y%!\u0019\u0002/\u0005$G\rU1si&$\u0018n\u001c8tI\u0011,g-Y;mi\u00122\u0014aF1eIB\u000b'\u000f^5uS>t7\u000f\n3fM\u0006,H\u000e\u001e\u00138+\t\u0011yH\u000b\u0003\u0003Z\u0005\u0005\u0014aF1eIB\u000b'\u000f^5uS>t7\u000f\n3fM\u0006,H\u000e\u001e\u00139\u0003u\u0019'/Z1uK:+w\u000fU1si&$\u0018n\u001c8t\u0003N\u001c\u0018n\u001a8nK:$H\u0003EAf\u0005\u000f\u0013IIa#\u0003\u000e\n=%\u0011\u0013BJ\u0011\u0015A\b\u00051\u0001z\u0011\u001d\u0011\u0019\u0005\ta\u0001\u0003\u0017DqAa\u0012!\u0001\u0004\tY\tC\u0005\u0003L\u0001\u0002\n\u00111\u0001\u0002\u000e!9!1\u0005\u0011A\u0002\t=\u0003b\u0002B,A\u0001\u0007!\u0011\f\u0005\b\u0005W\u0002\u0003\u0019AA \u0003\u001d\u001a'/Z1uK:+w\u000fU1si&$\u0018n\u001c8t\u0003N\u001c\u0018n\u001a8nK:$H\u0005Z3gCVdG\u000f\n\u001b\u0002+Y\fG.\u001b3bi\u0016tUm\u001e)beRLG/[8ogRA!1\u0014BQ\u0005G\u0013)\u000bE\u0004T\u0005;\u000b\u0019,!\u0004\n\u0007\t}EK\u0001\u0004UkBdWM\r\u0005\u0006q\n\u0002\r!\u001f\u0005\b\u0005\u0007\u0012\u0003\u0019AAf\u0011\u001d\u0011YE\ta\u0001\u0003\u001b\tad\u0019:fCR,\u0007+\u0019:uSRLwN\\:XSRD\u0017i]:jO:lWM\u001c;\u0015\u0015\u0005-'1\u0016BW\u0005_\u0013\u0019\fC\u0003yG\u0001\u0007\u0011\u0010C\u0004\u0003D\r\u0002\r!a3\t\u000f\tE6\u00051\u0001\u0002L\u00061b.Z<QCJ$\u0018\u000e^5p]\u0006\u001b8/[4o[\u0016tG\u000fC\u0005\u0002L\r\u0002\n\u00111\u0001\u0002N\u0005A3M]3bi\u0016\u0004\u0016M\u001d;ji&|gn],ji\"\f5o]5h]6,g\u000e\u001e\u0013eK\u001a\fW\u000f\u001c;%i\u0005Ib/\u00197jI\u0006$XMU3qY&\u001c\u0017-Q:tS\u001etW.\u001a8u)\u001d!(1\u0018B_\u0005\u0003DqAa\t&\u0001\u0004\tY\rC\u0004\u0003@\u0016\u0002\r!!\u0004\u00023\u0015D\b/Z2uK\u0012\u0014V\r\u001d7jG\u0006$\u0018n\u001c8GC\u000e$xN\u001d\u0005\b\u0005\u0007,\u0003\u0019\u0001Bc\u0003I\tg/Y5mC\ndWM\u0011:pW\u0016\u0014\u0018\nZ:\u0011\u000bi\u00149-!\u0004\n\t\t=\u0011qA\u0001\fa\u0006\u00148/\u001a\"s_.,'\u000f\u0006\u0003\u0003N\n=\u0007\u0003B*f\u0003\u001bAaA!5'\u0001\u0004I\u0018A\u00022s_.,'/A\u0007dQ\u0006tw-Z\"p]\u001aLwm\u001d\u000b\ni\n]'1\u001cBp\u0005GDaA!7(\u0001\u0004I\u0018AC3oi&$\u0018\u0010V=qK\"1!Q\\\u0014A\u0002e\f!\"\u001a8uSRLh*Y7f\u0011\u001d\u0011\to\na\u0001\u00037\tqaY8oM&<7\u000fC\u0005\u0003f\u001e\u0002\n\u00111\u0001\u0002@\u0005q\u0011n]+tKJ\u001cE.[3oi&#\u0017aF2iC:<WmQ8oM&<7\u000f\n3fM\u0006,H\u000e\u001e\u00135\u0003I!(/_\"mK\u0006t\u0017+^8uC:{G-Z:\u0015\u0011\u0005}\"Q\u001eBx\u0005cDaA!7*\u0001\u0004I\bB\u0002BoS\u0001\u0007\u0011\u0010C\u0004\u0003f&\u0002\r!a\u0010\u0002)\rD\u0017M\\4f\u00072LWM\u001c;JI\u000e{gNZ5h)\u0015!(q\u001fB~\u0011\u0019\u0011IP\u000ba\u0001s\u0006\t2/\u00198ji&TX\rZ\"mS\u0016tG/\u00133\t\u000f\t\u0005(\u00061\u0001\u0002\u001c\u0005q2\r[1oO\u0016,6/\u001a:PeV\u001bXM]\"mS\u0016tG/\u00133D_:4\u0017n\u001a\u000b\bi\u000e\u00051QAB\u0004\u0011\u0019\u0019\u0019a\u000ba\u0001s\u0006\u00192/\u00198ji&TX\rZ#oi&$\u0018PT1nK\"9!\u0011]\u0016A\u0002\u0005m\u0001\"\u0003BsWA\u0005\t\u0019AA \u0003!\u001a\u0007.\u00198hKV\u001bXM](s+N,'o\u00117jK:$\u0018\nZ\"p]\u001aLw\r\n3fM\u0006,H\u000e\u001e\u00134\u0003A1\u0018\r\\5eCR,\u0017\n]\"p]\u001aLw\rF\u0003u\u0007\u001f\u0019\u0019\u0002\u0003\u0004\u0004\u00125\u0002\r!_\u0001\u0003SBDqA!9.\u0001\u0004\tY\"\u0001\u000bwC2LG-\u0019;f)\u0016t\u0017M\u001c;D_:4\u0017n\u001a\u000b\u0006i\u000ee1Q\u0004\u0005\u0007\u00077q\u0003\u0019A=\u0002\rQ,g.\u00198u\u0011\u001d\u0011\tO\fa\u0001\u00037\tab\u00195b]\u001e,\u0017\n]\"p]\u001aLw\rF\u0003u\u0007G\u0019)\u0003\u0003\u0004\u0004\u0012=\u0002\r!\u001f\u0005\b\u0005C|\u0003\u0019AA\u000e\u0003I\u0019\u0007.\u00198hKR+g.\u00198u\u0007>tg-[4\u0015\u000bQ\u001cYc!\f\t\r\rm\u0001\u00071\u0001z\u0011\u001d\u0011\t\u000f\ra\u0001\u00037\t1C^1mS\u0012\fG/\u001a+pa&\u001c7i\u001c8gS\u001e$R\u0001^B\u001a\u0007kAQ\u0001_\u0019A\u0002eDqA!92\u0001\u0004\tY\"A\tdQ\u0006tw-\u001a+pa&\u001c7i\u001c8gS\u001e$R\u0001^B\u001e\u0007{AQ\u0001\u001f\u001aA\u0002eDqA!93\u0001\u0004\tY\"\u0001\ndQ\u0006tw-\u001a\"s_.,'oQ8oM&<G#\u0002;\u0004D\r\u001d\u0003bBB#g\u0001\u0007\u00111W\u0001\bEJ|7.\u001a:t\u0011\u001d\u0011\to\ra\u0001\u00037!R\u0001^B&\u0007\u001bBqA!55\u0001\u0004\u0011i\rC\u0004\u0003bR\u0002\r!a\u0007\u0002)Y\fG.\u001b3bi\u0016\u0014%o\\6fe\u000e{gNZ5h)\r!81\u000b\u0005\b\u0005C,\u0004\u0019AA\u000e\u0003]\u0019\u0007.\u00198hK\u000ecWo\u001d;fe2Kgn[\"p]\u001aLw\rF\u0003u\u00073\u001aI\u0007C\u0004\u0004\\Y\u0002\ra!\u0018\u0002\r1Lgn[%e!\u0011\u0019yf!\u001a\u000e\u0005\r\u0005$\u0002BB2\u0003;\u000baaY8n[>t\u0017\u0002BB4\u0007C\u0012A!V;jI\"911\u000e\u001cA\u0002\u0005m\u0011a\u00049feNL7\u000f^3oiB\u0013x\u000e]:\u0002-\u0019,Go\u00195DYV\u001cH/\u001a:MS:\\7i\u001c8gS\u001e$B!a\u0007\u0004r!911L\u001cA\u0002\ru\u0013aF3ogV\u0014Xm\u00117vgR,'\u000fT5oW\u0016C\u0018n\u001d;t)\r!8q\u000f\u0005\b\u00077B\u0004\u0019AB/\u0003I\u0019\u0007.\u00198hK\u0016sG/\u001b;z\u0007>tg-[4\u0015\u0013Q\u001cih!!\u0004\u0006\u000e\u001d\u0005BBB@s\u0001\u0007\u00110\u0001\bs_>$XI\u001c;jif$\u0016\u0010]3\t\r\r\r\u0015\b1\u0001z\u0003]1W\u000f\u001c7TC:LG/\u001b>fI\u0016sG/\u001b;z\u001d\u0006lW\rC\u0004\u0003bf\u0002\r!a\u0007\t\u0013\t\u0015\u0018\b%AA\u0002\u0005}\u0012\u0001H2iC:<W-\u00128uSRL8i\u001c8gS\u001e$C-\u001a4bk2$H\u0005N\u0001\u0012M\u0016$8\r[#oi&$\u0018pQ8oM&<GCBA\u000e\u0007\u001f\u001b\t\n\u0003\u0004\u0004\u0000m\u0002\r!\u001f\u0005\u0007\u0007\u0007Y\u0004\u0019A=\u0002+\u0019,Go\u00195BY2,e\u000e^5us\u000e{gNZ5hgR!1qSBM!\u001d\ti)!4z\u00037AaA!7=\u0001\u0004I\u0018A\u00074fi\u000eD\u0017\t\u001c7DQ&dG-\u00128uSRL8i\u001c8gS\u001e\u001cHCBBL\u0007?\u001b\t\u000b\u0003\u0004\u0004\u0000u\u0002\r!\u001f\u0005\u0007\u0007Gk\u0004\u0019A=\u0002\u001f\rD\u0017\u000e\u001c3F]RLG/\u001f+za\u0016$Baa*\u0004*B9\u0011QRAgs\u00065\u0001bBBV}\u0001\u00071QV\u0001\u0007i>\u0004\u0018nY:\u0011\ti\u00149-\u001f\u000b\u0005\u0005\u001b\u001c\t\fC\u0003y\u007f\u0001\u0007\u00110A\tde\u0016\fG/Z\"mkN$XM\u001d'j].$R\u0001^B\\\u0007\u0003Dqa!/A\u0001\u0004\u0019Y,A\bdYV\u001cH/\u001a:MS:\\G)\u0019;b!\r\u00017QX\u0005\u0004\u0007\u007fc%aD\"mkN$XM\u001d'j].$\u0015\r^1\t\u000f\r\r\u0007\t1\u0001\u0002\u001c\u0005\t\u0002/\u001a:tSN$XM\u001c;D_:4\u0017nZ:\u0002\u001d\u001d,Go\u00117vgR,'\u000fT5oWR!1\u0011ZBf!\u0011\u0019Vma/\t\u000f\rm\u0013\t1\u0001\u0004^\u0005yq-\u001a;DYV\u001cH/\u001a:MS:\\7\u000f\u0006\u0003\u0004R\u000eM\u0007\u0003CAG\u0003\u001b\u001cifa/\t\u000f\rU'\t1\u0001\u0004X\u00069A.\u001b8l\u0013\u0012\u001c\b#\u0002>\u0003H\u000eu\u0013AE4fi\u0006cGn\u00117vgR,'\u000fT5oWN$\"a!8\u0011\r\u00055\u00151SB^\u00039\u0019X\r^\"mkN$XM\u001d'j].$R\u0001^Br\u0007KDqa!/E\u0001\u0004\u0019Y\fC\u0004\u0004h\u0012\u0003\r!!\u0004\u0002A\u0015D\b/Z2uK\u0012\u001cuN\u001c;s_2dWM]#q_\u000eD'l\u001b,feNLwN\\\u0001\u0012I\u0016dW\r^3DYV\u001cH/\u001a:MS:\\G#\u0002;\u0004n\u000e=\bbBB.\u000b\u0002\u00071Q\f\u0005\b\u0007O,\u0005\u0019AA\u0007\u0003\u0001j\u0017-\u001f2f%\u0016,gn\u0019:zaR\u001cE.^:uKJd\u0015N\\6D_:4\u0017nZ:\u0015\u0007Q\u001c)\u0010C\u0004\u0004x\u001a\u0003\ra!?\u0002#\r|gNZ5h)J\fgn\u001d4pe6,'\u000fE\u0004T\u0007w\fYba@\n\u0007\ruHKA\u0005Gk:\u001cG/[8ocA!1+ZA\u000e\u00035\tE-\\5o5.\u001cE.[3oiB\u0011\u0001\rS\n\u0003\u0011J#\"\u0001b\u0001\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00133+\t!iAK\u0002e\u0003C\u0002")
public class AdminZkClient
implements Logging {
    private final KafkaZkClient zkClient;
    private final Option<KafkaConfig> kafkaConfig;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static Option<KafkaConfig> $lessinit$greater$default$2() {
        return None$.MODULE$;
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public void createTopic(String topic, int partitions, int replicationFactor, Properties topicConfig, RackAwareMode rackAwareMode, boolean usesModernTopicId, boolean usesLegacyTopicId, Option<ClusterLinkTopicState> clusterLink) {
        java.util.List brokerMetadatas = CollectionConverters$.MODULE$.SeqHasAsJava(this.getBrokerMetadatas(rackAwareMode, this.getBrokerMetadatas$default$2())).asJava();
        Map replicaAssignment = (Map)CoreUtils$.MODULE$.replicaToBrokerAssignmentAsScala(AdminUtils.assignReplicasToBrokers((Collection)brokerMetadatas, (int)partitions, (int)replicationFactor, (int)-1, (int)-1)).map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                int partition = x0$1._1$mcI$sp();
                Seq replicas = (Seq)x0$1._2();
                return new Tuple2((Object)BoxesRunTime.boxToInteger((int)partition), (Object)ReplicaAssignment$.MODULE$.apply((Seq<Object>)replicas, (Seq<Object>)((Seq)Seq$.MODULE$.empty())));
            }
            throw new MatchError(null);
        });
        boolean x$7 = this.createTopicWithAssignment$default$4();
        this.createTopicWithAssignment(topic, topicConfig, (Map<Object, ReplicaAssignment>)replicaAssignment, x$7, usesModernTopicId, usesLegacyTopicId, clusterLink);
    }

    public Properties createTopic$default$4() {
        return new Properties();
    }

    public RackAwareMode createTopic$default$5() {
        return RackAwareMode$Enforced$.MODULE$;
    }

    public boolean createTopic$default$6() {
        return false;
    }

    public boolean createTopic$default$7() {
        return false;
    }

    public Option<ClusterLinkTopicState> createTopic$default$8() {
        return None$.MODULE$;
    }

    public Seq<BrokerMetadata> getBrokerMetadatas(RackAwareMode rackAwareMode, Option<Seq<Object>> brokerList) {
        Seq<Broker> allBrokers = this.zkClient.getAllBrokersInCluster();
        Seq brokers = (Seq)brokerList.map((Function1 & Serializable)brokerIds -> (Seq)allBrokers.filter((Function1 & Serializable)b -> BoxesRunTime.boxToBoolean((boolean)brokerIds.contains((Object)BoxesRunTime.boxToInteger((int)b.id()))))).getOrElse((Function0 & Serializable)() -> allBrokers);
        Seq brokersWithRack = (Seq)brokers.filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)AdminZkClient.$anonfun$getBrokerMetadatas$4(x$1)));
        RackAwareMode rackAwareMode2 = rackAwareMode;
        RackAwareMode$Enforced$ rackAwareMode$Enforced$ = RackAwareMode$Enforced$.MODULE$;
        if (rackAwareMode2 != null && rackAwareMode2.equals(rackAwareMode$Enforced$) && brokersWithRack.nonEmpty() && brokersWithRack.size() < brokers.size()) {
            throw new AdminOperationException("Not all brokers have rack information. Add --disable-rack-aware in command line to make replica assignment without rack information.");
        }
        return (Seq)(RackAwareMode$Disabled$.MODULE$.equals(rackAwareMode) ? (Seq)brokers.map((Function1 & Serializable)broker -> new BrokerMetadata(broker.id(), Optional.empty())) : (RackAwareMode$Safe$.MODULE$.equals(rackAwareMode) && brokersWithRack.size() < brokers.size() ? (Seq)brokers.map((Function1 & Serializable)broker -> new BrokerMetadata(broker.id(), Optional.empty())) : (Seq)brokers.map((Function1 & Serializable)broker -> new BrokerMetadata(broker.id(), Optional.ofNullable(broker.rack().orNull((.less.colon.less)$less$colon$less$.MODULE$.refl())))))).sortBy((Function1 & Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.id), (Ordering)Ordering.Int$.MODULE$);
    }

    public RackAwareMode getBrokerMetadatas$default$1() {
        return RackAwareMode$Enforced$.MODULE$;
    }

    public Option<Seq<Object>> getBrokerMetadatas$default$2() {
        return None$.MODULE$;
    }

    public void createTopicWithAssignment(String topic, Properties config, Map<Object, ReplicaAssignment> partitionReplicaAssignment, boolean validate, boolean usesModernTopicId, boolean usesLegacyTopicId, Option<ClusterLinkTopicState> clusterLink) {
        if (validate) {
            this.validateTopicCreate(topic, partitionReplicaAssignment, config, (Function0<Set<String>>)(Function0 & Serializable)() -> $this.zkClient.getAllTopicsInCluster($this.zkClient.getAllTopicsInCluster$default$1()), this.validateTopicCreate$default$5());
        }
        this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(69).append("Creating topic ").append(topic).append(" with configuration ").append(config).append(" and initial partition ").append("assignment ").append(partitionReplicaAssignment).toString());
        this.zkClient.setOrCreateEntityConfigs("topics", topic, config);
        this.writeTopicPartitionAssignment(topic, partitionReplicaAssignment, false, usesModernTopicId, usesLegacyTopicId, clusterLink);
    }

    public boolean createTopicWithAssignment$default$4() {
        return true;
    }

    public boolean createTopicWithAssignment$default$5() {
        return false;
    }

    public boolean createTopicWithAssignment$default$6() {
        return false;
    }

    public Option<ClusterLinkTopicState> createTopicWithAssignment$default$7() {
        return None$.MODULE$;
    }

    public boolean topicExists(String topicName) {
        return this.zkClient.topicExists(topicName);
    }

    public void validateTopicCreate(String topic, Map<Object, ReplicaAssignment> partitionReplicaAssignment, Properties config, Function0<Set<String>> topicsSupplier, Set<String> createdTopics) {
        Topic.validate((String)topic);
        if (this.zkClient.isTopicMarkedForDeletion(topic)) {
            throw new TopicExistsException(new StringBuilder(32).append("Topic '").append(topic).append("' is marked for deletion.").toString());
        }
        if (this.zkClient.topicExists(topic)) {
            throw new TopicExistsException(new StringBuilder(24).append("Topic '").append(topic).append("' already exists.").toString());
        }
        if (Topic.hasCollisionChars((String)topic)) {
            Set topics = (Set)topicsSupplier.apply();
            if (topics.contains((Object)topic) || createdTopics.contains((Object)topic)) {
                throw new TopicExistsException(new StringBuilder(24).append("Topic '").append(topic).append("' already exists.").toString());
            }
            Set collidingTopics = (Set)((SetOps)topics.filter((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)AdminZkClient.$anonfun$validateTopicCreate$1(topic, x$3)))).$plus$plus((IterableOnce)createdTopics.filter((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)AdminZkClient.$anonfun$validateTopicCreate$2(topic, x$4))));
            if (collidingTopics.nonEmpty()) {
                throw new InvalidTopicException(new StringBuilder(40).append("Topic '").append(topic).append("' collides with existing topics: ").append(collidingTopics.mkString(", ")).toString());
            }
        }
        if (((IterableOnceOps)partitionReplicaAssignment.values().map((Function1 & Serializable)x$5 -> BoxesRunTime.boxToInteger((int)AdminZkClient.$anonfun$validateTopicCreate$3(x$5)))).toSet().size() != 1) {
            throw new InvalidReplicaAssignmentException("All partitions should have the same number of replicas");
        }
        if (((IterableOnceOps)partitionReplicaAssignment.values().map((Function1 & Serializable)x$6 -> BoxesRunTime.boxToInteger((int)AdminZkClient.$anonfun$validateTopicCreate$4(x$6)))).toSet().size() != 1) {
            throw new InvalidReplicaAssignmentException("All partitions should have the same number of observers");
        }
        partitionReplicaAssignment.values().foreach((Function1 & Serializable)assignment -> {
            AdminZkClient.$anonfun$validateTopicCreate$5(partitionReplicaAssignment, assignment);
            return BoxedUnit.UNIT;
        });
        int partitionSize = partitionReplicaAssignment.size();
        int sequenceSum = partitionSize * (partitionSize - 1) / 2;
        if (partitionReplicaAssignment.size() != partitionReplicaAssignment.toSet().size() || BoxesRunTime.unboxToInt((Object)((IterableOnceOps)partitionReplicaAssignment.keys().filter((Function1)(JFunction1.mcZI.sp & Serializable)x$7 -> x$7 >= 0)).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)) != sequenceSum) {
            throw new InvalidReplicaAssignmentException("partitions should be a consecutive 0-based integer sequence");
        }
        LogConfig.validate((Properties)config, (java.util.Map)((java.util.Map)this.kafkaConfig.map((Function1 & Serializable)x$8 -> x$8.extractLogConfigMap()).getOrElse((Function0 & Serializable)() -> Collections.emptyMap())), (boolean)this.kafkaConfig.exists((Function1 & Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)AdminZkClient.$anonfun$validateTopicCreate$9(x$9))), (boolean)false);
    }

    public Set<String> validateTopicCreate$default$5() {
        return Predef$.MODULE$.Set().empty();
    }

    public void writeTopicPartitionAssignment(String topic, Map<Object, ReplicaAssignment> replicaAssignment, boolean isUpdate, boolean usesModernTopicId, boolean usesLegacyTopicId, Option<ClusterLinkTopicState> clusterLink) {
        try {
            scala.collection.immutable.Map assignment = replicaAssignment.map((Function1 & Serializable)x0$1 -> {
                if (x0$1 != null) {
                    int partitionId = x0$1._1$mcI$sp();
                    ReplicaAssignment replicas = (ReplicaAssignment)x0$1._2();
                    return new Tuple2((Object)new TopicPartition(topic, partitionId), (Object)replicas);
                }
                throw new MatchError(null);
            }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
            if (!isUpdate) {
                None$ legacyTopicIdOpt = usesLegacyTopicId ? new Some((Object)Uuid.randomUuid()) : None$.MODULE$;
                None$ topicIdOpt = usesModernTopicId ? new Some((Object)Uuid.randomUuid()) : None$.MODULE$;
                this.zkClient.createTopicAssignment(topic, (Option<Uuid>)topicIdOpt, (Option<Uuid>)legacyTopicIdOpt, (Map<TopicPartition, ReplicaAssignment>)assignment, clusterLink);
                topicIdOpt.orElse(() -> AdminZkClient.$anonfun$writeTopicPartitionAssignment$2((Option)legacyTopicIdOpt)).foreach((Function1 & Serializable)topicId -> {
                    this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(27).append("Assigned topicId ").append(topicId).append(" to topic ").append(topic$3).toString());
                    return BoxedUnit.UNIT;
                });
            } else {
                TopicZNode.TopicIdReplicaAssignment oldAssignment = (TopicZNode.TopicIdReplicaAssignment)this.zkClient.getReplicaAssignmentAndTopicIdForTopics((scala.collection.immutable.Set<String>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic})))).head();
                this.zkClient.setTopicAssignment(topic, oldAssignment.topicId(), oldAssignment.legacyTopicId(), (Map<TopicPartition, ReplicaAssignment>)assignment, clusterLink, this.zkClient.setTopicAssignment$default$6());
            }
            this.debug((Function0<String>)(Function0 & Serializable)() -> StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Updated path %s with %s for replica assignment"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{TopicZNode$.MODULE$.path(topic), assignment})));
            return;
        }
        catch (KeeperException.NodeExistsException nodeExistsException) {
            throw new TopicExistsException(new StringBuilder(24).append("Topic '").append(topic).append("' already exists.").toString());
        }
        catch (Throwable e2) {
            throw new AdminOperationException(e2.toString());
        }
    }

    public boolean writeTopicPartitionAssignment$default$4() {
        return false;
    }

    public boolean writeTopicPartitionAssignment$default$5() {
        return false;
    }

    public Option<ClusterLinkTopicState> writeTopicPartitionAssignment$default$6() {
        return None$.MODULE$;
    }

    public void deleteTopic(String topic) {
        if (this.zkClient.topicExists(topic)) {
            try {
                this.zkClient.createDeleteTopicPath(topic);
                return;
            }
            catch (KeeperException.NodeExistsException nodeExistsException) {
                throw new TopicAlreadyMarkedForDeletionException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("topic %s is already marked for deletion"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{topic})));
            }
            catch (Throwable e) {
                throw new AdminOperationException(e.getMessage());
            }
        }
        throw new UnknownTopicOrPartitionException(new StringBuilder(33).append("Topic `").append(topic).append("` to delete does not exist").toString());
    }

    public Map<Object, ReplicaAssignment> addPartitions(String topic, Map<Object, ReplicaAssignment> existingAssignment, Seq<BrokerMetadata> allBrokers, int numPartitions, Option<Map<Object, ReplicaAssignment>> replicaAssignment, boolean validateOnly, Option<TopicPlacement> topicPlacement, Option<ClusterLinkTopicState> clusterLink, boolean rackMixingSupportEnabled) {
        Map<Object, ReplicaAssignment> proposedAssignmentForNewPartitions = this.createNewPartitionsAssignment(topic, existingAssignment, allBrokers, numPartitions, replicaAssignment, topicPlacement, rackMixingSupportEnabled);
        if (validateOnly) {
            return (Map)existingAssignment.$plus$plus(proposedAssignmentForNewPartitions);
        }
        return this.createPartitionsWithAssignment(topic, existingAssignment, proposedAssignmentForNewPartitions, clusterLink);
    }

    public int addPartitions$default$4() {
        return 1;
    }

    public Option<Map<Object, ReplicaAssignment>> addPartitions$default$5() {
        return None$.MODULE$;
    }

    public boolean addPartitions$default$6() {
        return false;
    }

    public Option<TopicPlacement> addPartitions$default$7() {
        return None$.MODULE$;
    }

    public Option<ClusterLinkTopicState> addPartitions$default$8() {
        return None$.MODULE$;
    }

    /*
     * WARNING - void declaration
     */
    public Map<Object, ReplicaAssignment> createNewPartitionsAssignment(String topic, Map<Object, ReplicaAssignment> existingAssignment, Seq<BrokerMetadata> allBrokers, int numPartitions, Option<Map<Object, ReplicaAssignment>> replicaAssignment, Option<TopicPlacement> topicPlacement, boolean rackMixingSupportEnabled) {
        void var9_9;
        Tuple2<Seq<Object>, Object> tuple2 = this.validateNewPartitions(topic, existingAssignment, numPartitions);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Seq existingAssignmentPartition0 = (Seq)tuple2._1();
        int n = tuple2._2$mcI$sp();
        replicaAssignment.foreach(arg_0 -> AdminZkClient.$anonfun$createNewPartitionsAssignment$1$adapted(this, (Seq)var9_9, allBrokers, arg_0));
        return (Map)((Map)replicaAssignment.getOrElse(() -> AdminZkClient.$anonfun$createNewPartitionsAssignment$3(allBrokers, (Seq)var9_9, topicPlacement, n, rackMixingSupportEnabled, existingAssignment))).map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                int tp = x0$1._1$mcI$sp();
                ReplicaAssignment replicas = (ReplicaAssignment)x0$1._2();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp)), (Object)replicas);
            }
            throw new MatchError(null);
        });
    }

    public int createNewPartitionsAssignment$default$4() {
        return 1;
    }

    public Tuple2<Seq<Object>, Object> validateNewPartitions(String topic, Map<Object, ReplicaAssignment> existingAssignment, int numPartitions) {
        Seq<Object> existingAssignmentPartition0 = ((ReplicaAssignment)existingAssignment.getOrElse((Object)BoxesRunTime.boxToInteger((int)0), (Function0 & Serializable)() -> {
            throw new AdminOperationException(new StringBuilder(92).append("Unexpected existing replica assignment for topic '").append(topic).append("', partition id 0 is missing. ").append("Assignment: ").append(existingAssignment).toString());
        })).replicas();
        int partitionsToAdd = numPartitions - existingAssignment.size();
        if (partitionsToAdd <= 0) {
            throw new InvalidPartitionsException(new StringBuilder(120).append("The number of partitions for a topic can only be increased. ").append("Topic ").append(topic).append(" currently has ").append(existingAssignment.size()).append(" partitions, ").append(numPartitions).append(" would not be an increase.").toString());
        }
        return new Tuple2(existingAssignmentPartition0, (Object)BoxesRunTime.boxToInteger((int)partitionsToAdd));
    }

    public Map<Object, ReplicaAssignment> createPartitionsWithAssignment(String topic, Map<Object, ReplicaAssignment> existingAssignment, Map<Object, ReplicaAssignment> newPartitionAssignment, Option<ClusterLinkTopicState> clusterLink) {
        this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(68).append("Creating ").append(newPartitionAssignment.size()).append(" partitions for '").append(topic).append("' with the following replica assignment: ").append(newPartitionAssignment).append(".").toString());
        Map combinedAssignment = (Map)existingAssignment.$plus$plus(newPartitionAssignment);
        boolean x$5 = this.writeTopicPartitionAssignment$default$4();
        boolean x$6 = this.writeTopicPartitionAssignment$default$5();
        this.writeTopicPartitionAssignment(topic, (Map<Object, ReplicaAssignment>)combinedAssignment, true, x$5, x$6, clusterLink);
        return combinedAssignment;
    }

    public Option<ClusterLinkTopicState> createPartitionsWithAssignment$default$4() {
        return None$.MODULE$;
    }

    private void validateReplicaAssignment(Map<Object, ReplicaAssignment> replicaAssignment, int expectedReplicationFactor, scala.collection.immutable.Set<Object> availableBrokerIds) {
        Function2 & Serializable forKeyValue$extension_f = (Function2 & Serializable)(partitionId, assignment) -> {
            AdminZkClient.$anonfun$validateReplicaAssignment$1(availableBrokerIds, BoxesRunTime.unboxToInt((Object)partitionId), assignment);
            return BoxedUnit.UNIT;
        };
        replicaAssignment.foreachEntry((arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1(forKeyValue$extension_f, arg_0, arg_1));
        Object var8_4 = null;
        Map badRepFactors = (Map)replicaAssignment.collect((PartialFunction)new Serializable(null, expectedReplicationFactor){
            private static final long serialVersionUID = 0L;
            private final int expectedReplicationFactor$1;

            public final <A1 extends Tuple2<Object, ReplicaAssignment>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                if (x1 != null) {
                    int partition = x1._1$mcI$sp();
                    ReplicaAssignment assignment = (ReplicaAssignment)x1._2();
                    if (assignment.replicas().size() != this.expectedReplicationFactor$1) {
                        return (B1)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)partition)), (Object)BoxesRunTime.boxToInteger((int)assignment.replicas().size()));
                    }
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Tuple2<Object, ReplicaAssignment> x1) {
                return x1 != null && ((ReplicaAssignment)x1._2()).replicas().size() != this.expectedReplicationFactor$1;
            }
            {
                this.expectedReplicationFactor$1 = expectedReplicationFactor$1;
            }
        });
        if (badRepFactors.nonEmpty()) {
            scala.collection.immutable.Seq sortedBadRepFactors = (scala.collection.immutable.Seq)badRepFactors.toSeq().sortBy((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToInteger((int)AdminZkClient.$anonfun$validateReplicaAssignment$2(x0$1)), (Ordering)Ordering.Int$.MODULE$);
            scala.collection.immutable.Seq partitions = (scala.collection.immutable.Seq)sortedBadRepFactors.map((Function1 & Serializable)x0$2 -> BoxesRunTime.boxToInteger((int)AdminZkClient.$anonfun$validateReplicaAssignment$3(x0$2)));
            scala.collection.immutable.Seq repFactors = (scala.collection.immutable.Seq)sortedBadRepFactors.map((Function1 & Serializable)x0$3 -> BoxesRunTime.boxToInteger((int)AdminZkClient.$anonfun$validateReplicaAssignment$4(x0$3)));
            throw new InvalidReplicaAssignmentException(new StringBuilder(131).append("Inconsistent replication factor between partitions, ").append("partition 0 has ").append(expectedReplicationFactor).append(" while partitions [").append(partitions.mkString(", ")).append("] have ").append("replication factors [").append(repFactors.mkString(", ")).append("], respectively.").toString());
        }
    }

    public Option<Object> parseBroker(String broker) {
        switch (broker == null ? 0 : broker.hashCode()) {
            case -428804519: {
                if (!"<default>".equals(broker)) break;
                return None$.MODULE$;
            }
        }
        try {
            return new Some((Object)BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(broker))));
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException(new StringBuilder(78).append("Error parsing broker ").append(broker).append(". The broker's Entity Name must be a single integer value").toString());
        }
    }

    public void changeConfigs(String entityType, String entityName, Properties configs, boolean isUserClientId) {
        switch (entityType == null ? 0 : entityType.hashCode()) {
            case -1873421222: {
                if (!"confluent-tenants".equals(entityType)) break;
                this.changeTenantConfig(entityName, configs);
                return;
            }
            case -868034268: {
                if (!"topics".equals(entityType)) break;
                this.changeTopicConfig(entityName, configs);
                return;
            }
            case 104492: {
                if (!"ips".equals(entityType)) break;
                this.changeIpConfig(entityName, configs);
                return;
            }
            case 111578632: {
                if (!"users".equals(entityType)) break;
                this.changeUserOrUserClientIdConfig(entityName, configs, isUserClientId);
                return;
            }
            case 150569914: {
                if (!"brokers".equals(entityType)) break;
                this.changeBrokerConfig(this.parseBroker(entityName), configs);
                return;
            }
            case 860587528: {
                if (!"clients".equals(entityType)) break;
                this.changeClientIdConfig(entityName, configs);
                return;
            }
            case 1366135334: {
                if (!"cluster-links".equals(entityType)) break;
                throw new IllegalArgumentException("Cluster link configs can be altered only using Admin API");
            }
        }
        throw new IllegalArgumentException(new StringBuilder(51).append(entityType).append(" is not a known entityType. Should be one of List(").append(String.join((CharSequence)", ", ConfigType.ALL)).append(")").toString());
    }

    public boolean changeConfigs$default$4() {
        return false;
    }

    private boolean tryCleanQuotaNodes(String entityType, String entityName, boolean isUserClientId) {
        String currPath = ConfigEntityZNode$.MODULE$.path(entityType, entityName);
        if (this.zkClient.getChildren(currPath).isEmpty()) {
            ObjectRef pathToDelete = ObjectRef.create((Object)currPath);
            if (isUserClientId) {
                String user = entityName.substring(0, entityName.indexOf("/"));
                String clientId = entityName.substring(entityName.lastIndexOf("/") + 1);
                String clientsPath = ConfigEntityZNode$.MODULE$.path("users", new StringBuilder(8).append(user).append("/").append("clients").toString());
                Seq<String> seq = this.zkClient.getChildren(clientsPath);
                .colon.colon colon2 = new .colon.colon((Object)clientId, (List)Nil$.MODULE$);
                if (seq != null && seq.equals((Object)colon2)) {
                    pathToDelete.elem = clientsPath;
                    Properties userData = this.fetchEntityConfig("users", user);
                    String userPath = ConfigEntityZNode$.MODULE$.path("users", user);
                    Seq<String> userChildren = this.zkClient.getChildren(userPath);
                    if (userData.isEmpty()) {
                        Seq<String> seq2 = userChildren;
                        .colon.colon colon3 = new .colon.colon((Object)"clients", (List)Nil$.MODULE$);
                        if (seq2 != null && seq2.equals((Object)colon3)) {
                            pathToDelete.elem = userPath;
                        }
                    }
                }
            }
            this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(69).append("Deleting zk node ").append((String)pathToDelete$1.elem).append(" since node of entityType ").append(entityType).append(" and entityName ").append(entityName).append(" is empty.").toString());
            this.zkClient.deletePath((String)pathToDelete.elem, this.zkClient.deletePath$default$2(), this.zkClient.deletePath$default$3());
            return true;
        }
        return false;
    }

    public void changeClientIdConfig(String sanitizedClientId, Properties configs) {
        DynamicConfig$Client$.MODULE$.validate(configs);
        this.changeEntityConfig("clients", sanitizedClientId, configs, false);
    }

    public void changeUserOrUserClientIdConfig(String sanitizedEntityName, Properties configs, boolean isUserClientId) {
        String string = sanitizedEntityName;
        String string2 = "<default>";
        if (string != null && string.equals(string2) || sanitizedEntityName.contains("/clients")) {
            DynamicConfig$Client$.MODULE$.validate(configs);
        } else {
            DynamicConfig$User$.MODULE$.validate(configs);
        }
        this.changeEntityConfig("users", sanitizedEntityName, configs, isUserClientId);
    }

    public boolean changeUserOrUserClientIdConfig$default$3() {
        return false;
    }

    private void validateIpConfig(String ip, Properties configs) {
        if (!DynamicConfig$Ip$.MODULE$.isValidIpEntity(ip)) {
            throw new AdminOperationException(new StringBuilder(38).append(ip).append(" is not a valid IP or resolvable host.").toString());
        }
        DynamicConfig$Ip$.MODULE$.validate(configs);
    }

    public void validateTenantConfig(String tenant, Properties configs) {
        DynamicConfig$Tenant$.MODULE$.validate(configs);
    }

    public void changeIpConfig(String ip, Properties configs) {
        this.validateIpConfig(ip, configs);
        this.changeEntityConfig("ips", ip, configs, false);
    }

    public void changeTenantConfig(String tenant, Properties configs) {
        this.validateTenantConfig(tenant, configs);
        this.changeEntityConfig("confluent-tenants", tenant, configs, false);
    }

    public void validateTopicConfig(String topic, Properties configs) {
        Topic.validate((String)topic);
        if (!this.zkClient.topicExists(topic)) {
            throw new UnknownTopicOrPartitionException(new StringBuilder(24).append("Topic '").append(topic).append("' does not exist.").toString());
        }
        LogConfig.validate((Properties)configs);
    }

    public void changeTopicConfig(String topic, Properties configs) {
        this.validateTopicConfig(topic, configs);
        this.changeEntityConfig("topics", topic, configs, false);
    }

    public void changeBrokerConfig(Seq<Object> brokers, Properties configs) {
        DynamicConfig$Broker$.MODULE$.validate(configs);
        brokers.foreach((Function1)(JFunction1.mcVI.sp & Serializable)broker -> this.changeEntityConfig("brokers", Integer.toString(broker), configs, false));
    }

    public void changeBrokerConfig(Option<Object> broker, Properties configs) {
        DynamicConfig$Broker$.MODULE$.validate(configs);
        this.changeEntityConfig("brokers", (String)broker.map((Function1 & Serializable)x$13 -> AdminZkClient.$anonfun$changeBrokerConfig$2(BoxesRunTime.unboxToInt((Object)x$13))).getOrElse((Function0 & Serializable)() -> "<default>"), configs, false);
    }

    private void validateBrokerConfig(Properties configs) {
        DynamicConfig$Broker$.MODULE$.validate(configs);
    }

    public void changeClusterLinkConfig(Uuid linkId, Properties persistentProps) {
        this.ensureClusterLinkExists(linkId);
        this.changeEntityConfig("cluster-links", CoreUtils$.MODULE$.toJavaUUID(linkId).toString(), persistentProps, false);
    }

    public Properties fetchClusterLinkConfig(Uuid linkId) {
        return this.fetchEntityConfig("cluster-links", CoreUtils$.MODULE$.toJavaUUID(linkId).toString());
    }

    public void ensureClusterLinkExists(Uuid linkId) {
        if (!this.zkClient.clusterLinkExists(linkId)) {
            throw new ClusterLinkNotFoundException(new StringBuilder(39).append("Cluster link with ID '").append(linkId).append("' does not exist.").toString());
        }
    }

    private void changeEntityConfig(String rootEntityType, String fullSanitizedEntityName, Properties configs, boolean isUserClientId) {
        String sanitizedEntityPath = new StringBuilder(11).append(rootEntityType).append('/').append(fullSanitizedEntityName).toString();
        boolean needUpdateConfigs = true;
        if (("clients".equals(rootEntityType) || "users".equals(rootEntityType) || "ips".equals(rootEntityType) || "confluent-tenants".equals(rootEntityType)) && configs.isEmpty() && this.tryCleanQuotaNodes(rootEntityType, fullSanitizedEntityName, isUserClientId)) {
            needUpdateConfigs = false;
        }
        if (needUpdateConfigs) {
            this.zkClient.setOrCreateEntityConfigs(rootEntityType, fullSanitizedEntityName, configs);
        }
        this.zkClient.createConfigChangeNotification(sanitizedEntityPath);
    }

    private boolean changeEntityConfig$default$4() {
        return false;
    }

    public Properties fetchEntityConfig(String rootEntityType, String sanitizedEntityName) {
        return this.zkClient.getEntityConfigs(rootEntityType, sanitizedEntityName);
    }

    public Map<String, Properties> fetchAllEntityConfigs(String entityType) {
        return ((IterableOnceOps)this.zkClient.getAllEntitiesWithConfig(entityType).map((Function1 & Serializable)entity -> new Tuple2(entity, (Object)this.fetchEntityConfig(entityType, (String)entity)))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public Map<String, Properties> fetchAllChildEntityConfigs(String rootEntityType, String childEntityType) {
        return ((IterableOnceOps)((IterableOps)this.entityPaths$1((Option)None$.MODULE$, rootEntityType).flatMap((Function1 & Serializable)entity -> this.entityPaths$1((Option)new Some((Object)new StringBuilder(11).append((String)entity).append('/').append(childEntityType).toString()), rootEntityType))).map((Function1 & Serializable)entityPath -> new Tuple2(entityPath, (Object)this.fetchEntityConfig(rootEntityType, (String)entityPath)))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public Map<String, Object> numPartitions(scala.collection.immutable.Set<String> topics) {
        return (Map)this.zkClient.getPartitionsForTopics(topics).map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                String topic = (String)x0$1._1();
                Seq partitions = (Seq)x0$1._2();
                return new Tuple2((Object)topic, (Object)BoxesRunTime.boxToInteger((int)partitions.size()));
            }
            throw new MatchError(null);
        });
    }

    public Option<Object> numPartitions(String topic) {
        return this.zkClient.getTopicPartitionCount(topic);
    }

    public void createClusterLink(ClusterLinkData clusterLinkData, Properties persistentConfigs) {
        Uuid linkId = clusterLinkData.linkId();
        if (this.zkClient.clusterLinkExists(linkId)) {
            throw new ClusterLinkExistsException(new StringBuilder(39).append("Cluster link with ID '").append(linkId).append("' already exists.").toString());
        }
        String javaLinkId = CoreUtils$.MODULE$.toJavaUUID(clusterLinkData.linkId()).toString();
        this.zkClient.setOrCreateEntityConfigs("cluster-links", javaLinkId, persistentConfigs);
        this.zkClient.createClusterLink(clusterLinkData);
        this.zkClient.createConfigChangeNotification(new StringBuilder(24).append("cluster-links").append('/').append(javaLinkId).toString());
    }

    public Option<ClusterLinkData> getClusterLink(Uuid linkId) {
        UUID javaLinkId = CoreUtils$.MODULE$.toJavaUUID(linkId);
        return this.zkClient.getClusterLinks((scala.collection.immutable.Set<UUID>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new UUID[]{javaLinkId})))).get((Object)javaLinkId);
    }

    public Map<Uuid, ClusterLinkData> getClusterLinks(scala.collection.immutable.Set<Uuid> linkIds) {
        scala.collection.immutable.Set javaLinkIds = (scala.collection.immutable.Set)linkIds.map((Function1 & Serializable)uuid -> CoreUtils$.MODULE$.toJavaUUID((Uuid)uuid));
        return (Map)this.zkClient.getClusterLinks((scala.collection.immutable.Set<UUID>)javaLinkIds).map((Function1 & Serializable)entry -> new Tuple2((Object)CoreUtils$.MODULE$.toKafkaUUID((UUID)entry._1()), entry._2()));
    }

    public Seq<ClusterLinkData> getAllClusterLinks() {
        return this.zkClient.getClusterLinks((scala.collection.immutable.Set<UUID>)((IterableOnceOps)this.zkClient.getChildren("/cluster_links").map((Function1 & Serializable)x$1 -> UUID.fromString(x$1))).toSet()).values().toSeq();
    }

    public void setClusterLink(ClusterLinkData clusterLinkData, int expectedControllerEpochZkVersion) {
        Uuid linkId = clusterLinkData.linkId();
        this.ensureClusterLinkExists(linkId);
        this.zkClient.setClusterLink(clusterLinkData, expectedControllerEpochZkVersion);
        String javaLinkId = CoreUtils$.MODULE$.toJavaUUID(linkId).toString();
        this.zkClient.createConfigChangeNotification(new StringBuilder(24).append("cluster-links").append('/').append(javaLinkId).toString());
    }

    public void deleteClusterLink(Uuid linkId, int expectedControllerEpochZkVersion) {
        this.ensureClusterLinkExists(linkId);
        this.zkClient.deleteClusterLink(linkId, expectedControllerEpochZkVersion);
        String javaLinkId = CoreUtils$.MODULE$.toJavaUUID(linkId).toString();
        this.zkClient.deleteEntityConfig("cluster-links", javaLinkId, this.zkClient.deleteEntityConfig$default$3());
        this.zkClient.createConfigChangeNotification(new StringBuilder(24).append("cluster-links").append('/').append(javaLinkId).toString());
    }

    public void maybeReencryptClusterLinkConfigs(Function1<Properties, Option<Properties>> configTransformer) {
        this.getAllClusterLinks().foreach((Function1 & Serializable)link -> {
            AdminZkClient.$anonfun$maybeReencryptClusterLinkConfigs$1(this, configTransformer, link);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$getBrokerMetadatas$4(Broker x$1) {
        return x$1.rack().nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$validateTopicCreate$1(String topic$2, String x$3) {
        return Topic.hasCollision((String)topic$2, (String)x$3);
    }

    public static final /* synthetic */ boolean $anonfun$validateTopicCreate$2(String topic$2, String x$4) {
        return Topic.hasCollision((String)topic$2, (String)x$4);
    }

    public static final /* synthetic */ int $anonfun$validateTopicCreate$3(ReplicaAssignment x$5) {
        return x$5.replicas().size();
    }

    public static final /* synthetic */ int $anonfun$validateTopicCreate$4(ReplicaAssignment x$6) {
        return x$6.observers().size();
    }

    public static final /* synthetic */ void $anonfun$validateTopicCreate$5(Map partitionReplicaAssignment$2, ReplicaAssignment assignment) {
        if (assignment.replicas().size() != assignment.replicas().toSet().size()) {
            throw new InvalidReplicaAssignmentException(new StringBuilder(36).append("Duplicate replica assignment found: ").append(partitionReplicaAssignment$2).toString());
        }
        if (assignment.observers().size() != assignment.observers().toSet().size()) {
            throw new InvalidReplicaAssignmentException(new StringBuilder(38).append("Duplicate observers assignment found: ").append(partitionReplicaAssignment$2).toString());
        }
    }

    public static final /* synthetic */ boolean $anonfun$validateTopicCreate$9(KafkaConfig x$9) {
        if (x$9.remoteLogManagerConfig() == null) {
            throw null;
        }
        return false;
    }

    public static final /* synthetic */ Option $anonfun$writeTopicPartitionAssignment$2(Option legacyTopicIdOpt$1) {
        return legacyTopicIdOpt$1;
    }

    public static final /* synthetic */ boolean $anonfun$createNewPartitionsAssignment$4(Seq existingAssignmentPartition0$1, BrokerMetadata x$12) {
        return x$12.id >= BoxesRunTime.unboxToInt((Object)existingAssignmentPartition0$1.head());
    }

    public static final /* synthetic */ Map $anonfun$createNewPartitionsAssignment$3(Seq allBrokers$2, Seq existingAssignmentPartition0$1, Option topicPlacement$1, int partitionsToAdd$1, boolean rackMixingSupportEnabled$1, Map existingAssignment$1) {
        int startIndex = package$.MODULE$.max(0, allBrokers$2.indexWhere((Function1 & Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)AdminZkClient.$anonfun$createNewPartitionsAssignment$4(existingAssignmentPartition0$1, x$12))));
        return Observer$.MODULE$.getReplicaAssignment((Seq<BrokerMetadata>)allBrokers$2, (Option<TopicPlacement>)topicPlacement$1, partitionsToAdd$1, existingAssignmentPartition0$1.size(), rackMixingSupportEnabled$1, startIndex, existingAssignment$1.size());
    }

    public static final /* synthetic */ void $anonfun$validateReplicaAssignment$1(scala.collection.immutable.Set availableBrokerIds$1, int partitionId, ReplicaAssignment assignment) {
        if (assignment.replicas().isEmpty()) {
            throw new InvalidReplicaAssignmentException(new StringBuilder(54).append("Cannot have replication factor of 0 for partition id ").append(partitionId).append(".").toString());
        }
        if (assignment.replicas().size() != assignment.replicas().toSet().size()) {
            throw new InvalidReplicaAssignmentException(new StringBuilder(72).append("Duplicate brokers not allowed in replica assignment: ").append(assignment.replicas().mkString(", ")).append(" for partition id ").append(partitionId).append(".").toString());
        }
        if (!assignment.replicas().toSet().subsetOf((Set)availableBrokerIds$1)) {
            throw new BrokerNotAvailableException(new StringBuilder(101).append("Some brokers specified for partition id ").append(partitionId).append(" are not available. ").append("Specified brokers: ").append(assignment.replicas().mkString(", ")).append(", ").append("available brokers: ").append(availableBrokerIds$1.mkString(", ")).append(".").toString());
        }
    }

    public static final /* synthetic */ int $anonfun$validateReplicaAssignment$2(Tuple2 x0$1) {
        if (x0$1 != null) {
            return x0$1._1$mcI$sp();
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ int $anonfun$validateReplicaAssignment$3(Tuple2 x0$2) {
        if (x0$2 != null) {
            return x0$2._1$mcI$sp();
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ int $anonfun$validateReplicaAssignment$4(Tuple2 x0$3) {
        if (x0$3 != null) {
            return x0$3._2$mcI$sp();
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ String $anonfun$changeBrokerConfig$2(int x$13) {
        return Integer.toString(x$13);
    }

    private final Seq entityPaths$1(Option rootPath, String rootEntityType$1) {
        String string;
        if (rootPath instanceof Some) {
            String path = (String)((Some)rootPath).value();
            string = new StringBuilder(11).append(rootEntityType$1).append('/').append(path).toString();
        } else if (None$.MODULE$.equals(rootPath)) {
            string = rootEntityType$1;
        } else {
            throw new MatchError((Object)rootPath);
        }
        String root = string;
        Seq<String> entityNames = this.zkClient.getAllEntitiesWithConfig(root);
        if (rootPath instanceof Some) {
            String path = (String)((Some)rootPath).value();
            return (Seq)entityNames.map((Function1 & Serializable)entityName -> new StringBuilder(11).append(path).append('/').append((String)entityName).toString());
        }
        if (None$.MODULE$.equals(rootPath)) {
            return entityNames;
        }
        throw new MatchError((Object)rootPath);
    }

    public static final /* synthetic */ void $anonfun$maybeReencryptClusterLinkConfigs$1(AdminZkClient $this, Function1 configTransformer$1, ClusterLinkData link) {
        String javaLinkId = CoreUtils$.MODULE$.toJavaUUID(link.linkId()).toString();
        $this.zkClient.transformEntityConfigs("cluster-links", javaLinkId, (Function1<Properties, Option<Properties>>)configTransformer$1);
    }

    public AdminZkClient(KafkaZkClient zkClient, Option<KafkaConfig> kafkaConfig) {
        this.zkClient = zkClient;
        this.kafkaConfig = kafkaConfig;
    }

    public static final /* synthetic */ Object $anonfun$createNewPartitionsAssignment$1$adapted(AdminZkClient $this, Seq existingAssignmentPartition0$1, Seq allBrokers$2, Map proposedReplicaAssignment) {
        $this.validateReplicaAssignment((Map<Object, ReplicaAssignment>)proposedReplicaAssignment, existingAssignmentPartition0$1.size(), (scala.collection.immutable.Set<Object>)((IterableOnceOps)allBrokers$2.map((Function1 & Serializable)x$11 -> BoxesRunTime.boxToInteger((int)x$11.id))).toSet());
        return BoxedUnit.UNIT;
    }
}

