/*
 * Decompiled with CFR 0.152.
 */
package kafka.zk.migration;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.EnumSet;
import java.util.Optional;
import java.util.Properties;
import kafka.api.LeaderAndIsr$;
import kafka.api.PartitionLinkState;
import kafka.controller.LeaderIsrAndControllerEpoch;
import kafka.controller.ReplicaAssignment;
import kafka.server.link.ClusterLinkTopicState;
import kafka.server.link.ClusterLinkTopicState$;
import kafka.utils.Logging;
import kafka.zk.ConfigEntityZNode$;
import kafka.zk.ConfluentAssignmentMigration$;
import kafka.zk.DeleteTopicsTopicZNode$;
import kafka.zk.KRaftAssignment;
import kafka.zk.KafkaZkClient;
import kafka.zk.TopicPartitionStateZNode$;
import kafka.zk.TopicPartitionZNode$;
import kafka.zk.TopicPartitionsZNode$;
import kafka.zk.TopicZNode;
import kafka.zk.TopicZNode$;
import kafka.zk.ZkMigrationClient$;
import kafka.zk.ZkVersion$;
import kafka.zookeeper.AsyncResponse;
import kafka.zookeeper.CreateRequest;
import kafka.zookeeper.DeleteRequest;
import kafka.zookeeper.DeleteResponse;
import kafka.zookeeper.GetChildrenRequest;
import kafka.zookeeper.GetChildrenResponse;
import kafka.zookeeper.SetDataRequest;
import org.apache.kafka.common.MirrorTopicError;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metadata.MirrorTopicRecord;
import org.apache.kafka.common.metadata.PartitionRecord;
import org.apache.kafka.metadata.LeaderRecoveryState;
import org.apache.kafka.metadata.MirrorTopic;
import org.apache.kafka.metadata.PartitionRegistration;
import org.apache.kafka.metadata.migration.ClusterLinkMetadata;
import org.apache.kafka.metadata.migration.MigrationClientAuthException;
import org.apache.kafka.metadata.migration.MigrationClientException;
import org.apache.kafka.metadata.migration.TopicMigrationClient;
import org.apache.kafka.metadata.migration.ZkMigrationLeadershipState;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Iterable;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\tua\u0001\u0002\u000b\u0016\u0001qA\u0001b\u000e\u0001\u0003\u0002\u0003\u0006I\u0001\u000f\u0005\u0006y\u0001!\t!\u0010\u0005\u0006\u0003\u0002!\tE\u0011\u0005\u0006W\u0002!\t\u0005\u001c\u0005\u0007W\u0002!\t%!\r\t\u000f\u0005m\u0002\u0001\"\u0003\u0002>!9\u00111\r\u0001\u0005\n\u0005\u0015\u0004bBA2\u0001\u0011%\u0011q\u0010\u0005\b\u0003\u000b\u0003A\u0011IAD\u0011\u001d\t\u0019\n\u0001C!\u0003+Cq!a'\u0001\t\u0003\ni\nC\u0004\u0002(\u0002!\t%!+\t\u000f\u0005=\u0006\u0001\"\u0011\u00022\"9\u0011q\u0018\u0001\u0005\n\u0005\u0005\u0007bBAg\u0001\u0011%\u0011q\u001a\u0005\b\u0003g\u0004A\u0011BA{\u0011\u001d\ti\u0010\u0001C\u0005\u0003\u007fDqA!\u0004\u0001\t\u0003\u0012y\u0001C\u0004\u0003\u0014\u0001!\tE!\u0006\u0003-i[Gk\u001c9jG6KwM]1uS>t7\t\\5f]RT!AF\f\u0002\u00135LwM]1uS>t'B\u0001\r\u001a\u0003\tQ8NC\u0001\u001b\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019B\u0001A\u000f&cA\u0011adI\u0007\u0002?)\u0011\u0001%I\u0001\u0005Y\u0006twMC\u0001#\u0003\u0011Q\u0017M^1\n\u0005\u0011z\"AB(cU\u0016\u001cG\u000f\u0005\u0002'_5\tqE\u0003\u0002\u0017Q)\u0011\u0011FK\u0001\t[\u0016$\u0018\rZ1uC*\u0011!d\u000b\u0006\u0003Y5\na!\u00199bG\",'\"\u0001\u0018\u0002\u0007=\u0014x-\u0003\u00021O\t!Bk\u001c9jG6KwM]1uS>t7\t\\5f]R\u0004\"AM\u001b\u000e\u0003MR!\u0001N\r\u0002\u000bU$\u0018\u000e\\:\n\u0005Y\u001a$a\u0002'pO\u001eLgnZ\u0001\tu.\u001cE.[3oiB\u0011\u0011HO\u0007\u0002/%\u00111h\u0006\u0002\u000e\u0017\u000647.\u0019.l\u00072LWM\u001c;\u0002\rqJg.\u001b;?)\tq\u0004\t\u0005\u0002@\u00015\tQ\u0003C\u00038\u0005\u0001\u0007\u0001(A\u0007ji\u0016\u0014\u0018\r^3U_BL7m\u001d\u000b\u0004\u0007&+\u0007C\u0001#H\u001b\u0005)%\"\u0001$\u0002\u000bM\u001c\u0017\r\\1\n\u0005!+%\u0001B+oSRDQAS\u0002A\u0002-\u000b\u0011\"\u001b8uKJ,7\u000f^:\u0011\u00071{\u0015+D\u0001N\u0015\tq\u0015%\u0001\u0003vi&d\u0017B\u0001)N\u0005\u001d)e.^7TKR\u0004\"A\u00152\u000f\u0005M\u0003gB\u0001+`\u001d\t)fL\u0004\u0002W;:\u0011q\u000b\u0018\b\u00031nk\u0011!\u0017\u0006\u00035n\ta\u0001\u0010:p_Rt\u0014\"\u0001\u0018\n\u00051j\u0013B\u0001\u000e,\u0013\tI#&\u0003\u0002\u0017Q%\u0011\u0011mJ\u0001\u0015)>\u0004\u0018nY'jOJ\fG/[8o\u00072LWM\u001c;\n\u0005\r$'\u0001\u0006+pa&\u001cg+[:ji>\u0014\u0018J\u001c;fe\u0016\u001cHO\u0003\u0002bO!)am\u0001a\u0001O\u00069a/[:ji>\u0014\bC\u00015j\u001d\t1\u0003-\u0003\u0002kI\naAk\u001c9jGZK7/\u001b;pe\u0006Y1M]3bi\u0016$v\u000e]5d)%i\u0007O_A\u0003\u0003;\ti\u0003\u0005\u0002']&\u0011qn\n\u0002\u001b5.l\u0015n\u001a:bi&|g\u000eT3bI\u0016\u00148\u000f[5q'R\fG/\u001a\u0005\u0006c\u0012\u0001\rA]\u0001\ni>\u0004\u0018n\u0019(b[\u0016\u0004\"a]<\u000f\u0005Q,\bC\u0001-F\u0013\t1X)\u0001\u0004Qe\u0016$WMZ\u0005\u0003qf\u0014aa\u0015;sS:<'B\u0001<F\u0011\u0015YH\u00011\u0001}\u0003\u001d!x\u000e]5d\u0013\u0012\u00042!`A\u0001\u001b\u0005q(BA@+\u0003\u0019\u0019w.\\7p]&\u0019\u00111\u0001@\u0003\tU+\u0018\u000e\u001a\u0005\b\u0003\u000f!\u0001\u0019AA\u0005\u0003)\u0001\u0018M\u001d;ji&|gn\u001d\t\b\u0019\u0006-\u0011qBA\u000b\u0013\r\ti!\u0014\u0002\u0004\u001b\u0006\u0004\bc\u0001\u0010\u0002\u0012%\u0019\u00111C\u0010\u0003\u000f%sG/Z4feB!\u0011qCA\r\u001b\u0005A\u0013bAA\u000eQ\t)\u0002+\u0019:uSRLwN\u001c*fO&\u001cHO]1uS>t\u0007bBA\u0010\t\u0001\u0007\u0011\u0011E\u0001\f[&\u0014(o\u001c:U_BL7\rE\u0003M\u0003G\t9#C\u0002\u0002&5\u0013\u0001b\u00149uS>t\u0017\r\u001c\t\u0005\u0003/\tI#C\u0002\u0002,!\u00121\"T5se>\u0014Hk\u001c9jG\"1\u0011q\u0006\u0003A\u00025\fQa\u001d;bi\u0016$\u0012\"\\A\u001a\u0003k\t9$!\u000f\t\u000bE,\u0001\u0019\u0001:\t\u000bm,\u0001\u0019\u0001?\t\u000f\u0005\u001dQ\u00011\u0001\u0002\n!1\u0011qF\u0003A\u00025\f!e\u0019:fCR,Gk\u001c9jGB\u000b'\u000f^5uS>t'LT8eKN\u0014V-];fgR\u001cH\u0003CA \u0003;\ny&!\u0019\u0011\r\u0005\u0005\u00131JA)\u001d\u0011\t\u0019%a\u0012\u000f\u0007a\u000b)%C\u0001G\u0013\r\tI%R\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\ti%a\u0014\u0003\u0007M+\u0017OC\u0002\u0002J\u0015\u0003B!a\u0015\u0002Z5\u0011\u0011Q\u000b\u0006\u0004\u0003/J\u0012!\u0003>p_.,W\r]3s\u0013\u0011\tY&!\u0016\u0003\u001b\r\u0013X-\u0019;f%\u0016\fX/Z:u\u0011\u0015\th\u00011\u0001s\u0011\u001d\t9A\u0002a\u0001\u0003\u0013Aa!a\f\u0007\u0001\u0004i\u0017!\u0005:fGV\u00148/\u001b<f\u0007\"LG\u000e\u001a:f]R)1)a\u001a\u0002l!1\u0011\u0011N\u0004A\u0002I\fA\u0001]1uQ\"9\u0011QN\u0004A\u0002\u0005=\u0014aA1dGB)\u0011\u0011OA>e6\u0011\u00111\u000f\u0006\u0005\u0003k\n9(A\u0004nkR\f'\r\\3\u000b\u0007\u0005eT)\u0001\u0006d_2dWm\u0019;j_:LA!! \u0002t\tY\u0011I\u001d:bs\n+hMZ3s)\u0011\t\t)a!\u0011\u000b\u0005\u0005\u00131\n:\t\r\u0005%\u0004\u00021\u0001s\u0003-)\b\u000fZ1uKR{\u0007/[2\u0015\u00175\fI)a#\u0002\u000e\u0006=\u0015\u0011\u0013\u0005\u0006c&\u0001\rA\u001d\u0005\u0006w&\u0001\r\u0001 \u0005\b\u0003\u000fI\u0001\u0019AA\u0005\u0011\u001d\ty\"\u0003a\u0001\u0003CAa!a\f\n\u0001\u0004i\u0017a\u00033fY\u0016$X\rV8qS\u000e$R!\\AL\u00033CQ!\u001d\u0006A\u0002IDa!a\f\u000b\u0001\u0004i\u0017!F2sK\u0006$X\rV8qS\u000e\u0004\u0016M\u001d;ji&|gn\u001d\u000b\u0006[\u0006}\u0015Q\u0015\u0005\b\u0003C[\u0001\u0019AAR\u0003=!x\u000e]5d!\u0006\u0014H/\u001b;j_:\u001c\bC\u0002'\u0002\fI\fI\u0001\u0003\u0004\u00020-\u0001\r!\\\u0001\u0016kB$\u0017\r^3U_BL7\rU1si&$\u0018n\u001c8t)\u0015i\u00171VAW\u0011\u001d\t\t\u000b\u0004a\u0001\u0003GCa!a\f\r\u0001\u0004i\u0017!\u00063fY\u0016$X\rV8qS\u000e\u0004\u0016M\u001d;ji&|gn\u001d\u000b\u0006[\u0006M\u0016Q\u0018\u0005\b\u0003Ck\u0001\u0019AA[!\u0019a\u00151\u0002:\u00028B)A*!/\u0002\u0010%\u0019\u00111X'\u0003\u0007M+G\u000f\u0003\u0004\u000205\u0001\r!\\\u0001\u0015GJ,\u0017\r^3U_BL7\rU1si&$\u0018n\u001c8\u0015\t\u0005E\u00131\u0019\u0005\b\u0003\u000bt\u0001\u0019AAd\u00039!x\u000e]5d!\u0006\u0014H/\u001b;j_:\u00042!`Ae\u0013\r\tYM \u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0003e\u0001\u0018M\u001d;ji&|gn\u0015;bi\u0016\u0004\u0016\r\u001e5B]\u0012$\u0015\r^1\u0015\u0011\u0005E\u00171]As\u0003S\u0004b\u0001RAje\u0006]\u0017bAAk\u000b\n1A+\u001e9mKJ\u0002R\u0001RAm\u0003;L1!a7F\u0005\u0015\t%O]1z!\r!\u0015q\\\u0005\u0004\u0003C,%\u0001\u0002\"zi\u0016Dq!!2\u0010\u0001\u0004\t9\rC\u0004\u0002h>\u0001\r!!\u0006\u0002+A\f'\u000f^5uS>t'+Z4jgR\u0014\u0018\r^5p]\"9\u00111^\bA\u0002\u00055\u0018aD2p]R\u0014x\u000e\u001c7fe\u0016\u0003xn\u00195\u0011\u0007\u0011\u000by/C\u0002\u0002r\u0016\u00131!\u00138u\u0003e\u0019'/Z1uKR{\u0007/[2QCJ$\u0018\u000e^5p]N#\u0018\r^3\u0015\u0011\u0005E\u0013q_A}\u0003wDq!!2\u0011\u0001\u0004\t9\rC\u0004\u0002hB\u0001\r!!\u0006\t\u000f\u0005-\b\u00031\u0001\u0002n\u0006IR\u000f\u001d3bi\u0016$v\u000e]5d!\u0006\u0014H/\u001b;j_:\u001cF/\u0019;f)!\u0011\tAa\u0002\u0003\n\t-\u0001\u0003BA*\u0005\u0007IAA!\u0002\u0002V\tq1+\u001a;ECR\f'+Z9vKN$\bbBAc#\u0001\u0007\u0011q\u0019\u0005\b\u0003O\f\u0002\u0019AA\u000b\u0011\u001d\tY/\u0005a\u0001\u0003[\f\u0011D]3bIB+g\u000eZ5oOR{\u0007/[2EK2,G/[8ogR\u0011!\u0011\u0003\t\u0005\u0019\u0006e&/\u0001\u000edY\u0016\f'\u000fU3oI&tw\rV8qS\u000e$U\r\\3uS>t7\u000fF\u0003n\u0005/\u0011Y\u0002C\u0004\u0003\u001aM\u0001\rA!\u0005\u0002+A,g\u000eZ5oOR{\u0007/[2EK2,G/[8og\"1\u0011qF\nA\u00025\u0004")
public class ZkTopicMigrationClient
implements TopicMigrationClient,
Logging {
    private final KafkaZkClient zkClient;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public void iterateTopics(EnumSet<TopicMigrationClient.TopicVisitorInterest> interests, TopicMigrationClient.TopicVisitor visitor) {
        try {
            ZkTopicMigrationClient.$anonfun$iterateTopics$1(this, interests, visitor);
            return;
        }
        catch (Throwable throwable) {
            if (throwable instanceof MigrationClientException ? true : throwable instanceof MigrationClientAuthException) {
                throw throwable;
            }
            if (throwable instanceof KeeperException.AuthFailedException ? true : (throwable instanceof KeeperException.NoAuthException ? true : throwable instanceof KeeperException.SessionClosedRequireAuthException)) {
                throw new MigrationClientAuthException(throwable);
            }
            if (throwable instanceof KeeperException) {
                KeeperException keeperException = (KeeperException)throwable;
                throw new MigrationClientException((Throwable)keeperException);
            }
            throw throwable;
        }
    }

    public ZkMigrationLeadershipState createTopic(String topicName, Uuid topicId, java.util.Map<Integer, PartitionRegistration> partitions, Optional<MirrorTopic> mirrorTopic, ZkMigrationLeadershipState state) {
        try {
            return ZkTopicMigrationClient.$anonfun$createTopic$1(this, partitions, topicName, topicId, mirrorTopic, state);
        }
        catch (Throwable throwable) {
            if (throwable instanceof MigrationClientException ? true : throwable instanceof MigrationClientAuthException) {
                throw throwable;
            }
            if (throwable instanceof KeeperException.AuthFailedException ? true : (throwable instanceof KeeperException.NoAuthException ? true : throwable instanceof KeeperException.SessionClosedRequireAuthException)) {
                throw new MigrationClientAuthException(throwable);
            }
            if (throwable instanceof KeeperException) {
                KeeperException keeperException = (KeeperException)throwable;
                throw new MigrationClientException((Throwable)keeperException);
            }
            throw throwable;
        }
    }

    public ZkMigrationLeadershipState createTopic(String topicName, Uuid topicId, java.util.Map<Integer, PartitionRegistration> partitions, ZkMigrationLeadershipState state) {
        return this.createTopic(topicName, topicId, partitions, Optional.empty(), state);
    }

    private scala.collection.immutable.Seq<CreateRequest> createTopicPartitionZNodesRequests(String topicName, java.util.Map<Integer, PartitionRegistration> partitions, ZkMigrationLeadershipState state) {
        String path = TopicPartitionsZNode$.MODULE$.path(topicName);
        CreateRequest createPartitionsZNode = new CreateRequest(path, null, this.zkClient.defaultAcls(path), CreateMode.PERSISTENT, (Option<Object>)None$.MODULE$);
        scala.collection.immutable.Seq createPartitionZNodeReqs = (scala.collection.immutable.Seq)CollectionConverters$.MODULE$.MapHasAsScala(partitions).asScala().toSeq().flatMap((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                Integer partitionId = (Integer)x0$1._1();
                PartitionRegistration partition = (PartitionRegistration)x0$1._2();
                TopicPartition topicPartition = new TopicPartition(topicName, Predef$.MODULE$.Integer2int(partitionId));
                return new .colon.colon((Object)this.createTopicPartition(topicPartition), (List)new .colon.colon((Object)this.createTopicPartitionState(topicPartition, partition, state.kraftControllerEpoch()), (List)Nil$.MODULE$));
            }
            throw new MatchError(null);
        });
        return (scala.collection.immutable.Seq)new .colon.colon((Object)createPartitionsZNode, (List)Nil$.MODULE$).$plus$plus((IterableOnce)createPartitionZNodeReqs);
    }

    private void recursiveChildren(String path, ArrayBuffer<String> acc) {
        ((GetChildrenResponse)this.zkClient.retryRequestUntilConnected(new GetChildrenRequest(path, false, (Option<Object>)None$.MODULE$), this.zkClient.retryRequestUntilConnected$default$2())).children().foreach((Function1 & Serializable)child -> {
            this.recursiveChildren(new StringBuilder(1).append(path).append("/").append((String)child).toString(), acc);
            return (ArrayBuffer)acc.append((Object)new StringBuilder(1).append(path).append("/").append((String)child).toString());
        });
    }

    private scala.collection.immutable.Seq<String> recursiveChildren(String path) {
        ArrayBuffer buffer = new ArrayBuffer();
        this.recursiveChildren(path, (ArrayBuffer<String>)buffer);
        return buffer.toSeq();
    }

    public ZkMigrationLeadershipState updateTopic(String topicName, Uuid topicId, java.util.Map<Integer, PartitionRegistration> partitions, Optional<MirrorTopic> mirrorTopic, ZkMigrationLeadershipState state) {
        try {
            return ZkTopicMigrationClient.$anonfun$updateTopic$1(this, partitions, topicName, topicId, mirrorTopic, state);
        }
        catch (Throwable throwable) {
            if (throwable instanceof MigrationClientException ? true : throwable instanceof MigrationClientAuthException) {
                throw throwable;
            }
            if (throwable instanceof KeeperException.AuthFailedException ? true : (throwable instanceof KeeperException.NoAuthException ? true : throwable instanceof KeeperException.SessionClosedRequireAuthException)) {
                throw new MigrationClientAuthException(throwable);
            }
            if (throwable instanceof KeeperException) {
                KeeperException keeperException = (KeeperException)throwable;
                throw new MigrationClientException((Throwable)keeperException);
            }
            throw throwable;
        }
    }

    public ZkMigrationLeadershipState deleteTopic(String topicName, ZkMigrationLeadershipState state) {
        try {
            return ZkTopicMigrationClient.$anonfun$deleteTopic$1(this, topicName, state);
        }
        catch (Throwable throwable) {
            if (throwable instanceof MigrationClientException ? true : throwable instanceof MigrationClientAuthException) {
                throw throwable;
            }
            if (throwable instanceof KeeperException.AuthFailedException ? true : (throwable instanceof KeeperException.NoAuthException ? true : throwable instanceof KeeperException.SessionClosedRequireAuthException)) {
                throw new MigrationClientAuthException(throwable);
            }
            if (throwable instanceof KeeperException) {
                KeeperException keeperException = (KeeperException)throwable;
                throw new MigrationClientException((Throwable)keeperException);
            }
            throw throwable;
        }
    }

    public ZkMigrationLeadershipState createTopicPartitions(java.util.Map<String, java.util.Map<Integer, PartitionRegistration>> topicPartitions, ZkMigrationLeadershipState state) {
        try {
            return ZkTopicMigrationClient.$anonfun$createTopicPartitions$1(this, topicPartitions, state);
        }
        catch (Throwable throwable) {
            if (throwable instanceof MigrationClientException ? true : throwable instanceof MigrationClientAuthException) {
                throw throwable;
            }
            if (throwable instanceof KeeperException.AuthFailedException ? true : (throwable instanceof KeeperException.NoAuthException ? true : throwable instanceof KeeperException.SessionClosedRequireAuthException)) {
                throw new MigrationClientAuthException(throwable);
            }
            if (throwable instanceof KeeperException) {
                KeeperException keeperException = (KeeperException)throwable;
                throw new MigrationClientException((Throwable)keeperException);
            }
            throw throwable;
        }
    }

    public ZkMigrationLeadershipState updateTopicPartitions(java.util.Map<String, java.util.Map<Integer, PartitionRegistration>> topicPartitions, ZkMigrationLeadershipState state) {
        try {
            return ZkTopicMigrationClient.$anonfun$updateTopicPartitions$1(this, topicPartitions, state);
        }
        catch (Throwable throwable) {
            if (throwable instanceof MigrationClientException ? true : throwable instanceof MigrationClientAuthException) {
                throw throwable;
            }
            if (throwable instanceof KeeperException.AuthFailedException ? true : (throwable instanceof KeeperException.NoAuthException ? true : throwable instanceof KeeperException.SessionClosedRequireAuthException)) {
                throw new MigrationClientAuthException(throwable);
            }
            if (throwable instanceof KeeperException) {
                KeeperException keeperException = (KeeperException)throwable;
                throw new MigrationClientException((Throwable)keeperException);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public ZkMigrationLeadershipState deleteTopicPartitions(java.util.Map<String, java.util.Set<Integer>> topicPartitions, ZkMigrationLeadershipState state) {
        void var6_6;
        Iterable requests = (Iterable)CollectionConverters$.MODULE$.MapHasAsScala(topicPartitions).asScala().flatMap((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                String topicName = (String)x0$1._1();
                java.util.Set partitionIds = (java.util.Set)x0$1._2();
                return (scala.collection.mutable.Set)CollectionConverters$.MODULE$.SetHasAsScala(partitionIds).asScala().map((Function1 & Serializable)partitionId -> {
                    TopicPartition topicPartition = new TopicPartition(topicName, Predef$.MODULE$.Integer2int(partitionId));
                    String path = TopicPartitionZNode$.MODULE$.path(topicPartition);
                    return new DeleteRequest(path, ZkVersion$.MODULE$.MatchAnyVersion(), (Option<Object>)None$.MODULE$);
                });
            }
            throw new MatchError(null);
        });
        if (requests.isEmpty()) {
            return state;
        }
        Tuple2<Object, Seq<AsyncResponse>> tuple2 = this.zkClient.retryMigrationRequestsUntilConnected(requests.toSeq(), state);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        int migrationZkVersion = tuple2._1$mcI$sp();
        Seq responses = (Seq)tuple2._2();
        scala.collection.immutable.Map resultCodes = ((IterableOnceOps)var6_6.map((Function1 & Serializable)response -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)response.path()), (Object)response.resultCode()))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        if (resultCodes.forall((Function1 & Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)ZkTopicMigrationClient.$anonfun$deleteTopicPartitions$4(x0$2)))) {
            void var5_5;
            return state.withMigrationZkVersion((int)var5_5);
        }
        throw new MigrationClientException(new StringBuilder(64).append("Failed to delete partition states: ").append(topicPartitions).append(". ZK transaction had results ").append(resultCodes).toString());
    }

    private CreateRequest createTopicPartition(TopicPartition topicPartition) {
        try {
            return ZkTopicMigrationClient.$anonfun$createTopicPartition$1(this, topicPartition);
        }
        catch (Throwable throwable) {
            if (throwable instanceof MigrationClientException ? true : throwable instanceof MigrationClientAuthException) {
                throw throwable;
            }
            if (throwable instanceof KeeperException.AuthFailedException ? true : (throwable instanceof KeeperException.NoAuthException ? true : throwable instanceof KeeperException.SessionClosedRequireAuthException)) {
                throw new MigrationClientAuthException(throwable);
            }
            if (throwable instanceof KeeperException) {
                KeeperException keeperException = (KeeperException)throwable;
                throw new MigrationClientException((Throwable)keeperException);
            }
            throw throwable;
        }
    }

    private Tuple2<String, byte[]> partitionStatePathAndData(TopicPartition topicPartition, PartitionRegistration partitionRegistration, int controllerEpoch) {
        None$ none$;
        String path = TopicPartitionStateZNode$.MODULE$.path(topicPartition);
        PartitionRegistration.LinkState linkState = partitionRegistration.linkState;
        if (PartitionRegistration.LinkState.NOT_MIRROR.equals(linkState)) {
            none$ = None$.MODULE$;
        } else {
            boolean topicFailed = linkState.equals((Object)PartitionRegistration.LinkState.FAILED);
            MirrorTopicError error = topicFailed ? MirrorTopicError.UNKNOWN : MirrorTopicError.NO_ERROR;
            none$ = new Some((Object)new PartitionLinkState(partitionRegistration.linkedLeaderEpoch, topicFailed, error));
        }
        None$ linkState2 = none$;
        byte[] data = TopicPartitionStateZNode$.MODULE$.encode(new LeaderIsrAndControllerEpoch(LeaderAndIsr$.MODULE$.apply(partitionRegistration.leader, partitionRegistration.leaderEpoch, (List<Object>)Predef$.MODULE$.wrapIntArray(partitionRegistration.isr).toList(), partitionRegistration.leaderRecoveryState, partitionRegistration.partitionEpoch, (Option<PartitionLinkState>)linkState2), controllerEpoch));
        return new Tuple2((Object)path, (Object)data);
    }

    /*
     * WARNING - void declaration
     */
    private CreateRequest createTopicPartitionState(TopicPartition topicPartition, PartitionRegistration partitionRegistration, int controllerEpoch) {
        void var6_6;
        void var5_5;
        Tuple2<String, byte[]> tuple2 = this.partitionStatePathAndData(topicPartition, partitionRegistration, controllerEpoch);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        String path = (String)tuple2._1();
        byte[] data = (byte[])tuple2._2();
        return new CreateRequest((String)var5_5, (byte[])var6_6, this.zkClient.defaultAcls((String)var5_5), CreateMode.PERSISTENT, (Option<Object>)new Some((Object)topicPartition));
    }

    /*
     * WARNING - void declaration
     */
    private SetDataRequest updateTopicPartitionState(TopicPartition topicPartition, PartitionRegistration partitionRegistration, int controllerEpoch) {
        void var6_6;
        void var5_5;
        Tuple2<String, byte[]> tuple2 = this.partitionStatePathAndData(topicPartition, partitionRegistration, controllerEpoch);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        String path = (String)tuple2._1();
        byte[] data = (byte[])tuple2._2();
        return new SetDataRequest((String)var5_5, (byte[])var6_6, ZkVersion$.MODULE$.MatchAnyVersion(), (Option<Object>)new Some((Object)topicPartition));
    }

    public java.util.Set<String> readPendingTopicDeletions() {
        return CollectionConverters$.MODULE$.SetHasAsJava((Set)this.zkClient.getTopicDeletions().toSet()).asJava();
    }

    /*
     * WARNING - void declaration
     */
    public ZkMigrationLeadershipState clearPendingTopicDeletions(java.util.Set<String> pendingTopicDeletions, ZkMigrationLeadershipState state) {
        void var6_6;
        scala.collection.immutable.Seq deleteRequests = ((IterableOnceOps)CollectionConverters$.MODULE$.SetHasAsScala(pendingTopicDeletions).asScala().map((Function1 & Serializable)topicName -> new DeleteRequest(DeleteTopicsTopicZNode$.MODULE$.path((String)topicName), ZkVersion$.MODULE$.MatchAnyVersion(), (Option<Object>)None$.MODULE$))).toSeq();
        Tuple2<Object, Seq<AsyncResponse>> tuple2 = this.zkClient.retryMigrationRequestsUntilConnected(deleteRequests, state);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        int migrationZkVersion = tuple2._1$mcI$sp();
        Seq responses = (Seq)tuple2._2();
        scala.collection.immutable.Map resultCodes = ((IterableOnceOps)var6_6.map((Function1 & Serializable)response -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)response.path()), (Object)response.resultCode()))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        if (resultCodes.forall((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ZkTopicMigrationClient.$anonfun$clearPendingTopicDeletions$3(x0$1)))) {
            void var5_5;
            return state.withMigrationZkVersion((int)var5_5);
        }
        throw new MigrationClientException(new StringBuilder(71).append("Failed to delete pending topic deletions: ").append(pendingTopicDeletions).append(". ZK transaction had results ").append(resultCodes).toString());
    }

    public static final /* synthetic */ void $anonfun$iterateTopics$3(ZkTopicMigrationClient $this, String deletion) {
        if ($this.logger().underlying().isInfoEnabled()) {
            $this.logger().underlying().info("Not migrating pending deleted topic: {}", (Object)deletion);
        }
    }

    public static final /* synthetic */ void $anonfun$iterateTopics$9(ZkTopicMigrationClient $this, Option topicIdOpt$1, Map leaderIsrAndControllerEpochs$1, TopicMigrationClient.TopicVisitor visitor$1, Tuple2 x0$3) {
        if (x0$3 != null) {
            TopicPartition topicPartition = (TopicPartition)x0$3._1();
            ReplicaAssignment replicaAssignment = (ReplicaAssignment)x0$3._2();
            KRaftAssignment kraftAssignment = ConfluentAssignmentMigration$.MODULE$.fromZkToKRaftAssignment(replicaAssignment);
            java.util.List replicaList = CollectionConverters$.MODULE$.SeqHasAsJava(kraftAssignment.replicas()).asJava();
            PartitionRecord record = new PartitionRecord().setTopicId((Uuid)topicIdOpt$1.get()).setPartitionId(topicPartition.partition()).setReplicas(CollectionConverters$.MODULE$.SeqHasAsJava(kraftAssignment.replicas()).asJava()).setObservers(CollectionConverters$.MODULE$.SeqHasAsJava(kraftAssignment.observers()).asJava()).setAddingReplicas(CollectionConverters$.MODULE$.SeqHasAsJava(kraftAssignment.addingReplicas()).asJava()).setRemovingReplicas(CollectionConverters$.MODULE$.SeqHasAsJava(kraftAssignment.removingReplicas()).asJava()).setAddingObservers(CollectionConverters$.MODULE$.SeqHasAsJava(kraftAssignment.addingObservers()).asJava()).setRemovingObservers(CollectionConverters$.MODULE$.SeqHasAsJava(kraftAssignment.removingObservers()).asJava());
            Option option = leaderIsrAndControllerEpochs$1.get((Object)topicPartition);
            if (option instanceof Some) {
                LeaderIsrAndControllerEpoch leaderIsrAndEpoch = (LeaderIsrAndControllerEpoch)((Some)option).value();
                record.setIsr(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)leaderIsrAndEpoch.leaderAndIsr().isr().map((Function1 & Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1))).asJava()).setLeader(leaderIsrAndEpoch.leaderAndIsr().leader()).setLeaderEpoch(leaderIsrAndEpoch.leaderAndIsr().leaderEpoch()).setPartitionEpoch(leaderIsrAndEpoch.leaderAndIsr().partitionEpoch()).setLeaderRecoveryState(leaderIsrAndEpoch.leaderAndIsr().leaderRecoveryState().value());
                leaderIsrAndEpoch.leaderAndIsr().clusterLinkState().foreach((Function1 & Serializable)state -> record.setLinkedLeaderEpoch(state.linkedLeaderEpoch()).setLinkState((state.linkFailed() ? PartitionRegistration.LinkState.FAILED : PartitionRegistration.LinkState.ACTIVE).levelCode));
            } else if (None$.MODULE$.equals(option)) {
                $this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(101).append("Could not find partition state in ZK for ").append(topicPartition).append(". Initializing this partition ").append("with ISR={").append(replicaList).append("} and leaderEpoch=0.").toString());
                record.setIsr(replicaList).setLeader(Predef$.MODULE$.Integer2int((Integer)replicaList.get(0))).setLeaderEpoch(0).setPartitionEpoch(0).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED.value());
            } else {
                throw new MatchError((Object)option);
            }
            String logAndRethrow_msg = new StringBuilder(49).append("Error in partition consumer. TopicPartition was ").append(topicPartition).append(".").toString();
            try {
                visitor$1.visitPartition(new TopicIdPartition((Uuid)topicIdOpt$1.get(), topicPartition), new PartitionRegistration(record));
                return;
            }
            catch (Throwable logAndRethrow_e) {
                $this.error((Function0<String>)((Function0 & Serializable)() -> ZkMigrationClient$.$anonfun$logAndRethrow$1(logAndRethrow_msg)), (Function0<Throwable>)((Function0 & Serializable)() -> ZkMigrationClient$.$anonfun$logAndRethrow$2(logAndRethrow_e)));
                throw logAndRethrow_e;
            }
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$iterateTopics$4(ZkTopicMigrationClient $this, EnumSet interests$1, TopicMigrationClient.TopicVisitor visitor$1, TopicZNode.TopicIdReplicaAssignment x0$1) {
        if (x0$1 != null) {
            String topic = x0$1.topic();
            Option<Uuid> topicIdOpt = x0$1.topicId();
            Option<Uuid> legacyTopicIdOpt = x0$1.legacyTopicId();
            Map<TopicPartition, ReplicaAssignment> partitionAssignments = x0$1.assignment();
            Option<ClusterLinkTopicState> clusterLinkOpt = x0$1.clusterLink();
            if (legacyTopicIdOpt.isDefined()) {
                throw new RuntimeException("Cannot migrate legacy Confluent topic IDs. These should have been migrated to normal topic IDs already.");
            }
            Option mirrorTopic = interests$1.contains(TopicMigrationClient.TopicVisitorInterest.MIRROR_STATE) ? clusterLinkOpt.map((Function1 & Serializable)state -> {
                ClusterLinkMetadata linkMetadata = visitor$1.resolveClusterLink(state.linkId());
                if (linkMetadata == null) {
                    throw new RuntimeException(new StringBuilder(44).append("Unable to resolve the link ").append(state.linkName()).append(" of mirror topic ").append(topic).toString());
                }
                return MirrorTopic.fromRecord((MirrorTopicRecord)state.toMirrorTopicRecord(topic, (Uuid)topicIdOpt.get(), (Option<String>)OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(linkMetadata.linkPrefix())), (Option<String>)OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(linkMetadata.tenantPrefix()))));
            }) : Option$.MODULE$.empty();
            java.util.Map topicAssignment = CollectionConverters$.MODULE$.MapHasAsJava((Map)partitionAssignments.map((Function1 & Serializable)x0$2 -> {
                if (x0$2 != null) {
                    TopicPartition partition = (TopicPartition)x0$2._1();
                    ReplicaAssignment assignment = (ReplicaAssignment)x0$2._2();
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)partition.partition())), (Object)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)assignment.replicas().map((Function1 & Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1))).asJava());
                }
                throw new MatchError(null);
            }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())).asJava();
            String logAndRethrow_msg = new StringBuilder(36).append("Error in topic consumer. Topic was ").append(topic).append(".").toString();
            try {
                visitor$1.visitTopic(topic, (Uuid)topicIdOpt.get(), topicAssignment, OptionConverters.RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8(mirrorTopic)));
            }
            catch (Throwable logAndRethrow_e) {
                $this.error((Function0<String>)((Function0 & Serializable)() -> ZkMigrationClient$.$anonfun$logAndRethrow$1(logAndRethrow_msg)), (Function0<Throwable>)((Function0 & Serializable)() -> ZkMigrationClient$.$anonfun$logAndRethrow$2(logAndRethrow_e)));
                throw logAndRethrow_e;
            }
            Object var13_11 = null;
            if (interests$1.contains(TopicMigrationClient.TopicVisitorInterest.PARTITIONS)) {
                scala.collection.immutable.Seq partitions = partitionAssignments.keys().toSeq();
                Map<TopicPartition, LeaderIsrAndControllerEpoch> leaderIsrAndControllerEpochs = $this.zkClient.getTopicPartitionStates((Seq<TopicPartition>)partitions);
                partitionAssignments.foreach((Function1 & Serializable)x0$3 -> {
                    ZkTopicMigrationClient.$anonfun$iterateTopics$9($this, topicIdOpt, leaderIsrAndControllerEpochs, visitor$1, x0$3);
                    return BoxedUnit.UNIT;
                });
                return;
            }
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$iterateTopics$1(ZkTopicMigrationClient $this, EnumSet interests$1, TopicMigrationClient.TopicVisitor visitor$1) {
        if (!interests$1.contains(TopicMigrationClient.TopicVisitorInterest.TOPICS)) {
            throw new IllegalArgumentException("Must specify at least TOPICS in topic visitor interests.");
        }
        scala.collection.immutable.Set<String> allTopics = $this.zkClient.getAllTopicsInCluster($this.zkClient.getAllTopicsInCluster$default$1());
        scala.collection.mutable.Set topicDeletions = CollectionConverters$.MODULE$.SetHasAsScala($this.readPendingTopicDeletions()).asScala();
        scala.collection.immutable.Set topicsToMigrated = (scala.collection.immutable.Set)allTopics.$minus$minus((IterableOnce)topicDeletions);
        if (topicDeletions.nonEmpty()) {
            $this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(163).append("Found ").append(topicDeletions.size()).append(" pending topic deletions. These will be not migrated ").append("to KRaft. After the migration, the brokers will reconcile their logs with these pending topic deletions.").toString());
        }
        topicDeletions.foreach((Function1 & Serializable)deletion -> {
            ZkTopicMigrationClient.$anonfun$iterateTopics$3($this, deletion);
            return BoxedUnit.UNIT;
        });
        $this.zkClient.getReplicaAssignmentAndTopicIdForTopics((scala.collection.immutable.Set<String>)topicsToMigrated).foreach((Function1 & Serializable)x0$1 -> {
            ZkTopicMigrationClient.$anonfun$iterateTopics$4($this, interests$1, visitor$1, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$createTopic$5(Tuple2 x0$2) {
        if (x0$2 != null) {
            return ((KeeperException.Code)x0$2._2()).equals((Object)KeeperException.Code.OK);
        }
        throw new MatchError(null);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ ZkMigrationLeadershipState $anonfun$createTopic$1(ZkTopicMigrationClient $this, java.util.Map partitions$1, String topicName$1, Uuid topicId$1, Optional mirrorTopic$2, ZkMigrationLeadershipState state$1) {
        void var15_15;
        scala.collection.immutable.Seq<CreateRequest> createPartitionZNodeReqs;
        scala.collection.mutable.Map assignments = (scala.collection.mutable.Map)CollectionConverters$.MODULE$.MapHasAsScala(partitions$1).asScala().map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                Integer partitionId = (Integer)x0$1._1();
                PartitionRegistration partition = (PartitionRegistration)x0$1._2();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(topicName$1, Predef$.MODULE$.Integer2int(partitionId))), (Object)ConfluentAssignmentMigration$.MODULE$.fromKRaftToZkAssignment(partition));
            }
            throw new MatchError(null);
        });
        String path = TopicZNode$.MODULE$.path(topicName$1);
        CreateRequest createTopicZNode = new CreateRequest(path, TopicZNode$.MODULE$.encode((Option<Uuid>)new Some((Object)topicId$1), (Option<Uuid>)None$.MODULE$, (Map<TopicPartition, ReplicaAssignment>)assignments, (Option<ClusterLinkTopicState>)OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(mirrorTopic$2)).map((Function1 & Serializable)x$1 -> ClusterLinkTopicState$.MODULE$.apply((MirrorTopic)x$1))), $this.zkClient.defaultAcls(path), CreateMode.PERSISTENT, (Option<Object>)None$.MODULE$);
        String path2 = ConfigEntityZNode$.MODULE$.path("topics", topicName$1);
        CreateRequest topicConfigZNode = new CreateRequest(path2, ConfigEntityZNode$.MODULE$.encode(new Properties()), $this.zkClient.defaultAcls(path2), CreateMode.PERSISTENT, (Option<Object>)None$.MODULE$);
        scala.collection.immutable.Seq requests = (scala.collection.immutable.Seq)new .colon.colon((Object)createTopicZNode, (List)new .colon.colon((Object)topicConfigZNode, (List)Nil$.MODULE$)).$plus$plus(createPartitionZNodeReqs = $this.createTopicPartitionZNodesRequests(topicName$1, partitions$1, state$1));
        Tuple2<Object, Seq<AsyncResponse>> tuple2 = $this.zkClient.retryMigrationRequestsUntilConnected(requests, state$1);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        int migrationZkVersion = tuple2._1$mcI$sp();
        Seq responses = (Seq)tuple2._2();
        scala.collection.immutable.Map resultCodes = ((IterableOnceOps)var15_15.map((Function1 & Serializable)response -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)response.path()), (Object)response.resultCode()))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        if (((Enum)resultCodes.apply((Object)TopicZNode$.MODULE$.path(topicName$1))).equals(KeeperException.Code.NODEEXISTS)) {
            return state$1;
        }
        if (resultCodes.forall((Function1 & Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)ZkTopicMigrationClient.$anonfun$createTopic$5(x0$2)))) {
            void var14_14;
            return state$1.withMigrationZkVersion((int)var14_14);
        }
        throw new MigrationClientException(new StringBuilder(61).append("Failed to create or update topic ").append(topicName$1).append(". ZK operations had results ").append(resultCodes).toString());
    }

    public static final /* synthetic */ boolean $anonfun$updateTopic$5(Tuple2 x0$2) {
        if (x0$2 != null) {
            return ((KeeperException.Code)x0$2._2()).equals((Object)KeeperException.Code.OK);
        }
        throw new MatchError(null);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ ZkMigrationLeadershipState $anonfun$updateTopic$1(ZkTopicMigrationClient $this, java.util.Map partitions$2, String topicName$3, Uuid topicId$2, Optional mirrorTopic$3, ZkMigrationLeadershipState state$3) {
        void var10_10;
        scala.collection.mutable.Map assignments = (scala.collection.mutable.Map)CollectionConverters$.MODULE$.MapHasAsScala(partitions$2).asScala().map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                Integer partitionId = (Integer)x0$1._1();
                PartitionRegistration partition = (PartitionRegistration)x0$1._2();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(topicName$3, Predef$.MODULE$.Integer2int(partitionId))), (Object)new ReplicaAssignment((Seq<Object>)Predef$.MODULE$.wrapIntArray(partition.replicas), (Seq<Object>)Predef$.MODULE$.wrapIntArray(partition.addingReplicas), (Seq<Object>)Predef$.MODULE$.wrapIntArray(partition.removingReplicas), (Seq<Object>)((Seq)package$.MODULE$.Seq().empty()), (Option<Seq<Object>>)None$.MODULE$));
            }
            throw new MatchError(null);
        });
        SetDataRequest request = new SetDataRequest(TopicZNode$.MODULE$.path(topicName$3), TopicZNode$.MODULE$.encode((Option<Uuid>)new Some((Object)topicId$2), (Option<Uuid>)None$.MODULE$, (Map<TopicPartition, ReplicaAssignment>)assignments, (Option<ClusterLinkTopicState>)OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(mirrorTopic$3)).map((Function1 & Serializable)x$3 -> ClusterLinkTopicState$.MODULE$.apply((MirrorTopic)x$3))), ZkVersion$.MODULE$.MatchAnyVersion(), (Option<Object>)None$.MODULE$);
        Tuple2<Object, Seq<AsyncResponse>> tuple2 = $this.zkClient.retryMigrationRequestsUntilConnected(new .colon.colon((Object)request, (List)Nil$.MODULE$), state$3);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        int migrationZkVersion = tuple2._1$mcI$sp();
        Seq responses = (Seq)tuple2._2();
        scala.collection.immutable.Map resultCodes = ((IterableOnceOps)var10_10.map((Function1 & Serializable)response -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)response.path()), (Object)response.resultCode()))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        if (resultCodes.forall((Function1 & Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)ZkTopicMigrationClient.$anonfun$updateTopic$5(x0$2)))) {
            void var9_9;
            return state$3.withMigrationZkVersion((int)var9_9);
        }
        throw new MigrationClientException(new StringBuilder(62).append("Failed to update topic metadata: ").append(topicName$3).append(". ZK transaction had results ").append(resultCodes).toString());
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ ZkMigrationLeadershipState $anonfun$deleteTopic$1(ZkTopicMigrationClient $this, String topicName$4, ZkMigrationLeadershipState state$4) {
        void var7_7;
        String topicPath = TopicZNode$.MODULE$.path(topicName$4);
        scala.collection.immutable.Seq deleteRequests = (scala.collection.immutable.Seq)((IterableOps)$this.recursiveChildren(topicPath).map((Function1 & Serializable)childPath -> new DeleteRequest((String)childPath, ZkVersion$.MODULE$.MatchAnyVersion(), (Option<Object>)None$.MODULE$))).$plus$plus((IterableOnce)new .colon.colon((Object)new DeleteRequest(ConfigEntityZNode$.MODULE$.path("topics", topicName$4), ZkVersion$.MODULE$.MatchAnyVersion(), (Option<Object>)None$.MODULE$), (List)new .colon.colon((Object)new DeleteRequest(TopicZNode$.MODULE$.path(topicName$4), ZkVersion$.MODULE$.MatchAnyVersion(), (Option<Object>)None$.MODULE$), (List)Nil$.MODULE$)));
        Tuple2<Object, Seq<AsyncResponse>> tuple2 = $this.zkClient.retryMigrationRequestsUntilConnected(deleteRequests, state$4);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        int migrationZkVersion = tuple2._1$mcI$sp();
        Seq responses = (Seq)tuple2._2();
        scala.collection.immutable.Map resultCodes = ((IterableOnceOps)var7_7.map((Function1 & Serializable)response -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)response.path()), (Object)response.resultCode()))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        if (((DeleteResponse)var7_7.last()).resultCode().equals((Object)KeeperException.Code.OK)) {
            void var6_6;
            return state$4.withMigrationZkVersion((int)var6_6);
        }
        throw new MigrationClientException(new StringBuilder(51).append("Failed to delete topic ").append(topicName$4).append(". ZK operations had results ").append(resultCodes).toString());
    }

    public static final /* synthetic */ boolean $anonfun$createTopicPartitions$4(Tuple2 x0$2) {
        if (x0$2 != null) {
            KeeperException.Code code = (KeeperException.Code)x0$2._2();
            return code.equals((Object)KeeperException.Code.OK) || code.equals((Object)KeeperException.Code.NODEEXISTS);
        }
        throw new MatchError(null);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ ZkMigrationLeadershipState $anonfun$createTopicPartitions$1(ZkTopicMigrationClient $this, java.util.Map topicPartitions$1, ZkMigrationLeadershipState state$5) {
        void var6_6;
        scala.collection.immutable.Seq requests = (scala.collection.immutable.Seq)CollectionConverters$.MODULE$.MapHasAsScala(topicPartitions$1).asScala().toSeq().flatMap((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                String topicName = (String)x0$1._1();
                java.util.Map partitions = (java.util.Map)x0$1._2();
                return $this.createTopicPartitionZNodesRequests(topicName, partitions, state$5);
            }
            throw new MatchError(null);
        });
        Tuple2<Object, Seq<AsyncResponse>> tuple2 = $this.zkClient.retryMigrationRequestsUntilConnected(requests, state$5);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        int migrationZkVersion = tuple2._1$mcI$sp();
        Seq responses = (Seq)tuple2._2();
        scala.collection.immutable.Map resultCodes = ((IterableOnceOps)var6_6.map((Function1 & Serializable)response -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)response.path()), (Object)response.resultCode()))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        if (resultCodes.forall((Function1 & Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)ZkTopicMigrationClient.$anonfun$createTopicPartitions$4(x0$2)))) {
            void var5_5;
            return state$5.withMigrationZkVersion((int)var5_5);
        }
        throw new MigrationClientException(new StringBuilder(64).append("Failed to create partition states: ").append(topicPartitions$1).append(". ZK transaction had results ").append(resultCodes).toString());
    }

    public static final /* synthetic */ boolean $anonfun$updateTopicPartitions$5(Tuple2 x0$3) {
        if (x0$3 != null) {
            return ((KeeperException.Code)x0$3._2()).equals((Object)KeeperException.Code.OK);
        }
        throw new MatchError(null);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ ZkMigrationLeadershipState $anonfun$updateTopicPartitions$1(ZkTopicMigrationClient $this, java.util.Map topicPartitions$2, ZkMigrationLeadershipState state$6) {
        void var6_6;
        Iterable requests = (Iterable)CollectionConverters$.MODULE$.MapHasAsScala(topicPartitions$2).asScala().flatMap((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                String topicName = (String)x0$1._1();
                java.util.Map partitionRegistrations = (java.util.Map)x0$1._2();
                return (Iterable)CollectionConverters$.MODULE$.MapHasAsScala(partitionRegistrations).asScala().flatMap((Function1 & Serializable)x0$2 -> {
                    if (x0$2 != null) {
                        Integer partitionId = (Integer)x0$2._1();
                        PartitionRegistration partitionRegistration = (PartitionRegistration)x0$2._2();
                        TopicPartition topicPartition = new TopicPartition(topicName, Predef$.MODULE$.Integer2int(partitionId));
                        return new .colon.colon((Object)$this.updateTopicPartitionState(topicPartition, partitionRegistration, state$6.kraftControllerEpoch()), (List)Nil$.MODULE$);
                    }
                    throw new MatchError(null);
                });
            }
            throw new MatchError(null);
        });
        if (requests.isEmpty()) {
            return state$6;
        }
        Tuple2<Object, Seq<AsyncResponse>> tuple2 = $this.zkClient.retryMigrationRequestsUntilConnected(requests.toSeq(), state$6);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        int migrationZkVersion = tuple2._1$mcI$sp();
        Seq responses = (Seq)tuple2._2();
        scala.collection.immutable.Map resultCodes = ((IterableOnceOps)var6_6.map((Function1 & Serializable)response -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)response.path()), (Object)response.resultCode()))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        if (resultCodes.forall((Function1 & Serializable)x0$3 -> BoxesRunTime.boxToBoolean((boolean)ZkTopicMigrationClient.$anonfun$updateTopicPartitions$5(x0$3)))) {
            void var5_5;
            return state$6.withMigrationZkVersion((int)var5_5);
        }
        throw new MigrationClientException(new StringBuilder(64).append("Failed to update partition states: ").append(topicPartitions$2).append(". ZK transaction had results ").append(resultCodes).toString());
    }

    public static final /* synthetic */ boolean $anonfun$deleteTopicPartitions$4(Tuple2 x0$2) {
        if (x0$2 != null) {
            return ((KeeperException.Code)x0$2._2()).equals((Object)KeeperException.Code.OK);
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ CreateRequest $anonfun$createTopicPartition$1(ZkTopicMigrationClient $this, TopicPartition topicPartition$2) {
        String path = TopicPartitionZNode$.MODULE$.path(topicPartition$2);
        return new CreateRequest(path, null, $this.zkClient.defaultAcls(path), CreateMode.PERSISTENT, (Option<Object>)new Some((Object)topicPartition$2));
    }

    public static final /* synthetic */ boolean $anonfun$clearPendingTopicDeletions$3(Tuple2 x0$1) {
        if (x0$1 != null) {
            return ((KeeperException.Code)x0$1._2()).equals((Object)KeeperException.Code.OK);
        }
        throw new MatchError(null);
    }

    public ZkTopicMigrationClient(KafkaZkClient zkClient) {
        this.zkClient = zkClient;
    }
}

