/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.flink.apiserver.client;

import com.google.gson.reflect.TypeToken;
import io.confluent.flink.apiserver.client.ApiCallback;
import io.confluent.flink.apiserver.client.ApiClient;
import io.confluent.flink.apiserver.client.ApiException;
import io.confluent.flink.apiserver.client.ApiResponse;
import io.confluent.flink.apiserver.client.Configuration;
import io.confluent.flink.apiserver.client.Pair;
import io.confluent.flink.apiserver.client.model.NetworkV1alphaLogicalClusterSNIIngress;
import io.confluent.flink.apiserver.client.model.NetworkV1alphaLogicalClusterSNIIngressList;
import io.confluent.flink.apiserver.client.model.NetworkV1alphaNetworkDestination;
import io.confluent.flink.apiserver.client.model.NetworkV1alphaNetworkDestinationList;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;

public class NetworkV1alphaApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public NetworkV1alphaApi() {
        this(Configuration.getDefaultApiClient());
    }

    public NetworkV1alphaApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call createNetworkV1alphaLogicalClusterSNIIngressCall(String environment, String org, NetworkV1alphaLogicalClusterSNIIngress networkV1alphaLogicalClusterSNIIngress, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        NetworkV1alphaLogicalClusterSNIIngress localVarPostBody = networkV1alphaLogicalClusterSNIIngress;
        String localVarPath = "/apis/network/v1alpha/orgs/{org}/environments/{environment}/logicalclustersniingresses".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createNetworkV1alphaLogicalClusterSNIIngressValidateBeforeCall(String environment, String org, NetworkV1alphaLogicalClusterSNIIngress networkV1alphaLogicalClusterSNIIngress, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling createNetworkV1alphaLogicalClusterSNIIngress(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling createNetworkV1alphaLogicalClusterSNIIngress(Async)");
        }
        if (networkV1alphaLogicalClusterSNIIngress == null) {
            throw new ApiException("Missing the required parameter 'networkV1alphaLogicalClusterSNIIngress' when calling createNetworkV1alphaLogicalClusterSNIIngress(Async)");
        }
        return this.createNetworkV1alphaLogicalClusterSNIIngressCall(environment, org, networkV1alphaLogicalClusterSNIIngress, _callback);
    }

    public NetworkV1alphaLogicalClusterSNIIngress createNetworkV1alphaLogicalClusterSNIIngress(String environment, String org, NetworkV1alphaLogicalClusterSNIIngress networkV1alphaLogicalClusterSNIIngress) throws ApiException {
        ApiResponse<NetworkV1alphaLogicalClusterSNIIngress> localVarResp = this.createNetworkV1alphaLogicalClusterSNIIngressWithHttpInfo(environment, org, networkV1alphaLogicalClusterSNIIngress);
        return localVarResp.getData();
    }

    public ApiResponse<NetworkV1alphaLogicalClusterSNIIngress> createNetworkV1alphaLogicalClusterSNIIngressWithHttpInfo(String environment, String org, NetworkV1alphaLogicalClusterSNIIngress networkV1alphaLogicalClusterSNIIngress) throws ApiException {
        Call localVarCall = this.createNetworkV1alphaLogicalClusterSNIIngressValidateBeforeCall(environment, org, networkV1alphaLogicalClusterSNIIngress, null);
        Type localVarReturnType = new TypeToken<NetworkV1alphaLogicalClusterSNIIngress>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createNetworkV1alphaLogicalClusterSNIIngressAsync(String environment, String org, NetworkV1alphaLogicalClusterSNIIngress networkV1alphaLogicalClusterSNIIngress, ApiCallback<NetworkV1alphaLogicalClusterSNIIngress> _callback) throws ApiException {
        Call localVarCall = this.createNetworkV1alphaLogicalClusterSNIIngressValidateBeforeCall(environment, org, networkV1alphaLogicalClusterSNIIngress, _callback);
        Type localVarReturnType = new TypeToken<NetworkV1alphaLogicalClusterSNIIngress>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call createNetworkV1alphaNetworkDestinationCall(String environment, String org, NetworkV1alphaNetworkDestination networkV1alphaNetworkDestination, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        NetworkV1alphaNetworkDestination localVarPostBody = networkV1alphaNetworkDestination;
        String localVarPath = "/apis/network/v1alpha/orgs/{org}/environments/{environment}/networkdestinations".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createNetworkV1alphaNetworkDestinationValidateBeforeCall(String environment, String org, NetworkV1alphaNetworkDestination networkV1alphaNetworkDestination, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling createNetworkV1alphaNetworkDestination(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling createNetworkV1alphaNetworkDestination(Async)");
        }
        if (networkV1alphaNetworkDestination == null) {
            throw new ApiException("Missing the required parameter 'networkV1alphaNetworkDestination' when calling createNetworkV1alphaNetworkDestination(Async)");
        }
        return this.createNetworkV1alphaNetworkDestinationCall(environment, org, networkV1alphaNetworkDestination, _callback);
    }

    public NetworkV1alphaNetworkDestination createNetworkV1alphaNetworkDestination(String environment, String org, NetworkV1alphaNetworkDestination networkV1alphaNetworkDestination) throws ApiException {
        ApiResponse<NetworkV1alphaNetworkDestination> localVarResp = this.createNetworkV1alphaNetworkDestinationWithHttpInfo(environment, org, networkV1alphaNetworkDestination);
        return localVarResp.getData();
    }

    public ApiResponse<NetworkV1alphaNetworkDestination> createNetworkV1alphaNetworkDestinationWithHttpInfo(String environment, String org, NetworkV1alphaNetworkDestination networkV1alphaNetworkDestination) throws ApiException {
        Call localVarCall = this.createNetworkV1alphaNetworkDestinationValidateBeforeCall(environment, org, networkV1alphaNetworkDestination, null);
        Type localVarReturnType = new TypeToken<NetworkV1alphaNetworkDestination>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createNetworkV1alphaNetworkDestinationAsync(String environment, String org, NetworkV1alphaNetworkDestination networkV1alphaNetworkDestination, ApiCallback<NetworkV1alphaNetworkDestination> _callback) throws ApiException {
        Call localVarCall = this.createNetworkV1alphaNetworkDestinationValidateBeforeCall(environment, org, networkV1alphaNetworkDestination, _callback);
        Type localVarReturnType = new TypeToken<NetworkV1alphaNetworkDestination>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteNetworkV1alphaLogicalClusterSNIIngressCall(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/network/v1alpha/orgs/{org}/environments/{environment}/logicalclustersniingresses/{name}".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (propagationPolicy != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("propagationPolicy", propagationPolicy));
        }
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if (uid != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("uid", uid));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteNetworkV1alphaLogicalClusterSNIIngressValidateBeforeCall(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling deleteNetworkV1alphaLogicalClusterSNIIngress(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling deleteNetworkV1alphaLogicalClusterSNIIngress(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling deleteNetworkV1alphaLogicalClusterSNIIngress(Async)");
        }
        return this.deleteNetworkV1alphaLogicalClusterSNIIngressCall(environment, name, org, propagationPolicy, resourceVersion, uid, _callback);
    }

    public NetworkV1alphaLogicalClusterSNIIngress deleteNetworkV1alphaLogicalClusterSNIIngress(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid) throws ApiException {
        ApiResponse<NetworkV1alphaLogicalClusterSNIIngress> localVarResp = this.deleteNetworkV1alphaLogicalClusterSNIIngressWithHttpInfo(environment, name, org, propagationPolicy, resourceVersion, uid);
        return localVarResp.getData();
    }

    public ApiResponse<NetworkV1alphaLogicalClusterSNIIngress> deleteNetworkV1alphaLogicalClusterSNIIngressWithHttpInfo(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid) throws ApiException {
        Call localVarCall = this.deleteNetworkV1alphaLogicalClusterSNIIngressValidateBeforeCall(environment, name, org, propagationPolicy, resourceVersion, uid, null);
        Type localVarReturnType = new TypeToken<NetworkV1alphaLogicalClusterSNIIngress>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call deleteNetworkV1alphaLogicalClusterSNIIngressAsync(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid, ApiCallback<NetworkV1alphaLogicalClusterSNIIngress> _callback) throws ApiException {
        Call localVarCall = this.deleteNetworkV1alphaLogicalClusterSNIIngressValidateBeforeCall(environment, name, org, propagationPolicy, resourceVersion, uid, _callback);
        Type localVarReturnType = new TypeToken<NetworkV1alphaLogicalClusterSNIIngress>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteNetworkV1alphaNetworkDestinationCall(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/network/v1alpha/orgs/{org}/environments/{environment}/networkdestinations/{name}".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (propagationPolicy != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("propagationPolicy", propagationPolicy));
        }
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if (uid != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("uid", uid));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteNetworkV1alphaNetworkDestinationValidateBeforeCall(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling deleteNetworkV1alphaNetworkDestination(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling deleteNetworkV1alphaNetworkDestination(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling deleteNetworkV1alphaNetworkDestination(Async)");
        }
        return this.deleteNetworkV1alphaNetworkDestinationCall(environment, name, org, propagationPolicy, resourceVersion, uid, _callback);
    }

    public NetworkV1alphaNetworkDestination deleteNetworkV1alphaNetworkDestination(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid) throws ApiException {
        ApiResponse<NetworkV1alphaNetworkDestination> localVarResp = this.deleteNetworkV1alphaNetworkDestinationWithHttpInfo(environment, name, org, propagationPolicy, resourceVersion, uid);
        return localVarResp.getData();
    }

    public ApiResponse<NetworkV1alphaNetworkDestination> deleteNetworkV1alphaNetworkDestinationWithHttpInfo(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid) throws ApiException {
        Call localVarCall = this.deleteNetworkV1alphaNetworkDestinationValidateBeforeCall(environment, name, org, propagationPolicy, resourceVersion, uid, null);
        Type localVarReturnType = new TypeToken<NetworkV1alphaNetworkDestination>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call deleteNetworkV1alphaNetworkDestinationAsync(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid, ApiCallback<NetworkV1alphaNetworkDestination> _callback) throws ApiException {
        Call localVarCall = this.deleteNetworkV1alphaNetworkDestinationValidateBeforeCall(environment, name, org, propagationPolicy, resourceVersion, uid, _callback);
        Type localVarReturnType = new TypeToken<NetworkV1alphaNetworkDestination>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listNetworkV1alphaLogicalClusterSNIIngresssCall(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/network/v1alpha/orgs/{org}/environments/{environment}/logicalclustersniingresses".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (_continue != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("continue", _continue));
        }
        if (eventuallyConsistent != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("eventuallyConsistent", eventuallyConsistent));
        }
        if (fieldSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldSelector", fieldSelector));
        }
        if (labelSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("labelSelector", labelSelector));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listNetworkV1alphaLogicalClusterSNIIngresssValidateBeforeCall(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling listNetworkV1alphaLogicalClusterSNIIngresss(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling listNetworkV1alphaLogicalClusterSNIIngresss(Async)");
        }
        return this.listNetworkV1alphaLogicalClusterSNIIngresssCall(environment, org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
    }

    public NetworkV1alphaLogicalClusterSNIIngressList listNetworkV1alphaLogicalClusterSNIIngresss(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        ApiResponse<NetworkV1alphaLogicalClusterSNIIngressList> localVarResp = this.listNetworkV1alphaLogicalClusterSNIIngresssWithHttpInfo(environment, org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit);
        return localVarResp.getData();
    }

    public ApiResponse<NetworkV1alphaLogicalClusterSNIIngressList> listNetworkV1alphaLogicalClusterSNIIngresssWithHttpInfo(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        Call localVarCall = this.listNetworkV1alphaLogicalClusterSNIIngresssValidateBeforeCall(environment, org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, null);
        Type localVarReturnType = new TypeToken<NetworkV1alphaLogicalClusterSNIIngressList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listNetworkV1alphaLogicalClusterSNIIngresssAsync(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback<NetworkV1alphaLogicalClusterSNIIngressList> _callback) throws ApiException {
        Call localVarCall = this.listNetworkV1alphaLogicalClusterSNIIngresssValidateBeforeCall(environment, org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
        Type localVarReturnType = new TypeToken<NetworkV1alphaLogicalClusterSNIIngressList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listNetworkV1alphaLogicalClusterSNIIngresssForAllEnvironmentsCall(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/network/v1alpha/orgs/{org}/logicalclustersniingresses".replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (_continue != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("continue", _continue));
        }
        if (eventuallyConsistent != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("eventuallyConsistent", eventuallyConsistent));
        }
        if (fieldSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldSelector", fieldSelector));
        }
        if (labelSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("labelSelector", labelSelector));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listNetworkV1alphaLogicalClusterSNIIngresssForAllEnvironmentsValidateBeforeCall(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling listNetworkV1alphaLogicalClusterSNIIngresssForAllEnvironments(Async)");
        }
        return this.listNetworkV1alphaLogicalClusterSNIIngresssForAllEnvironmentsCall(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
    }

    public NetworkV1alphaLogicalClusterSNIIngressList listNetworkV1alphaLogicalClusterSNIIngresssForAllEnvironments(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        ApiResponse<NetworkV1alphaLogicalClusterSNIIngressList> localVarResp = this.listNetworkV1alphaLogicalClusterSNIIngresssForAllEnvironmentsWithHttpInfo(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit);
        return localVarResp.getData();
    }

    public ApiResponse<NetworkV1alphaLogicalClusterSNIIngressList> listNetworkV1alphaLogicalClusterSNIIngresssForAllEnvironmentsWithHttpInfo(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        Call localVarCall = this.listNetworkV1alphaLogicalClusterSNIIngresssForAllEnvironmentsValidateBeforeCall(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, null);
        Type localVarReturnType = new TypeToken<NetworkV1alphaLogicalClusterSNIIngressList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listNetworkV1alphaLogicalClusterSNIIngresssForAllEnvironmentsAsync(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback<NetworkV1alphaLogicalClusterSNIIngressList> _callback) throws ApiException {
        Call localVarCall = this.listNetworkV1alphaLogicalClusterSNIIngresssForAllEnvironmentsValidateBeforeCall(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
        Type localVarReturnType = new TypeToken<NetworkV1alphaLogicalClusterSNIIngressList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listNetworkV1alphaNetworkDestinationsCall(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/network/v1alpha/orgs/{org}/environments/{environment}/networkdestinations".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (_continue != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("continue", _continue));
        }
        if (eventuallyConsistent != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("eventuallyConsistent", eventuallyConsistent));
        }
        if (fieldSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldSelector", fieldSelector));
        }
        if (labelSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("labelSelector", labelSelector));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listNetworkV1alphaNetworkDestinationsValidateBeforeCall(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling listNetworkV1alphaNetworkDestinations(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling listNetworkV1alphaNetworkDestinations(Async)");
        }
        return this.listNetworkV1alphaNetworkDestinationsCall(environment, org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
    }

    public NetworkV1alphaNetworkDestinationList listNetworkV1alphaNetworkDestinations(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        ApiResponse<NetworkV1alphaNetworkDestinationList> localVarResp = this.listNetworkV1alphaNetworkDestinationsWithHttpInfo(environment, org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit);
        return localVarResp.getData();
    }

    public ApiResponse<NetworkV1alphaNetworkDestinationList> listNetworkV1alphaNetworkDestinationsWithHttpInfo(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        Call localVarCall = this.listNetworkV1alphaNetworkDestinationsValidateBeforeCall(environment, org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, null);
        Type localVarReturnType = new TypeToken<NetworkV1alphaNetworkDestinationList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listNetworkV1alphaNetworkDestinationsAsync(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback<NetworkV1alphaNetworkDestinationList> _callback) throws ApiException {
        Call localVarCall = this.listNetworkV1alphaNetworkDestinationsValidateBeforeCall(environment, org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
        Type localVarReturnType = new TypeToken<NetworkV1alphaNetworkDestinationList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listNetworkV1alphaNetworkDestinationsForAllEnvironmentsCall(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/network/v1alpha/orgs/{org}/networkdestinations".replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (_continue != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("continue", _continue));
        }
        if (eventuallyConsistent != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("eventuallyConsistent", eventuallyConsistent));
        }
        if (fieldSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldSelector", fieldSelector));
        }
        if (labelSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("labelSelector", labelSelector));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listNetworkV1alphaNetworkDestinationsForAllEnvironmentsValidateBeforeCall(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling listNetworkV1alphaNetworkDestinationsForAllEnvironments(Async)");
        }
        return this.listNetworkV1alphaNetworkDestinationsForAllEnvironmentsCall(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
    }

    public NetworkV1alphaNetworkDestinationList listNetworkV1alphaNetworkDestinationsForAllEnvironments(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        ApiResponse<NetworkV1alphaNetworkDestinationList> localVarResp = this.listNetworkV1alphaNetworkDestinationsForAllEnvironmentsWithHttpInfo(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit);
        return localVarResp.getData();
    }

    public ApiResponse<NetworkV1alphaNetworkDestinationList> listNetworkV1alphaNetworkDestinationsForAllEnvironmentsWithHttpInfo(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        Call localVarCall = this.listNetworkV1alphaNetworkDestinationsForAllEnvironmentsValidateBeforeCall(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, null);
        Type localVarReturnType = new TypeToken<NetworkV1alphaNetworkDestinationList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listNetworkV1alphaNetworkDestinationsForAllEnvironmentsAsync(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback<NetworkV1alphaNetworkDestinationList> _callback) throws ApiException {
        Call localVarCall = this.listNetworkV1alphaNetworkDestinationsForAllEnvironmentsValidateBeforeCall(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
        Type localVarReturnType = new TypeToken<NetworkV1alphaNetworkDestinationList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call patchNetworkV1alphaLogicalClusterSNIIngressCall(String environment, String name, String org, NetworkV1alphaLogicalClusterSNIIngress networkV1alphaLogicalClusterSNIIngress, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        NetworkV1alphaLogicalClusterSNIIngress localVarPostBody = networkV1alphaLogicalClusterSNIIngress;
        String localVarPath = "/apis/network/v1alpha/orgs/{org}/environments/{environment}/logicalclustersniingresses/{name}".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json-patch+json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchNetworkV1alphaLogicalClusterSNIIngressValidateBeforeCall(String environment, String name, String org, NetworkV1alphaLogicalClusterSNIIngress networkV1alphaLogicalClusterSNIIngress, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling patchNetworkV1alphaLogicalClusterSNIIngress(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling patchNetworkV1alphaLogicalClusterSNIIngress(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling patchNetworkV1alphaLogicalClusterSNIIngress(Async)");
        }
        if (networkV1alphaLogicalClusterSNIIngress == null) {
            throw new ApiException("Missing the required parameter 'networkV1alphaLogicalClusterSNIIngress' when calling patchNetworkV1alphaLogicalClusterSNIIngress(Async)");
        }
        return this.patchNetworkV1alphaLogicalClusterSNIIngressCall(environment, name, org, networkV1alphaLogicalClusterSNIIngress, _callback);
    }

    public NetworkV1alphaLogicalClusterSNIIngress patchNetworkV1alphaLogicalClusterSNIIngress(String environment, String name, String org, NetworkV1alphaLogicalClusterSNIIngress networkV1alphaLogicalClusterSNIIngress) throws ApiException {
        ApiResponse<NetworkV1alphaLogicalClusterSNIIngress> localVarResp = this.patchNetworkV1alphaLogicalClusterSNIIngressWithHttpInfo(environment, name, org, networkV1alphaLogicalClusterSNIIngress);
        return localVarResp.getData();
    }

    public ApiResponse<NetworkV1alphaLogicalClusterSNIIngress> patchNetworkV1alphaLogicalClusterSNIIngressWithHttpInfo(String environment, String name, String org, NetworkV1alphaLogicalClusterSNIIngress networkV1alphaLogicalClusterSNIIngress) throws ApiException {
        Call localVarCall = this.patchNetworkV1alphaLogicalClusterSNIIngressValidateBeforeCall(environment, name, org, networkV1alphaLogicalClusterSNIIngress, null);
        Type localVarReturnType = new TypeToken<NetworkV1alphaLogicalClusterSNIIngress>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call patchNetworkV1alphaLogicalClusterSNIIngressAsync(String environment, String name, String org, NetworkV1alphaLogicalClusterSNIIngress networkV1alphaLogicalClusterSNIIngress, ApiCallback<NetworkV1alphaLogicalClusterSNIIngress> _callback) throws ApiException {
        Call localVarCall = this.patchNetworkV1alphaLogicalClusterSNIIngressValidateBeforeCall(environment, name, org, networkV1alphaLogicalClusterSNIIngress, _callback);
        Type localVarReturnType = new TypeToken<NetworkV1alphaLogicalClusterSNIIngress>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call patchNetworkV1alphaLogicalClusterSNIIngressFinalizersCall(String environment, String name, String org, NetworkV1alphaLogicalClusterSNIIngress networkV1alphaLogicalClusterSNIIngress, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        NetworkV1alphaLogicalClusterSNIIngress localVarPostBody = networkV1alphaLogicalClusterSNIIngress;
        String localVarPath = "/apis/network/v1alpha/orgs/{org}/environments/{environment}/logicalclustersniingresses/{name}/finalizers".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json-patch+json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchNetworkV1alphaLogicalClusterSNIIngressFinalizersValidateBeforeCall(String environment, String name, String org, NetworkV1alphaLogicalClusterSNIIngress networkV1alphaLogicalClusterSNIIngress, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling patchNetworkV1alphaLogicalClusterSNIIngressFinalizers(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling patchNetworkV1alphaLogicalClusterSNIIngressFinalizers(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling patchNetworkV1alphaLogicalClusterSNIIngressFinalizers(Async)");
        }
        if (networkV1alphaLogicalClusterSNIIngress == null) {
            throw new ApiException("Missing the required parameter 'networkV1alphaLogicalClusterSNIIngress' when calling patchNetworkV1alphaLogicalClusterSNIIngressFinalizers(Async)");
        }
        return this.patchNetworkV1alphaLogicalClusterSNIIngressFinalizersCall(environment, name, org, networkV1alphaLogicalClusterSNIIngress, _callback);
    }

    public NetworkV1alphaLogicalClusterSNIIngress patchNetworkV1alphaLogicalClusterSNIIngressFinalizers(String environment, String name, String org, NetworkV1alphaLogicalClusterSNIIngress networkV1alphaLogicalClusterSNIIngress) throws ApiException {
        ApiResponse<NetworkV1alphaLogicalClusterSNIIngress> localVarResp = this.patchNetworkV1alphaLogicalClusterSNIIngressFinalizersWithHttpInfo(environment, name, org, networkV1alphaLogicalClusterSNIIngress);
        return localVarResp.getData();
    }

    public ApiResponse<NetworkV1alphaLogicalClusterSNIIngress> patchNetworkV1alphaLogicalClusterSNIIngressFinalizersWithHttpInfo(String environment, String name, String org, NetworkV1alphaLogicalClusterSNIIngress networkV1alphaLogicalClusterSNIIngress) throws ApiException {
        Call localVarCall = this.patchNetworkV1alphaLogicalClusterSNIIngressFinalizersValidateBeforeCall(environment, name, org, networkV1alphaLogicalClusterSNIIngress, null);
        Type localVarReturnType = new TypeToken<NetworkV1alphaLogicalClusterSNIIngress>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call patchNetworkV1alphaLogicalClusterSNIIngressFinalizersAsync(String environment, String name, String org, NetworkV1alphaLogicalClusterSNIIngress networkV1alphaLogicalClusterSNIIngress, ApiCallback<NetworkV1alphaLogicalClusterSNIIngress> _callback) throws ApiException {
        Call localVarCall = this.patchNetworkV1alphaLogicalClusterSNIIngressFinalizersValidateBeforeCall(environment, name, org, networkV1alphaLogicalClusterSNIIngress, _callback);
        Type localVarReturnType = new TypeToken<NetworkV1alphaLogicalClusterSNIIngress>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call patchNetworkV1alphaNetworkDestinationCall(String environment, String name, String org, NetworkV1alphaNetworkDestination networkV1alphaNetworkDestination, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        NetworkV1alphaNetworkDestination localVarPostBody = networkV1alphaNetworkDestination;
        String localVarPath = "/apis/network/v1alpha/orgs/{org}/environments/{environment}/networkdestinations/{name}".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json-patch+json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchNetworkV1alphaNetworkDestinationValidateBeforeCall(String environment, String name, String org, NetworkV1alphaNetworkDestination networkV1alphaNetworkDestination, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling patchNetworkV1alphaNetworkDestination(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling patchNetworkV1alphaNetworkDestination(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling patchNetworkV1alphaNetworkDestination(Async)");
        }
        if (networkV1alphaNetworkDestination == null) {
            throw new ApiException("Missing the required parameter 'networkV1alphaNetworkDestination' when calling patchNetworkV1alphaNetworkDestination(Async)");
        }
        return this.patchNetworkV1alphaNetworkDestinationCall(environment, name, org, networkV1alphaNetworkDestination, _callback);
    }

    public NetworkV1alphaNetworkDestination patchNetworkV1alphaNetworkDestination(String environment, String name, String org, NetworkV1alphaNetworkDestination networkV1alphaNetworkDestination) throws ApiException {
        ApiResponse<NetworkV1alphaNetworkDestination> localVarResp = this.patchNetworkV1alphaNetworkDestinationWithHttpInfo(environment, name, org, networkV1alphaNetworkDestination);
        return localVarResp.getData();
    }

    public ApiResponse<NetworkV1alphaNetworkDestination> patchNetworkV1alphaNetworkDestinationWithHttpInfo(String environment, String name, String org, NetworkV1alphaNetworkDestination networkV1alphaNetworkDestination) throws ApiException {
        Call localVarCall = this.patchNetworkV1alphaNetworkDestinationValidateBeforeCall(environment, name, org, networkV1alphaNetworkDestination, null);
        Type localVarReturnType = new TypeToken<NetworkV1alphaNetworkDestination>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call patchNetworkV1alphaNetworkDestinationAsync(String environment, String name, String org, NetworkV1alphaNetworkDestination networkV1alphaNetworkDestination, ApiCallback<NetworkV1alphaNetworkDestination> _callback) throws ApiException {
        Call localVarCall = this.patchNetworkV1alphaNetworkDestinationValidateBeforeCall(environment, name, org, networkV1alphaNetworkDestination, _callback);
        Type localVarReturnType = new TypeToken<NetworkV1alphaNetworkDestination>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call patchNetworkV1alphaNetworkDestinationFinalizersCall(String environment, String name, String org, NetworkV1alphaNetworkDestination networkV1alphaNetworkDestination, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        NetworkV1alphaNetworkDestination localVarPostBody = networkV1alphaNetworkDestination;
        String localVarPath = "/apis/network/v1alpha/orgs/{org}/environments/{environment}/networkdestinations/{name}/finalizers".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json-patch+json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchNetworkV1alphaNetworkDestinationFinalizersValidateBeforeCall(String environment, String name, String org, NetworkV1alphaNetworkDestination networkV1alphaNetworkDestination, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling patchNetworkV1alphaNetworkDestinationFinalizers(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling patchNetworkV1alphaNetworkDestinationFinalizers(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling patchNetworkV1alphaNetworkDestinationFinalizers(Async)");
        }
        if (networkV1alphaNetworkDestination == null) {
            throw new ApiException("Missing the required parameter 'networkV1alphaNetworkDestination' when calling patchNetworkV1alphaNetworkDestinationFinalizers(Async)");
        }
        return this.patchNetworkV1alphaNetworkDestinationFinalizersCall(environment, name, org, networkV1alphaNetworkDestination, _callback);
    }

    public NetworkV1alphaNetworkDestination patchNetworkV1alphaNetworkDestinationFinalizers(String environment, String name, String org, NetworkV1alphaNetworkDestination networkV1alphaNetworkDestination) throws ApiException {
        ApiResponse<NetworkV1alphaNetworkDestination> localVarResp = this.patchNetworkV1alphaNetworkDestinationFinalizersWithHttpInfo(environment, name, org, networkV1alphaNetworkDestination);
        return localVarResp.getData();
    }

    public ApiResponse<NetworkV1alphaNetworkDestination> patchNetworkV1alphaNetworkDestinationFinalizersWithHttpInfo(String environment, String name, String org, NetworkV1alphaNetworkDestination networkV1alphaNetworkDestination) throws ApiException {
        Call localVarCall = this.patchNetworkV1alphaNetworkDestinationFinalizersValidateBeforeCall(environment, name, org, networkV1alphaNetworkDestination, null);
        Type localVarReturnType = new TypeToken<NetworkV1alphaNetworkDestination>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call patchNetworkV1alphaNetworkDestinationFinalizersAsync(String environment, String name, String org, NetworkV1alphaNetworkDestination networkV1alphaNetworkDestination, ApiCallback<NetworkV1alphaNetworkDestination> _callback) throws ApiException {
        Call localVarCall = this.patchNetworkV1alphaNetworkDestinationFinalizersValidateBeforeCall(environment, name, org, networkV1alphaNetworkDestination, _callback);
        Type localVarReturnType = new TypeToken<NetworkV1alphaNetworkDestination>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call readNetworkV1alphaLogicalClusterSNIIngressCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/network/v1alpha/orgs/{org}/environments/{environment}/logicalclustersniingresses/{name}".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call readNetworkV1alphaLogicalClusterSNIIngressValidateBeforeCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling readNetworkV1alphaLogicalClusterSNIIngress(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling readNetworkV1alphaLogicalClusterSNIIngress(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling readNetworkV1alphaLogicalClusterSNIIngress(Async)");
        }
        return this.readNetworkV1alphaLogicalClusterSNIIngressCall(environment, name, org, resourceVersion, _callback);
    }

    public NetworkV1alphaLogicalClusterSNIIngress readNetworkV1alphaLogicalClusterSNIIngress(String environment, String name, String org, String resourceVersion) throws ApiException {
        ApiResponse<NetworkV1alphaLogicalClusterSNIIngress> localVarResp = this.readNetworkV1alphaLogicalClusterSNIIngressWithHttpInfo(environment, name, org, resourceVersion);
        return localVarResp.getData();
    }

    public ApiResponse<NetworkV1alphaLogicalClusterSNIIngress> readNetworkV1alphaLogicalClusterSNIIngressWithHttpInfo(String environment, String name, String org, String resourceVersion) throws ApiException {
        Call localVarCall = this.readNetworkV1alphaLogicalClusterSNIIngressValidateBeforeCall(environment, name, org, resourceVersion, null);
        Type localVarReturnType = new TypeToken<NetworkV1alphaLogicalClusterSNIIngress>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call readNetworkV1alphaLogicalClusterSNIIngressAsync(String environment, String name, String org, String resourceVersion, ApiCallback<NetworkV1alphaLogicalClusterSNIIngress> _callback) throws ApiException {
        Call localVarCall = this.readNetworkV1alphaLogicalClusterSNIIngressValidateBeforeCall(environment, name, org, resourceVersion, _callback);
        Type localVarReturnType = new TypeToken<NetworkV1alphaLogicalClusterSNIIngress>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call readNetworkV1alphaLogicalClusterSNIIngressFinalizersCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/network/v1alpha/orgs/{org}/environments/{environment}/logicalclustersniingresses/{name}/finalizers".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call readNetworkV1alphaLogicalClusterSNIIngressFinalizersValidateBeforeCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling readNetworkV1alphaLogicalClusterSNIIngressFinalizers(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling readNetworkV1alphaLogicalClusterSNIIngressFinalizers(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling readNetworkV1alphaLogicalClusterSNIIngressFinalizers(Async)");
        }
        return this.readNetworkV1alphaLogicalClusterSNIIngressFinalizersCall(environment, name, org, resourceVersion, _callback);
    }

    public NetworkV1alphaLogicalClusterSNIIngress readNetworkV1alphaLogicalClusterSNIIngressFinalizers(String environment, String name, String org, String resourceVersion) throws ApiException {
        ApiResponse<NetworkV1alphaLogicalClusterSNIIngress> localVarResp = this.readNetworkV1alphaLogicalClusterSNIIngressFinalizersWithHttpInfo(environment, name, org, resourceVersion);
        return localVarResp.getData();
    }

    public ApiResponse<NetworkV1alphaLogicalClusterSNIIngress> readNetworkV1alphaLogicalClusterSNIIngressFinalizersWithHttpInfo(String environment, String name, String org, String resourceVersion) throws ApiException {
        Call localVarCall = this.readNetworkV1alphaLogicalClusterSNIIngressFinalizersValidateBeforeCall(environment, name, org, resourceVersion, null);
        Type localVarReturnType = new TypeToken<NetworkV1alphaLogicalClusterSNIIngress>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call readNetworkV1alphaLogicalClusterSNIIngressFinalizersAsync(String environment, String name, String org, String resourceVersion, ApiCallback<NetworkV1alphaLogicalClusterSNIIngress> _callback) throws ApiException {
        Call localVarCall = this.readNetworkV1alphaLogicalClusterSNIIngressFinalizersValidateBeforeCall(environment, name, org, resourceVersion, _callback);
        Type localVarReturnType = new TypeToken<NetworkV1alphaLogicalClusterSNIIngress>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call readNetworkV1alphaNetworkDestinationCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/network/v1alpha/orgs/{org}/environments/{environment}/networkdestinations/{name}".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call readNetworkV1alphaNetworkDestinationValidateBeforeCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling readNetworkV1alphaNetworkDestination(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling readNetworkV1alphaNetworkDestination(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling readNetworkV1alphaNetworkDestination(Async)");
        }
        return this.readNetworkV1alphaNetworkDestinationCall(environment, name, org, resourceVersion, _callback);
    }

    public NetworkV1alphaNetworkDestination readNetworkV1alphaNetworkDestination(String environment, String name, String org, String resourceVersion) throws ApiException {
        ApiResponse<NetworkV1alphaNetworkDestination> localVarResp = this.readNetworkV1alphaNetworkDestinationWithHttpInfo(environment, name, org, resourceVersion);
        return localVarResp.getData();
    }

    public ApiResponse<NetworkV1alphaNetworkDestination> readNetworkV1alphaNetworkDestinationWithHttpInfo(String environment, String name, String org, String resourceVersion) throws ApiException {
        Call localVarCall = this.readNetworkV1alphaNetworkDestinationValidateBeforeCall(environment, name, org, resourceVersion, null);
        Type localVarReturnType = new TypeToken<NetworkV1alphaNetworkDestination>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call readNetworkV1alphaNetworkDestinationAsync(String environment, String name, String org, String resourceVersion, ApiCallback<NetworkV1alphaNetworkDestination> _callback) throws ApiException {
        Call localVarCall = this.readNetworkV1alphaNetworkDestinationValidateBeforeCall(environment, name, org, resourceVersion, _callback);
        Type localVarReturnType = new TypeToken<NetworkV1alphaNetworkDestination>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call readNetworkV1alphaNetworkDestinationFinalizersCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/network/v1alpha/orgs/{org}/environments/{environment}/networkdestinations/{name}/finalizers".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call readNetworkV1alphaNetworkDestinationFinalizersValidateBeforeCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling readNetworkV1alphaNetworkDestinationFinalizers(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling readNetworkV1alphaNetworkDestinationFinalizers(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling readNetworkV1alphaNetworkDestinationFinalizers(Async)");
        }
        return this.readNetworkV1alphaNetworkDestinationFinalizersCall(environment, name, org, resourceVersion, _callback);
    }

    public NetworkV1alphaNetworkDestination readNetworkV1alphaNetworkDestinationFinalizers(String environment, String name, String org, String resourceVersion) throws ApiException {
        ApiResponse<NetworkV1alphaNetworkDestination> localVarResp = this.readNetworkV1alphaNetworkDestinationFinalizersWithHttpInfo(environment, name, org, resourceVersion);
        return localVarResp.getData();
    }

    public ApiResponse<NetworkV1alphaNetworkDestination> readNetworkV1alphaNetworkDestinationFinalizersWithHttpInfo(String environment, String name, String org, String resourceVersion) throws ApiException {
        Call localVarCall = this.readNetworkV1alphaNetworkDestinationFinalizersValidateBeforeCall(environment, name, org, resourceVersion, null);
        Type localVarReturnType = new TypeToken<NetworkV1alphaNetworkDestination>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call readNetworkV1alphaNetworkDestinationFinalizersAsync(String environment, String name, String org, String resourceVersion, ApiCallback<NetworkV1alphaNetworkDestination> _callback) throws ApiException {
        Call localVarCall = this.readNetworkV1alphaNetworkDestinationFinalizersValidateBeforeCall(environment, name, org, resourceVersion, _callback);
        Type localVarReturnType = new TypeToken<NetworkV1alphaNetworkDestination>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateNetworkV1alphaLogicalClusterSNIIngressCall(String environment, String name, String org, NetworkV1alphaLogicalClusterSNIIngress networkV1alphaLogicalClusterSNIIngress, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        NetworkV1alphaLogicalClusterSNIIngress localVarPostBody = networkV1alphaLogicalClusterSNIIngress;
        String localVarPath = "/apis/network/v1alpha/orgs/{org}/environments/{environment}/logicalclustersniingresses/{name}".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateNetworkV1alphaLogicalClusterSNIIngressValidateBeforeCall(String environment, String name, String org, NetworkV1alphaLogicalClusterSNIIngress networkV1alphaLogicalClusterSNIIngress, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling updateNetworkV1alphaLogicalClusterSNIIngress(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling updateNetworkV1alphaLogicalClusterSNIIngress(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling updateNetworkV1alphaLogicalClusterSNIIngress(Async)");
        }
        if (networkV1alphaLogicalClusterSNIIngress == null) {
            throw new ApiException("Missing the required parameter 'networkV1alphaLogicalClusterSNIIngress' when calling updateNetworkV1alphaLogicalClusterSNIIngress(Async)");
        }
        return this.updateNetworkV1alphaLogicalClusterSNIIngressCall(environment, name, org, networkV1alphaLogicalClusterSNIIngress, _callback);
    }

    public NetworkV1alphaLogicalClusterSNIIngress updateNetworkV1alphaLogicalClusterSNIIngress(String environment, String name, String org, NetworkV1alphaLogicalClusterSNIIngress networkV1alphaLogicalClusterSNIIngress) throws ApiException {
        ApiResponse<NetworkV1alphaLogicalClusterSNIIngress> localVarResp = this.updateNetworkV1alphaLogicalClusterSNIIngressWithHttpInfo(environment, name, org, networkV1alphaLogicalClusterSNIIngress);
        return localVarResp.getData();
    }

    public ApiResponse<NetworkV1alphaLogicalClusterSNIIngress> updateNetworkV1alphaLogicalClusterSNIIngressWithHttpInfo(String environment, String name, String org, NetworkV1alphaLogicalClusterSNIIngress networkV1alphaLogicalClusterSNIIngress) throws ApiException {
        Call localVarCall = this.updateNetworkV1alphaLogicalClusterSNIIngressValidateBeforeCall(environment, name, org, networkV1alphaLogicalClusterSNIIngress, null);
        Type localVarReturnType = new TypeToken<NetworkV1alphaLogicalClusterSNIIngress>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateNetworkV1alphaLogicalClusterSNIIngressAsync(String environment, String name, String org, NetworkV1alphaLogicalClusterSNIIngress networkV1alphaLogicalClusterSNIIngress, ApiCallback<NetworkV1alphaLogicalClusterSNIIngress> _callback) throws ApiException {
        Call localVarCall = this.updateNetworkV1alphaLogicalClusterSNIIngressValidateBeforeCall(environment, name, org, networkV1alphaLogicalClusterSNIIngress, _callback);
        Type localVarReturnType = new TypeToken<NetworkV1alphaLogicalClusterSNIIngress>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateNetworkV1alphaLogicalClusterSNIIngressFinalizersCall(String environment, String name, String org, NetworkV1alphaLogicalClusterSNIIngress networkV1alphaLogicalClusterSNIIngress, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        NetworkV1alphaLogicalClusterSNIIngress localVarPostBody = networkV1alphaLogicalClusterSNIIngress;
        String localVarPath = "/apis/network/v1alpha/orgs/{org}/environments/{environment}/logicalclustersniingresses/{name}/finalizers".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateNetworkV1alphaLogicalClusterSNIIngressFinalizersValidateBeforeCall(String environment, String name, String org, NetworkV1alphaLogicalClusterSNIIngress networkV1alphaLogicalClusterSNIIngress, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling updateNetworkV1alphaLogicalClusterSNIIngressFinalizers(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling updateNetworkV1alphaLogicalClusterSNIIngressFinalizers(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling updateNetworkV1alphaLogicalClusterSNIIngressFinalizers(Async)");
        }
        if (networkV1alphaLogicalClusterSNIIngress == null) {
            throw new ApiException("Missing the required parameter 'networkV1alphaLogicalClusterSNIIngress' when calling updateNetworkV1alphaLogicalClusterSNIIngressFinalizers(Async)");
        }
        return this.updateNetworkV1alphaLogicalClusterSNIIngressFinalizersCall(environment, name, org, networkV1alphaLogicalClusterSNIIngress, _callback);
    }

    public NetworkV1alphaLogicalClusterSNIIngress updateNetworkV1alphaLogicalClusterSNIIngressFinalizers(String environment, String name, String org, NetworkV1alphaLogicalClusterSNIIngress networkV1alphaLogicalClusterSNIIngress) throws ApiException {
        ApiResponse<NetworkV1alphaLogicalClusterSNIIngress> localVarResp = this.updateNetworkV1alphaLogicalClusterSNIIngressFinalizersWithHttpInfo(environment, name, org, networkV1alphaLogicalClusterSNIIngress);
        return localVarResp.getData();
    }

    public ApiResponse<NetworkV1alphaLogicalClusterSNIIngress> updateNetworkV1alphaLogicalClusterSNIIngressFinalizersWithHttpInfo(String environment, String name, String org, NetworkV1alphaLogicalClusterSNIIngress networkV1alphaLogicalClusterSNIIngress) throws ApiException {
        Call localVarCall = this.updateNetworkV1alphaLogicalClusterSNIIngressFinalizersValidateBeforeCall(environment, name, org, networkV1alphaLogicalClusterSNIIngress, null);
        Type localVarReturnType = new TypeToken<NetworkV1alphaLogicalClusterSNIIngress>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateNetworkV1alphaLogicalClusterSNIIngressFinalizersAsync(String environment, String name, String org, NetworkV1alphaLogicalClusterSNIIngress networkV1alphaLogicalClusterSNIIngress, ApiCallback<NetworkV1alphaLogicalClusterSNIIngress> _callback) throws ApiException {
        Call localVarCall = this.updateNetworkV1alphaLogicalClusterSNIIngressFinalizersValidateBeforeCall(environment, name, org, networkV1alphaLogicalClusterSNIIngress, _callback);
        Type localVarReturnType = new TypeToken<NetworkV1alphaLogicalClusterSNIIngress>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateNetworkV1alphaNetworkDestinationCall(String environment, String name, String org, NetworkV1alphaNetworkDestination networkV1alphaNetworkDestination, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        NetworkV1alphaNetworkDestination localVarPostBody = networkV1alphaNetworkDestination;
        String localVarPath = "/apis/network/v1alpha/orgs/{org}/environments/{environment}/networkdestinations/{name}".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateNetworkV1alphaNetworkDestinationValidateBeforeCall(String environment, String name, String org, NetworkV1alphaNetworkDestination networkV1alphaNetworkDestination, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling updateNetworkV1alphaNetworkDestination(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling updateNetworkV1alphaNetworkDestination(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling updateNetworkV1alphaNetworkDestination(Async)");
        }
        if (networkV1alphaNetworkDestination == null) {
            throw new ApiException("Missing the required parameter 'networkV1alphaNetworkDestination' when calling updateNetworkV1alphaNetworkDestination(Async)");
        }
        return this.updateNetworkV1alphaNetworkDestinationCall(environment, name, org, networkV1alphaNetworkDestination, _callback);
    }

    public NetworkV1alphaNetworkDestination updateNetworkV1alphaNetworkDestination(String environment, String name, String org, NetworkV1alphaNetworkDestination networkV1alphaNetworkDestination) throws ApiException {
        ApiResponse<NetworkV1alphaNetworkDestination> localVarResp = this.updateNetworkV1alphaNetworkDestinationWithHttpInfo(environment, name, org, networkV1alphaNetworkDestination);
        return localVarResp.getData();
    }

    public ApiResponse<NetworkV1alphaNetworkDestination> updateNetworkV1alphaNetworkDestinationWithHttpInfo(String environment, String name, String org, NetworkV1alphaNetworkDestination networkV1alphaNetworkDestination) throws ApiException {
        Call localVarCall = this.updateNetworkV1alphaNetworkDestinationValidateBeforeCall(environment, name, org, networkV1alphaNetworkDestination, null);
        Type localVarReturnType = new TypeToken<NetworkV1alphaNetworkDestination>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateNetworkV1alphaNetworkDestinationAsync(String environment, String name, String org, NetworkV1alphaNetworkDestination networkV1alphaNetworkDestination, ApiCallback<NetworkV1alphaNetworkDestination> _callback) throws ApiException {
        Call localVarCall = this.updateNetworkV1alphaNetworkDestinationValidateBeforeCall(environment, name, org, networkV1alphaNetworkDestination, _callback);
        Type localVarReturnType = new TypeToken<NetworkV1alphaNetworkDestination>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateNetworkV1alphaNetworkDestinationFinalizersCall(String environment, String name, String org, NetworkV1alphaNetworkDestination networkV1alphaNetworkDestination, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        NetworkV1alphaNetworkDestination localVarPostBody = networkV1alphaNetworkDestination;
        String localVarPath = "/apis/network/v1alpha/orgs/{org}/environments/{environment}/networkdestinations/{name}/finalizers".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateNetworkV1alphaNetworkDestinationFinalizersValidateBeforeCall(String environment, String name, String org, NetworkV1alphaNetworkDestination networkV1alphaNetworkDestination, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling updateNetworkV1alphaNetworkDestinationFinalizers(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling updateNetworkV1alphaNetworkDestinationFinalizers(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling updateNetworkV1alphaNetworkDestinationFinalizers(Async)");
        }
        if (networkV1alphaNetworkDestination == null) {
            throw new ApiException("Missing the required parameter 'networkV1alphaNetworkDestination' when calling updateNetworkV1alphaNetworkDestinationFinalizers(Async)");
        }
        return this.updateNetworkV1alphaNetworkDestinationFinalizersCall(environment, name, org, networkV1alphaNetworkDestination, _callback);
    }

    public NetworkV1alphaNetworkDestination updateNetworkV1alphaNetworkDestinationFinalizers(String environment, String name, String org, NetworkV1alphaNetworkDestination networkV1alphaNetworkDestination) throws ApiException {
        ApiResponse<NetworkV1alphaNetworkDestination> localVarResp = this.updateNetworkV1alphaNetworkDestinationFinalizersWithHttpInfo(environment, name, org, networkV1alphaNetworkDestination);
        return localVarResp.getData();
    }

    public ApiResponse<NetworkV1alphaNetworkDestination> updateNetworkV1alphaNetworkDestinationFinalizersWithHttpInfo(String environment, String name, String org, NetworkV1alphaNetworkDestination networkV1alphaNetworkDestination) throws ApiException {
        Call localVarCall = this.updateNetworkV1alphaNetworkDestinationFinalizersValidateBeforeCall(environment, name, org, networkV1alphaNetworkDestination, null);
        Type localVarReturnType = new TypeToken<NetworkV1alphaNetworkDestination>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateNetworkV1alphaNetworkDestinationFinalizersAsync(String environment, String name, String org, NetworkV1alphaNetworkDestination networkV1alphaNetworkDestination, ApiCallback<NetworkV1alphaNetworkDestination> _callback) throws ApiException {
        Call localVarCall = this.updateNetworkV1alphaNetworkDestinationFinalizersValidateBeforeCall(environment, name, org, networkV1alphaNetworkDestination, _callback);
        Type localVarReturnType = new TypeToken<NetworkV1alphaNetworkDestination>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

