/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.flink.apiserver.client;

import com.google.gson.reflect.TypeToken;
import io.confluent.flink.apiserver.client.ApiCallback;
import io.confluent.flink.apiserver.client.ApiClient;
import io.confluent.flink.apiserver.client.ApiException;
import io.confluent.flink.apiserver.client.ApiResponse;
import io.confluent.flink.apiserver.client.Configuration;
import io.confluent.flink.apiserver.client.Pair;
import io.confluent.flink.apiserver.client.model.RayV1alphaComputePool;
import io.confluent.flink.apiserver.client.model.RayV1alphaComputePoolList;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;

public class RayV1alphaApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public RayV1alphaApi() {
        this(Configuration.getDefaultApiClient());
    }

    public RayV1alphaApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call createRayV1alphaComputePoolCall(String environment, String org, RayV1alphaComputePool rayV1alphaComputePool, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        RayV1alphaComputePool localVarPostBody = rayV1alphaComputePool;
        String localVarPath = "/apis/ray/v1alpha/orgs/{org}/environments/{environment}/computepools".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createRayV1alphaComputePoolValidateBeforeCall(String environment, String org, RayV1alphaComputePool rayV1alphaComputePool, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling createRayV1alphaComputePool(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling createRayV1alphaComputePool(Async)");
        }
        if (rayV1alphaComputePool == null) {
            throw new ApiException("Missing the required parameter 'rayV1alphaComputePool' when calling createRayV1alphaComputePool(Async)");
        }
        return this.createRayV1alphaComputePoolCall(environment, org, rayV1alphaComputePool, _callback);
    }

    public RayV1alphaComputePool createRayV1alphaComputePool(String environment, String org, RayV1alphaComputePool rayV1alphaComputePool) throws ApiException {
        ApiResponse<RayV1alphaComputePool> localVarResp = this.createRayV1alphaComputePoolWithHttpInfo(environment, org, rayV1alphaComputePool);
        return localVarResp.getData();
    }

    public ApiResponse<RayV1alphaComputePool> createRayV1alphaComputePoolWithHttpInfo(String environment, String org, RayV1alphaComputePool rayV1alphaComputePool) throws ApiException {
        Call localVarCall = this.createRayV1alphaComputePoolValidateBeforeCall(environment, org, rayV1alphaComputePool, null);
        Type localVarReturnType = new TypeToken<RayV1alphaComputePool>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createRayV1alphaComputePoolAsync(String environment, String org, RayV1alphaComputePool rayV1alphaComputePool, ApiCallback<RayV1alphaComputePool> _callback) throws ApiException {
        Call localVarCall = this.createRayV1alphaComputePoolValidateBeforeCall(environment, org, rayV1alphaComputePool, _callback);
        Type localVarReturnType = new TypeToken<RayV1alphaComputePool>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteRayV1alphaComputePoolCall(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/ray/v1alpha/orgs/{org}/environments/{environment}/computepools/{name}".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (propagationPolicy != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("propagationPolicy", propagationPolicy));
        }
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if (uid != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("uid", uid));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteRayV1alphaComputePoolValidateBeforeCall(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling deleteRayV1alphaComputePool(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling deleteRayV1alphaComputePool(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling deleteRayV1alphaComputePool(Async)");
        }
        return this.deleteRayV1alphaComputePoolCall(environment, name, org, propagationPolicy, resourceVersion, uid, _callback);
    }

    public RayV1alphaComputePool deleteRayV1alphaComputePool(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid) throws ApiException {
        ApiResponse<RayV1alphaComputePool> localVarResp = this.deleteRayV1alphaComputePoolWithHttpInfo(environment, name, org, propagationPolicy, resourceVersion, uid);
        return localVarResp.getData();
    }

    public ApiResponse<RayV1alphaComputePool> deleteRayV1alphaComputePoolWithHttpInfo(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid) throws ApiException {
        Call localVarCall = this.deleteRayV1alphaComputePoolValidateBeforeCall(environment, name, org, propagationPolicy, resourceVersion, uid, null);
        Type localVarReturnType = new TypeToken<RayV1alphaComputePool>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call deleteRayV1alphaComputePoolAsync(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid, ApiCallback<RayV1alphaComputePool> _callback) throws ApiException {
        Call localVarCall = this.deleteRayV1alphaComputePoolValidateBeforeCall(environment, name, org, propagationPolicy, resourceVersion, uid, _callback);
        Type localVarReturnType = new TypeToken<RayV1alphaComputePool>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listRayV1alphaComputePoolsCall(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/ray/v1alpha/orgs/{org}/environments/{environment}/computepools".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (_continue != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("continue", _continue));
        }
        if (eventuallyConsistent != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("eventuallyConsistent", eventuallyConsistent));
        }
        if (fieldSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldSelector", fieldSelector));
        }
        if (labelSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("labelSelector", labelSelector));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listRayV1alphaComputePoolsValidateBeforeCall(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling listRayV1alphaComputePools(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling listRayV1alphaComputePools(Async)");
        }
        return this.listRayV1alphaComputePoolsCall(environment, org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
    }

    public RayV1alphaComputePoolList listRayV1alphaComputePools(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        ApiResponse<RayV1alphaComputePoolList> localVarResp = this.listRayV1alphaComputePoolsWithHttpInfo(environment, org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit);
        return localVarResp.getData();
    }

    public ApiResponse<RayV1alphaComputePoolList> listRayV1alphaComputePoolsWithHttpInfo(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        Call localVarCall = this.listRayV1alphaComputePoolsValidateBeforeCall(environment, org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, null);
        Type localVarReturnType = new TypeToken<RayV1alphaComputePoolList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listRayV1alphaComputePoolsAsync(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback<RayV1alphaComputePoolList> _callback) throws ApiException {
        Call localVarCall = this.listRayV1alphaComputePoolsValidateBeforeCall(environment, org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
        Type localVarReturnType = new TypeToken<RayV1alphaComputePoolList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listRayV1alphaComputePoolsForAllEnvironmentsCall(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/ray/v1alpha/orgs/{org}/computepools".replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (_continue != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("continue", _continue));
        }
        if (eventuallyConsistent != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("eventuallyConsistent", eventuallyConsistent));
        }
        if (fieldSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldSelector", fieldSelector));
        }
        if (labelSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("labelSelector", labelSelector));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listRayV1alphaComputePoolsForAllEnvironmentsValidateBeforeCall(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling listRayV1alphaComputePoolsForAllEnvironments(Async)");
        }
        return this.listRayV1alphaComputePoolsForAllEnvironmentsCall(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
    }

    public RayV1alphaComputePoolList listRayV1alphaComputePoolsForAllEnvironments(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        ApiResponse<RayV1alphaComputePoolList> localVarResp = this.listRayV1alphaComputePoolsForAllEnvironmentsWithHttpInfo(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit);
        return localVarResp.getData();
    }

    public ApiResponse<RayV1alphaComputePoolList> listRayV1alphaComputePoolsForAllEnvironmentsWithHttpInfo(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        Call localVarCall = this.listRayV1alphaComputePoolsForAllEnvironmentsValidateBeforeCall(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, null);
        Type localVarReturnType = new TypeToken<RayV1alphaComputePoolList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listRayV1alphaComputePoolsForAllEnvironmentsAsync(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback<RayV1alphaComputePoolList> _callback) throws ApiException {
        Call localVarCall = this.listRayV1alphaComputePoolsForAllEnvironmentsValidateBeforeCall(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
        Type localVarReturnType = new TypeToken<RayV1alphaComputePoolList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call patchRayV1alphaComputePoolCall(String environment, String name, String org, RayV1alphaComputePool rayV1alphaComputePool, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        RayV1alphaComputePool localVarPostBody = rayV1alphaComputePool;
        String localVarPath = "/apis/ray/v1alpha/orgs/{org}/environments/{environment}/computepools/{name}".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json-patch+json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchRayV1alphaComputePoolValidateBeforeCall(String environment, String name, String org, RayV1alphaComputePool rayV1alphaComputePool, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling patchRayV1alphaComputePool(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling patchRayV1alphaComputePool(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling patchRayV1alphaComputePool(Async)");
        }
        if (rayV1alphaComputePool == null) {
            throw new ApiException("Missing the required parameter 'rayV1alphaComputePool' when calling patchRayV1alphaComputePool(Async)");
        }
        return this.patchRayV1alphaComputePoolCall(environment, name, org, rayV1alphaComputePool, _callback);
    }

    public RayV1alphaComputePool patchRayV1alphaComputePool(String environment, String name, String org, RayV1alphaComputePool rayV1alphaComputePool) throws ApiException {
        ApiResponse<RayV1alphaComputePool> localVarResp = this.patchRayV1alphaComputePoolWithHttpInfo(environment, name, org, rayV1alphaComputePool);
        return localVarResp.getData();
    }

    public ApiResponse<RayV1alphaComputePool> patchRayV1alphaComputePoolWithHttpInfo(String environment, String name, String org, RayV1alphaComputePool rayV1alphaComputePool) throws ApiException {
        Call localVarCall = this.patchRayV1alphaComputePoolValidateBeforeCall(environment, name, org, rayV1alphaComputePool, null);
        Type localVarReturnType = new TypeToken<RayV1alphaComputePool>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call patchRayV1alphaComputePoolAsync(String environment, String name, String org, RayV1alphaComputePool rayV1alphaComputePool, ApiCallback<RayV1alphaComputePool> _callback) throws ApiException {
        Call localVarCall = this.patchRayV1alphaComputePoolValidateBeforeCall(environment, name, org, rayV1alphaComputePool, _callback);
        Type localVarReturnType = new TypeToken<RayV1alphaComputePool>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call patchRayV1alphaComputePoolFinalizersCall(String environment, String name, String org, RayV1alphaComputePool rayV1alphaComputePool, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        RayV1alphaComputePool localVarPostBody = rayV1alphaComputePool;
        String localVarPath = "/apis/ray/v1alpha/orgs/{org}/environments/{environment}/computepools/{name}/finalizers".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json-patch+json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchRayV1alphaComputePoolFinalizersValidateBeforeCall(String environment, String name, String org, RayV1alphaComputePool rayV1alphaComputePool, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling patchRayV1alphaComputePoolFinalizers(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling patchRayV1alphaComputePoolFinalizers(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling patchRayV1alphaComputePoolFinalizers(Async)");
        }
        if (rayV1alphaComputePool == null) {
            throw new ApiException("Missing the required parameter 'rayV1alphaComputePool' when calling patchRayV1alphaComputePoolFinalizers(Async)");
        }
        return this.patchRayV1alphaComputePoolFinalizersCall(environment, name, org, rayV1alphaComputePool, _callback);
    }

    public RayV1alphaComputePool patchRayV1alphaComputePoolFinalizers(String environment, String name, String org, RayV1alphaComputePool rayV1alphaComputePool) throws ApiException {
        ApiResponse<RayV1alphaComputePool> localVarResp = this.patchRayV1alphaComputePoolFinalizersWithHttpInfo(environment, name, org, rayV1alphaComputePool);
        return localVarResp.getData();
    }

    public ApiResponse<RayV1alphaComputePool> patchRayV1alphaComputePoolFinalizersWithHttpInfo(String environment, String name, String org, RayV1alphaComputePool rayV1alphaComputePool) throws ApiException {
        Call localVarCall = this.patchRayV1alphaComputePoolFinalizersValidateBeforeCall(environment, name, org, rayV1alphaComputePool, null);
        Type localVarReturnType = new TypeToken<RayV1alphaComputePool>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call patchRayV1alphaComputePoolFinalizersAsync(String environment, String name, String org, RayV1alphaComputePool rayV1alphaComputePool, ApiCallback<RayV1alphaComputePool> _callback) throws ApiException {
        Call localVarCall = this.patchRayV1alphaComputePoolFinalizersValidateBeforeCall(environment, name, org, rayV1alphaComputePool, _callback);
        Type localVarReturnType = new TypeToken<RayV1alphaComputePool>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call patchRayV1alphaComputePoolStatusCall(String environment, String name, String org, RayV1alphaComputePool rayV1alphaComputePool, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        RayV1alphaComputePool localVarPostBody = rayV1alphaComputePool;
        String localVarPath = "/apis/ray/v1alpha/orgs/{org}/environments/{environment}/computepools/{name}/status".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json-patch+json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchRayV1alphaComputePoolStatusValidateBeforeCall(String environment, String name, String org, RayV1alphaComputePool rayV1alphaComputePool, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling patchRayV1alphaComputePoolStatus(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling patchRayV1alphaComputePoolStatus(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling patchRayV1alphaComputePoolStatus(Async)");
        }
        if (rayV1alphaComputePool == null) {
            throw new ApiException("Missing the required parameter 'rayV1alphaComputePool' when calling patchRayV1alphaComputePoolStatus(Async)");
        }
        return this.patchRayV1alphaComputePoolStatusCall(environment, name, org, rayV1alphaComputePool, _callback);
    }

    public RayV1alphaComputePool patchRayV1alphaComputePoolStatus(String environment, String name, String org, RayV1alphaComputePool rayV1alphaComputePool) throws ApiException {
        ApiResponse<RayV1alphaComputePool> localVarResp = this.patchRayV1alphaComputePoolStatusWithHttpInfo(environment, name, org, rayV1alphaComputePool);
        return localVarResp.getData();
    }

    public ApiResponse<RayV1alphaComputePool> patchRayV1alphaComputePoolStatusWithHttpInfo(String environment, String name, String org, RayV1alphaComputePool rayV1alphaComputePool) throws ApiException {
        Call localVarCall = this.patchRayV1alphaComputePoolStatusValidateBeforeCall(environment, name, org, rayV1alphaComputePool, null);
        Type localVarReturnType = new TypeToken<RayV1alphaComputePool>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call patchRayV1alphaComputePoolStatusAsync(String environment, String name, String org, RayV1alphaComputePool rayV1alphaComputePool, ApiCallback<RayV1alphaComputePool> _callback) throws ApiException {
        Call localVarCall = this.patchRayV1alphaComputePoolStatusValidateBeforeCall(environment, name, org, rayV1alphaComputePool, _callback);
        Type localVarReturnType = new TypeToken<RayV1alphaComputePool>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call readRayV1alphaComputePoolCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/ray/v1alpha/orgs/{org}/environments/{environment}/computepools/{name}".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call readRayV1alphaComputePoolValidateBeforeCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling readRayV1alphaComputePool(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling readRayV1alphaComputePool(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling readRayV1alphaComputePool(Async)");
        }
        return this.readRayV1alphaComputePoolCall(environment, name, org, resourceVersion, _callback);
    }

    public RayV1alphaComputePool readRayV1alphaComputePool(String environment, String name, String org, String resourceVersion) throws ApiException {
        ApiResponse<RayV1alphaComputePool> localVarResp = this.readRayV1alphaComputePoolWithHttpInfo(environment, name, org, resourceVersion);
        return localVarResp.getData();
    }

    public ApiResponse<RayV1alphaComputePool> readRayV1alphaComputePoolWithHttpInfo(String environment, String name, String org, String resourceVersion) throws ApiException {
        Call localVarCall = this.readRayV1alphaComputePoolValidateBeforeCall(environment, name, org, resourceVersion, null);
        Type localVarReturnType = new TypeToken<RayV1alphaComputePool>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call readRayV1alphaComputePoolAsync(String environment, String name, String org, String resourceVersion, ApiCallback<RayV1alphaComputePool> _callback) throws ApiException {
        Call localVarCall = this.readRayV1alphaComputePoolValidateBeforeCall(environment, name, org, resourceVersion, _callback);
        Type localVarReturnType = new TypeToken<RayV1alphaComputePool>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call readRayV1alphaComputePoolFinalizersCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/ray/v1alpha/orgs/{org}/environments/{environment}/computepools/{name}/finalizers".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call readRayV1alphaComputePoolFinalizersValidateBeforeCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling readRayV1alphaComputePoolFinalizers(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling readRayV1alphaComputePoolFinalizers(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling readRayV1alphaComputePoolFinalizers(Async)");
        }
        return this.readRayV1alphaComputePoolFinalizersCall(environment, name, org, resourceVersion, _callback);
    }

    public RayV1alphaComputePool readRayV1alphaComputePoolFinalizers(String environment, String name, String org, String resourceVersion) throws ApiException {
        ApiResponse<RayV1alphaComputePool> localVarResp = this.readRayV1alphaComputePoolFinalizersWithHttpInfo(environment, name, org, resourceVersion);
        return localVarResp.getData();
    }

    public ApiResponse<RayV1alphaComputePool> readRayV1alphaComputePoolFinalizersWithHttpInfo(String environment, String name, String org, String resourceVersion) throws ApiException {
        Call localVarCall = this.readRayV1alphaComputePoolFinalizersValidateBeforeCall(environment, name, org, resourceVersion, null);
        Type localVarReturnType = new TypeToken<RayV1alphaComputePool>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call readRayV1alphaComputePoolFinalizersAsync(String environment, String name, String org, String resourceVersion, ApiCallback<RayV1alphaComputePool> _callback) throws ApiException {
        Call localVarCall = this.readRayV1alphaComputePoolFinalizersValidateBeforeCall(environment, name, org, resourceVersion, _callback);
        Type localVarReturnType = new TypeToken<RayV1alphaComputePool>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call readRayV1alphaComputePoolStatusCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/ray/v1alpha/orgs/{org}/environments/{environment}/computepools/{name}/status".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call readRayV1alphaComputePoolStatusValidateBeforeCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling readRayV1alphaComputePoolStatus(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling readRayV1alphaComputePoolStatus(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling readRayV1alphaComputePoolStatus(Async)");
        }
        return this.readRayV1alphaComputePoolStatusCall(environment, name, org, resourceVersion, _callback);
    }

    public RayV1alphaComputePool readRayV1alphaComputePoolStatus(String environment, String name, String org, String resourceVersion) throws ApiException {
        ApiResponse<RayV1alphaComputePool> localVarResp = this.readRayV1alphaComputePoolStatusWithHttpInfo(environment, name, org, resourceVersion);
        return localVarResp.getData();
    }

    public ApiResponse<RayV1alphaComputePool> readRayV1alphaComputePoolStatusWithHttpInfo(String environment, String name, String org, String resourceVersion) throws ApiException {
        Call localVarCall = this.readRayV1alphaComputePoolStatusValidateBeforeCall(environment, name, org, resourceVersion, null);
        Type localVarReturnType = new TypeToken<RayV1alphaComputePool>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call readRayV1alphaComputePoolStatusAsync(String environment, String name, String org, String resourceVersion, ApiCallback<RayV1alphaComputePool> _callback) throws ApiException {
        Call localVarCall = this.readRayV1alphaComputePoolStatusValidateBeforeCall(environment, name, org, resourceVersion, _callback);
        Type localVarReturnType = new TypeToken<RayV1alphaComputePool>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateRayV1alphaComputePoolCall(String environment, String name, String org, RayV1alphaComputePool rayV1alphaComputePool, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        RayV1alphaComputePool localVarPostBody = rayV1alphaComputePool;
        String localVarPath = "/apis/ray/v1alpha/orgs/{org}/environments/{environment}/computepools/{name}".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateRayV1alphaComputePoolValidateBeforeCall(String environment, String name, String org, RayV1alphaComputePool rayV1alphaComputePool, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling updateRayV1alphaComputePool(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling updateRayV1alphaComputePool(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling updateRayV1alphaComputePool(Async)");
        }
        if (rayV1alphaComputePool == null) {
            throw new ApiException("Missing the required parameter 'rayV1alphaComputePool' when calling updateRayV1alphaComputePool(Async)");
        }
        return this.updateRayV1alphaComputePoolCall(environment, name, org, rayV1alphaComputePool, _callback);
    }

    public RayV1alphaComputePool updateRayV1alphaComputePool(String environment, String name, String org, RayV1alphaComputePool rayV1alphaComputePool) throws ApiException {
        ApiResponse<RayV1alphaComputePool> localVarResp = this.updateRayV1alphaComputePoolWithHttpInfo(environment, name, org, rayV1alphaComputePool);
        return localVarResp.getData();
    }

    public ApiResponse<RayV1alphaComputePool> updateRayV1alphaComputePoolWithHttpInfo(String environment, String name, String org, RayV1alphaComputePool rayV1alphaComputePool) throws ApiException {
        Call localVarCall = this.updateRayV1alphaComputePoolValidateBeforeCall(environment, name, org, rayV1alphaComputePool, null);
        Type localVarReturnType = new TypeToken<RayV1alphaComputePool>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateRayV1alphaComputePoolAsync(String environment, String name, String org, RayV1alphaComputePool rayV1alphaComputePool, ApiCallback<RayV1alphaComputePool> _callback) throws ApiException {
        Call localVarCall = this.updateRayV1alphaComputePoolValidateBeforeCall(environment, name, org, rayV1alphaComputePool, _callback);
        Type localVarReturnType = new TypeToken<RayV1alphaComputePool>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateRayV1alphaComputePoolFinalizersCall(String environment, String name, String org, RayV1alphaComputePool rayV1alphaComputePool, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        RayV1alphaComputePool localVarPostBody = rayV1alphaComputePool;
        String localVarPath = "/apis/ray/v1alpha/orgs/{org}/environments/{environment}/computepools/{name}/finalizers".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateRayV1alphaComputePoolFinalizersValidateBeforeCall(String environment, String name, String org, RayV1alphaComputePool rayV1alphaComputePool, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling updateRayV1alphaComputePoolFinalizers(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling updateRayV1alphaComputePoolFinalizers(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling updateRayV1alphaComputePoolFinalizers(Async)");
        }
        if (rayV1alphaComputePool == null) {
            throw new ApiException("Missing the required parameter 'rayV1alphaComputePool' when calling updateRayV1alphaComputePoolFinalizers(Async)");
        }
        return this.updateRayV1alphaComputePoolFinalizersCall(environment, name, org, rayV1alphaComputePool, _callback);
    }

    public RayV1alphaComputePool updateRayV1alphaComputePoolFinalizers(String environment, String name, String org, RayV1alphaComputePool rayV1alphaComputePool) throws ApiException {
        ApiResponse<RayV1alphaComputePool> localVarResp = this.updateRayV1alphaComputePoolFinalizersWithHttpInfo(environment, name, org, rayV1alphaComputePool);
        return localVarResp.getData();
    }

    public ApiResponse<RayV1alphaComputePool> updateRayV1alphaComputePoolFinalizersWithHttpInfo(String environment, String name, String org, RayV1alphaComputePool rayV1alphaComputePool) throws ApiException {
        Call localVarCall = this.updateRayV1alphaComputePoolFinalizersValidateBeforeCall(environment, name, org, rayV1alphaComputePool, null);
        Type localVarReturnType = new TypeToken<RayV1alphaComputePool>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateRayV1alphaComputePoolFinalizersAsync(String environment, String name, String org, RayV1alphaComputePool rayV1alphaComputePool, ApiCallback<RayV1alphaComputePool> _callback) throws ApiException {
        Call localVarCall = this.updateRayV1alphaComputePoolFinalizersValidateBeforeCall(environment, name, org, rayV1alphaComputePool, _callback);
        Type localVarReturnType = new TypeToken<RayV1alphaComputePool>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateRayV1alphaComputePoolStatusCall(String environment, String name, String org, RayV1alphaComputePool rayV1alphaComputePool, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        RayV1alphaComputePool localVarPostBody = rayV1alphaComputePool;
        String localVarPath = "/apis/ray/v1alpha/orgs/{org}/environments/{environment}/computepools/{name}/status".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateRayV1alphaComputePoolStatusValidateBeforeCall(String environment, String name, String org, RayV1alphaComputePool rayV1alphaComputePool, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling updateRayV1alphaComputePoolStatus(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling updateRayV1alphaComputePoolStatus(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling updateRayV1alphaComputePoolStatus(Async)");
        }
        if (rayV1alphaComputePool == null) {
            throw new ApiException("Missing the required parameter 'rayV1alphaComputePool' when calling updateRayV1alphaComputePoolStatus(Async)");
        }
        return this.updateRayV1alphaComputePoolStatusCall(environment, name, org, rayV1alphaComputePool, _callback);
    }

    public RayV1alphaComputePool updateRayV1alphaComputePoolStatus(String environment, String name, String org, RayV1alphaComputePool rayV1alphaComputePool) throws ApiException {
        ApiResponse<RayV1alphaComputePool> localVarResp = this.updateRayV1alphaComputePoolStatusWithHttpInfo(environment, name, org, rayV1alphaComputePool);
        return localVarResp.getData();
    }

    public ApiResponse<RayV1alphaComputePool> updateRayV1alphaComputePoolStatusWithHttpInfo(String environment, String name, String org, RayV1alphaComputePool rayV1alphaComputePool) throws ApiException {
        Call localVarCall = this.updateRayV1alphaComputePoolStatusValidateBeforeCall(environment, name, org, rayV1alphaComputePool, null);
        Type localVarReturnType = new TypeToken<RayV1alphaComputePool>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateRayV1alphaComputePoolStatusAsync(String environment, String name, String org, RayV1alphaComputePool rayV1alphaComputePool, ApiCallback<RayV1alphaComputePool> _callback) throws ApiException {
        Call localVarCall = this.updateRayV1alphaComputePoolStatusValidateBeforeCall(environment, name, org, rayV1alphaComputePool, _callback);
        Type localVarReturnType = new TypeToken<RayV1alphaComputePool>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

