/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.flink.apiserver.client.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.confluent.flink.apiserver.client.JSON;
import io.confluent.flink.apiserver.client.model.FlinkV1FlinkResources;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class FlinkV1RuntimeSpec
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_ATTRIBUTES = "attributes";
    @SerializedName(value="attributes")
    private Map<String, String> attributes = new HashMap<String, String>();
    public static final String SERIALIZED_NAME_CONFIGURATION = "configuration";
    @SerializedName(value="configuration")
    private Map<String, String> _configuration = new HashMap<String, String>();
    public static final String SERIALIZED_NAME_FLINK_LIMITS = "flinkLimits";
    @SerializedName(value="flinkLimits")
    private FlinkV1FlinkResources flinkLimits;
    public static final String SERIALIZED_NAME_FLINK_RESOURCES = "flinkResources";
    @SerializedName(value="flinkResources")
    private FlinkV1FlinkResources flinkResources;
    public static final String SERIALIZED_NAME_IMAGE = "image";
    @SerializedName(value="image")
    private String image = "";
    public static final String SERIALIZED_NAME_IMAGE_PULL_POLICY = "imagePullPolicy";
    @SerializedName(value="imagePullPolicy")
    private ImagePullPolicyEnum imagePullPolicy;
    public static final String SERIALIZED_NAME_LOGGING_CONFIGURATION_NAME = "loggingConfigurationName";
    @SerializedName(value="loggingConfigurationName")
    private String loggingConfigurationName;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public FlinkV1RuntimeSpec attributes(Map<String, String> attributes) {
        this.attributes = attributes;
        return this;
    }

    public FlinkV1RuntimeSpec putAttributesItem(String key, String attributesItem) {
        if (this.attributes == null) {
            this.attributes = new HashMap<String, String>();
        }
        this.attributes.put(key, attributesItem);
        return this;
    }

    @Nullable
    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<String, String> attributes) {
        this.attributes = attributes;
    }

    public FlinkV1RuntimeSpec _configuration(Map<String, String> _configuration) {
        this._configuration = _configuration;
        return this;
    }

    public FlinkV1RuntimeSpec putConfigurationItem(String key, String _configurationItem) {
        if (this._configuration == null) {
            this._configuration = new HashMap<String, String>();
        }
        this._configuration.put(key, _configurationItem);
        return this;
    }

    @Nullable
    public Map<String, String> getConfiguration() {
        return this._configuration;
    }

    public void setConfiguration(Map<String, String> _configuration) {
        this._configuration = _configuration;
    }

    public FlinkV1RuntimeSpec flinkLimits(FlinkV1FlinkResources flinkLimits) {
        this.flinkLimits = flinkLimits;
        return this;
    }

    @Nullable
    public FlinkV1FlinkResources getFlinkLimits() {
        return this.flinkLimits;
    }

    public void setFlinkLimits(FlinkV1FlinkResources flinkLimits) {
        this.flinkLimits = flinkLimits;
    }

    public FlinkV1RuntimeSpec flinkResources(FlinkV1FlinkResources flinkResources) {
        this.flinkResources = flinkResources;
        return this;
    }

    @Nullable
    public FlinkV1FlinkResources getFlinkResources() {
        return this.flinkResources;
    }

    public void setFlinkResources(FlinkV1FlinkResources flinkResources) {
        this.flinkResources = flinkResources;
    }

    public FlinkV1RuntimeSpec image(String image) {
        this.image = image;
        return this;
    }

    @Nonnull
    public String getImage() {
        return this.image;
    }

    public void setImage(String image) {
        this.image = image;
    }

    public FlinkV1RuntimeSpec imagePullPolicy(ImagePullPolicyEnum imagePullPolicy) {
        this.imagePullPolicy = imagePullPolicy;
        return this;
    }

    @Nonnull
    public ImagePullPolicyEnum getImagePullPolicy() {
        return this.imagePullPolicy;
    }

    public void setImagePullPolicy(ImagePullPolicyEnum imagePullPolicy) {
        this.imagePullPolicy = imagePullPolicy;
    }

    public FlinkV1RuntimeSpec loggingConfigurationName(String loggingConfigurationName) {
        this.loggingConfigurationName = loggingConfigurationName;
        return this;
    }

    @Nullable
    public String getLoggingConfigurationName() {
        return this.loggingConfigurationName;
    }

    public void setLoggingConfigurationName(String loggingConfigurationName) {
        this.loggingConfigurationName = loggingConfigurationName;
    }

    public FlinkV1RuntimeSpec putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FlinkV1RuntimeSpec flinkV1RuntimeSpec = (FlinkV1RuntimeSpec)o;
        return Objects.equals(this.attributes, flinkV1RuntimeSpec.attributes) && Objects.equals(this._configuration, flinkV1RuntimeSpec._configuration) && Objects.equals(this.flinkLimits, flinkV1RuntimeSpec.flinkLimits) && Objects.equals(this.flinkResources, flinkV1RuntimeSpec.flinkResources) && Objects.equals(this.image, flinkV1RuntimeSpec.image) && Objects.equals((Object)this.imagePullPolicy, (Object)flinkV1RuntimeSpec.imagePullPolicy) && Objects.equals(this.loggingConfigurationName, flinkV1RuntimeSpec.loggingConfigurationName) && Objects.equals(this.additionalProperties, flinkV1RuntimeSpec.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.attributes, this._configuration, this.flinkLimits, this.flinkResources, this.image, this.imagePullPolicy, this.loggingConfigurationName, this.additionalProperties});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FlinkV1RuntimeSpec {\n");
        sb.append("    attributes: ").append(this.toIndentedString(this.attributes)).append("\n");
        sb.append("    _configuration: ").append(this.toIndentedString(this._configuration)).append("\n");
        sb.append("    flinkLimits: ").append(this.toIndentedString(this.flinkLimits)).append("\n");
        sb.append("    flinkResources: ").append(this.toIndentedString(this.flinkResources)).append("\n");
        sb.append("    image: ").append(this.toIndentedString(this.image)).append("\n");
        sb.append("    imagePullPolicy: ").append(this.toIndentedString((Object)this.imagePullPolicy)).append("\n");
        sb.append("    loggingConfigurationName: ").append(this.toIndentedString(this.loggingConfigurationName)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in FlinkV1RuntimeSpec is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (!jsonObj.get(SERIALIZED_NAME_IMAGE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `image` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_IMAGE).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_IMAGE_PULL_POLICY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `imagePullPolicy` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_IMAGE_PULL_POLICY).toString()));
        }
        ImagePullPolicyEnum.validateJsonElement(jsonObj.get(SERIALIZED_NAME_IMAGE_PULL_POLICY));
        if (jsonObj.get(SERIALIZED_NAME_LOGGING_CONFIGURATION_NAME) != null && !jsonObj.get(SERIALIZED_NAME_LOGGING_CONFIGURATION_NAME).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_LOGGING_CONFIGURATION_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `loggingConfigurationName` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_LOGGING_CONFIGURATION_NAME).toString()));
        }
    }

    public static FlinkV1RuntimeSpec fromJson(String jsonString) throws IOException {
        return (FlinkV1RuntimeSpec)JSON.getGson().fromJson(jsonString, FlinkV1RuntimeSpec.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ATTRIBUTES);
        openapiFields.add(SERIALIZED_NAME_CONFIGURATION);
        openapiFields.add(SERIALIZED_NAME_FLINK_LIMITS);
        openapiFields.add(SERIALIZED_NAME_FLINK_RESOURCES);
        openapiFields.add(SERIALIZED_NAME_IMAGE);
        openapiFields.add(SERIALIZED_NAME_IMAGE_PULL_POLICY);
        openapiFields.add(SERIALIZED_NAME_LOGGING_CONFIGURATION_NAME);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_IMAGE);
        openapiRequiredFields.add(SERIALIZED_NAME_IMAGE_PULL_POLICY);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!FlinkV1RuntimeSpec.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(FlinkV1RuntimeSpec.class));
            return new TypeAdapter<FlinkV1RuntimeSpec>(){

                public void write(JsonWriter out, FlinkV1RuntimeSpec value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            JsonElement jsonElement = gson.toJsonTree(entry.getValue());
                            if (jsonElement.isJsonArray()) {
                                obj.add(entry.getKey(), (JsonElement)jsonElement.getAsJsonArray());
                                continue;
                            }
                            obj.add(entry.getKey(), (JsonElement)jsonElement.getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, (Object)obj);
                }

                public FlinkV1RuntimeSpec read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    FlinkV1RuntimeSpec.validateJsonElement(jsonElement);
                    JsonObject jsonObj = jsonElement.getAsJsonObject();
                    FlinkV1RuntimeSpec instance = (FlinkV1RuntimeSpec)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                    for (Map.Entry entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsNumber());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), ((JsonElement)entry.getValue()).toString()));
                        }
                        if (((JsonElement)entry.getValue()).isJsonArray()) {
                            instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), List.class));
                            continue;
                        }
                        instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ImagePullPolicyEnum {
        ALWAYS("Always"),
        IF_NOT_PRESENT("IfNotPresent"),
        NEVER("Never");

        private String value;

        private ImagePullPolicyEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ImagePullPolicyEnum fromValue(String value) {
            for (ImagePullPolicyEnum b : ImagePullPolicyEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static void validateJsonElement(JsonElement jsonElement) throws IOException {
            String value = jsonElement.getAsString();
            ImagePullPolicyEnum.fromValue(value);
        }

        public static class Adapter
        extends TypeAdapter<ImagePullPolicyEnum> {
            public void write(JsonWriter jsonWriter, ImagePullPolicyEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public ImagePullPolicyEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ImagePullPolicyEnum.fromValue(value);
            }
        }
    }
}

