/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.flink.apiserver.client.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.confluent.flink.apiserver.client.JSON;
import io.confluent.flink.apiserver.client.model.FlinkV1ScalingStatus;
import io.confluent.flink.apiserver.client.model.SqlV3StatementResultsSpec;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.io.Serializable;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class SqlV3StatementStatus
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_DETAIL = "detail";
    @SerializedName(value="detail")
    private String detail;
    public static final String SERIALIZED_NAME_EXPIRATION_TIMESTAMP = "expirationTimestamp";
    @SerializedName(value="expirationTimestamp")
    private OffsetDateTime expirationTimestamp;
    public static final String SERIALIZED_NAME_FAILURE_REASON = "failureReason";
    @SerializedName(value="failureReason")
    private String failureReason;
    public static final String SERIALIZED_NAME_JOB_ID = "jobId";
    @SerializedName(value="jobId")
    private String jobId;
    public static final String SERIALIZED_NAME_LATEST_OFFSETS = "latestOffsets";
    @SerializedName(value="latestOffsets")
    private Map<String, String> latestOffsets = new HashMap<String, String>();
    public static final String SERIALIZED_NAME_LATEST_OFFSETS_TIMESTAMP = "latestOffsetsTimestamp";
    @SerializedName(value="latestOffsetsTimestamp")
    private OffsetDateTime latestOffsetsTimestamp;
    public static final String SERIALIZED_NAME_PHASE = "phase";
    @SerializedName(value="phase")
    private PhaseEnum phase;
    public static final String SERIALIZED_NAME_REST_SERVICE = "restService";
    @SerializedName(value="restService")
    private String restService;
    public static final String SERIALIZED_NAME_RESULTS = "results";
    @SerializedName(value="results")
    private SqlV3StatementResultsSpec results;
    public static final String SERIALIZED_NAME_SCALING_STATUS = "scalingStatus";
    @SerializedName(value="scalingStatus")
    private FlinkV1ScalingStatus scalingStatus;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public SqlV3StatementStatus detail(String detail) {
        this.detail = detail;
        return this;
    }

    @Nullable
    public String getDetail() {
        return this.detail;
    }

    public void setDetail(String detail) {
        this.detail = detail;
    }

    public SqlV3StatementStatus expirationTimestamp(OffsetDateTime expirationTimestamp) {
        this.expirationTimestamp = expirationTimestamp;
        return this;
    }

    @Nullable
    public OffsetDateTime getExpirationTimestamp() {
        return this.expirationTimestamp;
    }

    public void setExpirationTimestamp(OffsetDateTime expirationTimestamp) {
        this.expirationTimestamp = expirationTimestamp;
    }

    public SqlV3StatementStatus failureReason(String failureReason) {
        this.failureReason = failureReason;
        return this;
    }

    @Nullable
    public String getFailureReason() {
        return this.failureReason;
    }

    public void setFailureReason(String failureReason) {
        this.failureReason = failureReason;
    }

    public SqlV3StatementStatus jobId(String jobId) {
        this.jobId = jobId;
        return this;
    }

    @Nullable
    public String getJobId() {
        return this.jobId;
    }

    public void setJobId(String jobId) {
        this.jobId = jobId;
    }

    public SqlV3StatementStatus latestOffsets(Map<String, String> latestOffsets) {
        this.latestOffsets = latestOffsets;
        return this;
    }

    public SqlV3StatementStatus putLatestOffsetsItem(String key, String latestOffsetsItem) {
        if (this.latestOffsets == null) {
            this.latestOffsets = new HashMap<String, String>();
        }
        this.latestOffsets.put(key, latestOffsetsItem);
        return this;
    }

    @Nullable
    public Map<String, String> getLatestOffsets() {
        return this.latestOffsets;
    }

    public void setLatestOffsets(Map<String, String> latestOffsets) {
        this.latestOffsets = latestOffsets;
    }

    public SqlV3StatementStatus latestOffsetsTimestamp(OffsetDateTime latestOffsetsTimestamp) {
        this.latestOffsetsTimestamp = latestOffsetsTimestamp;
        return this;
    }

    @Nullable
    public OffsetDateTime getLatestOffsetsTimestamp() {
        return this.latestOffsetsTimestamp;
    }

    public void setLatestOffsetsTimestamp(OffsetDateTime latestOffsetsTimestamp) {
        this.latestOffsetsTimestamp = latestOffsetsTimestamp;
    }

    public SqlV3StatementStatus phase(PhaseEnum phase) {
        this.phase = phase;
        return this;
    }

    @Nullable
    public PhaseEnum getPhase() {
        return this.phase;
    }

    public void setPhase(PhaseEnum phase) {
        this.phase = phase;
    }

    public SqlV3StatementStatus restService(String restService) {
        this.restService = restService;
        return this;
    }

    @Nullable
    public String getRestService() {
        return this.restService;
    }

    public void setRestService(String restService) {
        this.restService = restService;
    }

    public SqlV3StatementStatus results(SqlV3StatementResultsSpec results) {
        this.results = results;
        return this;
    }

    @Nullable
    public SqlV3StatementResultsSpec getResults() {
        return this.results;
    }

    public void setResults(SqlV3StatementResultsSpec results) {
        this.results = results;
    }

    public SqlV3StatementStatus scalingStatus(FlinkV1ScalingStatus scalingStatus) {
        this.scalingStatus = scalingStatus;
        return this;
    }

    @Nullable
    public FlinkV1ScalingStatus getScalingStatus() {
        return this.scalingStatus;
    }

    public void setScalingStatus(FlinkV1ScalingStatus scalingStatus) {
        this.scalingStatus = scalingStatus;
    }

    public SqlV3StatementStatus putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SqlV3StatementStatus sqlV3StatementStatus = (SqlV3StatementStatus)o;
        return Objects.equals(this.detail, sqlV3StatementStatus.detail) && Objects.equals(this.expirationTimestamp, sqlV3StatementStatus.expirationTimestamp) && Objects.equals(this.failureReason, sqlV3StatementStatus.failureReason) && Objects.equals(this.jobId, sqlV3StatementStatus.jobId) && Objects.equals(this.latestOffsets, sqlV3StatementStatus.latestOffsets) && Objects.equals(this.latestOffsetsTimestamp, sqlV3StatementStatus.latestOffsetsTimestamp) && Objects.equals((Object)this.phase, (Object)sqlV3StatementStatus.phase) && Objects.equals(this.restService, sqlV3StatementStatus.restService) && Objects.equals(this.results, sqlV3StatementStatus.results) && Objects.equals(this.scalingStatus, sqlV3StatementStatus.scalingStatus) && Objects.equals(this.additionalProperties, sqlV3StatementStatus.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.detail, this.expirationTimestamp, this.failureReason, this.jobId, this.latestOffsets, this.latestOffsetsTimestamp, this.phase, this.restService, this.results, this.scalingStatus, this.additionalProperties});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SqlV3StatementStatus {\n");
        sb.append("    detail: ").append(this.toIndentedString(this.detail)).append("\n");
        sb.append("    expirationTimestamp: ").append(this.toIndentedString(this.expirationTimestamp)).append("\n");
        sb.append("    failureReason: ").append(this.toIndentedString(this.failureReason)).append("\n");
        sb.append("    jobId: ").append(this.toIndentedString(this.jobId)).append("\n");
        sb.append("    latestOffsets: ").append(this.toIndentedString(this.latestOffsets)).append("\n");
        sb.append("    latestOffsetsTimestamp: ").append(this.toIndentedString(this.latestOffsetsTimestamp)).append("\n");
        sb.append("    phase: ").append(this.toIndentedString((Object)this.phase)).append("\n");
        sb.append("    restService: ").append(this.toIndentedString(this.restService)).append("\n");
        sb.append("    results: ").append(this.toIndentedString(this.results)).append("\n");
        sb.append("    scalingStatus: ").append(this.toIndentedString(this.scalingStatus)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in SqlV3StatementStatus is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_DETAIL) != null && !jsonObj.get(SERIALIZED_NAME_DETAIL).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_DETAIL).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `detail` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DETAIL).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_FAILURE_REASON) != null && !jsonObj.get(SERIALIZED_NAME_FAILURE_REASON).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_FAILURE_REASON).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `failureReason` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_FAILURE_REASON).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_JOB_ID) != null && !jsonObj.get(SERIALIZED_NAME_JOB_ID).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_JOB_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `jobId` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_JOB_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_PHASE) != null && !jsonObj.get(SERIALIZED_NAME_PHASE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_PHASE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `phase` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PHASE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_PHASE) != null && !jsonObj.get(SERIALIZED_NAME_PHASE).isJsonNull()) {
            PhaseEnum.validateJsonElement(jsonObj.get(SERIALIZED_NAME_PHASE));
        }
        if (jsonObj.get(SERIALIZED_NAME_REST_SERVICE) != null && !jsonObj.get(SERIALIZED_NAME_REST_SERVICE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_REST_SERVICE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `restService` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_REST_SERVICE).toString()));
        }
    }

    public static SqlV3StatementStatus fromJson(String jsonString) throws IOException {
        return (SqlV3StatementStatus)JSON.getGson().fromJson(jsonString, SqlV3StatementStatus.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_DETAIL);
        openapiFields.add(SERIALIZED_NAME_EXPIRATION_TIMESTAMP);
        openapiFields.add(SERIALIZED_NAME_FAILURE_REASON);
        openapiFields.add(SERIALIZED_NAME_JOB_ID);
        openapiFields.add(SERIALIZED_NAME_LATEST_OFFSETS);
        openapiFields.add(SERIALIZED_NAME_LATEST_OFFSETS_TIMESTAMP);
        openapiFields.add(SERIALIZED_NAME_PHASE);
        openapiFields.add(SERIALIZED_NAME_REST_SERVICE);
        openapiFields.add(SERIALIZED_NAME_RESULTS);
        openapiFields.add(SERIALIZED_NAME_SCALING_STATUS);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!SqlV3StatementStatus.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(SqlV3StatementStatus.class));
            return new TypeAdapter<SqlV3StatementStatus>(){

                public void write(JsonWriter out, SqlV3StatementStatus value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            JsonElement jsonElement = gson.toJsonTree(entry.getValue());
                            if (jsonElement.isJsonArray()) {
                                obj.add(entry.getKey(), (JsonElement)jsonElement.getAsJsonArray());
                                continue;
                            }
                            obj.add(entry.getKey(), (JsonElement)jsonElement.getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, (Object)obj);
                }

                public SqlV3StatementStatus read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    SqlV3StatementStatus.validateJsonElement(jsonElement);
                    JsonObject jsonObj = jsonElement.getAsJsonObject();
                    SqlV3StatementStatus instance = (SqlV3StatementStatus)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                    for (Map.Entry entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsNumber());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), ((JsonElement)entry.getValue()).toString()));
                        }
                        if (((JsonElement)entry.getValue()).isJsonArray()) {
                            instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), List.class));
                            continue;
                        }
                        instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum PhaseEnum {
        COMPLETED("Completed"),
        DEGRADED("Degraded"),
        DELETING("Deleting"),
        FAILED("Failed"),
        FAILING("Failing"),
        PENDING("Pending"),
        PLANNING("Planning"),
        RESUMING("Resuming"),
        RUNNING("Running"),
        STOPPED("Stopped"),
        STOPPING("Stopping");

        private String value;

        private PhaseEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static PhaseEnum fromValue(String value) {
            for (PhaseEnum b : PhaseEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static void validateJsonElement(JsonElement jsonElement) throws IOException {
            String value = jsonElement.getAsString();
            PhaseEnum.fromValue(value);
        }

        public static class Adapter
        extends TypeAdapter<PhaseEnum> {
            public void write(JsonWriter jsonWriter, PhaseEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public PhaseEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return PhaseEnum.fromValue(value);
            }
        }
    }
}

