/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.multitenant.metrics;

import io.confluent.kafka.multitenant.ZoneAlignment;
import java.util.Map;
import org.apache.kafka.common.metrics.CompoundStat;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.server.metrics.ApiSensorBuilder;
import org.apache.kafka.server.metrics.MetricsBuilderContext;

public class FetchResponseSensorCreator
extends ApiSensorBuilder.AbstractApiSensorCreator {
    private final ZoneAlignment zoneAlignment;
    private final boolean isSupportedFFFClient;

    FetchResponseSensorCreator(String name, String descriptiveName, ZoneAlignment zoneAlignment, boolean isSupportedFFFClient) {
        super(name, descriptiveName);
        this.zoneAlignment = zoneAlignment;
        this.isSupportedFFFClient = isSupportedFFFClient;
    }

    protected Sensor createSensor(Metrics metrics, String sensorName, MetricsBuilderContext context, ApiKeys apiKey) {
        Sensor sensor = super.createSensor(metrics, sensorName, ApiSensorBuilder.EXPIRY_SECONDS);
        Map<String, String> metricTags = this.metricTags(context, apiKey);
        String group = context.metricsGroup();
        sensor.add((CompoundStat)this.createMeter(metrics, group, metricTags, "response-byte", this.descriptiveName));
        return sensor;
    }

    protected Map<String, String> metricTags(MetricsBuilderContext context, ApiKeys apiKey) {
        Map metricTags = super.metricTags(context, apiKey);
        metricTags.put("zone-alignment", this.zoneAlignment.name());
        metricTags.put("is-supported-fff-client", Boolean.toString(this.isSupportedFFFClient));
        return metricTags;
    }

    public String name() {
        return this.name;
    }
}

