/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.server.plugins.auth;

import io.confluent.kafka.server.plugins.auth.DefaultDataPolicyContext;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.kafka.common.security.authenticator.SaslInternalConfigs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum DefaultDataPolicyValidationMode {
    NONE{

        @Override
        public boolean trafficAllowed(boolean defaultDataPolicyEnabled, Optional<String> localLkcEnvironmentId, DefaultDataPolicyContext policyContext) {
            return true;
        }
    }
    ,
    STRICT{

        @Override
        public boolean trafficAllowed(boolean defaultDataPolicyEnabled, Optional<String> localLkcEnvironmentId, DefaultDataPolicyContext policyContext) {
            if (!defaultDataPolicyEnabled) {
                return false;
            }
            if (!policyContext.hasSslPeerCertificate.orElse(false).booleanValue()) {
                log.debug("Not allowed because no SSL peer certificate");
                return false;
            }
            if (!(localLkcEnvironmentId.isPresent() && policyContext.environmentId.isPresent() && policyContext.networkType.isPresent())) {
                log.debug("Not allowed because because not all information is present: lkc environment id {}, environment id {}, network type {}", new Object[]{localLkcEnvironmentId, policyContext.environmentId, policyContext.networkType});
                return false;
            }
            if (policyContext.networkType.get() != SaslInternalConfigs.NetworkType.PRIVATE) {
                log.debug("Not allowed because network type is not private");
                return false;
            }
            if (!policyContext.environmentId.get().equals(localLkcEnvironmentId.get())) {
                log.debug("Not allowed because environment ids are different: lkc environment id {}, environment id {}", (Object)localLkcEnvironmentId.get(), policyContext.environmentId);
                return false;
            }
            return true;
        }
    };

    public static final String DEFAULT_DATA_POLICY_VALIDATION_MODE_KEY = "default_data_policy_validation_mode";
    private static final Logger log;

    public static DefaultDataPolicyValidationMode fromString(String text) {
        for (DefaultDataPolicyValidationMode mode : DefaultDataPolicyValidationMode.values()) {
            if (!mode.name().equalsIgnoreCase(text)) continue;
            return mode;
        }
        log.debug("Unknown default data policy validation mode: {}. Set it to none", (Object)text);
        return NONE;
    }

    public static DefaultDataPolicyValidationMode fromConfigs(Supplier<String> jaasConfigEntryOption) {
        return DefaultDataPolicyValidationMode.fromString(jaasConfigEntryOption.get());
    }

    public abstract boolean trafficAllowed(boolean var1, Optional<String> var2, DefaultDataPolicyContext var3);

    static {
        log = LoggerFactory.getLogger(DefaultDataPolicyValidationMode.class);
    }
}

