/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.server.plugins.auth;

import java.util.Objects;
import java.util.Optional;
import org.apache.kafka.common.security.authenticator.PathAwareSniHostName;
import org.apache.kafka.common.security.authenticator.SaslInternalConfigs;

public class PlainSaslCredentials {
    public final String username;
    public final String password;
    public final Optional<PathAwareSniHostName> sniHostName;
    public final Optional<String> logicalClusterId;
    public final Optional<String> networkId;
    public final Optional<String> environmentId;
    public final Optional<SaslInternalConfigs.NetworkType> networkType;
    public final Optional<Boolean> hasSslPeerCertificate;

    private PlainSaslCredentials(Builder builder) {
        this.username = builder.username;
        this.password = builder.password;
        this.sniHostName = builder.sniHostName;
        this.logicalClusterId = builder.logicalClusterId;
        this.networkId = builder.networkId;
        this.environmentId = builder.environmentId;
        this.networkType = builder.networkType;
        this.hasSslPeerCertificate = builder.hasSslPeerCertificate;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        PlainSaslCredentials other = (PlainSaslCredentials)obj;
        return this.username.equals(other.username) && this.password.equals(other.password) && this.sniHostName.equals(other.sniHostName) && this.logicalClusterId.equals(other.logicalClusterId) && this.networkId.equals(other.networkId) && this.environmentId.equals(other.environmentId) && this.networkType.equals(other.networkType) && this.hasSslPeerCertificate.equals(other.hasSslPeerCertificate);
    }

    public int hashCode() {
        return Objects.hash(this.username, this.password, this.sniHostName, this.logicalClusterId, this.networkId, this.environmentId, this.networkType, this.hasSslPeerCertificate);
    }

    public static class Builder {
        private final String username;
        private final String password;
        private Optional<PathAwareSniHostName> sniHostName = Optional.empty();
        private Optional<String> logicalClusterId = Optional.empty();
        private Optional<String> networkId = Optional.empty();
        private Optional<String> environmentId = Optional.empty();
        private Optional<SaslInternalConfigs.NetworkType> networkType = Optional.empty();
        private Optional<Boolean> hasSslPeerCertificate = Optional.empty();

        public Builder(String username, String password) {
            this.username = username;
            this.password = password;
        }

        public Builder(String username, String password, PathAwareSniHostName sniHostName, String logicalClusterId, String networkId, String environmentId, SaslInternalConfigs.NetworkType networkType, Boolean hasSslPeerCertificate) {
            this.username = username;
            this.password = password;
            this.sniHostName = Optional.ofNullable(sniHostName);
            this.logicalClusterId = Optional.ofNullable(logicalClusterId);
            this.networkId = Optional.ofNullable(networkId);
            this.environmentId = Optional.ofNullable(environmentId);
            this.networkType = Optional.ofNullable(networkType);
            this.hasSslPeerCertificate = Optional.ofNullable(hasSslPeerCertificate);
        }

        public Builder sniHostName(PathAwareSniHostName sniHostName) {
            this.sniHostName = Optional.ofNullable(sniHostName);
            return this;
        }

        public Builder logicalClusterId(String logicalClusterId) {
            this.logicalClusterId = Optional.ofNullable(logicalClusterId);
            return this;
        }

        public Builder networkId(String networkId) {
            this.networkId = Optional.ofNullable(networkId);
            return this;
        }

        public Builder environmentId(String environmentId) {
            this.environmentId = Optional.ofNullable(environmentId);
            return this;
        }

        public Builder networkType(SaslInternalConfigs.NetworkType networkType) {
            this.networkType = Optional.ofNullable(networkType);
            return this;
        }

        public Builder hasSslPeerCertificate(Boolean hasSslPeerCertificate) {
            this.hasSslPeerCertificate = Optional.ofNullable(hasSslPeerCertificate);
            return this;
        }

        public PlainSaslCredentials build() {
            return new PlainSaslCredentials(this);
        }
    }
}

