/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.server.plugins.auth;

import io.confluent.kafka.server.plugins.auth.TrafficNetworkIdValidationMode;
import java.util.Optional;
import java.util.function.Consumer;
import org.apache.kafka.server.traffic.TrafficNetworkIdRoutes;

public class TrafficNetworkIdAuthenticator {
    private final TrafficNetworkIdRoutes networkIdRoutes;
    private final TrafficNetworkIdValidationMode networkIdValidationMode;
    private final Consumer<String> errorHandler;

    public TrafficNetworkIdAuthenticator(TrafficNetworkIdRoutes networkIdRoutes, TrafficNetworkIdValidationMode networkIdValidationMode, Consumer<String> errorHandler) {
        this.networkIdRoutes = networkIdRoutes;
        this.networkIdValidationMode = networkIdValidationMode;
        this.errorHandler = errorHandler;
    }

    public boolean authenticate(Optional<String> networkId, String logicalClusterId) {
        if (this.networkIdValidationMode != TrafficNetworkIdValidationMode.NONE && this.networkIdRoutes == null) {
            String errorMessage = String.format("NetworkId: %s validation failed due to an internal error", networkId.orElse("<not-provided>"));
            this.errorHandler.accept(errorMessage);
            return false;
        }
        if (this.networkIdValidationMode.trafficAllowed(networkId, this.networkIdRoutes)) {
            return true;
        }
        String errorMessage = String.format("NetworkId: %s isn't allowed to communicate to the cluster ID %s", networkId.orElse("<not-provided>"), logicalClusterId);
        this.errorHandler.accept(errorMessage);
        return false;
    }
}

