/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.trogdor.fault;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collections;
import java.util.Map;
import org.apache.kafka.trogdor.fault.CloudNetworkFaultWorker;
import org.apache.kafka.trogdor.task.TaskController;
import org.apache.kafka.trogdor.task.TaskSpec;
import org.apache.kafka.trogdor.task.TaskWorker;

public class CloudNetworkFaultSpec
extends TaskSpec {
    private final Map<String, NetworkSpec> nodeSpecs;

    @JsonCreator
    public CloudNetworkFaultSpec(@JsonProperty(value="startMs") long startMs, @JsonProperty(value="durationMs") long durationMs, @JsonProperty(value="nodeSpecs") Map<String, NetworkSpec> networkFaultSpecs) {
        super(startMs, durationMs);
        this.nodeSpecs = networkFaultSpecs == null ? Collections.emptyMap() : Collections.unmodifiableMap(networkFaultSpecs);
    }

    @Override
    public TaskController newController(String id) {
        return topology -> this.nodeSpecs.keySet();
    }

    @Override
    public TaskWorker newTaskWorker(String id) {
        return new CloudNetworkFaultWorker(id, this.nodeSpecs);
    }

    @JsonProperty(value="nodeSpecs")
    public Map<String, NetworkSpec> nodeSpecs() {
        return this.nodeSpecs;
    }

    public static class NetworkSpec {
        private final String srcNamespace;
        private final String dstNamespace;
        private final String dstPodName;
        private final String srcPodName;
        private final String networkDevice;
        private final int lossPercentage;

        public NetworkSpec(@JsonProperty(value="networkDevice") String networkDevice, @JsonProperty(value="lossPercentage") Integer lossPercentage, @JsonProperty(value="dstPodName") String dstPodName, @JsonProperty(value="srcPodName") String srcPodName, @JsonProperty(value="srcNamespace") String srcNamespace, @JsonProperty(value="dstNamespace") String dstNamespace) {
            this.networkDevice = networkDevice == null ? "" : networkDevice;
            this.lossPercentage = lossPercentage == null ? 0 : lossPercentage;
            this.dstPodName = dstPodName == null ? "" : dstPodName;
            this.srcPodName = srcPodName == null ? "" : srcPodName;
            this.srcNamespace = srcNamespace == null ? "" : srcNamespace;
            this.dstNamespace = dstNamespace == null ? "" : dstNamespace;
        }

        @JsonProperty(value="networkDevice")
        public String networkDevice() {
            return this.networkDevice;
        }

        @JsonProperty(value="lossPercentage")
        public int lossPercentage() {
            return this.lossPercentage;
        }

        @JsonProperty(value="srcNamespace")
        public String srcNamespace() {
            return this.srcNamespace;
        }

        @JsonProperty(value="dstPodName")
        public String dstPodName() {
            return this.dstPodName;
        }

        @JsonProperty(value="srcPodName")
        public String srcPodName() {
            return this.srcPodName;
        }

        @JsonProperty(value="dstNamespace")
        public String dstNamespace() {
            return this.dstNamespace;
        }

        public String toString() {
            return "NetworkSpec{networkDevice='" + this.networkDevice + '\'' + ", lossPercentage=" + this.lossPercentage + ", srcNamespace=" + this.srcNamespace + ", srcPodName=" + this.srcPodName + ", dstPodName=" + this.dstPodName + ", dstNamespace=" + this.dstNamespace + '}';
        }
    }
}

