/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.trogdor.workload;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collections;
import org.apache.kafka.trogdor.task.TaskController;
import org.apache.kafka.trogdor.task.TaskSpec;
import org.apache.kafka.trogdor.task.TaskWorker;
import org.apache.kafka.trogdor.workload.MetadataServiceWorker;

public class MetadataServiceWorkloadSpec
extends TaskSpec {
    private final String clientNode;
    private final String seedMetadataServerUrl;
    private final String adminUserCredentials;
    private final int numRoleBindings;
    private final int targetCallsPerSec;

    @JsonCreator
    public MetadataServiceWorkloadSpec(@JsonProperty(value="startMs") long startMs, @JsonProperty(value="durationMs") long durationMs, @JsonProperty(value="clientNode") String clientNode, @JsonProperty(value="seedMetadataServerUrl") String seedMetadataServerUrl, @JsonProperty(value="adminUserCredentials") String adminUserCredentials, @JsonProperty(value="numRoleBindings") int numRoleBindings, @JsonProperty(value="targetCallsPerSec") int targetCallsPerSec) {
        super(startMs, durationMs);
        this.clientNode = clientNode == null ? "" : clientNode;
        this.seedMetadataServerUrl = seedMetadataServerUrl == null ? "" : seedMetadataServerUrl;
        this.adminUserCredentials = adminUserCredentials == null ? "" : adminUserCredentials;
        this.numRoleBindings = numRoleBindings;
        this.targetCallsPerSec = targetCallsPerSec;
    }

    @JsonProperty
    public String clientNode() {
        return this.clientNode;
    }

    @JsonProperty
    public String adminUserCredentials() {
        return this.adminUserCredentials;
    }

    @JsonProperty
    public String seedMetadataServerUrl() {
        return this.seedMetadataServerUrl;
    }

    @JsonProperty
    public int numRoleBindings() {
        return this.numRoleBindings;
    }

    @JsonProperty
    public int targetCallsPerSec() {
        return this.targetCallsPerSec;
    }

    @Override
    public TaskController newController(String id) {
        return topology -> Collections.singleton(this.clientNode);
    }

    @Override
    public TaskWorker newTaskWorker(String id) {
        return new MetadataServiceWorker(id, this);
    }
}

