/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.trogdor.workload;

import com.fasterxml.jackson.annotation.JsonCreator;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.HashMap;
import java.util.zip.CRC32;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.trogdor.workload.PayloadGenerator;

public class SequentialChecksumPayloadGenerator
implements PayloadGenerator {
    public static final int PAYLOAD_SIZE = 40;
    private final byte[] producerId = new byte[8];
    private final ByteBuffer buffer;
    private final HashMap<TopicPartition, Long> previousProduceOffsets = new HashMap();
    private TopicPartition currentTopicPartition;

    @JsonCreator
    public SequentialChecksumPayloadGenerator() {
        this.buffer = ByteBuffer.allocate(8);
        this.buffer.order(ByteOrder.LITTLE_ENDIAN);
    }

    public void setProducerId(long producerId) {
        this.buffer.clear();
        this.buffer.putLong(producerId);
        this.buffer.rewind();
        System.arraycopy(this.buffer.array(), 0, this.producerId, 0, 8);
    }

    public void setCurrentTopicPartition(TopicPartition tp) {
        this.currentTopicPartition = tp;
    }

    public void updateProduceOffset(TopicPartition tp, long offset) {
        this.previousProduceOffsets.put(tp, offset);
    }

    @Override
    public byte[] generate(long position) {
        int index = 0;
        byte[] result = new byte[40];
        System.arraycopy(this.producerId, 0, result, 0, 8);
        index += 8;
        this.buffer.clear();
        this.buffer.putLong(position);
        this.buffer.rewind();
        System.arraycopy(this.buffer.array(), 0, result, index, 8);
        index += 8;
        this.buffer.clear();
        if (this.currentTopicPartition == null || !this.previousProduceOffsets.containsKey(this.currentTopicPartition)) {
            this.buffer.putLong(-1L);
        } else {
            this.buffer.putLong(this.previousProduceOffsets.get(this.currentTopicPartition));
        }
        this.buffer.rewind();
        System.arraycopy(this.buffer.array(), 0, result, index, 8);
        index += 8;
        this.buffer.clear();
        this.buffer.putLong(Time.SYSTEM.milliseconds());
        this.buffer.rewind();
        System.arraycopy(this.buffer.array(), 0, result, index, 8);
        index += 8;
        CRC32 checksum = new CRC32();
        checksum.update(result, 0, 32);
        this.buffer.clear();
        this.buffer.putLong(checksum.getValue());
        this.buffer.rewind();
        System.arraycopy(this.buffer.array(), 0, result, index, 8);
        return result;
    }
}

