/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.trogdor.workload;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.CRC32;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.trogdor.workload.RecordBatchVerifier;
import org.apache.kafka.trogdor.workload.SequentialChecksumVerificationException;

public class SequentialChecksumRecordBatchVerifier
implements RecordBatchVerifier {
    private final Map<TopicPartition, Map<Long, Long>> previousProduceOffsets = new HashMap<TopicPartition, Map<Long, Long>>();
    private final Map<TopicPartition, Map<Long, Long>> previousPositions = new HashMap<TopicPartition, Map<Long, Long>>();
    private final ByteBuffer buffer = ByteBuffer.allocate(8);
    private long previousChecksum = 0L;

    public SequentialChecksumRecordBatchVerifier() {
        this.buffer.order(ByteOrder.LITTLE_ENDIAN);
    }

    @Override
    public synchronized void verifyRecords(ConsumerRecords<byte[], byte[]> consumerRecords) {
        for (ConsumerRecord record : consumerRecords) {
            long recordChecksum;
            long messageTimestampMs;
            long previousProduceOffset;
            long position;
            long producerId;
            TopicPartition topicPartition = new TopicPartition(record.topic(), record.partition());
            byte[] payload = (byte[])record.value();
            if (payload.length != 40) {
                throw new SequentialChecksumVerificationException(String.format("Invalid payload size %d, expected %d. TopicPartition: %s, record offset: %d", payload.length, 40, topicPartition, record.offset()));
            }
            try {
                this.buffer.clear();
                this.buffer.put(payload, 0, 8);
                this.buffer.rewind();
                producerId = this.buffer.getLong();
                this.buffer.clear();
                this.buffer.put(payload, 8, 8);
                this.buffer.rewind();
                position = this.buffer.getLong();
                this.buffer.clear();
                this.buffer.put(payload, 16, 8);
                this.buffer.rewind();
                previousProduceOffset = this.buffer.getLong();
                this.buffer.clear();
                this.buffer.put(payload, 24, 8);
                this.buffer.rewind();
                messageTimestampMs = this.buffer.getLong();
                this.buffer.clear();
                this.buffer.put(payload, 32, 8);
                this.buffer.rewind();
                recordChecksum = this.buffer.getLong();
            }
            catch (RuntimeException e) {
                throw new SequentialChecksumVerificationException(String.format("Error parsing payload. TopicPartition: %s, record offset: %d, payload: %s", topicPartition, record.offset(), this.getPayloadString(payload)), e);
            }
            CRC32 checksum = new CRC32();
            checksum.update(payload, 0, 32);
            if (checksum.getValue() != recordChecksum) {
                throw new SequentialChecksumVerificationException(String.format("Checksum mismatch. Checksum in record: %d, calculated checksum: %d. TopicPartition: %s, record offset: %d, record: [%s].", recordChecksum, checksum.getValue(), topicPartition, record.offset(), this.getRecordValueString(producerId, position, previousProduceOffset, messageTimestampMs, recordChecksum)));
            }
            if (!this.previousProduceOffsets.containsKey(topicPartition)) {
                HashMap<Long, Long> produceOffsetMap = new HashMap<Long, Long>();
                produceOffsetMap.put(producerId, record.offset());
                this.previousProduceOffsets.put(topicPartition, produceOffsetMap);
            } else {
                Map<Long, Long> previousProduceOffsets = this.previousProduceOffsets.get(topicPartition);
                long lastOffset = previousProduceOffsets.getOrDefault(producerId, -1L);
                if (lastOffset >= 0L && previousProduceOffset >= 0L && lastOffset != previousProduceOffset && recordChecksum != this.previousChecksum) {
                    throw new SequentialChecksumVerificationException(String.format("Previous produce offset mismatch. Expected offset: %d. TopicPartition: %s, record offset: %d, record: [%s].", lastOffset, topicPartition, record.offset(), this.getRecordValueString(producerId, position, previousProduceOffset, messageTimestampMs, recordChecksum)));
                }
                previousProduceOffsets.put(producerId, record.offset());
            }
            this.previousChecksum = recordChecksum;
            if (!this.previousPositions.containsKey(topicPartition)) {
                HashMap<Long, Long> positionMap = new HashMap<Long, Long>();
                positionMap.put(producerId, position);
                this.previousPositions.put(topicPartition, positionMap);
                continue;
            }
            Map<Long, Long> previousPositions = this.previousPositions.get(topicPartition);
            long lastPosition = previousPositions.getOrDefault(producerId, -1L);
            if (lastPosition >= 0L && position < lastPosition) {
                throw new SequentialChecksumVerificationException(String.format("Position mark rewinded. Last position: %d. TopicPartition: %s, record offset: %d, record: [%s].", lastPosition, topicPartition, record.offset(), this.getRecordValueString(producerId, position, previousProduceOffset, messageTimestampMs, recordChecksum)));
            }
            previousPositions.put(producerId, position);
        }
    }

    private String getPayloadString(byte[] payload) {
        StringBuilder sb = new StringBuilder();
        for (byte b : payload) {
            sb.append(String.format("0x%02X ", b));
        }
        return sb.toString();
    }

    private String getRecordValueString(long producerId, long position, long previousProduceOffset, long messageTimestampMs, long recordChecksum) {
        return String.format("producerId: %d, position: %d, previousProduceOffset: %d, messageTimestampMs: %d, recordChecksum: %d", producerId, position, previousProduceOffset, messageTimestampMs, recordChecksum);
    }

    @Override
    public void resetTrackedOffset(TopicPartition topicPartition) {
        this.previousProduceOffsets.remove(topicPartition);
        this.previousPositions.remove(topicPartition);
    }

    public synchronized void onPartitionsRevoked(Collection<TopicPartition> partitions) {
        this.previousProduceOffsets.keySet().removeAll(partitions);
        this.previousPositions.keySet().removeAll(partitions);
    }

    public synchronized void onPartitionsAssigned(Collection<TopicPartition> partitions) {
        this.previousProduceOffsets.keySet().removeAll(partitions);
        this.previousPositions.keySet().removeAll(partitions);
    }
}

