/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.trogdor.workload;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.apache.kafka.clients.CommonClientConfigs;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.consumer.ConsumerGroupMetadata;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerConfig;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.errors.InvalidProducerEpochException;
import org.apache.kafka.common.internals.KafkaFutureImpl;
import org.apache.kafka.common.metrics.KafkaMetricsContext;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.MetricsContext;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.common.utils.ThreadUtils;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.trogdor.common.JsonUtil;
import org.apache.kafka.trogdor.common.Platform;
import org.apache.kafka.trogdor.common.WorkerUtils;
import org.apache.kafka.trogdor.task.TaskWorker;
import org.apache.kafka.trogdor.task.WorkerStatusTracker;
import org.apache.kafka.trogdor.workload.Histogram;
import org.apache.kafka.trogdor.workload.PartitionsSpec;
import org.apache.kafka.trogdor.workload.PayloadIterator;
import org.apache.kafka.trogdor.workload.Throttle;
import org.apache.kafka.trogdor.workload.TransactionBenchSpec;
import org.apache.kafka.trogdor.workload.TransactionBenchWorkerMetrics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionBenchWorker
implements TaskWorker {
    private static final Logger log = LoggerFactory.getLogger(TransactionBenchWorker.class);
    private static final int THROTTLE_PERIOD_MS = 1000;
    private final String id;
    private final TransactionBenchSpec spec;
    private final AtomicBoolean running = new AtomicBoolean(false);
    private ScheduledExecutorService executor;
    private WorkerStatusTracker status;
    private KafkaFutureImpl<String> doneFuture;
    private final Histogram histogram;
    private AtomicLong transactionsCompleted = new AtomicLong();
    private Future<?> statusUpdaterFuture;
    private final long startTimeMs;
    private AtomicInteger taskToComplete;
    final Metrics metrics;
    private final TransactionBenchWorkerMetrics workerMetrics;

    public TransactionBenchWorker(String id, TransactionBenchSpec spec) {
        this.id = id;
        this.spec = spec;
        this.histogram = new Histogram(10000);
        this.startTimeMs = Time.SYSTEM.milliseconds();
        this.taskToComplete = new AtomicInteger(spec.numProducers());
        ProducerConfig config = new ProducerConfig(TransactionBenchWorker.getBasicProducerConfig(spec));
        Map<String, String> metricTags = Collections.singletonMap("trogdor-transaction-worker-id", id);
        MetricConfig metricConfig = new MetricConfig().samples(config.getInt("metrics.num.samples").intValue()).timeWindow(config.getLong("metrics.sample.window.ms").longValue(), TimeUnit.MILLISECONDS).recordLevel(Sensor.RecordingLevel.forName((String)config.getString("metrics.recording.level"))).tags(metricTags);
        List reporters = CommonClientConfigs.metricsReporters((String)id, (AbstractConfig)config);
        KafkaMetricsContext metricsContext = new KafkaMetricsContext("trogdor.worker", config.originalsWithPrefix("metrics.context."));
        this.metrics = new Metrics(metricConfig, reporters, Time.SYSTEM, (MetricsContext)metricsContext);
        this.workerMetrics = new TransactionBenchWorkerMetrics(this.metrics);
    }

    @Override
    public void start(Platform platform, WorkerStatusTracker status, KafkaFutureImpl<String> doneFuture) {
        if (!this.running.compareAndSet(false, true)) {
            throw new IllegalStateException("TransactionBenchWorker is already running.");
        }
        log.info("{}: Activating TransactionBenchWorker with {}", (Object)this.id, (Object)this.spec);
        this.executor = Executors.newScheduledThreadPool(this.taskToComplete.get() + 1, ThreadUtils.createThreadFactory((String)"TransactionBenchWorkerThread%d", (boolean)false));
        this.statusUpdaterFuture = this.executor.scheduleWithFixedDelay(new StatusUpdater(this.histogram), 30L, 30L, TimeUnit.SECONDS);
        this.status = status;
        this.doneFuture = doneFuture;
        for (int ii = this.taskToComplete.get(); ii > 0; --ii) {
            this.executor.submit(new Prepare());
        }
    }

    static Properties getBasicProducerConfig(TransactionBenchSpec spec) {
        Properties props = new Properties();
        WorkerUtils.addConfigsToProperties(props, spec.commonClientConf(), spec.producerConf());
        props.putIfAbsent("key.serializer", ByteArraySerializer.class.getName());
        props.putIfAbsent("value.serializer", ByteArraySerializer.class.getName());
        return props;
    }

    @Override
    public void stop(Platform platform) throws Exception {
        if (!this.running.compareAndSet(true, false)) {
            throw new IllegalStateException("TransactionBenchWorker is not running.");
        }
        this.doneFuture.complete((Object)"");
        log.info("{}: Deactivating TransactionBenchWorker.", (Object)this.id);
        this.executor.shutdownNow();
        this.executor.awaitTermination(1L, TimeUnit.DAYS);
        this.executor = null;
        this.status = null;
        this.doneFuture = null;
    }

    public static class StatusData {
        private final long totalSent;
        private final float averageLatencyMs;
        private final int p50LatencyMs;
        private final int p95LatencyMs;
        private final int p99LatencyMs;
        static final float[] PERCENTILES = new float[]{0.5f, 0.95f, 0.99f};

        @JsonCreator
        StatusData(@JsonProperty(value="totalSent") long totalSent, @JsonProperty(value="averageLatencyMs") float averageLatencyMs, @JsonProperty(value="p50LatencyMs") int p50latencyMs, @JsonProperty(value="p95LatencyMs") int p95latencyMs, @JsonProperty(value="p99LatencyMs") int p99latencyMs) {
            this.totalSent = totalSent;
            this.averageLatencyMs = averageLatencyMs;
            this.p50LatencyMs = p50latencyMs;
            this.p95LatencyMs = p95latencyMs;
            this.p99LatencyMs = p99latencyMs;
        }

        @JsonProperty
        public long totalSent() {
            return this.totalSent;
        }

        @JsonProperty
        public float averageLatencyMs() {
            return this.averageLatencyMs;
        }

        @JsonProperty
        public int p50LatencyMs() {
            return this.p50LatencyMs;
        }

        @JsonProperty
        public int p95LatencyMs() {
            return this.p95LatencyMs;
        }

        @JsonProperty
        public int p99LatencyMs() {
            return this.p99LatencyMs;
        }
    }

    public class StatusUpdater
    implements Runnable {
        private final Histogram histogram;

        StatusUpdater(Histogram histogram) {
            this.histogram = histogram;
        }

        @Override
        public void run() {
            try {
                this.update();
            }
            catch (Exception e) {
                WorkerUtils.abort(log, "StatusUpdater", e, (KafkaFutureImpl<String>)TransactionBenchWorker.this.doneFuture);
            }
        }

        StatusData update() {
            Histogram.Summary summary = this.histogram.summarize(StatusData.PERCENTILES);
            StatusData statusData = new StatusData(summary.numSamples(), summary.average(), summary.percentiles().get(0).value(), summary.percentiles().get(1).value(), summary.percentiles().get(2).value());
            TransactionBenchWorker.this.status.update(JsonUtil.JSON_SERDE.valueToTree((Object)statusData));
            return statusData;
        }
    }

    private static class SendRecordsCallback
    implements Callback {
        private HashMap<TopicPartition, OffsetAndMetadata> availableOffsets;

        SendRecordsCallback(HashMap<TopicPartition, OffsetAndMetadata> availableOffsets) {
            this.availableOffsets = availableOffsets;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onCompletion(RecordMetadata metadata, Exception exception) {
            TopicPartition tp = new TopicPartition(metadata.topic(), metadata.partition());
            HashMap<TopicPartition, OffsetAndMetadata> hashMap = this.availableOffsets;
            synchronized (hashMap) {
                this.availableOffsets.put(tp, new OffsetAndMetadata(metadata.offset()));
            }
            if (exception != null) {
                log.error("SendRecordsCallback: error", (Throwable)exception);
            }
        }
    }

    public class SendTransactions
    implements Callable<Void> {
        private final HashSet<TopicPartition> activePartitions;
        private final HashSet<TopicPartition> offsetsPartitions;
        private final KafkaProducer<byte[], byte[]> producer;
        private final KafkaProducer<byte[], byte[]> offsetProducer;
        private final KafkaConsumer<byte[], byte[]> consumer;
        private final PayloadIterator keys;
        private final PayloadIterator values;
        private final Throttle throttle;
        private Iterator<TopicPartition> partitionsIterator;
        private final boolean offsetsTestingEnabled;
        private HashMap<TopicPartition, OffsetAndMetadata> availableOffsets = new HashMap();
        private final String consumerGroupId;

        SendTransactions(HashSet<TopicPartition> activePartitions, HashSet<TopicPartition> offsetPartitions) {
            this.activePartitions = activePartitions;
            this.partitionsIterator = activePartitions.iterator();
            this.offsetsPartitions = offsetPartitions;
            this.offsetsTestingEnabled = !this.offsetsPartitions.isEmpty();
            int perPeriod = WorkerUtils.perSecToPerPeriod(TransactionBenchWorker.this.spec.targetTransactionsPerSec() * TransactionBenchWorker.this.spec.messagesPerTransaction() * 10, 1000L);
            Uuid randomId = Uuid.randomUuid();
            Properties producerProps = TransactionBenchWorker.getBasicProducerConfig(TransactionBenchWorker.this.spec);
            producerProps.put("bootstrap.servers", TransactionBenchWorker.this.spec.bootstrapServers());
            this.offsetProducer = new KafkaProducer(producerProps);
            producerProps.put("transactional.id", "transaction-bench-transaction-id-" + randomId);
            this.producer = new KafkaProducer(producerProps);
            Properties consumerProps = TransactionBenchWorker.getBasicProducerConfig(TransactionBenchWorker.this.spec);
            consumerProps.put("bootstrap.servers", TransactionBenchWorker.this.spec.bootstrapServers());
            this.consumerGroupId = "transaction-bench-consumer-id-" + randomId;
            consumerProps.put("group.id", this.consumerGroupId);
            consumerProps.putIfAbsent("key.deserializer", ByteArrayDeserializer.class.getName());
            consumerProps.putIfAbsent("value.deserializer", ByteArrayDeserializer.class.getName());
            this.consumer = new KafkaConsumer(consumerProps);
            this.keys = new PayloadIterator(TransactionBenchWorker.this.spec.keyGenerator());
            this.values = new PayloadIterator(TransactionBenchWorker.this.spec.valueGenerator());
            this.throttle = new SendTransactionsThrottle(perPeriod, this.producer);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void call() throws Exception {
            try {
                try {
                    if (this.offsetsTestingEnabled) {
                        this.consumer.subscribe((Collection)this.offsetsPartitions.stream().map(tp -> tp.topic()).collect(Collectors.toSet()));
                    }
                    long finishedTransactions = 0L;
                    this.producer.initTransactions();
                    log.debug("Init transaction " + finishedTransactions);
                    while (TransactionBenchWorker.this.transactionsCompleted.getAndIncrement() < TransactionBenchWorker.this.spec.maxTransactions()) {
                        if (this.offsetsTestingEnabled) {
                            this.sendOffsetsMessages();
                        }
                        long startMs = Time.SYSTEM.milliseconds();
                        this.producer.beginTransaction();
                        for (int count = 0; count < TransactionBenchWorker.this.spec.messagesPerTransaction(); ++count) {
                            this.sendMessage();
                        }
                        if (this.offsetsTestingEnabled) {
                            for (final Map.Entry<TopicPartition, OffsetAndMetadata> entry : this.availableOffsets.entrySet()) {
                                this.producer.sendOffsetsToTransaction((Map)new HashMap<TopicPartition, OffsetAndMetadata>(){
                                    {
                                        this.put(entry.getKey(), entry.getValue());
                                    }
                                }, new ConsumerGroupMetadata(this.consumerGroupId));
                            }
                            this.availableOffsets.clear();
                        }
                        this.producer.flush();
                        this.producer.commitTransaction();
                        long durationMs = Time.SYSTEM.milliseconds() - startMs;
                        this.recordDuration(durationMs);
                        ++finishedTransactions;
                    }
                }
                catch (Exception e) {
                    log.warn("Hit exception when making transactions: " + e);
                    if (!(e instanceof InvalidProducerEpochException)) {
                        throw e;
                    }
                }
                finally {
                    this.producer.close();
                }
            }
            catch (Exception e) {
                try {
                    WorkerUtils.abort(log, "SendRecords", e, (KafkaFutureImpl<String>)TransactionBenchWorker.this.doneFuture);
                }
                catch (Throwable throwable) {
                    if (TransactionBenchWorker.this.taskToComplete.decrementAndGet() == 0 && !TransactionBenchWorker.this.doneFuture.isDone()) {
                        TransactionBenchWorker.this.statusUpdaterFuture.cancel(false);
                        StatusData statusData = new StatusUpdater(TransactionBenchWorker.this.histogram).update();
                        long curTimeMs = Time.SYSTEM.milliseconds();
                        TransactionBenchWorker.this.doneFuture.complete((Object)"");
                        log.info("Sent {} total transaction(s) in {} ms.  status: {}", new Object[]{TransactionBenchWorker.this.histogram.summarize().numSamples(), curTimeMs - TransactionBenchWorker.this.startTimeMs, statusData});
                    }
                    throw throwable;
                }
                if (TransactionBenchWorker.this.taskToComplete.decrementAndGet() == 0 && !TransactionBenchWorker.this.doneFuture.isDone()) {
                    TransactionBenchWorker.this.statusUpdaterFuture.cancel(false);
                    StatusData statusData = new StatusUpdater(TransactionBenchWorker.this.histogram).update();
                    long curTimeMs = Time.SYSTEM.milliseconds();
                    TransactionBenchWorker.this.doneFuture.complete((Object)"");
                    log.info("Sent {} total transaction(s) in {} ms.  status: {}", new Object[]{TransactionBenchWorker.this.histogram.summarize().numSamples(), curTimeMs - TransactionBenchWorker.this.startTimeMs, statusData});
                }
            }
            if (TransactionBenchWorker.this.taskToComplete.decrementAndGet() == 0 && !TransactionBenchWorker.this.doneFuture.isDone()) {
                TransactionBenchWorker.this.statusUpdaterFuture.cancel(false);
                StatusData statusData = new StatusUpdater(TransactionBenchWorker.this.histogram).update();
                long curTimeMs = Time.SYSTEM.milliseconds();
                TransactionBenchWorker.this.doneFuture.complete((Object)"");
                log.info("Sent {} total transaction(s) in {} ms.  status: {}", new Object[]{TransactionBenchWorker.this.histogram.summarize().numSamples(), curTimeMs - TransactionBenchWorker.this.startTimeMs, statusData});
            }
            return null;
        }

        private void sendMessage() throws InterruptedException {
            if (!this.partitionsIterator.hasNext()) {
                this.partitionsIterator = this.activePartitions.iterator();
            }
            TopicPartition partition = this.partitionsIterator.next();
            ProducerRecord record = new ProducerRecord(partition.topic(), Integer.valueOf(partition.partition()), (Object)this.keys.next(), (Object)this.values.next());
            this.producer.send(record);
            this.throttle.increment();
        }

        private void sendOffsetsMessages() throws InterruptedException {
            for (TopicPartition tp : this.offsetsPartitions) {
                ProducerRecord record = new ProducerRecord(tp.topic(), Integer.valueOf(tp.partition()), (Object)this.keys.next(), (Object)this.values.next());
                this.offsetProducer.send(record, (Callback)new SendRecordsCallback(this.availableOffsets));
                this.throttle.increment();
            }
            this.offsetProducer.flush();
        }

        void recordDuration(long durationMs) {
            TransactionBenchWorker.this.histogram.add(durationMs);
            TransactionBenchWorker.this.workerMetrics.recordTxnE2eLatency(durationMs);
        }
    }

    private static class SendTransactionsThrottle
    extends Throttle {
        private final KafkaProducer<?, ?> producer;

        SendTransactionsThrottle(int maxPerPeriod, KafkaProducer<?, ?> producer) {
            super(maxPerPeriod, 1000);
            this.producer = producer;
        }

        @Override
        protected synchronized void delay(long amount) throws InterruptedException {
            long startMs = this.time().milliseconds();
            this.producer.flush();
            long endMs = this.time().milliseconds();
            long delta = endMs - startMs;
            super.delay(amount - delta);
        }
    }

    public class Prepare
    implements Runnable {
        @Override
        public void run() {
            try {
                HashMap<String, NewTopic> newTopics = new HashMap<String, NewTopic>();
                HashSet<TopicPartition> active = new HashSet<TopicPartition>();
                for (int ii = TransactionBenchWorker.this.spec.topicsPerTransaction(); ii > 0; --ii) {
                    String topicName = "TransactionBenchWorker-" + TransactionBenchWorker.this.spec.producerNode() + "-" + ii + "-" + (int)(Math.random() * 10000.0) + "-" + System.currentTimeMillis();
                    PartitionsSpec partSpec = new PartitionsSpec(TransactionBenchWorker.this.spec.numPartitionsPerTopic(), (short)TransactionBenchWorker.this.spec.replicationFactor(), null, null);
                    newTopics.put(topicName, partSpec.newTopic(topicName));
                    for (Integer partitionNumber : partSpec.partitionNumbers()) {
                        active.add(new TopicPartition(topicName, partitionNumber.intValue()));
                    }
                }
                if (active.isEmpty()) {
                    throw new RuntimeException("You must specify at least one active topic.");
                }
                TransactionBenchWorker.this.status.update((JsonNode)new TextNode("Creating " + newTopics.keySet().size() + " topic(s)"));
                WorkerUtils.createTopics(log, TransactionBenchWorker.this.spec.bootstrapServers(), TransactionBenchWorker.this.spec.commonClientConf(), TransactionBenchWorker.this.spec.adminClientConf(), newTopics, false);
                TransactionBenchWorker.this.status.update((JsonNode)new TextNode("Created " + newTopics.keySet().size() + " topic(s)"));
                HashMap<String, NewTopic> offsetsTopicMap = new HashMap<String, NewTopic>();
                HashSet<TopicPartition> offsetsTopic = new HashSet<TopicPartition>();
                if (TransactionBenchWorker.this.spec.offsetsPerTransaction() > 0) {
                    TransactionBenchWorker.this.status.update((JsonNode)new TextNode("Creating offset commit testing topic."));
                    String offsetCommitTopicName = "TransactionBenchWorker-offset-commit-" + TransactionBenchWorker.this.spec.producerNode() + "-" + (int)(Math.random() * 10000.0) + "-" + System.currentTimeMillis();
                    PartitionsSpec partSpec = new PartitionsSpec(TransactionBenchWorker.this.spec.offsetsPerTransaction(), (short)TransactionBenchWorker.this.spec.replicationFactor(), null, null);
                    offsetsTopicMap.put(offsetCommitTopicName, partSpec.newTopic(offsetCommitTopicName));
                    for (Integer partitionNumber : partSpec.partitionNumbers()) {
                        offsetsTopic.add(new TopicPartition(offsetCommitTopicName, partitionNumber.intValue()));
                    }
                    WorkerUtils.createTopics(log, TransactionBenchWorker.this.spec.bootstrapServers(), TransactionBenchWorker.this.spec.commonClientConf(), TransactionBenchWorker.this.spec.adminClientConf(), offsetsTopicMap, false);
                    TransactionBenchWorker.this.status.update((JsonNode)new TextNode("Created offset commit testing topic."));
                }
                TransactionBenchWorker.this.executor.submit(new SendTransactions(active, offsetsTopic));
            }
            catch (Throwable e) {
                WorkerUtils.abort(log, "Prepare", e, (KafkaFutureImpl<String>)TransactionBenchWorker.this.doneFuture);
            }
        }
    }
}

