/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.cruisecontrol.monitor.sampling.aggregator;

import com.linkedin.cruisecontrol.common.LongGenerationed;
import com.linkedin.cruisecontrol.model.Entity;
import com.linkedin.cruisecontrol.monitor.sampling.aggregator.AggregationOptions;
import com.linkedin.cruisecontrol.monitor.sampling.aggregator.MetricSampleCompleteness;
import com.linkedin.kafka.cruisecontrol.monitor.sampling.holder.ReplicaEntity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.IntStream;
import org.apache.kafka.common.TopicPartition;

public class WindowState<E extends Entity>
extends LongGenerationed {
    private final Set<E> validEntities = new HashSet();
    private final Set<E> extrapolatedEntities = new HashSet();

    public WindowState(long generation) {
        super(generation);
    }

    void addValidEntities(E entity) {
        this.validEntities.add(entity);
    }

    void addExtrapolatedEntities(E entity) {
        this.extrapolatedEntities.add(entity);
    }

    void maybeInclude(long windowIndex, MetricSampleCompleteness<E> completeness, Map<E, Integer> includedEntityExtrapolations, AggregationOptions<E> options, Set<Integer> failedBrokerIds) {
        HashSet<Entity> validEntitiesForWindow = new HashSet<Entity>();
        HashSet<String> validGroupsForWindow = new HashSet<String>();
        this.fillInValidRatios(windowIndex, completeness, includedEntityExtrapolations, options, validEntitiesForWindow, validGroupsForWindow, failedBrokerIds);
        if (options.granularity() == AggregationOptions.Granularity.ENTITY_GROUP) {
            validEntitiesForWindow.removeIf(e -> !validGroupsForWindow.contains(e.group()));
        }
        if (this.meetValidEntityRatioAfterMerge(completeness, validEntitiesForWindow, options) && this.meetValidEntityGroupRatioAfterMerge(completeness, validGroupsForWindow, options)) {
            completeness.retainAllValidEntities(validEntitiesForWindow);
            completeness.retainAllValidEntityGroups(validGroupsForWindow);
            completeness.addValidWindowIndex(windowIndex);
            validEntitiesForWindow.forEach(entity -> {
                if (this.extrapolatedEntities.contains(entity)) {
                    includedEntityExtrapolations.compute(entity, (e, c) -> c == null ? 1 : c + 1);
                }
            });
        }
    }

    private boolean meetValidEntityRatioAfterMerge(MetricSampleCompleteness<E> completeness, Set<E> validEntitiesForWindow, AggregationOptions<E> options) {
        int totalNumEntities = options.interestedEntities().size();
        int numValidEntitiesAfterMerge = this.numValidElementsAfterMerge(completeness.validEntities(), validEntitiesForWindow);
        return numValidEntitiesAfterMerge > 0 && (double)((float)numValidEntitiesAfterMerge / (float)totalNumEntities) >= options.minValidEntityRatio();
    }

    private boolean meetValidEntityGroupRatioAfterMerge(MetricSampleCompleteness<E> completeness, Set<String> validEntityGroupForWindow, AggregationOptions<E> options) {
        int totalNumEntityGroups = options.interestedEntityGroups().size();
        int numValidEntityGroupsAfterMerge = this.numValidElementsAfterMerge(completeness.validEntityGroups(), validEntityGroupForWindow);
        return numValidEntityGroupsAfterMerge > 0 && (double)((float)numValidEntityGroupsAfterMerge / (float)totalNumEntityGroups) >= options.minValidEntityGroupRatio();
    }

    private void fillInValidRatios(long windowIndex, MetricSampleCompleteness<E> completeness, Map<E, Integer> includedExtrapolationsByEntity, AggregationOptions<E> options, Set<E> validEntitiesForOption, Set<String> validGroupsForOption, Set<Integer> failedBrokerIds) {
        int numExtrapolatedEntitiesForWindow = 0;
        HashMap<String, Integer> numValidEntitiesByGroupForOption = new HashMap<String, Integer>();
        HashSet<String> invalidGroupsForOption = new HashSet<String>();
        Map<E, E> entityMapping = WindowState.getEntityMapping(options.interestedEntities(), this.validEntities, failedBrokerIds);
        for (Object entity : options.interestedEntities()) {
            if (entityMapping.containsKey(entity)) {
                int includedExtrapolations;
                int extrapolationAddition = 0;
                if (this.extrapolatedEntities.contains(entityMapping.get(entity))) {
                    ++numExtrapolatedEntitiesForWindow;
                    extrapolationAddition = 1;
                }
                if ((includedExtrapolations = includedExtrapolationsByEntity.getOrDefault(entity, 0).intValue()) + extrapolationAddition <= options.maxAllowedExtrapolationsPerEntity()) {
                    validEntitiesForOption.add(entity);
                    numValidEntitiesByGroupForOption.compute(((Entity)entity).group(), (g, v) -> v == null ? 1 : v + 1);
                    continue;
                }
                invalidGroupsForOption.add(((Entity)entity).group());
                continue;
            }
            invalidGroupsForOption.add(((Entity)entity).group());
        }
        int validEntitiesWithGroupGranularity = validEntitiesForOption.size();
        for (String group : invalidGroupsForOption) {
            Integer count = (Integer)numValidEntitiesByGroupForOption.remove(group);
            if (count == null) continue;
            validEntitiesWithGroupGranularity -= count.intValue();
        }
        validGroupsForOption.addAll(numValidEntitiesByGroupForOption.keySet());
        int totalNumEntities = options.interestedEntities().size();
        completeness.addValidEntityRatio(windowIndex, (float)validEntitiesForOption.size() / (float)totalNumEntities);
        completeness.addValidEntityRatioWithGroupGranularity(windowIndex, (float)validEntitiesWithGroupGranularity / (float)totalNumEntities);
        completeness.addExtrapolationEntityRatio(windowIndex, (float)numExtrapolatedEntitiesForWindow / (float)totalNumEntities);
        completeness.addValidEntityGroupRatio(windowIndex, (float)numValidEntitiesByGroupForOption.size() / (float)options.interestedEntityGroups().size());
    }

    static <E extends Entity> Map<E, E> getEntityMapping(Set<E> interestedEntities, Set<E> validEntities, Set<Integer> failedBrokerIds) {
        if (interestedEntities == null || interestedEntities.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap entityMapping = new HashMap();
        HashSet missingEntities = new HashSet();
        boolean isReplicaEntity = interestedEntities.iterator().next() instanceof ReplicaEntity;
        interestedEntities.forEach(entity -> {
            if (validEntities.contains(entity)) {
                entityMapping.put(entity, entity);
            } else if (isReplicaEntity && failedBrokerIds != null && failedBrokerIds.contains(((ReplicaEntity)entity).brokerId()) && ((ReplicaEntity)entity).tp().numReplicas() > 1) {
                entityMapping.put(entity, entity);
            } else {
                missingEntities.add(entity);
            }
        });
        if (missingEntities.isEmpty()) {
            return entityMapping;
        }
        if (isReplicaEntity) {
            Map missingReplicasByTp = WindowState.groupReplicaByPartitions(missingEntities);
            Map unmatchedReplicas = WindowState.unmatchedReplicasOfPartitions(validEntities, missingReplicasByTp.keySet(), entityMapping);
            missingReplicasByTp.forEach((tp, replicas) -> {
                List unmatchedReplicasOfTp = unmatchedReplicas.getOrDefault(tp, Collections.emptyList());
                IntStream.range(0, Math.min(replicas.size(), unmatchedReplicasOfTp.size())).forEach(idx -> {
                    Entity cfr_ignored_0 = (Entity)entityMapping.put(replicas.get(idx), unmatchedReplicasOfTp.get(idx));
                });
            });
        }
        return entityMapping;
    }

    static <E extends Entity> Map<E, E> getEntityMapping(Set<E> interestedEntities, Set<E> validEntities) {
        return WindowState.getEntityMapping(interestedEntities, validEntities, Collections.emptySet());
    }

    static <E extends Entity> Map<TopicPartition, List<E>> groupReplicaByPartitions(Set<E> replicaEntities) {
        if (replicaEntities == null) {
            return Collections.emptyMap();
        }
        HashMap ret = new HashMap();
        replicaEntities.forEach(entity -> {
            ReplicaEntity replicaEntity = (ReplicaEntity)entity;
            TopicPartition tp = new TopicPartition(replicaEntity.tp().topic(), replicaEntity.tp().partition());
            ret.computeIfAbsent(tp, __ -> new ArrayList()).add(entity);
        });
        return ret;
    }

    static <E extends Entity> Map<TopicPartition, List<E>> unmatchedReplicasOfPartitions(Set<E> validEntities, Set<TopicPartition> partitions, Map<E, E> matchedEntities) {
        HashMap ret = new HashMap();
        validEntities.forEach(entity -> {
            ReplicaEntity replicaEntity = (ReplicaEntity)entity;
            TopicPartition tp = new TopicPartition(replicaEntity.tp().topic(), replicaEntity.tp().partition());
            if (partitions.contains(tp) && !matchedEntities.containsKey(entity)) {
                ret.computeIfAbsent(tp, __ -> new ArrayList()).add(entity);
            }
        });
        return ret;
    }

    private int numValidElementsAfterMerge(Set<?> validElements, Set<?> validElementsToMerge) {
        int numValidElements = 0;
        for (Object entity : validElements) {
            if (!validElementsToMerge.contains(entity)) continue;
            ++numValidElements;
        }
        return numValidElements;
    }

    private boolean canExtrapolate(E entity, Map<E, Integer> includedEntityExtrapolations, AggregationOptions<E> options) {
        int additionalExtrapolation = this.extrapolatedEntities.contains(entity) ? 1 : 0;
        int includedExtrapolations = includedEntityExtrapolations.getOrDefault(entity, 0);
        return includedExtrapolations + additionalExtrapolation <= options.maxAllowedExtrapolationsPerEntity();
    }

    public String toString() {
        return "WindowState{validEntities=" + this.validEntities + ", extrapolatedEntities=" + this.extrapolatedEntities + "}";
    }
}

