/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.analyzer;

import com.linkedin.kafka.cruisecontrol.analyzer.GoalOptimizationHistoryOptions;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class OptimizationOptions {
    private final Set<String> excludedTopics;
    private final Set<Integer> excludedBrokersForLeadership;
    private final Set<Integer> excludedBrokersForReplicaMove;
    private final boolean isTriggeredByGoalViolation;
    private final GoalOptimizationHistoryOptions goalOptimizationHistoryOptions;

    private OptimizationOptions(Set<String> excludedTopics, Set<Integer> excludedBrokersForLeadership, Set<Integer> excludedBrokersForReplicaMove, boolean isTriggeredByGoalViolation, GoalOptimizationHistoryOptions goalOptimizationHistoryOptions) {
        this.excludedTopics = excludedTopics;
        this.excludedBrokersForLeadership = excludedBrokersForLeadership;
        this.excludedBrokersForReplicaMove = excludedBrokersForReplicaMove;
        this.isTriggeredByGoalViolation = isTriggeredByGoalViolation;
        this.goalOptimizationHistoryOptions = goalOptimizationHistoryOptions;
    }

    public Set<String> excludedTopics() {
        return Collections.unmodifiableSet(this.excludedTopics);
    }

    public Set<Integer> excludedBrokersForLeadership() {
        return Collections.unmodifiableSet(this.excludedBrokersForLeadership);
    }

    public Set<Integer> excludedBrokersForReplicaMove() {
        return Collections.unmodifiableSet(this.excludedBrokersForReplicaMove);
    }

    public boolean isTriggeredByGoalViolation() {
        return this.isTriggeredByGoalViolation;
    }

    public Optional<GoalOptimizationHistoryOptions> goalOptimizationHistoryOptions() {
        return Optional.ofNullable(this.goalOptimizationHistoryOptions);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OptimizationOptions that = (OptimizationOptions)o;
        return this.isTriggeredByGoalViolation == that.isTriggeredByGoalViolation && Objects.equals(this.excludedTopics, that.excludedTopics) && Objects.equals(this.excludedBrokersForLeadership, that.excludedBrokersForLeadership) && Objects.equals(this.excludedBrokersForReplicaMove, that.excludedBrokersForReplicaMove) && Objects.equals(this.goalOptimizationHistoryOptions, that.goalOptimizationHistoryOptions);
    }

    public int hashCode() {
        return Objects.hash(this.excludedTopics, this.excludedBrokersForLeadership, this.excludedBrokersForReplicaMove, this.isTriggeredByGoalViolation, this.goalOptimizationHistoryOptions);
    }

    public String toString() {
        return "OptimizationOptions{excludedTopics=" + this.excludedTopics + ", excludedBrokersForLeadership=" + this.excludedBrokersForLeadership + ", excludedBrokersForReplicaMove=" + this.excludedBrokersForReplicaMove + ", isTriggeredByGoalViolation=" + this.isTriggeredByGoalViolation + ", goalOptimizationHistoryOptions=" + this.goalOptimizationHistoryOptions + '}';
    }

    public static class Builder {
        private Set<String> excludedTopics = Collections.emptySet();
        private Set<Integer> excludedBrokersForLeadership = Collections.emptySet();
        private Set<Integer> excludedBrokersForReplicaMove = Collections.emptySet();
        private boolean isTriggeredByGoalViolation = false;
        private GoalOptimizationHistoryOptions goalOptimizationHistoryOptions = null;

        public Builder excludedTopics(Set<String> excludedTopics) {
            this.excludedTopics = excludedTopics;
            return this;
        }

        public Builder excludedBrokersForLeadership(Set<Integer> excludedBrokersForLeadership) {
            this.excludedBrokersForLeadership = excludedBrokersForLeadership;
            return this;
        }

        public Builder excludedBrokersForReplicaMove(Set<Integer> excludedBrokersForReplicaMove) {
            this.excludedBrokersForReplicaMove = excludedBrokersForReplicaMove;
            return this;
        }

        public Builder triggeredByGoalViolation(boolean isTriggeredByGoalViolation) {
            this.isTriggeredByGoalViolation = isTriggeredByGoalViolation;
            return this;
        }

        public Builder goalOptimizationHistoryOptions(GoalOptimizationHistoryOptions goalOptimizationHistoryOptions) {
            this.goalOptimizationHistoryOptions = goalOptimizationHistoryOptions;
            return this;
        }

        public OptimizationOptions build() {
            return new OptimizationOptions(this.excludedTopics, this.excludedBrokersForLeadership, this.excludedBrokersForReplicaMove, this.isTriggeredByGoalViolation, this.goalOptimizationHistoryOptions);
        }
    }
}

