/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.analyzer;

import com.linkedin.kafka.cruisecontrol.analyzer.BalancingConstraint;
import com.linkedin.kafka.cruisecontrol.common.Resource;
import com.linkedin.kafka.cruisecontrol.config.KafkaCruiseControlConfig;
import java.util.Collections;
import java.util.Set;

public class UpdatableBalancingConstraint {
    private volatile BalancingConstraint balancingConstraint;
    private volatile boolean useCpuLowUtilizationThresholdForBrokerAddition;

    public UpdatableBalancingConstraint(KafkaCruiseControlConfig kafkaCruiseControlConfig) {
        this.balancingConstraint = new BalancingConstraint(kafkaCruiseControlConfig);
    }

    public BalancingConstraint balancingConstraint() {
        return this.balancingConstraint;
    }

    public boolean isUpdatableConfig(String configKey) {
        return UpdatableBalancingConstraint.updatableConfigs().contains(configKey);
    }

    public synchronized void update(KafkaCruiseControlConfig kafkaCruiseControlConfig) {
        this.balancingConstraint = new BalancingConstraint(kafkaCruiseControlConfig);
        if (this.useCpuLowUtilizationThresholdForBrokerAddition) {
            this.balancingConstraint.setLowUtilizationThresholdFor(Resource.CPU, this.balancingConstraint.cpuLowUtilizationThresholdForBrokerAddition());
        }
    }

    public synchronized void setDefaultCpuLowUtilizationThreshold() {
        this.useCpuLowUtilizationThresholdForBrokerAddition = false;
    }

    public synchronized void setCpuLowUtilizationThresholdForBrokerAddition() {
        this.useCpuLowUtilizationThresholdForBrokerAddition = true;
    }

    public static Set<String> updatableConfigs() {
        return Collections.singleton("cpu.low.utilization.threshold");
    }

    public boolean useCpuLowUtilizationThresholdForBrokerAddition() {
        return this.useCpuLowUtilizationThresholdForBrokerAddition;
    }

    public String toString() {
        return "UpdatableBalancingConstraint{balancingConstraint=" + this.balancingConstraint + "}";
    }
}

