/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.analyzer.goals;

import com.linkedin.kafka.cruisecontrol.analyzer.BalancingConstraint;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.CapacityGoal;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.RebalanceStep;
import com.linkedin.kafka.cruisecontrol.common.Resource;
import com.linkedin.kafka.cruisecontrol.model.Replica;

public class ConsumerOutboundCapacityGoal
extends CapacityGoal {
    public ConsumerOutboundCapacityGoal() {
    }

    ConsumerOutboundCapacityGoal(BalancingConstraint constraint) {
        super(constraint);
    }

    @Override
    protected boolean shouldExcludeForReplicaMove(Replica replica) {
        if (this.balancingConstraint.shouldBalanceFFFTraffic()) {
            return false;
        }
        return !replica.isOriginalOffline() && !replica.isLeader();
    }

    @Override
    protected RebalanceStep getRebalanceSteps(CapacityGoal.RebalanceContext context) {
        if (this.balancingConstraint.shouldBalanceFFFTraffic()) {
            return new CapacityGoal.CheckShouldRebalance(this, context).onFailureThen(new CapacityGoal.LeadershipAndReplicaMovementRebalance(this, context)).onFailureThen(new CapacityGoal.PartitionMovementRebalance(this, context));
        }
        return super.getRebalanceSteps(context);
    }

    @Override
    public CapacityGoal.CapacityViolationResponse selfHealingCapacityViolationResponse() {
        return CapacityGoal.CapacityViolationResponse.ACCEPT_ALWAYS;
    }

    @Override
    protected Resource.CompositeResource resource() {
        if (this.balancingConstraint.shouldBalanceFFFTraffic()) {
            return Resource.CompositeResource.RACK_BASED_AND_RACK_LESS_CONSUME_OUT;
        }
        return Resource.CompositeResource.ofResource(Resource.CONSUME_OUT);
    }

    @Override
    public String name() {
        return ConsumerOutboundCapacityGoal.class.getSimpleName();
    }
}

