/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.analyzer.goals;

import com.linkedin.kafka.cruisecontrol.analyzer.goals.ProposalStats;
import io.confluent.cruisecontrol.analyzer.history.TopicPartitionMovement;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public class GoalOptimizationResult {
    private final GoalOptimizationResultState resultState;
    private final Map<Integer, BrokerResultState> brokerResultStates;
    private final boolean hasReplicaChange;
    private final Set<String> movementsFrom;
    private final ProposalStats proposalStats;
    private final SortedSet<TopicPartitionMovement> topicPartitionMovements;

    private GoalOptimizationResult(GoalOptimizationResultState resultState, Map<Integer, BrokerResultState> brokerResultStates, boolean hasReplicaMove, Set<String> movementsFrom, ProposalStats proposalStats, SortedSet<TopicPartitionMovement> topicPartitionMovements) {
        this.resultState = resultState;
        this.brokerResultStates = brokerResultStates;
        this.hasReplicaChange = hasReplicaMove;
        this.movementsFrom = new HashSet<String>(movementsFrom);
        this.proposalStats = proposalStats;
        this.topicPartitionMovements = topicPartitionMovements;
    }

    public GoalOptimizationResultState resultState() {
        return this.resultState;
    }

    public Map<Integer, BrokerResultState> brokerResultStates() {
        return Collections.unmodifiableMap(this.brokerResultStates);
    }

    public boolean hasReplicaChange() {
        return this.hasReplicaChange;
    }

    public boolean isSuccessful() {
        return this.resultState.isSuccessful();
    }

    public boolean isInProgress() {
        return this.resultState.isInProgress();
    }

    public boolean isFailed() {
        return this.resultState.isFailed();
    }

    public Set<String> goalsWithMovements() {
        return Collections.unmodifiableSet(this.movementsFrom);
    }

    public ProposalStats proposalStats() {
        return this.proposalStats;
    }

    public SortedSet<TopicPartitionMovement> topicPartitionMovements() {
        return this.topicPartitionMovements;
    }

    public String toString() {
        return "GoalOptimizationResult{resultState=" + (Object)((Object)this.resultState) + ", brokerResultStates=" + this.brokerResultStates + ", hasReplicaChange=" + this.hasReplicaChange + ", movementsFrom=" + this.movementsFrom + ", proposalStats=" + this.proposalStats + ", topicPartitionMovements=" + this.topicPartitionMovements + '}';
    }

    public static enum BrokerResultState {
        BALANCED,
        BALANCING;

    }

    public static enum GoalOptimizationResultState {
        SUCCEEDED,
        IN_PROGRESS,
        FAILED;


        public boolean isSuccessful() {
            return this == SUCCEEDED;
        }

        public boolean isFailed() {
            return this == FAILED;
        }

        public boolean isInProgress() {
            return this == IN_PROGRESS;
        }
    }

    public static class Builder {
        private GoalOptimizationResultState resultState = GoalOptimizationResultState.SUCCEEDED;
        private Map<Integer, BrokerResultState> brokerResultStates = new HashMap<Integer, BrokerResultState>();
        private boolean hasReplicaChange;
        private final Set<String> movementsFrom = new HashSet<String>();
        private ProposalStats proposalStats;
        private SortedSet<TopicPartitionMovement> topicPartitionMovements = new TreeSet<TopicPartitionMovement>();

        public Builder markUnsuccessfulOptimization() {
            this.resultState = GoalOptimizationResultState.FAILED;
            return this;
        }

        public Builder addBrokerResultState(int brokerId, BrokerResultState brokerResultState) {
            this.brokerResultStates.put(brokerId, brokerResultState);
            if (brokerResultState == BrokerResultState.BALANCING) {
                this.resultState = GoalOptimizationResultState.IN_PROGRESS;
            }
            return this;
        }

        public Builder markSuccessfulOptimization() {
            this.resultState = GoalOptimizationResultState.SUCCEEDED;
            return this;
        }

        public Builder markInProgressOptimization() {
            this.resultState = GoalOptimizationResultState.IN_PROGRESS;
            return this;
        }

        public Builder recordReplicaChange(String goalKlass) {
            this.hasReplicaChange = true;
            this.movementsFrom.add(goalKlass);
            return this;
        }

        public Builder removeReplicaChange(String goalKlass) {
            this.hasReplicaChange = false;
            this.movementsFrom.remove(goalKlass);
            return this;
        }

        public Builder proposalStats(ProposalStats newStats) {
            this.proposalStats = newStats;
            return this;
        }

        public Builder recordTopicPartitionMovement(TopicPartitionMovement topicPartitionMovement) {
            this.topicPartitionMovements.add(topicPartitionMovement);
            return this;
        }

        public Builder removeTopicPartitionMovement(TopicPartitionMovement topicPartitionMovement) {
            this.topicPartitionMovements.remove(topicPartitionMovement);
            return this;
        }

        public GoalOptimizationResult build() {
            return new GoalOptimizationResult(this.resultState, this.brokerResultStates, this.hasReplicaChange, this.movementsFrom, this.proposalStats, this.topicPartitionMovements);
        }
    }
}

