/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.analyzer.goals;

import com.linkedin.kafka.cruisecontrol.analyzer.BalancingConstraint;
import com.linkedin.kafka.cruisecontrol.analyzer.OptimizationOptions;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.IncrementalResourceDistributionGoal;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.internals.ProposalObservabilityTrackingOptions;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.thresholds.BalancingThresholdsFactory;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.thresholds.ResourceUtilizationRatioThresholds;
import com.linkedin.kafka.cruisecontrol.common.Resource;
import com.linkedin.kafka.cruisecontrol.config.KafkaCruiseControlConfig;
import com.linkedin.kafka.cruisecontrol.model.Cell;
import com.linkedin.kafka.cruisecontrol.model.ClusterModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IncrementalCPUResourceDistributionGoal
extends IncrementalResourceDistributionGoal {
    private static final Logger LOG = LoggerFactory.getLogger(IncrementalCPUResourceDistributionGoal.class);
    private int numTopProposalsToTrack;
    private boolean topProposalTrackingEnabled = true;

    public IncrementalCPUResourceDistributionGoal() {
    }

    IncrementalCPUResourceDistributionGoal(BalancingConstraint constraint) {
        super(constraint);
    }

    @Override
    public String name() {
        return this.getClass().getSimpleName();
    }

    @Override
    public void configure(KafkaCruiseControlConfig kccConfig) {
        super.configure(kccConfig);
        this.numTopProposalsToTrack = kccConfig.getInt("incremental.balancing.cpu.top.proposal.tracking.num.proposals");
        this.topProposalTrackingEnabled = kccConfig.getBoolean("incremental.balancing.cpu.top.proposal.tracking.enabled");
    }

    @Override
    protected Resource resource() {
        return Resource.CPU;
    }

    @Override
    protected boolean validatePercentages() {
        return false;
    }

    @Override
    protected ResourceUtilizationRatioThresholds balancingThresholds(ClusterModel clusterModel, OptimizationOptions optimizationOptions, boolean needValidation) {
        return BalancingThresholdsFactory.computeAbsoluteThresholds(clusterModel, optimizationOptions, this.balancingConstraint, this.resource(), needValidation);
    }

    @Override
    protected ResourceUtilizationRatioThresholds balancingThresholdsForCell(Cell cell, OptimizationOptions optimizationOptions, boolean needValidation) {
        return BalancingThresholdsFactory.computeAbsoluteThresholdsForCell(cell, optimizationOptions, this.balancingConstraint, this.resource(), needValidation);
    }

    @Override
    protected ProposalObservabilityTrackingOptions proposalTrackingOptions() {
        return new ProposalObservabilityTrackingOptions(this.topProposalTrackingEnabled && LOG.isDebugEnabled(), this.numTopProposalsToTrack);
    }
}

