/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.analyzer.goals;

import com.linkedin.kafka.cruisecontrol.analyzer.ActionAcceptance;
import com.linkedin.kafka.cruisecontrol.analyzer.ActionType;
import com.linkedin.kafka.cruisecontrol.analyzer.AnalyzerUtils;
import com.linkedin.kafka.cruisecontrol.analyzer.BalancingConstraint;
import com.linkedin.kafka.cruisecontrol.analyzer.OptimizationOptions;
import com.linkedin.kafka.cruisecontrol.analyzer.PartitionBalancingAction;
import com.linkedin.kafka.cruisecontrol.analyzer.ReplicaBalancingAction;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.AbstractGoal;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.Goal;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.ReplicaDistributionAbstractGoal;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.metrics.OptimizationMetrics;
import com.linkedin.kafka.cruisecontrol.common.Statistic;
import com.linkedin.kafka.cruisecontrol.exception.OptimizationFailureException;
import com.linkedin.kafka.cruisecontrol.model.Broker;
import com.linkedin.kafka.cruisecontrol.model.ClusterModel;
import com.linkedin.kafka.cruisecontrol.model.ClusterModelStats;
import com.linkedin.kafka.cruisecontrol.model.Replica;
import com.linkedin.kafka.cruisecontrol.model.util.ClusterModelStatsComparator;
import com.linkedin.kafka.cruisecontrol.monitor.ModelCompletenessRequirements;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IncrementalTopicReplicaDistributionGoal
extends AbstractGoal {
    private static final Logger LOG = LoggerFactory.getLogger(IncrementalTopicReplicaDistributionGoal.class);
    private final Map<String, Double> averageLeadersPerBrokerForTopic = new HashMap<String, Double>();
    private final Map<String, Double> averageFollowersPerBrokerForTopic = new HashMap<String, Double>();
    private List<String> eligibleTopicsForRebalance = new ArrayList<String>();
    private Map<String, Double> eligibleTopicsForRebalanceInitialScores = new HashMap<String, Double>();
    private Boolean shouldTrigger = false;
    private int numProposedReassignments = 0;

    public IncrementalTopicReplicaDistributionGoal() {
    }

    public IncrementalTopicReplicaDistributionGoal(BalancingConstraint balancingConstraint) {
        this();
        this.balancingConstraint = balancingConstraint;
    }

    @Override
    public ActionAcceptance replicaActionAcceptance(ReplicaBalancingAction action, ClusterModel clusterModel) {
        Broker sourceBroker = clusterModel.broker(action.sourceBrokerId());
        Broker destinationBroker = clusterModel.broker(action.destinationBrokerId());
        String sourceTopic = action.topic();
        Replica sourceReplica = sourceBroker.replica(action.topicPartition());
        if (sourceReplica == null) {
            throw new IllegalStateException("Failed to find the replica that's being moved.");
        }
        switch (action.balancingAction()) {
            case INTER_BROKER_REPLICA_MOVEMENT: {
                return this.isReplicaCountUnderBalanceUpperLimitAfterChange(sourceTopic, sourceReplica, destinationBroker, ReplicaDistributionAbstractGoal.ChangeType.ADD) && this.isReplicaCountAboveBalanceLowerLimitAfterChange(sourceTopic, sourceReplica, sourceBroker, ReplicaDistributionAbstractGoal.ChangeType.REMOVE) ? ActionAcceptance.ACCEPT : ActionAcceptance.REPLICA_REJECT;
            }
            case LEADERSHIP_MOVEMENT: {
                return ActionAcceptance.ACCEPT;
            }
            case INTER_BROKER_REPLICA_SWAP: {
                return ActionAcceptance.REPLICA_REJECT;
            }
        }
        throw new IllegalArgumentException("Unsupported balancing action " + (Object)((Object)action.balancingAction()) + " is provided.");
    }

    @Override
    public ActionAcceptance partitionActionAcceptance(PartitionBalancingAction action, ClusterModel clusterModel) {
        return ActionAcceptance.REPLICA_REJECT;
    }

    private boolean isReplicaCountUnderBalanceUpperLimitAfterChange(String topic, Replica replica, Broker broker, ReplicaDistributionAbstractGoal.ChangeType changeType) {
        int brokerFollowerBalanceUpperLimit;
        int numTopicLeaders = broker.numLeaderReplicasOfTopicInBroker(topic);
        int numTopicFollowers = broker.numFollowerReplicasOfTopicInBroker(topic);
        int brokerLeaderBalanceUpperLimit = broker.isAlive() ? this.leadersPerBrokerForTopicUpperLimit(topic) : 0;
        int n = brokerFollowerBalanceUpperLimit = broker.isAlive() ? this.followersPerBrokerForTopicUpperLimit(topic) : 0;
        if (changeType == ReplicaDistributionAbstractGoal.ChangeType.ADD) {
            if (replica.isLeader()) {
                return numTopicLeaders + 1 <= brokerLeaderBalanceUpperLimit;
            }
            return numTopicFollowers + 1 <= brokerFollowerBalanceUpperLimit;
        }
        return true;
    }

    private boolean isReplicaCountAboveBalanceLowerLimitAfterChange(String topic, Replica replica, Broker broker, ReplicaDistributionAbstractGoal.ChangeType changeType) {
        int brokerFollowerBalanceLowerLimit;
        int numTopicLeaders = broker.numLeaderReplicasOfTopicInBroker(topic);
        int numTopicFollowers = broker.numFollowerReplicasOfTopicInBroker(topic);
        int brokerLeaderBalanceLowerLimit = broker.isAlive() ? this.leadersPerBrokerForTopicLowerLimit(topic) : 0;
        int n = brokerFollowerBalanceLowerLimit = broker.isAlive() ? this.followersPerBrokerForTopicLowerLimit(topic) : 0;
        if (changeType == ReplicaDistributionAbstractGoal.ChangeType.REMOVE) {
            if (replica.isLeader()) {
                return numTopicLeaders - 1 >= brokerLeaderBalanceLowerLimit;
            }
            return numTopicFollowers - 1 >= brokerFollowerBalanceLowerLimit;
        }
        return true;
    }

    @Override
    public ClusterModelStatsComparator clusterModelStatsComparator() {
        return new TopicReplicaDistributionGoalStatsComparator();
    }

    @Override
    public ModelCompletenessRequirements clusterModelCompletenessRequirements() {
        return new ModelCompletenessRequirements(1, 0.0, true);
    }

    @Override
    public String name() {
        return IncrementalTopicReplicaDistributionGoal.class.getSimpleName();
    }

    @Override
    public boolean isHardGoal() {
        return false;
    }

    @Override
    protected SortedSet<Broker> brokersToBalance(ClusterModel clusterModel) {
        return clusterModel.eligibleSourceOrDestinationBrokers();
    }

    List<String> topicsToRebalance(ClusterModel clusterModel, Set<String> excludedTopics) {
        List topicsToRebalance = clusterModel.topics().stream().filter(topic -> !excludedTopics.contains(topic)).filter(topic -> !this.isTopicBalanced(clusterModel, (String)topic)).distinct().sorted(Comparator.comparingDouble(clusterModel::topicImbalanceScore).reversed()).collect(Collectors.toCollection(LinkedList::new));
        if (topicsToRebalance.isEmpty()) {
            LOG.warn("All topics are excluded from {}.", (Object)this.name());
        }
        return Collections.unmodifiableList(topicsToRebalance);
    }

    @Override
    protected void initGoalState(ClusterModel clusterModel, OptimizationOptions optimizationOptions, Optional<OptimizationMetrics> optimizationMetricsOpt) {
        this.eligibleTopicsForRebalance = this.topicsToRebalance(clusterModel, optimizationOptions.excludedTopics());
        this.initializeTopicsToRebalanceInitialScores(clusterModel);
        this.initializeAverageLeaderAndFollowerReplica(clusterModel);
        this.initializeShouldTrigger(clusterModel, this.eligibleTopicsForRebalance, optimizationOptions);
        if (LOG.isDebugEnabled()) {
            this.logTopicDistributions(arg_0 -> ((Logger)LOG).debug(arg_0), clusterModel, "PRE-BALANCING");
        }
        this.numProposedReassignments = 0;
    }

    @Override
    public boolean replicaActionSelfSatisfied(ClusterModel clusterModel, ReplicaBalancingAction action) {
        if (this.numProposedReassignments < this.balancingConstraint.topicBalancingMaxReassignmentsPerIteration()) {
            if (clusterModel.broker(action.sourceBrokerId()).replica(action.topicPartition()).isLeader()) {
                return this.checkLeadershipImbalanceScore(clusterModel, action);
            }
            return this.checkTopicImbalanceScore(clusterModel, action);
        }
        return false;
    }

    @Override
    public boolean partitionActionSelfSatisfied(ClusterModel clusterModel, PartitionBalancingAction action) {
        return false;
    }

    @Override
    protected void updateGoalState(ClusterModel clusterModel, Set<String> excludedTopics) throws OptimizationFailureException {
        if (this.shouldTrigger.booleanValue()) {
            if (LOG.isDebugEnabled()) {
                this.logTopicDistributions(arg_0 -> ((Logger)LOG).debug(arg_0), clusterModel, "POST-BALANCING");
            }
            Set balancedTopics = this.eligibleTopicsForRebalance.stream().filter(topic -> this.isTopicBalanced(clusterModel, (String)topic)).collect(Collectors.toSet());
            Set improvedTopics = this.eligibleTopicsForRebalance.stream().filter(topic -> clusterModel.topicImbalanceScore((String)topic) < this.eligibleTopicsForRebalanceInitialScores.get(topic)).collect(Collectors.toSet());
            Set unimprovedTopics = this.eligibleTopicsForRebalance.stream().filter(topic -> !improvedTopics.contains(topic) && !balancedTopics.contains(topic)).collect(Collectors.toSet());
            LOG.info("The topic distribution goal managed to improve the following topics {} (out of which the following are even considered completely balanced {}), but it couldn't improve {}", new Object[]{improvedTopics, balancedTopics, unimprovedTopics});
            this.optimizationResultBuilder.markSuccessfulOptimization();
            List<String> updatedEligibleTopicsToRebalance = this.topicsToRebalance(clusterModel, excludedTopics);
            OptimizationOptions options = new OptimizationOptions.Builder().triggeredByGoalViolation(true).build();
            boolean stopsBeingTriggering = !this.initializeShouldTrigger(clusterModel, updatedEligibleTopicsToRebalance, options);
            LOG.info("Topic distribution goal will stop triggering from the next round: {}", (Object)stopsBeingTriggering);
            boolean hasMoreToRebalance = this.numProposedReassignments >= this.balancingConstraint.topicBalancingMaxReassignmentsPerIteration();
            LOG.info("Topic distribution goal can do {} more reassignments which means it has more work for the next round: {}", (Object)this.numProposedReassignments, (Object)hasMoreToRebalance);
            if (stopsBeingTriggering && hasMoreToRebalance) {
                LOG.info("The topic distribution goal will not be triggering in the next self-healing round, marking the goal as 'in progress'");
                this.optimizationResultBuilder.markInProgressOptimization();
            }
        }
        this.finish();
    }

    boolean isTopicBalanced(ClusterModel clusterModel, String topic) {
        return clusterModel.topicImbalanceScore(topic) == 0.0;
    }

    private void logTopicDistributions(Consumer<String> logConsumer, ClusterModel clusterModel, String logPrefix) {
        this.eligibleTopicsForRebalance.forEach(topic -> {
            Set brokersToBalanceIds = this.brokersToBalance(clusterModel).stream().map(Broker::id).collect(Collectors.toSet());
            LinkedHashMap leaderReplicas = new LinkedHashMap();
            clusterModel.aliveBrokers().forEach(broker -> leaderReplicas.put(broker.id(), broker.leaderReplicasOfTopicInBroker((String)topic).size()));
            Set validLeadersCount = leaderReplicas.entrySet().stream().filter(leadersEntry -> brokersToBalanceIds.contains(leadersEntry.getKey())).map(Map.Entry::getValue).collect(Collectors.toSet());
            int maxLeaders = (Integer)validLeadersCount.stream().max(Integer::compareTo).get();
            int minLeaders = (Integer)validLeadersCount.stream().min(Integer::compareTo).get();
            LinkedHashMap followerReplicas = new LinkedHashMap();
            clusterModel.aliveBrokers().forEach(broker -> followerReplicas.put(broker.id(), broker.followerReplicasOfTopicInBroker((String)topic).size()));
            Set validFollowersCount = followerReplicas.entrySet().stream().filter(followersEntry -> brokersToBalanceIds.contains(followersEntry.getKey())).map(Map.Entry::getValue).collect(Collectors.toSet());
            int maxFollowers = (Integer)validFollowersCount.stream().max(Integer::compareTo).get();
            int minFollowers = (Integer)validFollowersCount.stream().min(Integer::compareTo).get();
            logConsumer.accept(String.format("%s> Distributions for topic '%s': \nLeader difference: %d; \nFollower difference: %d; \nLeader: \n(%s); \nFollower: \n(%s)", logPrefix, topic, maxLeaders - minLeaders, maxFollowers - minFollowers, leaderReplicas.entrySet().stream().map(e -> String.format("{\"%d\": %d}", e.getKey(), e.getValue())).collect(Collectors.joining(", \n")), followerReplicas.entrySet().stream().map(e -> String.format("{\"%d\": %d}", e.getKey(), e.getValue())).collect(Collectors.joining(", \n"))));
            if (minLeaders < this.leadersPerBrokerForTopicLowerLimit((String)topic) || maxLeaders > this.leadersPerBrokerForTopicUpperLimit((String)topic) || minFollowers < this.followersPerBrokerForTopicLowerLimit((String)topic) || maxFollowers > this.followersPerBrokerForTopicUpperLimit((String)topic)) {
                logConsumer.accept(String.format("Topic %s is imbalanced, it has leaders count [%d, %d] for leader bounds [%d, %d], and followers count [%d, %d] for follower bounds [%d, %d]", topic, minLeaders, maxLeaders, this.leadersPerBrokerForTopicLowerLimit((String)topic), this.leadersPerBrokerForTopicUpperLimit((String)topic), minFollowers, maxFollowers, this.followersPerBrokerForTopicLowerLimit((String)topic), this.followersPerBrokerForTopicUpperLimit((String)topic)));
            }
        });
    }

    @Override
    public void finish() {
        this.finished = true;
    }

    @Override
    protected void rebalanceForBroker(Broker broker, ClusterModel clusterModel, Set<Goal> optimizedGoals, OptimizationOptions optimizationOpts) {
        LOG.debug("Rebalancing broker {}", (Object)broker.id());
        if (!this.shouldTrigger.booleanValue()) {
            return;
        }
        this.eligibleTopicsForRebalance.forEach(topic -> {
            if (this.numProposedReassignments >= this.balancingConstraint.topicBalancingMaxReassignmentsPerIteration()) {
                LOG.debug("Skip balancing broker {} because we've reached the limit of allowed reassignments of {}, currently proposed reassignments: {}", new Object[]{broker, this.balancingConstraint.topicBalancingMaxReassignmentsPerIteration(), this.numProposedReassignments});
                return;
            }
            this.rebalanceLeaderReplicaDistribution(broker, clusterModel, optimizedGoals, optimizationOpts, (String)topic);
            this.rebalanceFollowerReplicaDistribution(broker, clusterModel, optimizedGoals, optimizationOpts, (String)topic);
        });
    }

    private void rebalanceFollowerReplicaDistribution(Broker broker, ClusterModel clusterModel, Set<Goal> optimizedGoals, OptimizationOptions optimizationOpts, String topic) {
        boolean requireMoreFollowers;
        LOG.debug("Rebalancing follower replica distribution for broker {} for topic '{}'", (Object)broker, (Object)topic);
        Collection<Replica> followerReplicas = broker.followerReplicasOfTopicInBroker(topic);
        int numTopicFollowerReplicas = followerReplicas.size();
        boolean hasMoreFollowersForTopic = numTopicFollowerReplicas > this.followersPerBrokerForTopicUpperLimit(topic);
        boolean hasLessFollowersForTopic = numTopicFollowerReplicas < this.followersPerBrokerForTopicLowerLimit(topic);
        boolean requireLessFollowers = broker.isEligibleSource() && hasMoreFollowersForTopic;
        boolean bl = requireMoreFollowers = broker.isEligibleDestination() && hasLessFollowersForTopic;
        if (requireLessFollowers) {
            this.rebalanceByMovingFollowerReplicasOut(broker, topic, clusterModel, optimizedGoals, optimizationOpts);
        }
        if (requireMoreFollowers) {
            this.rebalanceByMovingFollowerReplicasIn(broker, topic, clusterModel, optimizedGoals, optimizationOpts);
        }
    }

    void rebalanceByMovingFollowerReplicasOut(Broker broker, String topic, ClusterModel clusterModel, Set<Goal> optimizedGoals, OptimizationOptions optimizationOptions) {
        TreeSet<Broker> destinationBrokers = new TreeSet<Broker>(Comparator.comparingInt(b -> b.numFollowerReplicasOfTopicInBroker(topic)).thenComparingInt(b -> b.numReplicasOfTopicInBroker(topic)).thenComparingInt(Broker::numReplicas).thenComparingInt(Broker::id));
        clusterModel.eligibleDestinationBrokers().stream().filter(b -> b.numFollowerReplicasOfTopicInBroker(topic) < this.followersPerBrokerForTopicUpperLimit(topic)).collect(Collectors.toCollection(() -> destinationBrokers));
        Collection<Replica> followerReplicasOfTopicInBroker = broker.followerReplicasOfTopicInBroker(topic);
        int followerReplicasOfTopicInBrokerCount = followerReplicasOfTopicInBroker.size();
        for (Replica replica : followerReplicasOfTopicInBroker) {
            boolean metTopicUpperBound;
            if (this.numProposedReassignments >= this.balancingConstraint.topicBalancingMaxReassignmentsPerIteration()) {
                return;
            }
            LOG.debug("Trying to move follower replica out {} for topic '{}' from broker {} to one of brokers {}", new Object[]{replica, topic, broker, destinationBrokers});
            Broker newHostBroker = this.maybeApplyBalancingAction(clusterModel, replica, destinationBrokers, ActionType.INTER_BROKER_REPLICA_MOVEMENT, optimizedGoals, optimizationOptions, Optional.empty());
            boolean movementSuccessful = newHostBroker != null;
            if (!movementSuccessful) continue;
            LOG.debug("Successfully moved follower replica out {} from broker {} to broker {}", new Object[]{replica, broker, newHostBroker});
            ++this.numProposedReassignments;
            boolean bl = metTopicUpperBound = --followerReplicasOfTopicInBrokerCount <= this.followersPerBrokerForTopicUpperLimit(topic);
            if (metTopicUpperBound) {
                LOG.debug("Broker {} successfully met the followers upper bound for topic {} by moving out extra replicas.", (Object)broker, (Object)topic);
                return;
            }
            destinationBrokers.removeIf(b -> b.equals(newHostBroker));
            boolean candidateCanTakeMoreTopicReplicas = newHostBroker.numFollowerReplicasOfTopicInBroker(topic) < this.followersPerBrokerForTopicUpperLimit(topic);
            if (!candidateCanTakeMoreTopicReplicas) continue;
            destinationBrokers.add(newHostBroker);
        }
    }

    void rebalanceByMovingFollowerReplicasIn(Broker broker, String topic, ClusterModel clusterModel, Set<Goal> optimizedGoals, OptimizationOptions optimizationOptions) {
        PriorityQueue<Broker> sourceBrokers = new PriorityQueue<Broker>(Comparator.comparingInt(b -> b.numFollowerReplicasOfTopicInBroker(topic)).thenComparingInt(b -> b.numReplicasOfTopicInBroker(topic)).thenComparingInt(Broker::numReplicas).thenComparingInt(Broker::id).reversed());
        clusterModel.eligibleSourceBrokers().stream().filter(b -> b.numFollowerReplicasOfTopicInBroker(topic) > this.followersPerBrokerForTopicLowerLimit(topic)).collect(Collectors.toCollection(() -> sourceBrokers));
        Collection<Replica> followerReplicasOfTopicInBroker = broker.followerReplicasOfTopicInBroker(topic);
        int numFollowerReplicasOfTopicInBroker = followerReplicasOfTopicInBroker.size();
        Set<Broker> candidateBrokers = Collections.singleton(broker);
        block0: while (!sourceBrokers.isEmpty()) {
            Broker sourceBroker = sourceBrokers.poll();
            Collection<Replica> sourceBrokerReplicasForTopic = sourceBroker.followerReplicasOfTopicInBroker(topic);
            for (Replica replica : sourceBrokerReplicasForTopic) {
                boolean metTopicLowerBound;
                if (this.numProposedReassignments >= this.balancingConstraint.topicBalancingMaxReassignmentsPerIteration()) {
                    return;
                }
                LOG.debug("Trying to move follower replica in {} for topic '{}' from broker {} to one of brokers {}", new Object[]{replica, topic, sourceBroker, candidateBrokers});
                Broker newHostBroker = this.maybeApplyBalancingAction(clusterModel, replica, candidateBrokers, ActionType.INTER_BROKER_REPLICA_MOVEMENT, optimizedGoals, optimizationOptions, Optional.empty());
                boolean movementSuccessful = newHostBroker != null;
                if (!movementSuccessful) continue;
                LOG.debug("Successfully moved follower replica in {} from broker {} to broker {}", new Object[]{replica, sourceBroker, newHostBroker});
                ++this.numProposedReassignments;
                boolean bl = metTopicLowerBound = ++numFollowerReplicasOfTopicInBroker >= this.followersPerBrokerForTopicLowerLimit(topic);
                if (metTopicLowerBound) {
                    LOG.debug("Broker {} successfully met the followers lower bound for topic {} by accepting additional replicas.", (Object)broker, (Object)topic);
                    return;
                }
                if (sourceBroker.numFollowerReplicasOfTopicInBroker(topic) <= this.followersPerBrokerForTopicLowerLimit(topic)) continue block0;
                boolean sourceShouldBeReplaced = !sourceBrokers.isEmpty() && sourceBroker.numFollowerReplicasOfTopicInBroker(topic) < sourceBrokers.peek().numFollowerReplicasOfTopicInBroker(topic);
                if (!sourceShouldBeReplaced) continue;
                sourceBrokers.add(sourceBroker);
                continue block0;
            }
        }
    }

    private void rebalanceLeaderReplicaDistribution(Broker broker, ClusterModel clusterModel, Set<Goal> optimizedGoals, OptimizationOptions optimizationOpts, String topic) {
        boolean requireMoreLeaders;
        LOG.debug("Rebalancing leader replica distribution for broker {} for topic '{}'", (Object)broker, (Object)topic);
        Collection<Replica> topicLeaderReplicas = broker.leaderReplicasOfTopicInBroker(topic);
        boolean hasMoreLeadersForTopic = topicLeaderReplicas.size() > this.leadersPerBrokerForTopicUpperLimit(topic);
        boolean hasLessLeadersForTopic = topicLeaderReplicas.size() < this.leadersPerBrokerForTopicLowerLimit(topic);
        boolean requireLessLeaders = broker.isEligibleSource() && hasMoreLeadersForTopic;
        boolean bl = requireMoreLeaders = broker.isEligibleDestination() && hasLessLeadersForTopic;
        if (requireLessLeaders) {
            this.rebalanceByMovingLeaderReplicasOut(broker, topic, clusterModel, optimizedGoals, optimizationOpts);
        }
        if (requireMoreLeaders) {
            this.rebalanceByMovingLeaderReplicasIn(broker, topic, clusterModel, optimizedGoals, optimizationOpts);
        }
    }

    void rebalanceByMovingLeaderReplicasOut(Broker broker, String topic, ClusterModel clusterModel, Set<Goal> optimizedGoals, OptimizationOptions optimizationOptions) {
        TreeSet<Broker> destinationBrokers = new TreeSet<Broker>(Comparator.comparingInt(b -> b.numLeaderReplicasOfTopicInBroker(topic)).thenComparingInt(b -> b.numReplicasOfTopicInBroker(topic)).thenComparingInt(Broker::numLeaderReplicas).thenComparingInt(Broker::numReplicas).thenComparingInt(Broker::id));
        clusterModel.eligibleDestinationBrokers().stream().filter(b -> b.numLeaderReplicasOfTopicInBroker(topic) < this.leadersPerBrokerForTopicUpperLimit(topic)).collect(Collectors.toCollection(() -> destinationBrokers));
        Collection<Replica> replicasToMove = broker.leaderReplicasOfTopicInBroker(topic);
        int numLeaderReplicasInBroker = replicasToMove.size();
        for (Replica replica : replicasToMove) {
            boolean metTopicLeadersUpperBound;
            boolean movementSuccessful;
            if (this.numProposedReassignments >= this.balancingConstraint.topicBalancingMaxReassignmentsPerIteration()) {
                return;
            }
            LOG.debug("Trying to move leader replica out {} for topic '{}' from broker {} to one of brokers {}", new Object[]{replica, topic, broker, destinationBrokers});
            Broker newHostBroker = this.maybeApplyBalancingActions(clusterModel, replica, destinationBrokers, Arrays.asList(ActionType.INTER_BROKER_REPLICA_MOVEMENT, ActionType.LEADERSHIP_MOVEMENT), optimizedGoals, optimizationOptions, Optional.empty());
            boolean bl = movementSuccessful = newHostBroker != null;
            if (!movementSuccessful) continue;
            LOG.debug("Successfully moved leader replica out {} for topic {} from broker {} to broker {}", new Object[]{replica, topic, broker, newHostBroker});
            ++this.numProposedReassignments;
            boolean bl2 = metTopicLeadersUpperBound = --numLeaderReplicasInBroker <= this.leadersPerBrokerForTopicUpperLimit(topic);
            if (metTopicLeadersUpperBound) {
                LOG.debug("Broker {} successfully met the leaders upper bound for topic {} by moving out extra replicas.", (Object)broker, (Object)topic);
                return;
            }
            destinationBrokers.removeIf(b -> b.equals(newHostBroker));
            boolean candidateCanTakeMoreTopicLeaderReplicas = newHostBroker.numLeaderReplicasOfTopicInBroker(topic) < this.leadersPerBrokerForTopicUpperLimit(topic);
            if (!candidateCanTakeMoreTopicLeaderReplicas) continue;
            destinationBrokers.add(newHostBroker);
        }
    }

    void rebalanceByMovingLeaderReplicasIn(Broker broker, String topic, ClusterModel clusterModel, Set<Goal> optimizedGoals, OptimizationOptions optimizationOptions) {
        PriorityQueue<Broker> sourceBrokers = new PriorityQueue<Broker>(Comparator.comparingInt(b -> b.numLeaderReplicasOfTopicInBroker(topic)).thenComparingInt(b -> b.numReplicasOfTopicInBroker(topic)).thenComparingInt(Broker::numLeaderReplicas).thenComparingInt(Broker::numReplicas).thenComparingInt(Broker::id).reversed());
        clusterModel.eligibleSourceBrokers().stream().filter(b -> b.numLeaderReplicasOfTopicInBroker(topic) > this.leadersPerBrokerForTopicLowerLimit(topic)).collect(Collectors.toCollection(() -> sourceBrokers));
        int numLeaderReplicasOfTopicInBroker = broker.numLeaderReplicasOfTopicInBroker(topic);
        Set<Broker> candidateBrokers = Collections.singleton(broker);
        block0: while (!sourceBrokers.isEmpty()) {
            Broker sourceBroker = sourceBrokers.poll();
            Collection<Replica> replicasToMove = sourceBroker.leaderReplicasOfTopicInBroker(topic);
            for (Replica replica : replicasToMove) {
                boolean metTopicLeaderLowerBound;
                boolean movementSuccessful;
                if (this.numProposedReassignments >= this.balancingConstraint.topicBalancingMaxReassignmentsPerIteration()) {
                    return;
                }
                LOG.debug("Trying to move leader replica in {} for topic '{}' from broker {} to one of brokers {}", new Object[]{replica, topic, sourceBroker, candidateBrokers});
                Broker newHostBroker = this.maybeApplyBalancingActions(clusterModel, replica, candidateBrokers, Arrays.asList(ActionType.INTER_BROKER_REPLICA_MOVEMENT, ActionType.LEADERSHIP_MOVEMENT), optimizedGoals, optimizationOptions, Optional.empty());
                boolean bl = movementSuccessful = newHostBroker != null;
                if (!movementSuccessful) continue;
                LOG.debug("Successfully moved leader replica in {} from broker {} to broker {}", new Object[]{replica, sourceBroker, newHostBroker});
                ++this.numProposedReassignments;
                boolean bl2 = metTopicLeaderLowerBound = ++numLeaderReplicasOfTopicInBroker >= this.leadersPerBrokerForTopicLowerLimit(topic);
                if (metTopicLeaderLowerBound) {
                    LOG.debug("Broker {} successfully met the leaders lower bound for topic {} by accepting additional replicas.", (Object)broker, (Object)topic);
                    return;
                }
                if (sourceBroker.numLeaderReplicasOfTopicInBroker(topic) <= this.leadersPerBrokerForTopicLowerLimit(topic)) continue block0;
                boolean requeueSourceBroker = !sourceBrokers.isEmpty() && sourceBroker.numLeaderReplicasOfTopicInBroker(topic) < sourceBrokers.peek().numLeaderReplicasOfTopicInBroker(topic);
                if (!requeueSourceBroker) continue;
                sourceBrokers.add(sourceBroker);
                continue block0;
            }
        }
    }

    private void initializeTopicsToRebalanceInitialScores(ClusterModel clusterModel) {
        this.eligibleTopicsForRebalanceInitialScores = this.eligibleTopicsForRebalance.stream().distinct().collect(Collectors.toMap(topic -> topic, clusterModel::topicImbalanceScore));
    }

    private void initializeAverageLeaderAndFollowerReplica(ClusterModel clusterModel) {
        int numEligibleDestinationBrokers = clusterModel.eligibleDestinationBrokers().size();
        for (String topic : this.eligibleTopicsForRebalance) {
            int allLeadersForTopic = clusterModel.eligibleDestinationBrokers().stream().mapToInt(broker -> broker.leaderReplicasOfTopicInBroker(topic).size()).sum();
            double avgLeaderReplicasPerBrokerForTopic = numEligibleDestinationBrokers > 0 ? (double)allLeadersForTopic / (double)numEligibleDestinationBrokers : 0.0;
            this.averageLeadersPerBrokerForTopic.put(topic, avgLeaderReplicasPerBrokerForTopic);
            int allFollowersForTopic = clusterModel.eligibleDestinationBrokers().stream().mapToInt(broker -> broker.followerReplicasOfTopicInBroker(topic).size()).sum();
            double avgFollowerReplicasPerBrokerForTopic = numEligibleDestinationBrokers > 0 ? (double)allFollowersForTopic / (double)numEligibleDestinationBrokers : 0.0;
            this.averageFollowersPerBrokerForTopic.put(topic, avgFollowerReplicasPerBrokerForTopic);
        }
        LOG.debug("Average Leader replicas per broker for topics: {}", this.averageLeadersPerBrokerForTopic);
        LOG.debug("Average Follower replicas per broker for topics: {}", this.averageFollowersPerBrokerForTopic);
    }

    boolean initializeShouldTrigger(ClusterModel clusterModel, List<String> eligibleTopicsForRebalance, OptimizationOptions options) {
        boolean manyTopicsImbalanced;
        boolean anyTopicBadlyImbalanced;
        if (eligibleTopicsForRebalance.isEmpty()) {
            LOG.warn("No topics to rebalance for {} so it won't trigger", (Object)this.name());
            this.shouldTrigger = false;
            return false;
        }
        Double maxTopicImbalancedScore = clusterModel.topicImbalanceScore(eligibleTopicsForRebalance.get(0));
        boolean bl = anyTopicBadlyImbalanced = maxTopicImbalancedScore > this.balancingConstraint.topicBalancingBadlyImbalancedTopicImbalanceScoreThreshold();
        if (anyTopicBadlyImbalanced) {
            LOG.info("{} will trigger, one of the topics is badly imbalanced with an imbalance score: {}", (Object)this.name(), (Object)maxTopicImbalancedScore);
        }
        int numTotalTopics = clusterModel.topics().size();
        double slightlyImbalancedTopicsNum = Math.round((double)numTotalTopics * this.balancingConstraint.topicBalancingSlightlyImbalancedTopicsPercentageGoalTrigger());
        boolean bl2 = manyTopicsImbalanced = (double)eligibleTopicsForRebalance.size() > slightlyImbalancedTopicsNum && clusterModel.topicImbalanceScore(eligibleTopicsForRebalance.get((int)slightlyImbalancedTopicsNum)) > this.balancingConstraint.topicBalancingSlightlyImbalancedTopicImbalanceScoreThreshold();
        if (manyTopicsImbalanced) {
            LOG.info("{} will trigger, more than {} topics have an imbalance score greater than: {}", new Object[]{this.name(), slightlyImbalancedTopicsNum, this.balancingConstraint.topicBalancingSlightlyImbalancedTopicImbalanceScoreThreshold()});
        }
        this.shouldTrigger = anyTopicBadlyImbalanced || manyTopicsImbalanced;
        LOG.info("{}'s trigger check is invoked by a goal violation detection: {}", (Object)this.name(), (Object)options.isTriggeredByGoalViolation());
        this.shouldTrigger = this.shouldTrigger != false || !options.isTriggeredByGoalViolation();
        return this.shouldTrigger;
    }

    private boolean checkLeadershipImbalanceScore(ClusterModel clusterModel, ReplicaBalancingAction action) {
        String topic = action.topic();
        List<Integer> leadershipDistributionBefore = clusterModel.replicaDistributionForTopic(topic, true);
        Double leadershipImbalanceScoreBefore = clusterModel.replicaDistributionImbalanceScore(leadershipDistributionBefore);
        List<Integer> leadershipDistributionAfter = this.replicaDistributionAfterAction(clusterModel, action, true);
        Double leadershipImbalanceScoreAfter = clusterModel.replicaDistributionImbalanceScore(leadershipDistributionAfter);
        return leadershipImbalanceScoreBefore > leadershipImbalanceScoreAfter;
    }

    private boolean checkTopicImbalanceScore(ClusterModel clusterModel, ReplicaBalancingAction action) {
        String topic = action.topic();
        Double topicImbalanceScoreBefore = clusterModel.topicImbalanceScore(topic);
        List<Integer> leadershipDistributionAfter = clusterModel.replicaDistributionForTopic(topic, true);
        List<Integer> followerDistributionAfter = this.replicaDistributionAfterAction(clusterModel, action, false);
        Double topicImbalanceScoreAfter = clusterModel.calculateTopicImbalanceScore(leadershipDistributionAfter, followerDistributionAfter);
        return topicImbalanceScoreBefore > topicImbalanceScoreAfter;
    }

    private List<Integer> replicaDistributionAfterAction(ClusterModel clusterModel, ReplicaBalancingAction action, Boolean isLeader) {
        String topic = action.topic();
        int limitNumberOfBrokers = isLeader != false ? clusterModel.numLeaderReplicasForTopicOnEligibleDestinationBrokers(topic) : clusterModel.numFollowerReplicasForTopicOnEligibleDestinationBrokers(topic);
        return clusterModel.eligibleDestinationBrokers().stream().mapToInt(broker -> {
            int numOfReplica;
            int n = numOfReplica = isLeader != false ? broker.numLeaderReplicasOfTopicInBroker(topic) : broker.numFollowerReplicasOfTopicInBroker(topic);
            if (broker.id() == action.sourceBrokerId().intValue()) {
                return numOfReplica - 1;
            }
            if (broker.id() == action.destinationBrokerId().intValue()) {
                return numOfReplica + 1;
            }
            return numOfReplica;
        }).boxed().sorted(Comparator.reverseOrder()).limit(limitNumberOfBrokers).collect(Collectors.toList());
    }

    int leadersPerBrokerForTopicUpperLimit(String topic) {
        return (int)Math.ceil(this.averageLeadersPerBrokerForTopic.getOrDefault(topic, (Double)Double.MAX_VALUE));
    }

    int leadersPerBrokerForTopicLowerLimit(String topic) {
        return (int)Math.floor(this.averageLeadersPerBrokerForTopic.getOrDefault(topic, 0.0));
    }

    int followersPerBrokerForTopicUpperLimit(String topic) {
        return (int)Math.ceil(this.averageFollowersPerBrokerForTopic.getOrDefault(topic, (Double)Double.MAX_VALUE));
    }

    int followersPerBrokerForTopicLowerLimit(String topic) {
        return (int)Math.floor(this.averageFollowersPerBrokerForTopic.getOrDefault(topic, 0.0));
    }

    private class TopicReplicaDistributionGoalStatsComparator
    implements ClusterModelStatsComparator {
        private String reasonForLastNegativeResult;

        private TopicReplicaDistributionGoalStatsComparator() {
        }

        @Override
        public int compare(ClusterModelStats stats1, ClusterModelStats stats2) {
            double postLeaderStdDev = stats1.topicLeaderReplicaStats().get((Object)Statistic.ST_DEV).doubleValue();
            double preLeaderStdDev = stats2.topicLeaderReplicaStats().get((Object)Statistic.ST_DEV).doubleValue();
            int leaderResult = AnalyzerUtils.compare(preLeaderStdDev, postLeaderStdDev, 1.0E-5);
            if (leaderResult < 0) {
                this.reasonForLastNegativeResult = String.format("Violated %s. [Std Deviation of Topic Leader Replica Distribution] post-optimization:%.3f pre-optimization:%.3f", IncrementalTopicReplicaDistributionGoal.this.name(), postLeaderStdDev, preLeaderStdDev);
                return leaderResult;
            }
            if (leaderResult == 0) {
                double postFollowerStdDev = stats1.topicFollowerReplicaStats().get((Object)Statistic.ST_DEV).doubleValue();
                double preFollowerStdDev = stats2.topicFollowerReplicaStats().get((Object)Statistic.ST_DEV).doubleValue();
                int followerResult = AnalyzerUtils.compare(preFollowerStdDev, postFollowerStdDev, 1.0E-5);
                if (followerResult < 0) {
                    this.reasonForLastNegativeResult = String.format("Violated %s. [Std Deviation of Topic Follower Replica Distribution] post-optimization:%.3f pre-optimization:%.3f", IncrementalTopicReplicaDistributionGoal.this.name(), postFollowerStdDev, preFollowerStdDev);
                    return followerResult;
                }
            }
            return leaderResult;
        }

        @Override
        public String explainLastComparison() {
            return this.reasonForLastNegativeResult;
        }
    }
}

