/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.analyzer.goals.internals;

import com.linkedin.kafka.cruisecontrol.analyzer.goals.internals.BrokerResourceStats;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDistributionStatsSnapshot {
    protected static final Logger LOG = LoggerFactory.getLogger(AbstractDistributionStatsSnapshot.class);
    protected BrokerResourceStats minBrokerResource;
    protected BrokerResourceStats maxBrokerResource;

    protected AbstractDistributionStatsSnapshot(BrokerResourceStats minBrokerResource, BrokerResourceStats maxBrokerResource) {
        this.minBrokerResource = minBrokerResource;
        this.maxBrokerResource = maxBrokerResource;
    }

    public BrokerResourceStats minBrokerResource() {
        return this.minBrokerResource;
    }

    public BrokerResourceStats maxBrokerResource() {
        return this.maxBrokerResource;
    }

    protected static BrokerResourceStats minResource(BrokerResourceStats brokerResource, BrokerResourceStats currentMinBrokerResource) {
        boolean isLowerThanCurrentResource;
        boolean bl = isLowerThanCurrentResource = currentMinBrokerResource == null || brokerResource.utilizationValue < currentMinBrokerResource.utilizationValue;
        if (isLowerThanCurrentResource) {
            return brokerResource;
        }
        return currentMinBrokerResource;
    }

    protected static BrokerResourceStats maxResource(BrokerResourceStats candidateMaxResource, BrokerResourceStats currentMaxBrokerResource) {
        boolean isAboveCurrentResource;
        boolean bl = isAboveCurrentResource = currentMaxBrokerResource == null || candidateMaxResource.utilizationValue > currentMaxBrokerResource.utilizationValue;
        if (isAboveCurrentResource) {
            return candidateMaxResource;
        }
        return currentMaxBrokerResource;
    }
}

