/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.common;

import java.util.Objects;
import javax.annotation.concurrent.Immutable;

@Immutable
public class BasicPartitionInfo {
    private final String topic;
    private final int partition;
    private final int numReplicas;

    public BasicPartitionInfo(String topic, int partition, int numReplicas) {
        this.topic = topic;
        this.partition = partition;
        this.numReplicas = numReplicas;
    }

    public String toString() {
        return "BasicPartitionInfo{topic='" + this.topic() + '\'' + ", partition=" + this.partition() + ", numReplicas=" + this.numReplicas() + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BasicPartitionInfo that = (BasicPartitionInfo)o;
        return this.partition() == that.partition() && this.numReplicas() == that.numReplicas() && Objects.equals(this.topic(), that.topic());
    }

    public int hashCode() {
        return Objects.hash(this.topic(), this.partition(), this.numReplicas());
    }

    public String topic() {
        return this.topic;
    }

    public int partition() {
        return this.partition;
    }

    public int numReplicas() {
        return this.numReplicas;
    }
}

