/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.common;

import com.linkedin.kafka.cruisecontrol.common.ResourceVisitor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.concurrent.Immutable;

public enum Resource {
    DISK("disk", 3, false, true, 100.0, "MiB"),
    NW_IN("networkInbound", 1, true, false, 10.0, "KiB/s"),
    NW_OUT("networkOutbound", 2, true, false, 10.0, "KiB/s"),
    CPU("cpu", 0, true, true, 0.001, "%"),
    PRODUCE_IN("produceInbound", 4, false, true, 10.0, "KiB/s"),
    CONSUME_OUT("consumeOutbound", 5, false, true, 10.0, "KiB/s"),
    MIRROR_IN("mirrorInbound", 6, false, true, 10.0, "KiB/s"),
    RACK_BASED_CONSUME_OUT("rackBasedConsumeOutbound", 7, false, true, 10.0, "KiB/s"),
    RACK_LESS_CONSUME_OUT("rackLessConsumeOutbound", 8, false, true, 10.0, "KiB/s"),
    REPLICATION_IN("replicationInbound", 9, false, true, 10.0, "KiB/s");

    private static final double EPSILON_PERCENT = 8.0E-4;
    private final String resource;
    private final int id;
    private final boolean isHostResource;
    private final boolean isBrokerResource;
    private final double epsilon;
    private String unit;
    private static final List<Resource> CACHED_VALUES;
    public static final Set<Resource> LEADER_INFLUENCED_RESOURCES;
    public static final Set<Resource> RACK_BASED_RESOURCES;

    public static List<Resource> cachedValues() {
        return CACHED_VALUES;
    }

    private Resource(String resource, int id, boolean isHostResource, boolean isBrokerResource, double epsilon, String unit) {
        this.resource = resource;
        this.id = id;
        this.isHostResource = isHostResource;
        this.isBrokerResource = isBrokerResource;
        this.epsilon = epsilon;
        this.unit = unit;
    }

    public String resource() {
        return this.resource;
    }

    public int id() {
        return this.id;
    }

    public String unit() {
        return this.unit;
    }

    public boolean isHostResource() {
        return this.isHostResource;
    }

    public boolean isBrokerResource() {
        return this.isBrokerResource;
    }

    public double epsilon(double value1, double value2) {
        return Math.max(this.epsilon, 8.0E-4 * (value1 + value2));
    }

    public <T> T visit(ResourceVisitor<T> visitor) {
        switch (this) {
            case CPU: {
                return visitor.visitCpuResource();
            }
            case NW_IN: {
                return visitor.visitNetworkInResource();
            }
            case NW_OUT: {
                return visitor.visitNetworkOutResource();
            }
            case DISK: {
                return visitor.visitDiskResource();
            }
            case PRODUCE_IN: {
                return visitor.visitProduceInResource();
            }
            case CONSUME_OUT: {
                return visitor.visitConsumeOutResource();
            }
            case MIRROR_IN: {
                return visitor.visitMirrorInResource();
            }
            case REPLICATION_IN: {
                return visitor.visitReplicationInResource();
            }
            case RACK_BASED_CONSUME_OUT: {
                return visitor.visitRackBasedConsumeOutResource();
            }
            case RACK_LESS_CONSUME_OUT: {
                return visitor.visitRackLessConsumeOutResource();
            }
        }
        throw new IllegalStateException("Enum type " + (Object)((Object)this) + " not recognized.");
    }

    public String toString() {
        return this.resource;
    }

    static {
        CACHED_VALUES = Collections.unmodifiableList(Arrays.asList(Resource.values()));
        LEADER_INFLUENCED_RESOURCES = Collections.unmodifiableSet(new HashSet<Resource>(Arrays.asList(CPU, PRODUCE_IN, CONSUME_OUT, NW_OUT, MIRROR_IN, RACK_LESS_CONSUME_OUT)));
        RACK_BASED_RESOURCES = Collections.unmodifiableSet(new HashSet<Resource>(Collections.singletonList(RACK_BASED_CONSUME_OUT)));
    }

    @Immutable
    public static enum CompositeResource {
        DISK(DISK),
        NW_IN(NW_IN),
        NW_OUT(NW_OUT),
        CPU(CPU),
        PRODUCE_IN(PRODUCE_IN),
        REPLICATION_IN(REPLICATION_IN),
        CONSUME_OUT(CONSUME_OUT),
        MIRROR_IN(MIRROR_IN),
        RACK_BASED_CONSUME_OUT(RACK_BASED_CONSUME_OUT),
        RAACK_LESS_CONSUME_OUT(RACK_LESS_CONSUME_OUT),
        PRODUCE_IN_MIRROR_IN(PRODUCE_IN, Arrays.asList(PRODUCE_IN, MIRROR_IN)),
        RACK_BASED_AND_RACK_LESS_CONSUME_OUT(RACK_BASED_CONSUME_OUT, Arrays.asList(RACK_BASED_CONSUME_OUT, RACK_LESS_CONSUME_OUT));

        public final Resource capacityResource;
        public final List<Resource> rackBasedUtilizationResources;
        public final List<Resource> rackLessUtilizationResources;
        public final List<Resource> allUtilizationResources;

        private CompositeResource(Resource resource) {
            this(resource, Collections.singletonList(resource));
        }

        private CompositeResource(Resource capacityResource, List<Resource> utilizationResources) {
            List<Resource> rackBasedUtilizationResources = utilizationResources.stream().filter(RACK_BASED_RESOURCES::contains).collect(Collectors.toList());
            List<Resource> rackLessUtilizationResources = utilizationResources.stream().filter(r -> !RACK_BASED_RESOURCES.contains(r)).collect(Collectors.toList());
            this.validateResources(capacityResource, rackBasedUtilizationResources, rackLessUtilizationResources);
            this.capacityResource = capacityResource;
            this.rackBasedUtilizationResources = rackBasedUtilizationResources;
            this.rackLessUtilizationResources = rackLessUtilizationResources;
            this.allUtilizationResources = new ArrayList<Resource>(utilizationResources);
        }

        public static CompositeResource ofResource(Resource resource) {
            switch (resource) {
                case DISK: {
                    return DISK;
                }
                case NW_IN: {
                    return NW_IN;
                }
                case NW_OUT: {
                    return NW_OUT;
                }
                case CPU: {
                    return CPU;
                }
                case PRODUCE_IN: {
                    return PRODUCE_IN;
                }
                case CONSUME_OUT: {
                    return CONSUME_OUT;
                }
                case RACK_BASED_CONSUME_OUT: {
                    return RACK_BASED_CONSUME_OUT;
                }
                case RACK_LESS_CONSUME_OUT: {
                    return RAACK_LESS_CONSUME_OUT;
                }
                case MIRROR_IN: {
                    return MIRROR_IN;
                }
                case REPLICATION_IN: {
                    return REPLICATION_IN;
                }
            }
            throw new IllegalArgumentException(String.format("Cannot get composite resource for resource %s since it doesn't have a composite resource defined.", new Object[]{resource}));
        }

        public boolean isBrokerResource() {
            return this.capacityResource.isBrokerResource;
        }

        private void validateResources(Resource capacityResource, List<Resource> rackBasedUtilizationResources, List<Resource> rackLessUtilizationResources) {
            if (rackBasedUtilizationResources.size() == 1 && rackLessUtilizationResources.size() == 0 && rackBasedUtilizationResources.get(0) == capacityResource) {
                return;
            }
            if (rackLessUtilizationResources.size() == 1 && rackBasedUtilizationResources.size() == 0 && rackLessUtilizationResources.get(0) == capacityResource) {
                return;
            }
            this.validateUtilizationResources(capacityResource, rackBasedUtilizationResources);
            this.validateUtilizationResources(capacityResource, rackLessUtilizationResources);
        }

        private void validateUtilizationResources(Resource capacityResource, List<Resource> utilizationResources) {
            HashSet<Boolean> hostResources = new HashSet<Boolean>(Collections.singletonList(capacityResource.isHostResource()));
            HashSet<Boolean> brokerResources = new HashSet<Boolean>(Collections.singletonList(capacityResource.isBrokerResource));
            HashSet<String> resourceUnits = new HashSet<String>(Collections.singletonList(capacityResource.unit()));
            for (Resource utilR : utilizationResources) {
                hostResources.add(utilR.isHostResource());
                resourceUnits.add(utilR.unit());
                brokerResources.add(utilR.isBrokerResource());
            }
            if (hostResources.size() > 1) {
                throw new IllegalArgumentException(String.format("Cannot configure a composite resource with host and broker resources, capacity resource: %s, utilization resources: %s", new Object[]{capacityResource, utilizationResources}));
            }
            if (brokerResources.size() > 1) {
                throw new IllegalArgumentException(String.format("Cannot configure a composite resource with host and broker resources, capacity resource: %s, utilization resources: %s", new Object[]{capacityResource, utilizationResources}));
            }
            if (resourceUnits.size() > 1) {
                throw new IllegalArgumentException(String.format("Cannot configure a composite resource with different units, capacity resource: %s, utilization resources: %s", new Object[]{capacityResource, utilizationResources}));
            }
        }
    }
}

