/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.detector;

import com.linkedin.cruisecontrol.detector.Anomaly;
import com.linkedin.cruisecontrol.detector.AnomalyFixStatus;
import com.linkedin.kafka.cruisecontrol.KafkaCruiseControl;
import com.linkedin.kafka.cruisecontrol.KafkaCruiseControlOperationMetricsTracker;
import com.linkedin.kafka.cruisecontrol.KafkaCruiseControlUtils;
import com.linkedin.kafka.cruisecontrol.analyzer.result.OptimizationPlaintextSummary;
import com.linkedin.kafka.cruisecontrol.common.KafkaCruiseControlThreadFactory;
import com.linkedin.kafka.cruisecontrol.config.KafkaCruiseControlConfig;
import com.linkedin.kafka.cruisecontrol.config.UpdatableSbcConfig;
import com.linkedin.kafka.cruisecontrol.detector.AnomalyDetectorState;
import com.linkedin.kafka.cruisecontrol.detector.AnomalyDetectorUtils;
import com.linkedin.kafka.cruisecontrol.detector.AnomalyState;
import com.linkedin.kafka.cruisecontrol.detector.BrokerFailureDetector;
import com.linkedin.kafka.cruisecontrol.detector.GoalViolationDetector;
import com.linkedin.kafka.cruisecontrol.detector.GoalViolations;
import com.linkedin.kafka.cruisecontrol.detector.KafkaAnomaly;
import com.linkedin.kafka.cruisecontrol.detector.ResourceUtilizationDetector;
import com.linkedin.kafka.cruisecontrol.detector.ResourceUtilizationHandler;
import com.linkedin.kafka.cruisecontrol.detector.factory.ResourceUtilizationDetectorBuilder;
import com.linkedin.kafka.cruisecontrol.detector.notifier.AnomalyNotificationResult;
import com.linkedin.kafka.cruisecontrol.detector.notifier.AnomalyType;
import com.linkedin.kafka.cruisecontrol.detector.notifier.SelfHealingNotifier;
import com.linkedin.kafka.cruisecontrol.exception.KafkaCruiseControlException;
import com.linkedin.kafka.cruisecontrol.exception.OptimizationFailureException;
import com.linkedin.kafka.cruisecontrol.executor.ExecutorState;
import com.linkedin.kafka.cruisecontrol.monitor.LoadMonitor;
import io.confluent.databalancer.metrics.CellOverloadMetrics;
import io.confluent.databalancer.metrics.GeneralSBCMetricsRegistry;
import io.confluent.databalancer.operation.BrokerAdditionV2StateManager;
import io.confluent.databalancer.operation.EvenClusterLoadStateManager;
import io.confluent.databalancer.persistence.ApiStatePersistenceStore;
import io.confluent.kafka.clients.CloudAdmin;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.common.errors.RebalancePlanComputationException;
import org.apache.kafka.common.utils.SystemTime;
import org.apache.kafka.common.utils.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnomalyDetector {
    static final String METRIC_REGISTRY_NAME = "AnomalyDetector";
    static final String BALANCEDNESS_SCORE_METRIC_NAME = "balancedness-score";
    static final String CAN_GOAL_VIOLATION_BE_FIXED_METRIC_NAME = "goal-violation-fixable";
    private static final String INTER_CELL_BALANCING_ENABLED_METRIC_NAME = "inter-cell-balancing-enabled";
    private static final int INIT_JITTER_BOUND = 10000;
    private static final int NUM_ANOMALY_DETECTION_THREADS = 3;
    private static final Logger LOG = LoggerFactory.getLogger(AnomalyDetector.class);
    private final KafkaCruiseControl kafkaCruiseControl;
    private SelfHealingNotifier selfHealingNotifier;
    private GoalViolationDetector goalViolationDetector;
    private BrokerFailureDetector brokerFailureDetector;
    private ResourceUtilizationHandler resourceUtilizationHandler;
    private final boolean isCpuDetectionEnabled;
    private final boolean isDiskDetectionEnabled;
    private final boolean isIncrementalBalancingEnabled;
    private final boolean isV2AdditionEnabled;
    private final boolean isInterCellBalancingEnabled;
    private ScheduledExecutorService detectorScheduler;
    private final long anomalyDetectionIntervalMs;
    private final int resourceOptimizationIntervalMs;
    private final LinkedBlockingDeque<Anomaly> anomalies;
    private volatile boolean shutdown;
    private final LoadMonitor loadMonitor;
    private AnomalyDetectorState anomalyDetectorState;
    private volatile Anomaly anomalyInProgress;
    private final AtomicLong numCheckedWithDelay;
    private final Object shutdownLock;
    private final KafkaCruiseControlConfig config;
    private final Time time;
    private final CloudAdmin adminClient;
    private final GeneralSBCMetricsRegistry metricRegistry;
    private final CellOverloadMetrics cellOverloadMetrics;
    private final ApiStatePersistenceStore persistenceStore;
    private final UpdatableSbcConfig updatableSbcConfig;
    private AtomicBoolean canFixGoalViolation;

    public AnomalyDetector(KafkaCruiseControlConfig config, CloudAdmin adminClient, LoadMonitor loadMonitor, KafkaCruiseControl kafkaCruiseControl, Time time, GeneralSBCMetricsRegistry metricRegistry, CellOverloadMetrics cellOverloadMetrics, ApiStatePersistenceStore persistenceStore, UpdatableSbcConfig updatableSbcConfig) {
        this.anomalies = new LinkedBlockingDeque();
        this.config = config;
        this.adminClient = adminClient;
        this.anomalyDetectionIntervalMs = config.getLong("anomaly.detection.interval.ms");
        this.isCpuDetectionEnabled = config.getBoolean("cpu.utilization.detector.enabled");
        this.isDiskDetectionEnabled = config.getBoolean("disk.utilization.detector.enabled");
        this.isIncrementalBalancingEnabled = config.getBoolean("incremental.balancing.enabled");
        this.resourceOptimizationIntervalMs = config.getInt("resource.utilization.detector.interval.ms");
        this.isV2AdditionEnabled = config.getBoolean("v2.addition.enabled");
        this.isInterCellBalancingEnabled = config.getBoolean("inter.cell.balancing.enabled");
        this.loadMonitor = loadMonitor;
        this.kafkaCruiseControl = kafkaCruiseControl;
        this.time = time;
        this.metricRegistry = metricRegistry;
        this.cellOverloadMetrics = cellOverloadMetrics;
        this.persistenceStore = persistenceStore;
        this.shutdown = false;
        this.anomalyInProgress = null;
        this.numCheckedWithDelay = new AtomicLong();
        this.shutdownLock = new Object();
        this.updatableSbcConfig = updatableSbcConfig;
        this.canFixGoalViolation = new AtomicBoolean(true);
    }

    AnomalyDetector(LinkedBlockingDeque<Anomaly> anomalies, KafkaCruiseControlConfig kafkaCruiseControlConfig, KafkaCruiseControl kafkaCruiseControl, GeneralSBCMetricsRegistry generalSBCMetricsRegistry, CellOverloadMetrics cellOverloadMetrics, SelfHealingNotifier selfHealingNotifier, GoalViolationDetector goalViolationDetector, BrokerFailureDetector brokerFailureDetector, ScheduledExecutorService detectorScheduler, ResourceUtilizationHandler resourceUtilizationHandler, LoadMonitor loadMonitor, UpdatableSbcConfig updatableSbcConfig) {
        this.config = kafkaCruiseControlConfig;
        this.adminClient = null;
        this.persistenceStore = null;
        this.metricRegistry = generalSBCMetricsRegistry;
        this.cellOverloadMetrics = cellOverloadMetrics;
        this.anomalies = anomalies;
        this.resourceOptimizationIntervalMs = 60000;
        this.selfHealingNotifier = selfHealingNotifier;
        this.goalViolationDetector = goalViolationDetector;
        this.brokerFailureDetector = brokerFailureDetector;
        this.resourceUtilizationHandler = resourceUtilizationHandler;
        this.anomalyDetectionIntervalMs = this.config.getLong("anomaly.detection.interval.ms");
        this.isCpuDetectionEnabled = this.config.getBoolean("cpu.utilization.detector.enabled");
        this.isDiskDetectionEnabled = this.config.getBoolean("disk.utilization.detector.enabled");
        this.isIncrementalBalancingEnabled = this.config.getBoolean("incremental.balancing.enabled");
        this.isV2AdditionEnabled = this.config.getBoolean("v2.addition.enabled");
        this.isInterCellBalancingEnabled = this.config.getBoolean("inter.cell.balancing.enabled");
        this.kafkaCruiseControl = kafkaCruiseControl;
        this.time = Time.SYSTEM;
        this.detectorScheduler = detectorScheduler;
        this.shutdown = false;
        this.loadMonitor = loadMonitor;
        this.anomalyInProgress = null;
        this.numCheckedWithDelay = new AtomicLong();
        this.shutdownLock = new Object();
        this.anomalyDetectorState = new AnomalyDetectorState((Time)new SystemTime(), selfHealingNotifier, 10, generalSBCMetricsRegistry);
        this.updatableSbcConfig = updatableSbcConfig;
        this.canFixGoalViolation = new AtomicBoolean(true);
    }

    void initializeSelfHealingNotifier(BrokerAdditionV2StateManager brokerAdditionV2StateManager) {
        long brokerFailureAlertThresholdMs = this.config.getLong("broker.failure.alert.threshold.ms");
        long selfHealingThresholdMs = this.config.getLong("broker.failure.self.healing.threshold.ms");
        boolean brokerFailureEnabled = this.config.getBoolean("self.healing.broker.failure.enabled");
        boolean selfHealingEnabled = this.config.getBoolean("self.healing.goal.violation.enabled");
        boolean interCellBalancingEnabled = this.config.getBoolean("inter.cell.balancing.enabled");
        this.selfHealingNotifier = new SelfHealingNotifier(brokerAdditionV2StateManager, brokerFailureAlertThresholdMs, selfHealingThresholdMs, brokerFailureEnabled, selfHealingEnabled, interCellBalancingEnabled);
    }

    public EvenClusterLoadStateManager init(Integer brokerId, KafkaCruiseControl.CcStartupMode startupMode, BrokerAdditionV2StateManager brokerAdditionV2StateManager, KafkaCruiseControlOperationMetricsTracker operationMetricsTracker) {
        this.initializeSelfHealingNotifier(brokerAdditionV2StateManager);
        this.goalViolationDetector = new GoalViolationDetector(this.config, this.loadMonitor, this.anomalies, this.time, this.kafkaCruiseControl, this.updatableSbcConfig.updatableSbcGoalsConfig(), startupMode, this.metricRegistry, brokerAdditionV2StateManager, this.persistenceStore);
        this.goalViolationDetector.registerAsChangeListener();
        this.brokerFailureDetector = new BrokerFailureDetector(this.config, (Admin)this.adminClient, this.loadMonitor, this.anomalies, this.time, this.kafkaCruiseControl, this.updatableSbcConfig.updatableSbcGoalsConfig(), this.persistenceStore);
        if (this.isAnyResourceDetectionEnabled()) {
            LOG.info("Resource utilization detector is enabled.");
            List<ResourceUtilizationDetector> detectors = new ResourceUtilizationDetectorBuilder().adminClient(this.adminClient).anomalies(this.anomalies).brokerAdditionV2StateManager(brokerAdditionV2StateManager).cellOverloadMetrics(this.cellOverloadMetrics).shouldSkipAnomalyDetectionSupplier(() -> AnomalyDetectorUtils.shouldSkipAnomalyDetection(this.kafkaCruiseControl, AnomalyType.CELL_OVERLOAD)).kccConfig(this.config).metricsRegistry(this.metricRegistry).operationMetricsTracker(operationMetricsTracker).updatableSbcConfig(this.updatableSbcConfig).persistenceStore(this.persistenceStore).time(this.time).buildResourceUtilizationDetectors();
            this.resourceUtilizationHandler = new ResourceUtilizationHandler(this.config, this.loadMonitor, this.time, detectors);
        }
        this.detectorScheduler = Executors.newScheduledThreadPool(3, new KafkaCruiseControlThreadFactory(METRIC_REGISTRY_NAME, false, LOG));
        int numCachedRecentAnomalyStates = this.config.getInt("num.cached.recent.anomaly.states");
        this.metricRegistry.newGauge(AnomalyDetector.class, INTER_CELL_BALANCING_ENABLED_METRIC_NAME, () -> this.isInterCellBalancingEnabled);
        this.metricRegistry.newGauge(AnomalyDetector.class, BALANCEDNESS_SCORE_METRIC_NAME, this.goalViolationDetector::balancednessScore);
        this.metricRegistry.newGauge(AnomalyDetector.class, CAN_GOAL_VIOLATION_BE_FIXED_METRIC_NAME, this::canGoalViolationBeFixed);
        this.anomalyDetectorState = new AnomalyDetectorState(this.time, this.selfHealingNotifier, numCachedRecentAnomalyStates, this.metricRegistry);
        return new EvenClusterLoadStateManager(brokerId, this.time, this.persistenceStore, this.selfHealingNotifier.isSelfHealingEnabled(AnomalyType.GOAL_VIOLATION));
    }

    public void startDetection() {
        LOG.info("Starting anomaly detector.");
        this.brokerFailureDetector.startDetection();
        int jitter = new Random().nextInt(10000);
        LOG.debug("Starting goal violation detector with delay of {} ms", (Object)jitter);
        this.detectorScheduler.scheduleAtFixedRate(() -> this.goalViolationDetector.update(null, null), this.anomalyDetectionIntervalMs / 2L + (long)jitter, this.anomalyDetectionIntervalMs, TimeUnit.MILLISECONDS);
        if (this.isAnyResourceDetectionEnabled()) {
            this.detectorScheduler.scheduleAtFixedRate(this.resourceUtilizationHandler, this.resourceOptimizationIntervalMs, this.resourceOptimizationIntervalMs, TimeUnit.MILLISECONDS);
        }
        this.detectorScheduler.submit(new AnomalyHandlerTask());
    }

    private boolean isAnyResourceDetectionEnabled() {
        return this.isCpuDetectionEnabled || this.isDiskDetectionEnabled || this.isIncrementalBalancingEnabled && this.isV2AdditionEnabled || this.isInterCellBalancingEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        LOG.info("Shutting down anomaly detector.");
        Object object = this.shutdownLock;
        synchronized (object) {
            this.shutdown = true;
        }
        KafkaCruiseControlUtils.executeSilently(this.brokerFailureDetector, BrokerFailureDetector::shutdownNow);
        KafkaCruiseControlUtils.executeSilently(this.detectorScheduler, this::shutdownDetectorScheduler);
        this.goalViolationDetector.shutdown();
        this.resourceUtilizationHandler.close();
        LOG.info("Anomaly detector shutdown completed.");
    }

    BrokerFailureDetector getBrokerFailureDetector() {
        return this.brokerFailureDetector;
    }

    private void shutdownDetectorScheduler(ScheduledExecutorService detectorScheduler) {
        try {
            detectorScheduler.shutdownNow();
            detectorScheduler.awaitTermination(this.anomalyDetectionIntervalMs, TimeUnit.MILLISECONDS);
            if (!detectorScheduler.isTerminated()) {
                LOG.warn("The resource utilization detector failed to shutdown in " + this.anomalyDetectionIntervalMs + " ms.");
            }
        }
        catch (InterruptedException e) {
            LOG.warn("Interrupted while waiting for anomaly detector to shutdown.");
        }
    }

    public synchronized AnomalyDetectorState anomalyDetectorState() {
        this.anomalyDetectorState.refreshMetrics(this.goalViolationDetector.balancednessScore());
        return this.anomalyDetectorState;
    }

    public boolean canGoalViolationBeFixed() {
        return this.canFixGoalViolation.get();
    }

    private void canGoalViolationBeFixed(boolean value) {
        this.canFixGoalViolation.set(value);
    }

    long numSelfHealingStarted() {
        return this.anomalyDetectorState.numSelfHealingStarted();
    }

    long numSelfHealingErrors() {
        return this.anomalyDetectorState.numSelfHealingErrors();
    }

    Anomaly ongoingSelfHealingAnomaly() {
        return this.anomalyDetectorState.ongoingSelfHealingAnomaly();
    }

    public void maybeClearOngoingAnomalyDetectionTimeMs() {
        this.anomalyDetectorState.maybeClearOngoingAnomalyDetectionTimeMs();
    }

    public boolean setSelfHealingFor(AnomalyType anomalyType, boolean isSelfHealingEnabled) {
        boolean oldSelfHealingEnabled = this.selfHealingNotifier.setSelfHealingFor(anomalyType, isSelfHealingEnabled);
        this.anomalyDetectorState.setSelfHealingFor(anomalyType, isSelfHealingEnabled);
        return oldSelfHealingEnabled;
    }

    public boolean isSelfHealingEnabled(AnomalyType anomalyType) {
        return this.anomalyDetectorState.getSelfHealingFor(anomalyType);
    }

    public long numCheckedWithDelay() {
        return this.numCheckedWithDelay.get();
    }

    public void markSelfHealingFinished(String anomalyId) {
        this.anomalyDetectorState.markSelfHealingFinished(anomalyId);
    }

    public void notifyNewAddingBrokers(Set<Integer> newBrokersBeingAdded) {
        this.brokerFailureDetector.notifyNewAddingBrokers(newBrokersBeingAdded);
        this.goalViolationDetector.notifyNewAddingBrokers(newBrokersBeingAdded);
    }

    public void notifyNewlyOnlineBrokers(Set<Integer> newlyOnlineBrokers) {
        this.brokerFailureDetector.notifyNewlyOnlineBrokers(newlyOnlineBrokers);
        this.goalViolationDetector.notifyNewlyOnlineBrokers(newlyOnlineBrokers);
    }

    public void notifyDeadBrokers(Set<Integer> deadBrokers) {
        this.brokerFailureDetector.notifyDeadBrokers(deadBrokers);
        this.goalViolationDetector.notifyDeadBrokers(deadBrokers);
    }

    private static class OptimizationResultSummary {
        String anomalyId;
        AnomalyFixStatus fixStatus;
        OptimizationFailureException exception;
        OptimizationPlaintextSummary summary;

        private OptimizationResultSummary(String anomalyId, AnomalyFixStatus fixStatus, OptimizationFailureException exception, OptimizationPlaintextSummary summary) {
            this.anomalyId = anomalyId;
            this.fixStatus = fixStatus;
            this.exception = exception;
            this.summary = summary;
        }

        private static OptimizationResultSummary fromSummary(String anomalyId, AnomalyFixStatus fixStatus, OptimizationPlaintextSummary summary) {
            return new OptimizationResultSummary(anomalyId, fixStatus, null, summary);
        }

        private static OptimizationResultSummary fromException(String anomalyId, AnomalyFixStatus fixStatus, OptimizationFailureException ofe) {
            return new OptimizationResultSummary(anomalyId, fixStatus, ofe, null);
        }

        private void logSelfHealingOperation() {
            String selfHealingStatusMessage = this.fixStatus.statusMessage();
            StringBuilder logBuilder = new StringBuilder();
            logBuilder.append("[").append(this.anomalyId).append("] ").append(selfHealingStatusMessage).append(System.lineSeparator());
            if (this.summary != null) {
                logBuilder.append("Summary:").append(System.lineSeparator());
                logBuilder.append(this.summary.summaryByLogLevel(LOG.isDebugEnabled())).append(System.lineSeparator());
            }
            if (this.exception != null) {
                logBuilder.append("Exception:").append(System.lineSeparator());
                logBuilder.append(this.exception);
            }
            String log = logBuilder.toString();
            if (this.fixStatus.failed()) {
                LOG.warn(log);
            } else {
                LOG.info(log);
            }
        }
    }

    class AnomalyHandlerTask
    implements Runnable {
        AnomalyHandlerTask() {
        }

        @Override
        public void run() {
            LOG.info("Starting anomaly handler");
            while (!Thread.currentThread().isInterrupted()) {
                boolean retryHandling = false;
                AnomalyDetector.this.anomalyInProgress = null;
                try {
                    AnomalyDetector.this.anomalyInProgress = (Anomaly)AnomalyDetector.this.anomalies.takeFirst();
                    LOG.trace("Processing anomaly {}.", (Object)AnomalyDetector.this.anomalyInProgress);
                    this.handleAnomalyInProgress();
                }
                catch (InterruptedException e) {
                    LOG.info("Anomaly handler is exiting...");
                    AnomalyDetector.this.anomalyInProgress = null;
                    Thread.currentThread().interrupt();
                }
                catch (KafkaCruiseControlException kcce) {
                    LOG.warn("Anomaly handler received exception when trying to fix the anomaly {}.", (Object)AnomalyDetector.this.anomalyInProgress, (Object)kcce);
                    retryHandling = true;
                }
                catch (RebalancePlanComputationException rebalancePlanComputationException) {
                    LOG.warn("Anomaly handler received an exception when trying to compute a plan for anomaly {}.", (Object)AnomalyDetector.this.anomalyInProgress, (Object)rebalancePlanComputationException);
                    retryHandling = true;
                }
                catch (Throwable t) {
                    LOG.error("Uncaught exception in anomaly handler.", t);
                    retryHandling = true;
                }
                if (AnomalyDetector.this.anomalyInProgress != null && AnomalyType.GOAL_VIOLATION.equals((Object)AnomalyDetectorUtils.getAnomalyType(AnomalyDetector.this.anomalyInProgress))) {
                    AnomalyDetector.this.canGoalViolationBeFixed(((GoalViolations)AnomalyDetector.this.anomalyInProgress).canViolationBeFixed());
                }
                if (AnomalyDetector.this.anomalyInProgress == null || !retryHandling) continue;
                this.checkWithDelay(AnomalyDetector.this.anomalyDetectionIntervalMs);
            }
            LOG.info("Anomaly handler exited.");
        }

        private void handleAnomalyInProgress() throws Exception {
            AnomalyType anomalyType = AnomalyDetectorUtils.getAnomalyType(AnomalyDetector.this.anomalyInProgress);
            AnomalyDetector.this.anomalyDetectorState.addAnomalyDetection(anomalyType, AnomalyDetector.this.anomalyInProgress);
            ExecutorState.State executorState = AnomalyDetector.this.kafkaCruiseControl.executionState();
            if (executorState != ExecutorState.State.NO_TASK_IN_PROGRESS) {
                LOG.debug("Schedule delayed check for anomaly {} because executor is in {} state", (Object)AnomalyDetector.this.anomalyInProgress, (Object)executorState);
                this.checkWithDelay(AnomalyDetector.this.anomalyDetectionIntervalMs);
            } else if (AnomalyDetector.this.kafkaCruiseControl.executorIsReserved()) {
                LOG.debug("Ignoring anomaly {} because the executor is reserved", (Object)AnomalyDetector.this.anomalyInProgress);
                AnomalyDetector.this.anomalyDetectorState.onAnomalyHandle(AnomalyDetector.this.anomalyInProgress, AnomalyState.Status.IGNORED);
            } else {
                this.processAnomalyInProgress(anomalyType);
            }
        }

        private void processAnomalyInProgress(AnomalyType anomalyType) throws Exception {
            AnomalyDetector.this.anomalyDetectorState.markAnomalyRate(anomalyType);
            AnomalyNotificationResult notificationResult = this.notifyAnomalyInProgress(anomalyType);
            if (notificationResult != null) {
                AnomalyDetector.this.anomalyDetectorState.maybeSetOngoingAnomalyDetectionTimeMs();
                switch (notificationResult.action()) {
                    case FIX: {
                        this.fixAnomalyInProgress(anomalyType);
                        break;
                    }
                    case CHECK: {
                        this.checkWithDelay(notificationResult.delay());
                        break;
                    }
                    case IGNORE: {
                        AnomalyDetector.this.anomalyDetectorState.onAnomalyHandle(AnomalyDetector.this.anomalyInProgress, AnomalyState.Status.IGNORED);
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unrecognized anomaly notification result.");
                    }
                }
            }
        }

        private AnomalyNotificationResult notifyAnomalyInProgress(AnomalyType anomalyType) {
            AnomalyNotificationResult notificationResult = null;
            switch (anomalyType) {
                case GOAL_VIOLATION: 
                case BROKER_FAILURE: 
                case CELL_OVERLOAD: {
                    notificationResult = ((KafkaAnomaly)AnomalyDetector.this.anomalyInProgress).notifyAnomalyInProgress(AnomalyDetector.this.selfHealingNotifier);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unrecognized anomaly type.");
                }
            }
            LOG.debug("Received notification result {}", (Object)notificationResult);
            return notificationResult;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void checkWithDelay(long delay) {
            if (AnomalyDetectorUtils.getAnomalyType(AnomalyDetector.this.anomalyInProgress) == AnomalyType.BROKER_FAILURE) {
                Object object = AnomalyDetector.this.shutdownLock;
                synchronized (object) {
                    if (AnomalyDetector.this.shutdown) {
                        LOG.debug("Skip delayed checking anomaly {}, because anomaly detector is shutting down.", (Object)AnomalyDetector.this.anomalyInProgress);
                    } else {
                        LOG.debug("Scheduling broker failure detection with delay of {} ms", (Object)delay);
                        AnomalyDetector.this.numCheckedWithDelay.incrementAndGet();
                        AnomalyDetector.this.detectorScheduler.schedule(AnomalyDetector.this.brokerFailureDetector::scheduleDetection, delay, TimeUnit.MILLISECONDS);
                        AnomalyDetector.this.anomalyDetectorState.onAnomalyHandle(AnomalyDetector.this.anomalyInProgress, AnomalyState.Status.CHECK_WITH_DELAY);
                    }
                }
            } else {
                AnomalyDetector.this.anomalyDetectorState.onAnomalyHandle(AnomalyDetector.this.anomalyInProgress, AnomalyState.Status.IGNORED);
            }
        }

        private OptimizationPlaintextSummary optimizationResultSummary(AnomalyType anomalyType) {
            switch (anomalyType) {
                case GOAL_VIOLATION: 
                case BROKER_FAILURE: 
                case CELL_OVERLOAD: {
                    return ((KafkaAnomaly)AnomalyDetector.this.anomalyInProgress).optimizationResultSummary();
                }
            }
            throw new IllegalStateException("Unrecognized anomaly type.");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void fixAnomalyInProgress(AnomalyType anomalyType) throws Exception {
            Object object = AnomalyDetector.this.shutdownLock;
            synchronized (object) {
                if (AnomalyDetector.this.shutdown) {
                    LOG.info("Skip fixing anomaly {}, because anomaly detector is shutting down.", (Object)AnomalyDetector.this.anomalyInProgress);
                } else {
                    boolean isReadyToFix = AnomalyDetector.this.anomalyInProgress.ready();
                    if (isReadyToFix) {
                        LOG.info("Fixing anomaly {}", (Object)AnomalyDetector.this.anomalyInProgress);
                        AnomalyFixStatus fixStatus = AnomalyFixStatus.START_FAILED;
                        String anomalyId = AnomalyDetector.this.anomalyInProgress.anomalyId();
                        AnomalyDetector.this.anomalyDetectorState.onAnomalyHandle(AnomalyDetector.this.anomalyInProgress, AnomalyState.Status.ATTEMPTING_FIX);
                        try {
                            fixStatus = AnomalyDetector.this.anomalyInProgress.fix();
                            OptimizationPlaintextSummary summary = this.optimizationResultSummary(anomalyType);
                            OptimizationResultSummary.fromSummary(anomalyId, fixStatus, summary).logSelfHealingOperation();
                        }
                        catch (OptimizationFailureException ofe) {
                            OptimizationResultSummary.fromException(anomalyId, fixStatus, ofe).logSelfHealingOperation();
                            throw ofe;
                        }
                        finally {
                            this.updateAnomalyDetectorState(anomalyId, fixStatus);
                        }
                    } else {
                        AnomalyDetector.this.anomalyDetectorState.onAnomalyHandle(AnomalyDetector.this.anomalyInProgress, AnomalyState.Status.COMPLETENESS_NOT_READY);
                    }
                    this.handlePostFixAnomaly(isReadyToFix);
                }
            }
        }

        private void updateAnomalyDetectorState(String anomalyId, AnomalyFixStatus fixStatus) {
            AnomalyState.Status anomalyStateStatus = AnomalyState.Status.ATTEMPTING_FIX;
            switch (fixStatus) {
                case START_SUCCESSFULLY: {
                    anomalyStateStatus = AnomalyState.Status.FIX_STARTED;
                    AnomalyDetector.this.anomalyDetectorState.incrementNumSelfHealingStarted();
                    break;
                }
                case START_FAILED: {
                    anomalyStateStatus = AnomalyState.Status.FIX_FAILED_TO_START;
                    AnomalyDetector.this.markSelfHealingFinished(anomalyId);
                    AnomalyDetector.this.anomalyDetectorState.incrementNumSelfHealingErrors();
                    break;
                }
                case DID_NOT_START: {
                    anomalyStateStatus = AnomalyState.Status.IGNORED;
                    AnomalyDetector.this.markSelfHealingFinished(anomalyId);
                    break;
                }
                default: {
                    String errMsg = "Unknown Self-healing state is detected: " + (Object)((Object)fixStatus);
                    LOG.warn(errMsg);
                    throw new IllegalStateException(errMsg);
                }
            }
            AnomalyDetector.this.anomalyDetectorState.onAnomalyHandle(AnomalyDetector.this.anomalyInProgress, anomalyStateStatus);
        }

        private void handlePostFixAnomaly(boolean isReadyToFix) {
            AnomalyDetector.this.anomalies.clear();
            AnomalyDetector.this.detectorScheduler.schedule(AnomalyDetector.this.brokerFailureDetector::scheduleDetection, isReadyToFix ? 0L : AnomalyDetector.this.anomalyDetectionIntervalMs, TimeUnit.MILLISECONDS);
        }
    }
}

