/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.detector;

import com.linkedin.kafka.cruisecontrol.KafkaCruiseControlUtils;
import com.linkedin.kafka.cruisecontrol.detector.notifier.AnomalyType;
import java.util.Map;

public class AnomalyStats {
    private final Map<AnomalyType, Double> meanTimeBetweenAnomaliesMs;
    private final double meanTimeToStartFixMs;
    private final long numSelfHealingStarted;
    private final long ongoingAnomalyDurationMs;

    public AnomalyStats(Map<AnomalyType, Double> meanTimeBetweenAnomaliesMs, double meanTimeToStartFixMs, long numSelfHealingStarted, long ongoingAnomalyDurationMs) {
        if (meanTimeBetweenAnomaliesMs == null) {
            throw new IllegalArgumentException("Attempt to set meanTimeBetweenAnomaliesMs with null.");
        }
        for (AnomalyType anomalyType : AnomalyType.cachedValues()) {
            if (meanTimeBetweenAnomaliesMs.containsKey((Object)anomalyType)) continue;
            throw new IllegalArgumentException((Object)((Object)anomalyType) + " is missing in meanTimeBetweenAnomaliesMs metric.");
        }
        this.meanTimeBetweenAnomaliesMs = meanTimeBetweenAnomaliesMs;
        this.meanTimeToStartFixMs = meanTimeToStartFixMs;
        this.numSelfHealingStarted = numSelfHealingStarted;
        this.ongoingAnomalyDurationMs = ongoingAnomalyDurationMs;
    }

    public double meanTimeToStartFixMs() {
        return this.meanTimeToStartFixMs;
    }

    public Map<AnomalyType, Double> meanTimeBetweenAnomaliesMs() {
        return this.meanTimeBetweenAnomaliesMs;
    }

    public long numSelfHealingStarted() {
        return this.numSelfHealingStarted;
    }

    public long ongoingAnomalyDurationMs() {
        return this.ongoingAnomalyDurationMs;
    }

    public String toString() {
        return String.format("{meanTimeBetweenAnomalies:{%s:%s, %s:%s}, meanTimeToStartFix:%s, numSelfHealingStarted:%d, ongoingAnomalyDuration=%s}", new Object[]{AnomalyType.GOAL_VIOLATION, KafkaCruiseControlUtils.toPrettyDuration(this.meanTimeBetweenAnomaliesMs.get((Object)AnomalyType.GOAL_VIOLATION)), AnomalyType.BROKER_FAILURE, KafkaCruiseControlUtils.toPrettyDuration(this.meanTimeBetweenAnomaliesMs.get((Object)AnomalyType.BROKER_FAILURE)), KafkaCruiseControlUtils.toPrettyDuration(this.meanTimeToStartFixMs), this.numSelfHealingStarted, KafkaCruiseControlUtils.toPrettyDuration(this.ongoingAnomalyDurationMs)});
    }
}

