/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.detector;

import com.linkedin.cruisecontrol.detector.AnomalyFixStatus;
import com.linkedin.kafka.cruisecontrol.KafkaCruiseControl;
import com.linkedin.kafka.cruisecontrol.KafkaCruiseControlUtils;
import com.linkedin.kafka.cruisecontrol.PlanComputationOptions;
import com.linkedin.kafka.cruisecontrol.analyzer.OptimizationResult;
import com.linkedin.kafka.cruisecontrol.config.GoalsConfig;
import com.linkedin.kafka.cruisecontrol.detector.KafkaAnomaly;
import com.linkedin.kafka.cruisecontrol.detector.notifier.AnomalyNotificationResult;
import com.linkedin.kafka.cruisecontrol.detector.notifier.AnomalyType;
import com.linkedin.kafka.cruisecontrol.detector.notifier.SelfHealingNotifier;
import java.util.Map;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrokerFailures
extends KafkaAnomaly {
    private static final Logger LOG = LoggerFactory.getLogger(BrokerFailures.class);
    private static final String ID_PREFIX = AnomalyType.BROKER_FAILURE.toString();
    private final KafkaCruiseControl kafkaCruiseControl;
    private final Map<Integer, Long> failedBrokers;
    private final GoalsConfig goalsConfig;
    private final PlanComputationOptions opts;
    private final String anomalyId;

    public BrokerFailures(KafkaCruiseControl kafkaCruiseControl, Map<Integer, Long> failedBrokers, boolean allowCapacityEstimation, boolean excludeRecentlyRemovedBrokers, GoalsConfig goalsConfig) {
        this.kafkaCruiseControl = kafkaCruiseControl;
        this.failedBrokers = failedBrokers;
        this.goalsConfig = goalsConfig;
        if (this.failedBrokers != null && this.failedBrokers.isEmpty()) {
            throw new IllegalArgumentException("Missing broker ids for failed brokers.");
        }
        this.opts = new PlanComputationOptions(allowCapacityEstimation, excludeRecentlyRemovedBrokers);
        this.anomalyId = String.format("%s-%s", ID_PREFIX, UUID.randomUUID().toString().substring(ID_PREFIX.length() + 1));
        this.optimizationResult = null;
    }

    public Map<Integer, Long> failedBrokers() {
        return this.failedBrokers;
    }

    @Override
    public String anomalyId() {
        return this.anomalyId;
    }

    @Override
    public boolean ready() {
        KafkaCruiseControl.CompletenessRequirementCheck completenessCheck = this.kafkaCruiseControl.meetCompletenessRequirements(this.goalsConfig.goals(), this.failedBrokers.keySet());
        if (!completenessCheck.meetsRequirements()) {
            LOG.warn("Skipping {} fix because load completeness requirement is not met for goals - {}.", (Object)AnomalyType.BROKER_FAILURE, (Object)completenessCheck.failureReason());
        }
        return completenessCheck.meetsRequirements();
    }

    @Override
    public AnomalyNotificationResult notifyAnomalyInProgress(SelfHealingNotifier selfHealingNotifier) {
        return selfHealingNotifier.onBrokerFailure(this);
    }

    @Override
    public AnomalyFixStatus fix() throws Exception {
        if (this.failedBrokers != null && !this.failedBrokers.isEmpty()) {
            this.optimizationResult = new OptimizationResult(this.kafkaCruiseControl.fixBrokerFailures(this.failedBrokers.keySet(), this.goalsConfig, this.anomalyId, this.opts));
            this.optimizationResult.discardIrrelevantAndCacheText();
            return AnomalyFixStatus.START_SUCCESSFULLY;
        }
        return AnomalyFixStatus.START_FAILED;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder().append("{\n");
        if (this.failedBrokers != null) {
            this.failedBrokers.forEach((key, value) -> sb.append("\tBroker ").append(key).append(" failed at ").append(KafkaCruiseControlUtils.toDateString(value)).append("\n"));
        }
        sb.append("}");
        return sb.toString();
    }
}

