/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.detector.factory;

import com.linkedin.cruisecontrol.detector.Anomaly;
import com.linkedin.kafka.cruisecontrol.KafkaCruiseControlOperationMetricsTracker;
import com.linkedin.kafka.cruisecontrol.config.KafkaCruiseControlConfig;
import com.linkedin.kafka.cruisecontrol.config.UpdatableSbcConfig;
import com.linkedin.kafka.cruisecontrol.detector.BrokerAdditionDetector;
import com.linkedin.kafka.cruisecontrol.detector.BrokerAdditionDetectorWithTopicDistribution;
import com.linkedin.kafka.cruisecontrol.detector.CellOverloadDetector;
import com.linkedin.kafka.cruisecontrol.detector.CpuUtilizationDetector;
import com.linkedin.kafka.cruisecontrol.detector.DiskUtilizationDetector;
import com.linkedin.kafka.cruisecontrol.detector.ResourceUtilizationDetector;
import com.linkedin.kafka.cruisecontrol.detector.utils.CellOverloadOccurrenceRecorder;
import io.confluent.databalancer.metrics.CellOverloadMetrics;
import io.confluent.databalancer.metrics.GeneralSBCMetricsRegistry;
import io.confluent.databalancer.metrics.internals.TenantUtilizationMetricHandler;
import io.confluent.databalancer.operation.BrokerAdditionV2StateManager;
import io.confluent.databalancer.persistence.ApiStatePersistenceStore;
import io.confluent.kafka.clients.CloudAdmin;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.function.Supplier;
import org.apache.kafka.common.utils.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceUtilizationDetectorBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(ResourceUtilizationDetectorBuilder.class);
    private ApiStatePersistenceStore persistenceStore;
    private BrokerAdditionV2StateManager brokerAdditionV2StateManager;
    private CloudAdmin adminClient;
    private GeneralSBCMetricsRegistry metricsRegistry;
    private CellOverloadMetrics cellOverloadMetrics;
    private Supplier<Boolean> shouldSkipAnomalyDetectionSupplier;
    private KafkaCruiseControlConfig kccConfig;
    private KafkaCruiseControlOperationMetricsTracker operationMetricsTracker;
    private UpdatableSbcConfig updatableSbcConfig;
    private Queue<Anomaly> anomalies;
    private Time time;

    public ResourceUtilizationDetectorBuilder persistenceStore(ApiStatePersistenceStore persistenceStore) {
        this.persistenceStore = persistenceStore;
        return this;
    }

    public ResourceUtilizationDetectorBuilder brokerAdditionV2StateManager(BrokerAdditionV2StateManager brokerAdditionV2StateManager) {
        this.brokerAdditionV2StateManager = brokerAdditionV2StateManager;
        return this;
    }

    public ResourceUtilizationDetectorBuilder adminClient(CloudAdmin adminClient) {
        this.adminClient = adminClient;
        return this;
    }

    public ResourceUtilizationDetectorBuilder metricsRegistry(GeneralSBCMetricsRegistry metricsRegistry) {
        this.metricsRegistry = metricsRegistry;
        return this;
    }

    public ResourceUtilizationDetectorBuilder cellOverloadMetrics(CellOverloadMetrics cellOverloadMetrics) {
        this.cellOverloadMetrics = cellOverloadMetrics;
        return this;
    }

    public ResourceUtilizationDetectorBuilder shouldSkipAnomalyDetectionSupplier(Supplier<Boolean> shouldSkipAnomalyDetectionSupplier) {
        this.shouldSkipAnomalyDetectionSupplier = shouldSkipAnomalyDetectionSupplier;
        return this;
    }

    public ResourceUtilizationDetectorBuilder kccConfig(KafkaCruiseControlConfig kccConfig) {
        this.kccConfig = kccConfig;
        return this;
    }

    public ResourceUtilizationDetectorBuilder operationMetricsTracker(KafkaCruiseControlOperationMetricsTracker operationMetricsTracker) {
        this.operationMetricsTracker = operationMetricsTracker;
        return this;
    }

    public ResourceUtilizationDetectorBuilder updatableSbcConfig(UpdatableSbcConfig updatableSbcConfig) {
        this.updatableSbcConfig = updatableSbcConfig;
        return this;
    }

    public ResourceUtilizationDetectorBuilder anomalies(Queue<Anomaly> anomalies) {
        this.anomalies = anomalies;
        return this;
    }

    public ResourceUtilizationDetectorBuilder time(Time time) {
        this.time = time;
        return this;
    }

    public List<ResourceUtilizationDetector> buildResourceUtilizationDetectors() {
        ArrayList<ResourceUtilizationDetector> detectors = new ArrayList<ResourceUtilizationDetector>();
        if (this.kccConfig.getBoolean("cpu.utilization.detector.enabled").booleanValue()) {
            LOG.info("CPU Utilization Detector is Enabled.");
            detectors.add(new CpuUtilizationDetector(this.kccConfig, this.time, this.metricsRegistry));
        }
        if (this.kccConfig.getBoolean("disk.utilization.detector.enabled").booleanValue()) {
            LOG.info("Disk Utilization Detector is Enabled.");
            detectors.add(new DiskUtilizationDetector(this.kccConfig, this.time, this.metricsRegistry));
        }
        if (this.kccConfig.getBoolean("incremental.balancing.enabled").booleanValue() && this.kccConfig.getBoolean("v2.addition.enabled").booleanValue()) {
            ResourceUtilizationDetector brokerAdditionDetector;
            if (this.kccConfig.getBoolean("topic.balancing.broker.addition.detector.with.trdg.enabled").booleanValue()) {
                LOG.info("Broker Addition Detector with Topic Distribution is Enabled.");
                brokerAdditionDetector = new BrokerAdditionDetectorWithTopicDistribution(this.kccConfig, this.time, this.metricsRegistry, this.brokerAdditionV2StateManager, this.operationMetricsTracker, this.updatableSbcConfig.updatableBalancingConstraint());
            } else {
                LOG.info("Default Broker Addition Detector is Enabled.");
                brokerAdditionDetector = new BrokerAdditionDetector(this.kccConfig, this.time, this.metricsRegistry, this.brokerAdditionV2StateManager, this.operationMetricsTracker, this.updatableSbcConfig.updatableBalancingConstraint());
            }
            detectors.add(brokerAdditionDetector);
        }
        if (this.kccConfig.getBoolean("confluent.cells.enable").booleanValue()) {
            LOG.info("Cell Overload Detector is {}.", (Object)(this.kccConfig.getBoolean("inter.cell.balancing.enabled") != false ? "enabled" : "disabled, hence running in dry-run mode."));
            CellOverloadOccurrenceRecorder cellOverloadOccurrenceRecorder = new CellOverloadOccurrenceRecorder(this.persistenceStore);
            TenantUtilizationMetricHandler tenantUtilizationMetricHandler = new TenantUtilizationMetricHandler(this.kccConfig, this.cellOverloadMetrics);
            CellOverloadDetector cellOverloadDetector = new CellOverloadDetector(this.kccConfig, this.adminClient, this.shouldSkipAnomalyDetectionSupplier, this.anomalies, cellOverloadOccurrenceRecorder, this.cellOverloadMetrics, tenantUtilizationMetricHandler, this.time);
            detectors.add(cellOverloadDetector);
        }
        return detectors;
    }
}

