/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.model;

import com.google.gson.Gson;
import com.linkedin.kafka.cruisecontrol.analyzer.BalancingConstraint;
import com.linkedin.kafka.cruisecontrol.common.Resource;
import com.linkedin.kafka.cruisecontrol.common.Statistic;
import com.linkedin.kafka.cruisecontrol.model.Broker;
import com.linkedin.kafka.cruisecontrol.model.ClusterModel;
import com.linkedin.kafka.cruisecontrol.model.Replica;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.function.Function;
import org.apache.kafka.common.TopicPartition;

public class ClusterModelStats {
    private final Map<Statistic, Map<Resource, Double>> resourceUtilizationStats = new HashMap<Statistic, Map<Resource, Double>>();
    private final Map<Statistic, Double> potentialNwOutUtilizationStats = new HashMap<Statistic, Double>();
    private final Map<Statistic, Number> replicaStats = new HashMap<Statistic, Number>();
    private final Map<Statistic, Number> leaderReplicaStats = new HashMap<Statistic, Number>();
    private final Map<Statistic, Number> topicReplicaStats = new HashMap<Statistic, Number>();
    private final Map<Statistic, Number> topicLeaderReplicaStats = new HashMap<Statistic, Number>();
    private final Map<Statistic, Number> topicFollowerReplicaStats = new HashMap<Statistic, Number>();
    private int numBrokers = 0;
    private int numAliveBrokers;
    private int numReplicasInCluster = 0;
    private int numPartitionsWithOfflineReplicas = 0;
    private int numTopics = 0;
    private Map<Resource, Integer> numBalancedBrokersByResource = new HashMap<Resource, Integer>();
    private int numBrokersUnderPotentialNwOut = 0;
    private BalancingConstraint balancingConstraint;
    private int numSnapshotWindows;
    private double monitoredPartitionsRatio;
    private int numUnbalancedDisks = 0;

    ClusterModelStats populate(ClusterModel clusterModel, BalancingConstraint balancingConstraint) {
        this.numBrokers = clusterModel.allBrokers().size();
        this.numAliveBrokers = clusterModel.aliveBrokers().size();
        this.numTopics = clusterModel.topics().size();
        this.balancingConstraint = balancingConstraint;
        this.utilizationForResources(clusterModel);
        this.utilizationForPotentialNwOut(clusterModel);
        this.numForReplicas(clusterModel);
        this.numForLeaderReplicas(clusterModel);
        this.numForAvgTopicReplicas(clusterModel);
        this.numForTopicLeaderReplicas(clusterModel);
        this.numForTopicFollowerReplicas(clusterModel);
        this.numSnapshotWindows = clusterModel.load().numWindows();
        this.monitoredPartitionsRatio = clusterModel.monitoredPartitionsRatio();
        return this;
    }

    public Map<Statistic, Map<Resource, Double>> resourceUtilizationStats() {
        return this.resourceUtilizationStats;
    }

    public Map<Statistic, Double> potentialNwOutUtilizationStats() {
        return this.potentialNwOutUtilizationStats;
    }

    public Map<Statistic, Number> replicaStats() {
        return this.replicaStats;
    }

    public Map<Statistic, Number> leaderReplicaStats() {
        return this.leaderReplicaStats;
    }

    public Map<Statistic, Number> topicReplicaStats() {
        return this.topicReplicaStats;
    }

    public Map<Statistic, Number> topicLeaderReplicaStats() {
        return this.topicLeaderReplicaStats;
    }

    public Map<Statistic, Number> topicFollowerReplicaStats() {
        return this.topicFollowerReplicaStats;
    }

    public int numBrokers() {
        return this.numBrokers;
    }

    public int numReplicasInCluster() {
        return this.numReplicasInCluster;
    }

    public int numPartitionsWithOfflineReplicas() {
        return this.numPartitionsWithOfflineReplicas;
    }

    public int numTopics() {
        return this.numTopics;
    }

    public Map<Resource, Integer> numBalancedBrokersByResource() {
        return this.numBalancedBrokersByResource;
    }

    public int numBrokersUnderPotentialNwOut() {
        return this.numBrokersUnderPotentialNwOut;
    }

    public double monitoredPartitionsPercentage() {
        return this.monitoredPartitionsRatio * 100.0;
    }

    public int numSnapshotWindows() {
        return this.numSnapshotWindows;
    }

    public int numUnbalancedDisks() {
        return this.numUnbalancedDisks;
    }

    public String getJSONString() {
        Gson gson = new Gson();
        return gson.toJson(this.getJsonStructure());
    }

    public Map<String, Object> getJsonStructure() {
        HashMap<String, Object> statMap = new HashMap<String, Object>();
        HashMap<String, Integer> basicMap = new HashMap<String, Integer>();
        basicMap.put("brokers", this.numBrokers());
        basicMap.put("replicas", this.numReplicasInCluster());
        basicMap.put("topics", this.numTopics());
        List<Statistic> cachedStatistic = Statistic.cachedValues();
        HashMap allStatMap = new HashMap(cachedStatistic.size());
        for (Statistic stat : cachedStatistic) {
            List<Resource> cachedResources = Resource.cachedValues();
            HashMap<String, Number> resourceMap = new HashMap<String, Number>(cachedResources.size() + 3);
            for (Resource resource : cachedResources) {
                resourceMap.put(resource.resource(), this.resourceUtilizationStats().get((Object)stat).get((Object)resource));
            }
            resourceMap.put("potentialNwOut", this.potentialNwOutUtilizationStats().get((Object)stat));
            resourceMap.put("replicas", this.replicaStats().get((Object)stat));
            resourceMap.put("leaderReplicas", this.leaderReplicaStats().get((Object)stat));
            resourceMap.put("topicReplicas", this.topicReplicaStats().get((Object)stat));
            allStatMap.put(stat.stat(), resourceMap);
        }
        statMap.put("metadata", basicMap);
        statMap.put("statistics", allStatMap);
        return statMap;
    }

    public String toStringCounts() {
        return String.format("%d brokers %d replicas %d topics.", this.numBrokers(), this.numReplicasInCluster(), this.numTopics());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Statistic stat : Statistic.cachedValues()) {
            sb.append(String.format("%s:{", new Object[]{stat}));
            for (Resource resource : Resource.cachedValues()) {
                sb.append(String.format("%s:%12.3f ", new Object[]{resource, this.resourceUtilizationStats().get((Object)stat).get((Object)resource)}));
            }
            sb.append(String.format("%s:%12.3f %s:%s %s:%s %s:%s}%n", "potentialNwOut", this.potentialNwOutUtilizationStats().get((Object)stat), "replicas", this.replicaStats().get((Object)stat), "leaderReplicas", this.leaderReplicaStats().get((Object)stat), "topicReplicas", this.topicReplicaStats().get((Object)stat)));
        }
        return sb.substring(0, sb.length() - 2);
    }

    private void utilizationForResources(ClusterModel clusterModel) {
        HashMap<Resource, Double> avgUtilizationByResource = new HashMap<Resource, Double>();
        HashMap<Resource, Double> maxUtilizationByResource = new HashMap<Resource, Double>();
        HashMap<Resource, Double> minUtilizationByResource = new HashMap<Resource, Double>();
        HashMap<Resource, Double> stDevUtilizationByResource = new HashMap<Resource, Double>();
        for (Resource resource : Resource.cachedValues()) {
            double avgUtilizationPercentage = clusterModel.load().expectedUtilizationFor(resource) / clusterModel.capacity().totalCapacityFor(resource);
            double balanceUpperThreshold = avgUtilizationPercentage * this.balancingConstraint.resourceBalancePercentage(resource);
            double balanceLowerThreshold = avgUtilizationPercentage * Math.max(0.0, 2.0 - this.balancingConstraint.resourceBalancePercentage(resource));
            double hottestBrokerUtilization = 0.0;
            double coldestBrokerUtilization = Double.MAX_VALUE;
            double varianceSum = 0.0;
            int numBalancedBrokers = 0;
            for (Broker broker : clusterModel.aliveBrokers()) {
                double capacity;
                double utilization = broker.load(resource).expectedUtilizationFor(resource);
                double utilizationPercentage = utilization / (capacity = broker.capacity(resource).totalCapacityFor(resource));
                if (utilizationPercentage >= balanceLowerThreshold && utilizationPercentage <= balanceUpperThreshold) {
                    ++numBalancedBrokers;
                }
                hottestBrokerUtilization = Math.max(hottestBrokerUtilization, utilization);
                coldestBrokerUtilization = Math.min(coldestBrokerUtilization, utilization);
                varianceSum += Math.pow(utilization - avgUtilizationPercentage * capacity, 2.0);
            }
            this.numBalancedBrokersByResource.put(resource, numBalancedBrokers);
            avgUtilizationByResource.put(resource, clusterModel.load().expectedUtilizationFor(resource) / (double)this.numAliveBrokers);
            maxUtilizationByResource.put(resource, hottestBrokerUtilization);
            minUtilizationByResource.put(resource, coldestBrokerUtilization);
            stDevUtilizationByResource.put(resource, Math.sqrt(varianceSum / (double)this.numAliveBrokers));
        }
        this.resourceUtilizationStats.put(Statistic.AVG, avgUtilizationByResource);
        this.resourceUtilizationStats.put(Statistic.MAX, maxUtilizationByResource);
        this.resourceUtilizationStats.put(Statistic.MIN, minUtilizationByResource);
        this.resourceUtilizationStats.put(Statistic.ST_DEV, stDevUtilizationByResource);
    }

    private void utilizationForPotentialNwOut(ClusterModel clusterModel) {
        double maxPotentialNwOut = 0.0;
        double minPotentialNwOut = Double.MAX_VALUE;
        double varianceSum = 0.0;
        double potentialNwOutInCluster = clusterModel.aliveBrokers().stream().mapToDouble(b -> clusterModel.potentialLeadershipLoadFor(b.id()).expectedUtilizationFor(Resource.NW_OUT)).sum();
        double avgPotentialNwOutUtilizationPct = potentialNwOutInCluster / clusterModel.capacity().totalCapacityFor(Resource.NW_OUT);
        for (Broker broker : clusterModel.aliveBrokers()) {
            double brokerUtilization = clusterModel.potentialLeadershipLoadFor(broker.id()).expectedUtilizationFor(Resource.NW_OUT);
            double brokerCapacity = broker.capacity().totalCapacityFor(Resource.NW_OUT);
            double capacityLimit = this.balancingConstraint.allowedCapacityForBroker(Resource.NW_OUT, broker.capacity());
            if (brokerUtilization <= capacityLimit) {
                ++this.numBrokersUnderPotentialNwOut;
            }
            maxPotentialNwOut = Math.max(maxPotentialNwOut, brokerUtilization);
            minPotentialNwOut = Math.min(minPotentialNwOut, brokerUtilization);
            varianceSum += Math.pow(brokerUtilization - avgPotentialNwOutUtilizationPct * brokerCapacity, 2.0);
        }
        this.potentialNwOutUtilizationStats.put(Statistic.AVG, potentialNwOutInCluster / (double)this.numAliveBrokers);
        this.potentialNwOutUtilizationStats.put(Statistic.MAX, maxPotentialNwOut);
        this.potentialNwOutUtilizationStats.put(Statistic.MIN, minPotentialNwOut);
        this.potentialNwOutUtilizationStats.put(Statistic.ST_DEV, Math.sqrt(varianceSum / (double)this.numAliveBrokers));
    }

    private void numForReplicas(ClusterModel clusterModel) {
        this.populateReplicaStats(clusterModel, Broker::numReplicas, this.replicaStats);
        this.numReplicasInCluster = clusterModel.numReplicas();
        HashSet<TopicPartition> partitionsWithOfflineReplicas = new HashSet<TopicPartition>();
        for (Replica replica : clusterModel.selfHealingEligibleReplicas()) {
            partitionsWithOfflineReplicas.add(replica.topicPartition());
        }
        this.numPartitionsWithOfflineReplicas = partitionsWithOfflineReplicas.size();
    }

    private void numForLeaderReplicas(ClusterModel clusterModel) {
        this.populateReplicaStats(clusterModel, Broker::numLeaderReplicas, this.leaderReplicaStats);
    }

    private void populateReplicaStats(ClusterModel clusterModel, Function<Broker, Integer> numInterestedReplicasFunc, Map<Statistic, Number> interestedReplicaStats) {
        int maxInterestedReplicasInBroker = 0;
        int minInterestedReplicasInBroker = Integer.MAX_VALUE;
        int numInterestedReplicasInCluster = 0;
        for (Broker broker : clusterModel.allBrokers()) {
            int numInterestedReplicasInBroker = numInterestedReplicasFunc.apply(broker);
            numInterestedReplicasInCluster += numInterestedReplicasInBroker;
            maxInterestedReplicasInBroker = Math.max(maxInterestedReplicasInBroker, numInterestedReplicasInBroker);
            minInterestedReplicasInBroker = Math.min(minInterestedReplicasInBroker, numInterestedReplicasInBroker);
        }
        double avgInterestedReplicas = (double)numInterestedReplicasInCluster / (double)this.numAliveBrokers;
        double varianceForInterestedReplicas = 0.0;
        for (Broker broker : clusterModel.aliveBrokers()) {
            varianceForInterestedReplicas += Math.pow((double)numInterestedReplicasFunc.apply(broker).intValue() - avgInterestedReplicas, 2.0) / (double)this.numAliveBrokers;
        }
        interestedReplicaStats.put(Statistic.AVG, avgInterestedReplicas);
        interestedReplicaStats.put(Statistic.MAX, maxInterestedReplicasInBroker);
        interestedReplicaStats.put(Statistic.MIN, minInterestedReplicasInBroker);
        interestedReplicaStats.put(Statistic.ST_DEV, Math.sqrt(varianceForInterestedReplicas));
    }

    private void numForAvgTopicReplicas(ClusterModel clusterModel) {
        this.populateTopicReplicaStats(clusterModel, this.topicReplicaStats, true, true);
    }

    private void numForTopicLeaderReplicas(ClusterModel clusterModel) {
        this.populateTopicReplicaStats(clusterModel, this.topicLeaderReplicaStats, true, false);
    }

    private void numForTopicFollowerReplicas(ClusterModel clusterModel) {
        this.populateTopicReplicaStats(clusterModel, this.topicFollowerReplicaStats, false, true);
    }

    private void populateTopicReplicaStats(ClusterModel clusterModel, Map<Statistic, Number> interestedReplicaStats, boolean leaderReplica, boolean followerReplica) {
        interestedReplicaStats.put(Statistic.AVG, 0.0);
        interestedReplicaStats.put(Statistic.MAX, 0);
        interestedReplicaStats.put(Statistic.MIN, Integer.MAX_VALUE);
        interestedReplicaStats.put(Statistic.ST_DEV, 0.0);
        int numAliveBrokers = clusterModel.aliveBrokers().size();
        SortedSet<Broker> allBrokers = clusterModel.allBrokers();
        for (String topic : clusterModel.topics()) {
            int maxTopicReplicasInBroker = 0;
            int minTopicReplicasInBroker = Integer.MAX_VALUE;
            int sumTopicReplicasInBroker = 0;
            for (Broker broker : allBrokers) {
                int numTopicReplicasInBroker = this.numOfTopicReplicaInBroker(broker, topic, leaderReplica, followerReplica);
                maxTopicReplicasInBroker = Math.max(maxTopicReplicasInBroker, numTopicReplicasInBroker);
                minTopicReplicasInBroker = Math.min(minTopicReplicasInBroker, numTopicReplicasInBroker);
                sumTopicReplicasInBroker += numTopicReplicasInBroker;
            }
            double avgTopicReplicas = (double)sumTopicReplicasInBroker / (double)numAliveBrokers;
            double variance = 0.0;
            for (Broker broker : clusterModel.aliveBrokers()) {
                variance += Math.pow((double)this.numOfTopicReplicaInBroker(broker, topic, leaderReplica, followerReplica) - avgTopicReplicas, 2.0) / (double)numAliveBrokers;
            }
            interestedReplicaStats.put(Statistic.AVG, interestedReplicaStats.get((Object)Statistic.AVG).doubleValue() + avgTopicReplicas);
            interestedReplicaStats.put(Statistic.MAX, Math.max(interestedReplicaStats.get((Object)Statistic.MAX).intValue(), maxTopicReplicasInBroker));
            interestedReplicaStats.put(Statistic.MIN, Math.min(interestedReplicaStats.get((Object)Statistic.MIN).intValue(), minTopicReplicasInBroker));
            interestedReplicaStats.put(Statistic.ST_DEV, (Double)interestedReplicaStats.get((Object)Statistic.ST_DEV) + Math.sqrt(variance));
        }
        interestedReplicaStats.put(Statistic.AVG, interestedReplicaStats.get((Object)Statistic.AVG).doubleValue() / (double)this.numTopics);
        interestedReplicaStats.put(Statistic.ST_DEV, interestedReplicaStats.get((Object)Statistic.ST_DEV).doubleValue() / (double)this.numTopics);
    }

    private int numOfTopicReplicaInBroker(Broker broker, String topic, boolean leaderReplica, boolean followerReplica) {
        int numTopicReplicasInBroker = 0;
        if (leaderReplica) {
            numTopicReplicasInBroker += broker.numLeaderReplicasOfTopicInBroker(topic);
        }
        if (followerReplica) {
            numTopicReplicasInBroker += broker.numFollowerReplicasOfTopicInBroker(topic);
        }
        return numTopicReplicasInBroker;
    }
}

