/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.model;

import com.linkedin.cruisecontrol.monitor.sampling.aggregator.AggregatedMetricValues;
import com.linkedin.kafka.cruisecontrol.config.BrokerCapacityInfo;
import com.linkedin.kafka.cruisecontrol.model.Broker;
import com.linkedin.kafka.cruisecontrol.model.Capacity;
import com.linkedin.kafka.cruisecontrol.model.Cell;
import com.linkedin.kafka.cruisecontrol.model.Load;
import com.linkedin.kafka.cruisecontrol.model.Rack;
import com.linkedin.kafka.cruisecontrol.model.Replica;
import com.linkedin.kafka.cruisecontrol.model.ResourceStats;
import com.linkedin.kafka.cruisecontrol.model.Utilization;
import com.linkedin.kafka.cruisecontrol.model.internal.AbstractEntityWithCapacity;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.common.TopicPartition;

public class Host
extends AbstractEntityWithCapacity
implements Serializable,
ResourceStats {
    static final double DEAD_HOST_CAPACITY = -1.0;
    private static final Capacity DEAD_CAPACITY = Capacity.dead(-1.0);
    private final Map<Integer, Broker> brokers;
    private final Set<Replica> replicas;
    private final Rack rack;
    private final String name;

    Host(String name, Rack rack) {
        this.name = name;
        this.brokers = new HashMap<Integer, Broker>();
        this.replicas = new HashSet<Replica>();
        this.rack = rack;
        this.load = new Load();
        this.utilization = Utilization.from(this.load);
        this.capacity = Capacity.create();
    }

    public Rack rack() {
        return this.rack;
    }

    public Broker broker(int brokerId) {
        return this.brokers.get(brokerId);
    }

    public Collection<Broker> brokers() {
        return this.brokers.values();
    }

    public Set<Replica> replicas() {
        return this.replicas;
    }

    public int numTopicReplicas(String topic) {
        int numTopicReplicas = 0;
        for (Broker broker : this.brokers.values()) {
            numTopicReplicas += broker.numReplicasOfTopicInBroker(topic);
        }
        return numTopicReplicas;
    }

    public Set<String> topics() {
        HashSet<String> topics = new HashSet<String>();
        this.brokers.values().forEach(broker -> topics.addAll(broker.topics()));
        return topics;
    }

    @Override
    public Capacity capacity() {
        return this.isAlive() ? this.capacity : DEAD_CAPACITY;
    }

    public boolean isEligibleDestination() {
        return this.brokers.values().stream().anyMatch(Broker::isEligibleDestination);
    }

    public boolean isAlive() {
        return this.brokers.values().stream().anyMatch(Broker::isAlive);
    }

    public String name() {
        return this.name;
    }

    Broker createBroker(Integer brokerId, Cell cell, BrokerCapacityInfo brokerCapacityInfo, Broker.Strategy strategy) {
        Broker broker = new Broker(brokerId, this, cell, brokerCapacityInfo, strategy);
        this.brokers.put(brokerId, broker);
        if (broker.isAlive()) {
            this.capacity.addCapacity(broker.capacity());
        }
        return broker;
    }

    void addReplica(Replica replica) {
        this.replicas.add(replica);
        Broker broker = this.brokers.get(replica.broker().id());
        broker.addReplica(replica);
        this.load.addLoad(replica.load());
        this.utilization.addLoad(broker.strategy(), replica.load());
    }

    Replica removeReplica(int brokerId, TopicPartition tp) {
        Broker broker = this.brokers.get(brokerId);
        if (broker == null) {
            throw new IllegalStateException(String.format("Cannot remove replica for %s from broker %s because it does not exist in host %s", tp, brokerId, this.name));
        }
        Replica replica = broker.removeReplica(tp);
        this.replicas.remove(replica);
        this.load.subtractLoad(replica.load());
        this.utilization.subtractLoad(broker.strategy(), replica.load());
        return replica;
    }

    void makeFollower(int brokerId, TopicPartition tp, AggregatedMetricValues leadershipLoadDelta) {
        Broker broker = this.brokers.get(brokerId);
        if (broker == null) {
            throw new IllegalStateException(String.format("Cannot make replica %s on broker %d as follower because the broker does not exist in host %s", tp, brokerId, this.name));
        }
        broker.makeFollower(tp, leadershipLoadDelta);
        this.load.subtractLoad(leadershipLoadDelta);
        this.utilization.subtractLoad(broker.strategy(), leadershipLoadDelta);
    }

    void makeLeader(int brokerId, TopicPartition tp, AggregatedMetricValues leadershipLoadDelta) {
        Broker broker = this.brokers.get(brokerId);
        broker.makeLeader(tp, leadershipLoadDelta);
        this.load.addLoad(leadershipLoadDelta);
        this.utilization.addLoad(broker.strategy(), leadershipLoadDelta);
    }

    void setReplicaLoad(int brokerId, TopicPartition tp, AggregatedMetricValues aggregatedMetricValues, List<Long> windows) {
        Broker broker = this.brokers.get(brokerId);
        broker.setReplicaLoad(tp, aggregatedMetricValues, windows);
        this.load.addMetricValues(aggregatedMetricValues, windows);
        this.utilization.addMetricValues(broker.strategy(), aggregatedMetricValues, windows);
    }

    public Map<String, Object> getJsonStructure() {
        HashMap<String, Object> hostMap = new HashMap<String, Object>();
        ArrayList<Map<String, Object>> brokerList = new ArrayList<Map<String, Object>>();
        for (Broker broker : this.brokers.values()) {
            brokerList.add(broker.getJsonStructure());
        }
        hostMap.put("name", this.name);
        hostMap.put("brokers", brokerList);
        return hostMap;
    }

    public void writeTo(OutputStream out) throws IOException {
        String host = String.format("<Host name=\"%s\">%n", this.name);
        out.write(host.getBytes(StandardCharsets.UTF_8));
        for (Broker broker : this.brokers.values()) {
            broker.writeTo(out);
        }
        out.write("</Host>%n".getBytes(StandardCharsets.UTF_8));
    }

    public String toString() {
        StringBuilder host = new StringBuilder().append(String.format("<Host name=\"%s\">%n", this.name));
        for (Broker broker : this.brokers.values()) {
            host.append(broker.toString());
        }
        return host.append("</Host>%n").toString();
    }
}

