/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.model.view;

import com.linkedin.kafka.cruisecontrol.common.CellResource;
import com.linkedin.kafka.cruisecontrol.model.Capacity;
import com.linkedin.kafka.cruisecontrol.model.Cell;
import com.linkedin.kafka.cruisecontrol.model.CellResourceLoad;
import com.linkedin.kafka.cruisecontrol.model.ClusterModelHelper;
import com.linkedin.kafka.cruisecontrol.model.Load;
import com.linkedin.kafka.cruisecontrol.model.OverloadedCell;
import com.linkedin.kafka.cruisecontrol.model.Tenant;
import com.linkedin.kafka.cruisecontrol.model.Utilization;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.kafka.common.CellState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CellTenantView {
    private static final Logger LOG = LoggerFactory.getLogger(CellTenantView.class);
    private final int id;
    private final int numBrokers;
    private final Set<Tenant> tenants;
    private final Capacity capacity;
    private final Utilization utilization;
    private final CellState state;
    private int numReplicas;

    public CellTenantView(Cell cell) {
        this.id = cell.id();
        this.numBrokers = cell.brokers().size();
        this.tenants = new HashSet<Tenant>();
        for (Tenant tenant : cell.tenants()) {
            this.tenants.add(new Tenant(tenant));
        }
        this.capacity = cell.capacity().newInstance();
        this.utilization = cell.utilization().newInstance();
        this.state = cell.state();
        this.numReplicas = cell.numReplicas();
    }

    public int id() {
        return this.id;
    }

    public Capacity capacity() {
        return this.capacity;
    }

    public Load load() {
        return this.utilization.totalUtilization();
    }

    public Collection<Tenant> tenants() {
        return this.tenants;
    }

    public CellState state() {
        return this.state;
    }

    public int numReplicas() {
        return this.numReplicas;
    }

    public void addTenant(Tenant tenant) {
        if (!this.tenants.contains(tenant)) {
            this.tenants.add(tenant);
            this.utilization.addUtilization(tenant.utilization());
            this.numReplicas += tenant.replicaCount();
            LOG.debug("Added Tenant {} to Cell {}", (Object)tenant, (Object)this.id);
        } else {
            LOG.warn("Didn't add Tenant {} to Cell {} because Tenant {} already exists in Cell {}", new Object[]{tenant, this.id, tenant.tenantId(), this.id});
        }
    }

    public void removeTenant(Tenant tenant) {
        if (this.tenants.contains(tenant)) {
            this.tenants.remove(tenant);
            this.utilization.subtractUtilization(tenant.utilization());
            this.numReplicas -= tenant.replicaCount();
            LOG.debug("Removed Tenant {} from Cell {}", (Object)tenant, (Object)this.id);
        } else {
            LOG.warn("Didn't remove Tenant {} from Cell {} because Tenant {} didn't exist in Cell {}", new Object[]{tenant, this.id, tenant.tenantId(), this.id});
        }
    }

    public double cellUtilRatio(long maxReplicasPerBroker) {
        if (this.numBrokers == 0) {
            return 1.0;
        }
        double rawCellLoad = CellResource.cachedValues().stream().map(resource -> this.loadForResource((CellResource)((Object)resource), maxReplicasPerBroker).ratio()).max(Double::compare).orElseThrow(() -> new IllegalStateException("Failed to calculate RawCellLoad because CellResource enum doesn't contain any resources."));
        return Math.min(1.0, rawCellLoad);
    }

    public OverloadedCell detectOverload(double cellLoadUpperBound, long maxReplicasPerBroker) {
        OverloadedCell.Builder overloadedCellBuilder = OverloadedCell.builder(this);
        for (CellResource resource : CellResource.cachedValues()) {
            CellResourceLoad cellResourceLoad = this.loadForResource(resource, maxReplicasPerBroker);
            if (!(cellResourceLoad.ratio() > cellLoadUpperBound)) continue;
            overloadedCellBuilder.addOverloadedResource(cellResourceLoad);
        }
        return overloadedCellBuilder.build();
    }

    private CellResourceLoad loadForResource(CellResource cellResource, long maxReplicasPerBroker) {
        double ratio = cellResource == CellResource.REPLICA_COUNT ? (double)this.numReplicas / (double)(maxReplicasPerBroker * (long)this.numBrokers) : ClusterModelHelper.utilizationRatioForResource(this.utilization, this.capacity, cellResource.resource()).orElse(1.0);
        return new CellResourceLoad(cellResource, ratio);
    }

    public List<Tenant> tenantsSortedByCellResource(CellResource cellResource) {
        ArrayList<Tenant> sortedTenants = new ArrayList<Tenant>(this.tenants);
        sortedTenants.sort(cellResource.tenantComparator());
        return sortedTenants;
    }

    public String toString() {
        return "CellTenantView{id=" + this.id + ", numBrokers=" + this.numBrokers + ", tenants=" + this.tenants + ", capacity=" + this.capacity + ", utilization=" + this.utilization + ", numReplicas=" + this.numReplicas + '}';
    }
}

