/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.monitor;

import java.util.HashMap;
import java.util.Map;

public class BasicStats {
    protected static final String DISK_MB = "DiskMB";
    protected static final String DISK_PCT = "DiskPct";
    protected static final String CPU_PCT = "CpuPct";
    protected static final String LEADER_NW_IN_RATE = "LeaderNwInRate";
    protected static final String FOLLOWER_NW_IN_RATE = "FollowerNwInRate";
    protected static final String NW_OUT_RATE = "NwOutRate";
    protected static final String PNW_OUT_RATE = "PnwOutRate";
    protected static final String REPLICAS = "Replicas";
    protected static final String LEADERS = "Leaders";
    protected double diskUtil;
    protected double cpuUtil;
    protected double leaderBytesInRate;
    protected double followerBytesInRate;
    protected double bytesOutRate;
    protected double potentialBytesOutRate;
    protected int numReplicas;
    protected int numLeaders;
    protected double diskCapacity;

    BasicStats(double diskUtil, double cpuUtil, double leaderBytesInRate, double followerBytesInRate, double bytesOutRate, double potentialBytesOutRate, int numReplicas, int numLeaders, double diskCapacity) {
        this.diskUtil = diskUtil < 0.0 ? 0.0 : diskUtil;
        this.cpuUtil = cpuUtil < 0.0 ? 0.0 : cpuUtil;
        this.leaderBytesInRate = leaderBytesInRate < 0.0 ? 0.0 : leaderBytesInRate;
        this.followerBytesInRate = followerBytesInRate < 0.0 ? 0.0 : followerBytesInRate;
        this.bytesOutRate = bytesOutRate < 0.0 ? 0.0 : bytesOutRate;
        this.potentialBytesOutRate = potentialBytesOutRate < 0.0 ? 0.0 : potentialBytesOutRate;
        this.numReplicas = numReplicas < 1 ? 0 : numReplicas;
        this.numLeaders = numLeaders < 1 ? 0 : numLeaders;
        this.diskCapacity = diskCapacity < 0.0 ? 0.0 : diskCapacity;
    }

    public double diskUtil() {
        return this.diskUtil;
    }

    public double diskUtilPct() {
        return this.diskCapacity > 0.0 ? 100.0 * this.diskUtil / this.diskCapacity : -1.0;
    }

    public double cpuUtil() {
        return this.cpuUtil;
    }

    public double leaderBytesInRate() {
        return this.leaderBytesInRate;
    }

    public double followerBytesInRate() {
        return this.followerBytesInRate;
    }

    public double bytesOutRate() {
        return this.bytesOutRate;
    }

    public double potentialBytesOutRate() {
        return this.potentialBytesOutRate;
    }

    public int numReplicas() {
        return this.numReplicas;
    }

    public int numLeaders() {
        return this.numLeaders;
    }

    public double diskCapacity() {
        return this.diskCapacity;
    }

    void addBasicStats(BasicStats basicStats) {
        this.diskUtil += basicStats.diskUtil();
        this.cpuUtil += basicStats.cpuUtil();
        this.leaderBytesInRate += basicStats.leaderBytesInRate();
        this.followerBytesInRate += basicStats.followerBytesInRate();
        this.bytesOutRate += basicStats.bytesOutRate();
        this.potentialBytesOutRate += basicStats.potentialBytesOutRate();
        this.numReplicas += basicStats.numReplicas();
        this.numLeaders += basicStats.numLeaders();
        this.diskCapacity += basicStats.diskCapacity();
    }

    public Map<String, Object> getJSONStructure() {
        HashMap<String, Object> entry = new HashMap<String, Object>(9);
        entry.put(DISK_MB, this.diskUtil());
        entry.put(DISK_PCT, this.diskUtilPct());
        entry.put(CPU_PCT, this.cpuUtil());
        entry.put(LEADER_NW_IN_RATE, this.leaderBytesInRate());
        entry.put(FOLLOWER_NW_IN_RATE, this.followerBytesInRate());
        entry.put(NW_OUT_RATE, this.bytesOutRate());
        entry.put(PNW_OUT_RATE, this.potentialBytesOutRate());
        entry.put(REPLICAS, this.numReplicas());
        entry.put(LEADERS, this.numLeaders());
        return entry;
    }
}

