/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.cruisecontrol.analyzer.history;

import io.confluent.cruisecontrol.analyzer.history.AbstractEntityEventHistory;
import org.apache.kafka.common.TopicPartition;

public class EntityEventHistoryUtils {
    public static int compareTopicPartitionEventHistories(AbstractEntityEventHistory h1, AbstractEntityEventHistory h2, TopicPartition tp1, TopicPartition tp2) {
        int result = EntityEventHistoryUtils.compareEntityEventHistories(h1, h2);
        if (result == 0 && (result = tp1.topic().compareTo(tp2.topic())) == 0) {
            result = Integer.compare(tp1.partition(), tp2.partition());
        }
        return result;
    }

    public static int compareTenantEventHistories(AbstractEntityEventHistory h1, AbstractEntityEventHistory h2, String tenant1, String tenant2) {
        int result = EntityEventHistoryUtils.compareEntityEventHistories(h1, h2);
        if (result == 0) {
            result = tenant1.compareTo(tenant2);
        }
        return result;
    }

    public static int compareEntityEventHistories(AbstractEntityEventHistory h1, AbstractEntityEventHistory h2) {
        int result = Long.compare(h1.epoch(), h2.epoch());
        if (result == 0) {
            result = Long.compare(h1.deadlineMs(), h2.deadlineMs());
        }
        return result;
    }
}

