/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.cruisecontrol.metricsreporter;

import com.google.protobuf.Message;
import com.linkedin.kafka.cruisecontrol.metricsreporter.metric.BrokerMetric;
import com.linkedin.kafka.cruisecontrol.metricsreporter.metric.CruiseControlMetric;
import com.linkedin.kafka.cruisecontrol.metricsreporter.metric.MetricsUtils;
import com.linkedin.kafka.cruisecontrol.metricsreporter.metric.RawMetricType;
import com.linkedin.kafka.cruisecontrol.metricsreporter.metric.YammerMetricWrapper;
import io.confluent.cruisecontrol.metricsreporter.ConfluentMetricsSamplerBase;
import io.confluent.metrics.record.ConfluentMetric;
import io.confluent.serializers.ProtoSerde;
import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.MetricName;

public class ConfluentMetricsReporterSampler
extends ConfluentMetricsSamplerBase {
    private ProtoSerde<ConfluentMetric.MetricsMessage> serde = new ProtoSerde((Message)ConfluentMetric.MetricsMessage.getDefaultInstance());

    @Override
    protected List<CruiseControlMetric> convertMetricRecord(ConsumerRecord<byte[], byte[]> confluentMetric) {
        YammerMetricWrapper metricWrapper;
        ArrayList<CruiseControlMetric> metricList = new ArrayList<CruiseControlMetric>();
        ConfluentMetric.MetricsMessage metricsMessage = (ConfluentMetric.MetricsMessage)this.serde.deserialize((byte[])confluentMetric.value());
        for (ConfluentMetric.KafkaMeasurable km : metricsMessage.getKafkaMeasurableList()) {
            MetricName metricName = this.convertKafkaMetricName(km.getMetricName());
            if (metricName.name().equals("CpuUsage")) {
                this.addIfNotNull(metricList, new BrokerMetric(RawMetricType.BROKER_CPU_UTIL, metricsMessage.getTimestamp(), metricsMessage.getBrokerId(), km.getValue()));
                continue;
            }
            if (!MetricsUtils.isInterested(metricName)) continue;
            this.addIfNotNull(metricList, MetricsUtils.toCruiseControlMetric(metricsMessage.getTimestamp(), metricsMessage.getBrokerId(), metricName.name(), metricName.tags(), km.getValue()));
        }
        for (ConfluentMetric.YammerGauge gauge : metricsMessage.getYammerGaugeList()) {
            metricWrapper = new YammerMetricWrapper(this.convertYammerMetricName(gauge.getMetricName()));
            if (!MetricsUtils.isInterested(metricWrapper)) continue;
            Double value = null;
            switch (gauge.getNumericValueCase()) {
                case LONGVALUE: {
                    value = gauge.getLongValue();
                    break;
                }
                case DOUBLEVALUE: {
                    value = gauge.getDoubleValue();
                    break;
                }
            }
            if (value == null) continue;
            this.addIfNotNull(metricList, MetricsUtils.toCruiseControlMetric(metricsMessage.getTimestamp(), metricsMessage.getBrokerId(), metricWrapper, value));
        }
        for (ConfluentMetric.YammerMeter meter : metricsMessage.getYammerMeterList()) {
            metricWrapper = new YammerMetricWrapper(this.convertYammerMetricName(meter.getMetricName()));
            if (!MetricsUtils.isInterested(metricWrapper)) continue;
            this.addIfNotNull(metricList, MetricsUtils.toCruiseControlMetric(metricsMessage.getTimestamp(), metricsMessage.getBrokerId(), metricWrapper, meter.getOneMinuteRate()));
        }
        for (ConfluentMetric.YammerTimer timer : metricsMessage.getYammerTimerList()) {
            metricWrapper = new YammerMetricWrapper(this.convertYammerMetricName(timer.getMetricName()));
            if (!MetricsUtils.isInterested(metricWrapper)) continue;
            this.addIfNotNull(metricList, MetricsUtils.toCruiseControlMetric(metricsMessage.getTimestamp(), metricsMessage.getBrokerId(), metricWrapper, timer.getOneMinuteRate()));
            this.addIfNotNull(metricList, MetricsUtils.toCruiseControlMetric(metricsMessage.getTimestamp(), metricsMessage.getBrokerId(), metricWrapper, timer.getMax(), "Max"));
            this.addIfNotNull(metricList, MetricsUtils.toCruiseControlMetric(metricsMessage.getTimestamp(), metricsMessage.getBrokerId(), metricWrapper, timer.getMean(), "Mean"));
        }
        for (ConfluentMetric.YammerHistogram histogram : metricsMessage.getYammerHistogramList()) {
            metricWrapper = new YammerMetricWrapper(this.convertYammerMetricName(histogram.getMetricName()));
            if (!MetricsUtils.isInterested(metricWrapper)) continue;
            this.addIfNotNull(metricList, MetricsUtils.toCruiseControlMetric(metricsMessage.getTimestamp(), metricsMessage.getBrokerId(), metricWrapper, histogram.getMax(), "Max"));
            this.addIfNotNull(metricList, MetricsUtils.toCruiseControlMetric(metricsMessage.getTimestamp(), metricsMessage.getBrokerId(), metricWrapper, histogram.getMean(), "Mean"));
        }
        CruiseControlMetric cruiseControlVolumeMetrics = this.convertVolumeMetrics(metricsMessage);
        this.addIfNotNull(metricList, cruiseControlVolumeMetrics);
        return metricList;
    }

    private CruiseControlMetric convertVolumeMetrics(ConfluentMetric.MetricsMessage metricsMessage) {
        List volumes = metricsMessage.getSystemMetrics().getVolumesList();
        if (!volumes.isEmpty()) {
            if (volumes.size() > 1) {
                throw new IllegalStateException("Dynamic disk size estimation not supported for multiple volumes");
            }
            double diskTotalBytes = ((ConfluentMetric.VolumeMetrics)volumes.get(0)).getTotalBytes();
            return new BrokerMetric(RawMetricType.BROKER_DISK_CAPACITY, metricsMessage.getTimestamp(), metricsMessage.getBrokerId(), diskTotalBytes);
        }
        return null;
    }

    private void addIfNotNull(List<CruiseControlMetric> metricList, CruiseControlMetric metric) {
        if (metric != null) {
            metricList.add(metric);
        }
    }

    private MetricName convertKafkaMetricName(ConfluentMetric.KafkaMetricName metricName) {
        return new MetricName(metricName.getName(), metricName.getGroup(), "", metricName.getTagsMap());
    }

    private com.yammer.metrics.core.MetricName convertYammerMetricName(ConfluentMetric.YammerMetricName metricName) {
        return new com.yammer.metrics.core.MetricName(metricName.getGroup(), metricName.getType(), metricName.getName(), metricName.getScope().equals("") ? null : metricName.getScope(), metricName.getMBeanName());
    }
}

