/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.cruisecontrol.metricsreporter.opentelemetry;

import com.google.protobuf.CodedInputStream;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class WireFormatHelpers {
    private static final Logger LOG = LoggerFactory.getLogger(WireFormatHelpers.class);
    static final int DEFAULT_TAG_VALUE_WHEN_MESSAGE_LIMIT_IS_REACHED = 0;
    static final int TAG_TYPE_BITS = 3;

    public static int makeTag(int fieldNumber, int wireType) {
        return fieldNumber << 3 | wireType;
    }

    public static boolean isMessageEndReached(CodedInputStream inputStream) throws IOException {
        if (inputStream.isAtEnd()) {
            int readTag = inputStream.readTag();
            if (readTag != 0) {
                LOG.error("The provided CodedInputStream reported that it has reached the end but read a non-zero tag value. Bytes until the limit: {}. Read tag value: {}", (Object)inputStream.getBytesUntilLimit(), (Object)readTag);
            }
            return true;
        }
        return false;
    }
}

