/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.databalancer.event;

import io.confluent.databalancer.SbcContext;
import io.confluent.databalancer.event.SbcEvent;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kafka.common.AliveBrokersMetadata;
import kafka.common.BrokerRemovalRequest;
import kafka.common.TopicsMetadataSnapshot;
import kafka.controller.ClusterBalanceManager;
import org.apache.kafka.common.errors.InvalidBrokerRemovalException;
import org.apache.kafka.common.requests.ApiError;

public abstract class SbcAbstractScheduleBrokerRemovalEvent
extends SbcEvent {
    protected final List<Integer> brokersToRemove;
    private final boolean shouldShutdown;
    private final ClusterBalanceManager.BalanceManagerOperationInvocationClientCallback cb;

    public SbcAbstractScheduleBrokerRemovalEvent(SbcContext context, List<Integer> brokersToRemove, boolean shouldShutdown, ClusterBalanceManager.BalanceManagerOperationInvocationClientCallback cb) {
        super(context);
        this.brokersToRemove = brokersToRemove;
        this.shouldShutdown = shouldShutdown;
        this.cb = cb;
    }

    protected SbcEvent.SbcEventHandlerResult validateAndScheduleRemoval(AliveBrokersMetadata aliveBrokersMetadata, TopicsMetadataSnapshot topicsMetadataSnapshot) {
        EligibleBrokers result = this.validateIfBrokersCanBeRemoved(topicsMetadataSnapshot, aliveBrokersMetadata);
        BrokerRemovalRequest removalRequest = new BrokerRemovalRequest(result.brokersEligibleForRemoval, result.nonExistentBrokers, Boolean.valueOf(this.shouldShutdown));
        LOG.info("SBC scheduling broker removal: {}", (Object)removalRequest);
        this.eventContext.kafkaDataBalanceManager().scheduleBrokerRemoval(removalRequest, aliveBrokersMetadata);
        return SbcEvent.SbcEventHandlerResult.SUCCESS;
    }

    @Override
    protected void respondToClient(ApiError error, SbcEvent.SbcEventHandlerResult result) {
        this.cb.respond(error);
    }

    protected EligibleBrokers validateIfBrokersCanBeRemoved(TopicsMetadataSnapshot topicsMetadataSnapshot, AliveBrokersMetadata aliveBrokersMetadata) {
        List partitionsByTopic = topicsMetadataSnapshot.partitionsByTopic();
        Set aliveBrokers = aliveBrokersMetadata.aliveBrokers();
        Map<Boolean, List<Integer>> brokersToRemoveByAliveState = this.brokersToRemove.stream().collect(Collectors.partitioningBy(aliveBrokers::contains));
        List<Integer> aliveBrokersToRemove = brokersToRemoveByAliveState.get(true);
        List<Integer> offlineBrokersToRemove = brokersToRemoveByAliveState.get(false);
        long clusterSizePostRemoval = aliveBrokers.stream().filter(b -> !aliveBrokersToRemove.contains(b) && !aliveBrokersMetadata.replicaExclusions().contains(b)).count();
        HashSet<Integer> emptyOfflineBrokersToRemove = new HashSet<Integer>(offlineBrokersToRemove);
        for (List partitionSnapshots : partitionsByTopic) {
            if (partitionSnapshots.isEmpty()) continue;
            TopicsMetadataSnapshot.PartitionSnapshot samplePartition = (TopicsMetadataSnapshot.PartitionSnapshot)partitionSnapshots.get(0);
            String topic = samplePartition.topic();
            if ((long)samplePartition.numReplicas() > clusterSizePostRemoval) {
                Optional replicaInfoOpt = topicsMetadataSnapshot.partitionInfoSnapshot(samplePartition);
                String replicasSuffix = replicaInfoOpt.isPresent() ? String.format(" %s", ((TopicsMetadataSnapshot.ReplicaInfo)replicaInfoOpt.get()).replicas().toString()) : "";
                throw new InvalidBrokerRemovalException(String.format("Can't remove brokers %s as there are partitions with replicas that cannot be accommodated on the remaining alive non-excluded brokers in the cluster post the removal operation. One such topic: %s with %s replicas%s", this.brokersToRemove, topic, samplePartition.numReplicas(), replicasSuffix));
            }
            if (offlineBrokersToRemove.isEmpty()) continue;
            partitionSnapshots.stream().map(arg_0 -> ((TopicsMetadataSnapshot)topicsMetadataSnapshot).partitionInfoSnapshot(arg_0)).filter(Optional::isPresent).map(Optional::get).forEach(replicaInfo -> {
                boolean isOffline;
                boolean bl = isOffline = !replicaInfo.offlineReplicas().isEmpty() && replicaInfo.offlineReplicas().containsAll(replicaInfo.inSyncReplicas());
                if (isOffline) {
                    if (replicaInfo.replicas().stream().anyMatch(offlineBrokersToRemove::contains)) {
                        throw new InvalidBrokerRemovalException(String.format("Can't remove brokers %s as there are offline partitions with some replicas on (offline) brokers that were requested to be removed as part of this broker removal operation. %s", this.brokersToRemove, topic));
                    }
                }
                if (!emptyOfflineBrokersToRemove.isEmpty()) {
                    replicaInfo.replicas().forEach(emptyOfflineBrokersToRemove::remove);
                    replicaInfo.observers().forEach(emptyOfflineBrokersToRemove::remove);
                }
            });
        }
        Map<Boolean, List<Integer>> brokersByExistence = this.brokersToRemove.stream().collect(Collectors.partitioningBy(b -> !emptyOfflineBrokersToRemove.contains(b)));
        return new EligibleBrokers(brokersByExistence.get(true), brokersByExistence.get(false));
    }

    public static class EligibleBrokers {
        public final List<Integer> brokersEligibleForRemoval;
        public final List<Integer> nonExistentBrokers;

        public EligibleBrokers(List<Integer> brokersEligibleForRemoval, List<Integer> nonExistentBrokers) {
            this.brokersEligibleForRemoval = brokersEligibleForRemoval;
            this.nonExistentBrokers = nonExistentBrokers;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            EligibleBrokers that = (EligibleBrokers)o;
            return Objects.equals(this.brokersEligibleForRemoval, that.brokersEligibleForRemoval) && Objects.equals(this.nonExistentBrokers, that.nonExistentBrokers);
        }

        public int hashCode() {
            return Objects.hash(this.brokersEligibleForRemoval, this.nonExistentBrokers);
        }
    }
}

