/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.databalancer.event;

import io.confluent.databalancer.event.SbcEvent;
import io.confluent.databalancer.metrics.GeneralSBCMetricsRegistry;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.SystemTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.queue.EventQueue;
import org.apache.kafka.queue.KafkaEventQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class SbcEventQueue {
    private static final Logger LOG = LoggerFactory.getLogger(SbcEventQueue.class);
    private static final String SIZE_METRIC_NAME = "Size";
    private final EventQueue eventQueue;
    private final AtomicLong numEnqueues;
    private volatile boolean shutdown;
    private final GeneralSBCMetricsRegistry metricsRegistry;

    public SbcEventQueue(GeneralSBCMetricsRegistry metricsRegistry) {
        this.metricsRegistry = metricsRegistry;
        this.shutdown = false;
        this.numEnqueues = new AtomicLong(0L);
        String identifierPrefix = SbcEventQueue.class.getSimpleName();
        this.eventQueue = new KafkaEventQueue((Time)new SystemTime(), new LogContext(identifierPrefix), identifierPrefix);
        this.registerMetrics();
    }

    public void enqueue(SbcEvent event) {
        if (this.shutdown) {
            throw new IllegalStateException(String.format("Attempting to enqueue event %s to closed SbcEventQueue", new Object[]{event}));
        }
        LOG.debug("Event {} enqueued", (Object)event.name());
        this.numEnqueues.incrementAndGet();
        this.eventQueue.append((EventQueue.Event)event);
    }

    public void prepend(SbcEvent event) {
        if (this.shutdown) {
            throw new IllegalStateException(String.format("Attempting to enqueue event %s to closed SbcEventQueue", new Object[]{event}));
        }
        LOG.debug("Event {} prepended to EventQueue", (Object)event.name());
        this.numEnqueues.incrementAndGet();
        this.eventQueue.prepend((EventQueue.Event)event);
    }

    public void shutdownQueue() throws InterruptedException {
        this.shutdown = true;
        this.eventQueue.close();
    }

    long numEnqueues() {
        return this.numEnqueues.get();
    }

    private void registerMetrics() {
        this.metricsRegistry.newGauge(SbcEventQueue.class, SIZE_METRIC_NAME, () -> ((EventQueue)this.eventQueue).size(), true);
    }
}

