/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.databalancer.event.resource;

import io.confluent.databalancer.event.resource.BalancerResourceManager;
import io.confluent.databalancer.event.resource.SbcResources;
import java.util.Optional;
import org.apache.kafka.image.ClusterImage;

public class SbcResourceUtils {
    public static Optional<ClusterImage> unfencedClusterImage(BalancerResourceManager resourceManager) {
        boolean unfencedBrokersExist;
        Optional<ClusterImage> clusterImage = resourceManager.maybeGetResourceValue(SbcResources.CLUSTER_IMAGE);
        if (clusterImage.isPresent() && (unfencedBrokersExist = clusterImage.get().brokers().values().stream().anyMatch(r -> !r.fenced()))) {
            return clusterImage;
        }
        return Optional.empty();
    }
}

