/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.databalancer.metrics.internals;

import com.linkedin.kafka.cruisecontrol.common.CellResource;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class TenantResourceStats {
    private final int cellId;
    private final String tenantId;
    private final CellResource resource;
    private final double cellCapacityValue;
    private final double utilizationValue;

    public TenantResourceStats(int cellId, String tenantId, CellResource resource, double cellCapacityValue, double utilizationValue) {
        this.cellId = cellId;
        this.tenantId = Objects.requireNonNull(tenantId);
        this.resource = Objects.requireNonNull(resource);
        this.cellCapacityValue = cellCapacityValue;
        this.utilizationValue = utilizationValue;
    }

    public int cellId() {
        return this.cellId;
    }

    public String tenantId() {
        return this.tenantId;
    }

    public CellResource resource() {
        return this.resource;
    }

    public double utilizationValue() {
        return this.utilizationValue;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TenantResourceStats that = (TenantResourceStats)o;
        if (this.cellId != that.cellId) {
            return false;
        }
        if (Double.compare(this.cellCapacityValue, that.cellCapacityValue) != 0) {
            return false;
        }
        if (Double.compare(this.utilizationValue, that.utilizationValue) != 0) {
            return false;
        }
        if (!this.tenantId.equals(that.tenantId)) {
            return false;
        }
        return this.resource == that.resource;
    }

    public int hashCode() {
        int result = this.cellId;
        result = 31 * result + this.tenantId.hashCode();
        result = 31 * result + this.resource.hashCode();
        long temp = Double.doubleToLongBits(this.cellCapacityValue);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.utilizationValue);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public String toString() {
        return "TenantResourceStats{cellId=" + this.cellId + ", tenantId='" + this.tenantId + '\'' + ", resource=" + (Object)((Object)this.resource) + ", cellCapacityValue=" + this.cellCapacityValue + ", utilizationValue=" + this.utilizationValue + '}';
    }
}

